# Keybindings

To allow for easy navigation, CmdBar provides a set of default key bindings.
- `ArrowUp`: Select the previous item in the list.
- `ArrowDown`: Select the next item in the list.
- `Enter`: Execute the selected item.

To [bind a key to a command](#command-shortcut), you can use the `shortcut` property of the `Command` object.

## useKeymap()

You can easily define your own key bindings by using the `useKeymap()` composable.

You can just pass an object with the following structure:
```ts
useKeymap((nav) => {
  return [
    {
      key: 'ArrowRight',
      action: () => nav.prev(),
      autoRepeat: true
    },
    {
      key: 'ArrowLeft',
      action: () => nav.next(),
      autoRepeat: true
    }
  ]
})
```
::alert{type="info"}
The property `autoRepeat` is optional, and defaults to `false`.
::

The composable also gives you access to the `nav` object, which provides the following methods:
- `prev()`: Select the previous item in the list.
- `next()`: Select the next item in the list.
- `execute()`: Execute the selected item.

## Command Shortcut

You can also define a shortcut for a command by using the `shortcut` property of the `Command` object.

```ts
const actions = [
  {
    id: 'new-resource',
    label: 'Create new Resource',
    leading: './src/assets/icons/create.svg',
    action: () => alert('New Resource created'),
    shortcut: 'Ctrl+R'
  },
  {
    id: 'new-service',
    label: 'Add new Service',
    leading: './src/assets/icons/service_1.svg',
    action: () => alert('New Service added'),
    shortcut: 'Ctrl+S'
  },
]
```

::alert{type="info"}
Keybindings are internally handled by [useMagicKeys | VueUse](https://vueuse.org/core/useMagicKeys/#usemagickeys). 
::
