# Getting Started

Setting up cmd-bar in you vue/nuxt application is only a couple of steps away.

## Play online
TODO: setup codesandbox/stackblitz
You can start playing with Docus in your browser using Stackblitz:

:button-link[Play on StackBlitz]{size="small" icon="IconStackBlitz" href="https://stackblitz.com/github/nuxt-themes/docus-starter" blank}

## Setup Vue

1. Install `cmd-bar` dependency to your project:

::code-group

  ```bash[npm]
  npm install cmd-bar
  ```

  ```bash[yarn]
  yarn add cmd-bar
  ```

  ```bach[pnpm]
   pnpm add cmd-bar
  ```
::

2. Then you can import the `CmdBar` Compound Component in your project.

```ts
import { CmdBar } from 'cmd-bar'

<CmdBar :groups="groupedCommands">
  <CmdBar.Dialog>
    <template #header>
      <CmdBar.Input placeholder="search for anything />
    </template>
    <template #content>
      <CmdBar.VirtualList :config="listConfig">
          <template #default="{ command }">
            <div class="leading">
              <img :src="command.leading" alt="icon" />
              {{ command.label }}
            </div>
            <span v-if="command.shortcut" class="actions">
              <kbd v-for="shortcut of command.shortcut)" :key="shortcut">
                {{ shortcut }}
              </kbd>
            </span>
          </template>
      </CmdBar.VirtualList>
    </template>
  </CmdBar.Dialog>
</CmdBar>
```



[//]: # (## Setup Nuxt)

[//]: # ()
[//]: # (1. Add `cmd-bar` dependency to your project:)

[//]: # ()
[//]: # (::code-group)

[//]: # ()
[//]: # (  ```bash[npm])

[//]: # (  npm install cmd-bar)

[//]: # (  ```)

[//]: # ()
[//]: # (  ```bash[yarn])

[//]: # (  yarn add cmd-bar)

[//]: # (  ```)

[//]: # ()
[//]: # (  ```bach[pnpm])

[//]: # (   pnpm add cmd-bar)

[//]: # (  ```)

[//]: # ()
[//]: # (::)

[//]: # ()
[//]: # (2. Add it to your modules section in your nuxt.config:)

[//]: # (```ts)

[//]: # (export default defineNuxtConfig&#40;{)

[//]: # (  modules: ['cmd-bar'],)

[//]: # (}&#41;)

[//]: # (```)

