# Composables

Discover the composable functions provided by CmdBar.

## `defineCommands()`

`defineCommands()`{lang=ts} provides type safety for your commands. It takes an array of `Command` objects and returns an array of `Command` objects.

```ts
import { defineCommands } from 'cmd-bar'

return data.value.users.map((user: Record<string, any>) =>
  defineCommand({
    id: user.id.toString(),
    leading: './src/assets/icons/user_new.svg',
    label: `${user.firstName} ${user.lastName}`,
    action: () => {
      // Define your action here.
    }
  })
)
```

::source-link
---
source: "defineCommand.ts"
---
::

## `useCmdBarEvent()`

`useCmdBarEvent()` let's you listen to the events emitted by CmdBar. Currently, the following events are emitted:
- `selected`: Emitted when a command is selected. It provides the selected command.
- `clicked`: Emitted when a command is clicked. It provides the clicked command.

Example usage:
```ts
const activeCommand = ref<Command | null>(null)

const { emitter } = useCmdBarEvent()

emitter.on('selected', (command) => {
  activeCommand.value = command
})
```
::alert{type="info"}
**Tip:** This is particularly useful when you want to **show a preview** of the selected command. (See [Previes Example](../examples/2.preview.md))
::
::source-link
---
source: "useCmdBarEvent.ts"
---
::

## `useKeymap()`

[`useKeymap()`](3.keybindings.md) let's you define your own key bindings with ease.




::source-link
---
source: "useKeymap.ts"
---
::

