# Vue

## Vue

1. Install `cmd-bar` dependency to your project:

```bash[npm]
npm install cmd-bar
```

```bash[yarn]
yarn add cmd-bar
```

```bach[pnpm]
pnpm add cmd-bar
```


---

**Lastly** you can import the `CmdBar` Compound Component in your project.

```html
import { CmdBar } from 'cmd-bar'

<CmdBar :commands="groups">
  <CmdBarDialog>
    <template #header>
      <CmdBarInput placeholder="search for anything />
    </template>
    <template #content>
      <CmdBarList>
          <template #default="{ command }">
            <div class="leading">
              <img :src="command.leading" alt="icon" />
              {{ command.label }}
            </div>
          </template>
      </CmdBarList>
    </template>
  </CmdBarDialog>
</CmdBar>
```


