# List

Renders the list of commands.

When a query is provided, the list will be filtered and the `results` slot will be rendered.

## Props
- `loop`: Whether the list should loop or not. (Default: `false`)
- `resultsHeader`: The header of the results list. Can bew turned off by setting it to `null`. (Default: `'Results'`)

## Slots
You can use the following slots:
- `default`: renders the items and provides the `command` object. 
- `loading`: can be used to render a loading indicator or Skeleton.
- `results`: renders a list of commands that match the query. To render a custom header, use the `resultsHeader` prop.
- `no-results`: can be used to render a message when no results are found.
- `preview`: Can be used to render a preview of the currently selected command. (See [Command](../examples/2.preview.md))

## Events
Emits a `selected` event when a command is selected. (@see [useCmdBarEvent composable](../4.composables/1.CmdBarEvent.md))
