# CmdBarEvent

`useCmdBarEvent()` let's you listen to the events emitted by CmdBar.

## Events
- `selected`: Emitted when a command is selected. It provides the selected command.
- `clicked`: Emitted when a command is clicked. It provides the clicked command.
- `input`: Emitted when the input value changes. It provides the current input value.
- `filterChange`: Emitted when the filter changes. It provides an array of `groupKey`s.


## Example
```vue
<script setup lang="ts">
import { type Command, CmdBar, useCmdBarEvent } from 'cmd-bar'

const activeCommand = ref<Command | null>(null)

const { emitter } = useCmdBarEvent()

emitter.on('selected', (command) => {
  activeCommand.value = command
})
  
// ...
</script>

<template>
<!-- ... -->
</template>

```         
