---
title: Home
navigation: false
layout: page
main:
  fluid: false
---

:ellipsis{right=40px width=60% blur=100px}

::block-hero
---
cta:
  - Get started
  - /introduction/getting-started
secondary:
  - Open on GitHub →
  - https://github.com/nuxt-themes/docus
---

#title
cmd-bar. 

#description
powerful and flexible web component written in Vue.js.

#support
<div style="z-index:10; position: absolute; right: 0;top:0; margin-top: 55px; margin-right: 40px">
<svg xmlns="http://www.w3.org/2000/svg" width="525" height="400" viewBox="0 0 640 500" fill="none">
<rect x=".5" y="1" width="639" height="485" rx="11.5" fill="#161616"/><g clip-path="url(#Dialog__a)"><g clip-path="url(#Dialog__b)"><path d="M26.167 25a4.167 4.167 0 0 1 4.166 4.167m.55 4.712L34.5 37.5m-1.667-8.333a6.667 6.667 0 1 1-13.333 0 6.667 6.667 0 0 1 13.333 0Z" stroke="#B3B3B3" stroke-width="1.667" stroke-linecap="round" stroke-linejoin="round"/></g></g><g clip-path="url(#Dialog__c)"><path d="m54.335 28.88-1.355.384a2.518 2.518 0 0 0-.377-.658 1.83 1.83 0 0 0-.665-.537c-.281-.14-.641-.211-1.08-.211-.6 0-1.102.138-1.502.415-.397.273-.595.62-.595 1.042 0 .375.137.671.41.889.272.217.698.398 1.278.543l1.457.358c.878.213 1.532.54 1.963.978.43.435.645.995.645 1.681 0 .563-.162 1.066-.486 1.509-.32.443-.767.792-1.342 1.048-.575.256-1.244.384-2.007.384-1.001 0-1.83-.218-2.486-.652-.657-.435-1.072-1.07-1.247-1.905l1.432-.358c.136.528.394.925.773 1.189.384.264.884.396 1.502.396.703 0 1.262-.15 1.675-.447.418-.303.627-.665.627-1.087 0-.341-.12-.627-.358-.857-.239-.234-.605-.409-1.1-.524l-1.636-.383c-.9-.213-1.56-.544-1.982-.991-.417-.452-.626-1.016-.626-1.694 0-.554.155-1.044.466-1.47.316-.426.744-.76 1.285-1.004.546-.243 1.164-.364 1.854-.364.972 0 1.734.213 2.288.64a3.44 3.44 0 0 1 1.19 1.687Zm6.566 7.825c-.946 0-1.762-.21-2.448-.627a4.204 4.204 0 0 1-1.579-1.764c-.366-.759-.55-1.64-.55-2.646s.184-1.892.55-2.66c.371-.77.887-1.372 1.547-1.802.665-.435 1.44-.652 2.327-.652.511 0 1.016.085 1.515.256.498.17.952.447 1.361.83.41.38.736.883.979 1.51.242.626.364 1.397.364 2.313v.64h-7.568v-1.305h6.034c0-.554-.111-1.048-.333-1.483a2.505 2.505 0 0 0-.933-1.029c-.4-.251-.873-.377-1.419-.377-.6 0-1.12.15-1.56.448a2.942 2.942 0 0 0-1.003 1.15 3.38 3.38 0 0 0-.352 1.521v.87c0 .741.128 1.37.384 1.885.26.512.62.902 1.08 1.17.46.264.995.396 1.605.396.396 0 .754-.055 1.073-.166.324-.115.603-.285.838-.511a2.33 2.33 0 0 0 .543-.857l1.457.41a3.23 3.23 0 0 1-.773 1.303c-.362.371-.81.66-1.342.87-.533.204-1.132.306-1.797.306Zm9.25.025a3.99 3.99 0 0 1-1.694-.351 2.907 2.907 0 0 1-1.208-1.03c-.298-.451-.448-.997-.448-1.636 0-.562.111-1.018.333-1.368.221-.354.517-.63.888-.83.37-.201.78-.35 1.227-.448.452-.102.906-.183 1.362-.243.597-.077 1.08-.134 1.451-.173.375-.042.648-.113.818-.21.175-.099.262-.27.262-.512v-.051c0-.63-.172-1.12-.517-1.47-.341-.35-.86-.524-1.554-.524-.72 0-1.285.157-1.694.473-.409.315-.696.652-.863 1.01l-1.431-.512c.255-.596.596-1.061 1.022-1.393.43-.337.9-.571 1.406-.703a5.841 5.841 0 0 1 1.51-.205c.314 0 .677.038 1.086.115.413.072.811.224 1.195.454.388.23.71.577.965 1.042.256.464.384 1.086.384 1.866V36.5h-1.509v-1.33h-.076a2.658 2.658 0 0 1-.512.684c-.239.243-.556.45-.952.62-.397.17-.88.256-1.451.256Zm.23-1.355c.597 0 1.1-.117 1.508-.352a2.393 2.393 0 0 0 1.253-2.077v-1.38c-.064.076-.204.146-.422.21-.213.06-.46.113-.741.16a33.842 33.842 0 0 1-1.445.192 5.772 5.772 0 0 0-1.1.25c-.336.11-.608.278-.817.504-.205.222-.307.524-.307.908 0 .524.194.92.581 1.189.393.264.889.396 1.49.396Zm7.023 1.125v-9.818h1.458v1.483h.102c.179-.486.503-.88.971-1.183a2.86 2.86 0 0 1 1.586-.454c.11 0 .249.003.415.007.166.004.292.01.377.019v1.534a4.466 4.466 0 0 0-.351-.058 3.462 3.462 0 0 0-.57-.044c-.477 0-.903.1-1.278.3-.37.196-.664.469-.882.818a2.21 2.21 0 0 0-.32 1.183V36.5h-1.508Zm10.387.205c-.92 0-1.713-.218-2.378-.652-.664-.435-1.176-1.034-1.534-1.797-.358-.762-.537-1.634-.537-2.614 0-.997.184-1.877.55-2.64.37-.767.886-1.366 1.547-1.796.665-.435 1.44-.652 2.327-.652.69 0 1.312.128 1.866.384a3.574 3.574 0 0 1 1.362 1.073c.353.46.573.998.658 1.611h-1.508c-.116-.447-.371-.844-.768-1.189-.392-.35-.92-.524-1.585-.524-.588 0-1.103.154-1.547.46-.439.303-.782.731-1.029 1.285-.243.55-.364 1.195-.364 1.937 0 .758.12 1.419.358 1.981.243.563.584 1 1.022 1.31.444.312.964.467 1.56.467.392 0 .748-.068 1.068-.204.32-.137.59-.333.812-.588.221-.256.379-.563.472-.92h1.509a3.495 3.495 0 0 1-.633 1.565c-.332.46-.773.827-1.323 1.1-.545.268-1.18.403-1.905.403Zm7.575-6.111V36.5h-1.509V23.41h1.509v4.806h.128c.23-.507.575-.91 1.035-1.208.465-.303 1.083-.454 1.854-.454.669 0 1.255.134 1.758.403.502.264.892.67 1.169 1.22.282.546.422 1.24.422 2.084V36.5h-1.508v-6.136c0-.78-.203-1.383-.608-1.81-.4-.43-.956-.645-1.668-.645-.494 0-.937.105-1.33.313a2.288 2.288 0 0 0-.92.914c-.221.4-.332.887-.332 1.458Zm18.561-3.912v1.278h-5.293v-1.278h5.293Zm-3.708 9.818V25.327c0-.563.132-1.032.397-1.407a2.454 2.454 0 0 1 1.029-.843 3.253 3.253 0 0 1 1.336-.282c.37 0 .673.03.907.09.235.06.409.115.524.166l-.434 1.304a7.355 7.355 0 0 0-.32-.096 1.94 1.94 0 0 0-.524-.057c-.499 0-.859.125-1.08.377-.218.251-.326.62-.326 1.106V36.5h-1.509Zm9.406.205c-.886 0-1.664-.211-2.333-.633-.665-.422-1.185-1.012-1.56-1.77-.37-.76-.556-1.646-.556-2.66 0-1.023.186-1.915.556-2.678.375-.763.895-1.355 1.56-1.777.669-.422 1.447-.633 2.333-.633.887 0 1.662.21 2.327.633.669.422 1.189 1.014 1.56 1.777.375.763.562 1.655.562 2.678 0 1.014-.187 1.9-.562 2.66-.371.758-.891 1.348-1.56 1.77-.665.422-1.44.633-2.327.633Zm0-1.356c.673 0 1.227-.172 1.662-.517.435-.346.757-.8.965-1.362a5.209 5.209 0 0 0 .314-1.828c0-.656-.105-1.268-.314-1.834a3.083 3.083 0 0 0-.965-1.375c-.435-.35-.989-.524-1.662-.524-.673 0-1.227.175-1.662.524-.434.35-.756.808-.965 1.375a5.261 5.261 0 0 0-.313 1.834c0 .656.104 1.266.313 1.828.209.563.531 1.017.965 1.362.435.345.989.517 1.662.517Zm14.703 1.381a3.987 3.987 0 0 1-1.693-.351 2.909 2.909 0 0 1-1.209-1.03c-.298-.451-.447-.997-.447-1.636 0-.562.111-1.018.332-1.368.222-.354.518-.63.889-.83.371-.201.78-.35 1.227-.448.452-.102.906-.183 1.362-.243.596-.077 1.08-.134 1.451-.173.375-.042.647-.113.818-.21.175-.099.262-.27.262-.512v-.051c0-.63-.173-1.12-.518-1.47-.341-.35-.858-.524-1.553-.524-.72 0-1.285.157-1.694.473-.409.315-.697.652-.863 1.01l-1.432-.512c.256-.596.597-1.061 1.023-1.393a3.83 3.83 0 0 1 1.406-.703 5.844 5.844 0 0 1 1.509-.205c.315 0 .677.038 1.086.115.414.072.812.224 1.196.454.388.23.709.577.965 1.042.256.464.383 1.086.383 1.866V36.5h-1.508v-1.33h-.077a2.64 2.64 0 0 1-.511.684c-.239.243-.556.45-.953.62-.396.17-.879.256-1.451.256Zm.231-1.355c.596 0 1.099-.117 1.508-.352a2.39 2.39 0 0 0 .933-.907c.213-.371.32-.76.32-1.17v-1.38c-.064.076-.205.146-.422.21-.213.06-.46.113-.741.16a34 34 0 0 1-1.445.192 5.752 5.752 0 0 0-1.099.25c-.337.11-.61.278-.819.504-.204.222-.306.524-.306.908 0 .524.193.92.581 1.189.392.264.889.396 1.49.396Zm8.531-4.781V36.5h-1.508v-9.818h1.457v1.534h.128c.23-.499.58-.9 1.048-1.202.469-.307 1.074-.46 1.816-.46.664 0 1.246.136 1.745.41.498.268.886.677 1.163 1.226.277.546.416 1.236.416 2.071V36.5h-1.509v-6.136c0-.772-.2-1.373-.601-1.803-.4-.435-.95-.652-1.649-.652-.481 0-.912.105-1.291.313a2.246 2.246 0 0 0-.889.914c-.217.4-.326.887-.326 1.458Zm9.641 9.588a3.35 3.35 0 0 1-.684-.064 1.792 1.792 0 0 1-.415-.115l.383-1.33c.367.094.691.128.972.103a1.17 1.17 0 0 0 .748-.378c.221-.221.424-.581.607-1.08l.281-.767-3.63-9.87h1.636l2.71 7.825h.102l2.711-7.824h1.636l-4.168 11.25c-.187.507-.419.927-.696 1.26a2.61 2.61 0 0 1-.966.747 2.973 2.973 0 0 1-1.227.243Zm13.318-13.5v1.278h-5.088v-1.278h5.088Zm-3.605-2.352h1.508v9.358c0 .426.062.745.186.958.128.21.29.35.486.422.2.068.411.102.632.102.167 0 .303-.008.409-.025l.256-.051.307 1.355a3.064 3.064 0 0 1-.428.115 3.163 3.163 0 0 1-.697.064c-.426 0-.844-.092-1.253-.275a2.492 2.492 0 0 1-1.01-.837c-.264-.375-.396-.848-.396-1.42V24.33Zm7.594 6.264V36.5h-1.509V23.41h1.509v4.806h.127c.231-.507.576-.91 1.036-1.208.464-.303 1.082-.454 1.854-.454.669 0 1.255.134 1.757.403.503.264.893.67 1.17 1.22.281.546.422 1.24.422 2.084V36.5h-1.508v-6.136c0-.78-.203-1.383-.608-1.81-.4-.43-.956-.645-1.668-.645a2.79 2.79 0 0 0-1.33.313 2.293 2.293 0 0 0-.92.914c-.222.4-.332.887-.332 1.458Zm9.126 5.906v-9.818h1.508V36.5h-1.508Zm.767-11.454c-.294 0-.548-.1-.761-.301a.964.964 0 0 1-.313-.722c0-.282.104-.522.313-.723.213-.2.467-.3.761-.3s.545.1.754.3c.213.2.32.441.32.723a.957.957 0 0 1-.32.722c-.209.2-.46.3-.754.3Zm5.013 5.548V36.5h-1.509v-9.818h1.458v1.534h.128a2.8 2.8 0 0 1 1.048-1.202c.469-.307 1.074-.46 1.815-.46.665 0 1.247.136 1.745.41.499.268.887.677 1.164 1.226.277.546.415 1.236.415 2.071V36.5H189.7v-6.136c0-.772-.201-1.373-.601-1.803-.401-.435-.951-.652-1.649-.652-.482 0-.912.105-1.292.313a2.238 2.238 0 0 0-.888.914c-.217.4-.326.887-.326 1.458Zm12.984 9.792c-.729 0-1.355-.093-1.88-.28-.524-.184-.96-.427-1.31-.73a3.975 3.975 0 0 1-.824-.958l1.201-.844c.137.179.309.383.518.614.209.234.494.436.857.607.366.174.845.262 1.438.262.792 0 1.446-.192 1.962-.576.516-.383.774-.984.774-1.802v-1.994h-.128a8.28 8.28 0 0 1-.473.664c-.201.26-.49.493-.87.697-.375.2-.882.3-1.521.3-.793 0-1.504-.187-2.135-.562-.626-.375-1.123-.92-1.489-1.636-.362-.716-.544-1.586-.544-2.608 0-1.006.177-1.882.531-2.627.354-.75.846-1.33 1.477-1.739.63-.413 1.359-.62 2.186-.62.639 0 1.146.107 1.521.32.379.208.669.447.869.716.205.264.362.481.473.651h.154v-1.56h1.457v10.1c0 .844-.192 1.53-.575 2.059a3.276 3.276 0 0 1-1.534 1.17c-.64.25-1.351.376-2.135.376Zm-.051-5.395c.605 0 1.116-.138 1.534-.415.417-.277.735-.675.952-1.195.217-.52.326-1.142.326-1.867 0-.707-.106-1.331-.32-1.873-.213-.54-.528-.965-.946-1.272-.417-.306-.933-.46-1.546-.46-.64 0-1.172.162-1.598.486-.422.324-.74.758-.953 1.304a5.036 5.036 0 0 0-.313 1.815c0 .682.106 1.285.32 1.81.217.519.536.928.958 1.226.427.294.955.442 1.586.442Z" fill="#A0A0A0"/></g><path d="m608.108 29.682 1.982 3.624 2.013-3.624h2.449l-2.96 4.909 3.011 4.909h-2.436l-2.077-3.535-2.058 3.535h-2.455l2.992-4.91-2.915-4.908h2.454Z" fill="#A0A0A0"/><path d="M18.577 73.5h-1.19l3.444-9.38h1.172l3.445 9.38h-1.191l-2.803-7.897h-.074L18.577 73.5Zm.44-3.664h4.8v1.007h-4.8v-1.007Zm7.892 3.664v-9.38h1.136v8.372h4.36V73.5H26.91Zm7.255 0v-9.38H35.3v8.372h4.36V73.5h-5.496Z" fill="#EDEDED"/><path fill="#0954A5" d="M17 91.5h23.14v2H17z"/><path d="M57.892 73.5h-1.2l3.472-9.454h1.181l3.472 9.454h-1.2l-2.825-7.959h-.074L57.892 73.5Zm.444-3.693h4.838v1.015h-4.838v-1.015ZM73.453 67h-1.145a2.38 2.38 0 0 0-.964-1.496 2.586 2.586 0 0 0-.79-.388 3.152 3.152 0 0 0-.905-.129c-.572 0-1.09.145-1.555.434-.462.29-.83.716-1.104 1.279-.27.563-.406 1.254-.406 2.073 0 .818.135 1.51.406 2.073.274.563.642.989 1.104 1.278.464.29.983.434 1.555.434.314 0 .616-.043.905-.129.29-.086.553-.214.79-.383a2.432 2.432 0 0 0 .965-1.5h1.144a3.814 3.814 0 0 1-.47 1.297 3.557 3.557 0 0 1-.85.974 3.722 3.722 0 0 1-1.14.605 4.25 4.25 0 0 1-1.344.207c-.806 0-1.523-.197-2.15-.59-.629-.395-1.123-.955-1.483-1.681-.36-.726-.54-1.588-.54-2.585 0-.997.18-1.86.54-2.585.36-.727.854-1.287 1.482-1.68.628-.395 1.345-.592 2.151-.592.477 0 .925.07 1.344.208.422.138.802.342 1.14.61.339.264.622.587.85.969.227.378.384.81.47 1.297Zm1.333-1.939v-1.016h7.091v1.016h-2.973V73.5H77.76v-8.439h-2.973Zm10.003-1.016V73.5h-1.145v-9.454h1.145Zm10.273 4.728c0 .997-.18 1.859-.54 2.585-.36.726-.854 1.286-1.482 1.68-.628.394-1.345.591-2.151.591-.807 0-1.524-.197-2.152-.59-.627-.395-1.121-.955-1.481-1.681-.36-.726-.54-1.588-.54-2.585 0-.997.18-1.86.54-2.585.36-.727.854-1.287 1.481-1.68.628-.395 1.345-.592 2.152-.592.806 0 1.523.197 2.151.591.628.394 1.122.954 1.482 1.68.36.727.54 1.589.54 2.586Zm-1.108 0c0-.819-.137-1.51-.41-2.073-.272-.563-.64-.99-1.104-1.279a2.86 2.86 0 0 0-1.551-.434c-.573 0-1.091.145-1.556.434-.462.29-.83.716-1.103 1.279-.271.563-.407 1.254-.407 2.073 0 .818.136 1.51.407 2.073.273.563.641.989 1.103 1.278.465.29.983.434 1.556.434a2.86 2.86 0 0 0 1.55-.434c.466-.289.833-.715 1.104-1.278.274-.564.411-1.255.411-2.073Zm10.53-4.727V73.5h-1.108l-5.152-7.423h-.092V73.5h-1.145v-9.454h1.108l5.17 7.441h.093v-7.441h1.126Zm7.462 2.363a1.45 1.45 0 0 0-.674-1.09c-.394-.258-.878-.387-1.45-.387-.419 0-.785.067-1.099.203a1.75 1.75 0 0 0-.729.558 1.342 1.342 0 0 0-.259.808c0 .253.06.47.18.651a1.6 1.6 0 0 0 .471.448c.191.117.391.214.6.291.21.074.402.134.577.18l.961.258a8.4 8.4 0 0 1 .821.268c.305.114.596.27.873.467.28.194.511.443.692.747.182.305.273.68.273 1.122 0 .511-.134.973-.402 1.385-.265.413-.652.74-1.163.984-.508.243-1.125.364-1.851.364-.677 0-1.264-.11-1.759-.328a2.807 2.807 0 0 1-1.164-.914 2.609 2.609 0 0 1-.475-1.362h1.182c.03.358.151.653.36.887.212.23.48.403.803.517.326.11.677.166 1.053.166.437 0 .829-.07 1.177-.212.348-.145.623-.345.826-.6.203-.259.305-.56.305-.905 0-.314-.088-.57-.263-.767a1.941 1.941 0 0 0-.693-.48 7.23 7.23 0 0 0-.928-.323l-1.163-.332c-.739-.213-1.323-.516-1.754-.91-.431-.394-.647-.91-.647-1.546 0-.53.144-.991.43-1.385a2.85 2.85 0 0 1 1.163-.923 3.929 3.929 0 0 1 1.639-.333c.609 0 1.151.11 1.625.328a2.8 2.8 0 0 1 1.126.886c.28.376.428.802.444 1.28h-1.108Zm26.893-2.363h1.145v6.26c0 .646-.152 1.223-.457 1.73a3.202 3.202 0 0 1-1.279 1.196c-.551.29-1.197.434-1.939.434s-1.388-.144-1.939-.434a3.233 3.233 0 0 1-1.283-1.195c-.302-.508-.453-1.085-.453-1.732v-6.26h1.145v6.168c0 .462.102.873.305 1.233.203.357.492.638.868.844.379.204.831.305 1.357.305s.979-.101 1.357-.305a2.14 2.14 0 0 0 .868-.844c.203-.36.305-.771.305-1.233v-6.167Zm8.602 2.363a1.45 1.45 0 0 0-.674-1.09c-.394-.258-.877-.387-1.45-.387a2.76 2.76 0 0 0-1.099.203 1.76 1.76 0 0 0-.729.558 1.342 1.342 0 0 0-.259.808c0 .253.06.47.181.651.123.179.28.328.47.448.191.117.391.214.601.291.209.074.401.134.577.18l.96.258a8.5 8.5 0 0 1 .822.268c.304.114.595.27.872.467.28.194.511.443.693.747.181.305.272.68.272 1.122 0 .511-.134.973-.402 1.385-.264.413-.652.74-1.163.984-.508.243-1.125.364-1.851.364-.677 0-1.264-.11-1.759-.328a2.807 2.807 0 0 1-1.164-.914 2.609 2.609 0 0 1-.475-1.362h1.182c.031.358.151.653.36.887.212.23.48.403.803.517.326.11.677.166 1.053.166.437 0 .829-.07 1.177-.212.348-.145.623-.345.826-.6.203-.259.305-.56.305-.905 0-.314-.088-.57-.263-.767a1.932 1.932 0 0 0-.693-.48 7.23 7.23 0 0 0-.928-.323l-1.163-.332c-.739-.213-1.323-.516-1.754-.91-.431-.394-.646-.91-.646-1.546 0-.53.143-.991.429-1.385a2.85 2.85 0 0 1 1.163-.923 3.932 3.932 0 0 1 1.639-.333c.609 0 1.151.11 1.625.328a2.8 2.8 0 0 1 1.126.886c.281.376.428.802.444 1.28h-1.108Zm3.119 7.091v-9.454h5.706v1.015h-4.561v3.195h4.266v1.015h-4.266v3.213h4.635V73.5h-5.78Zm7.77 0v-9.454h3.194c.739 0 1.345.126 1.819.378.474.25.825.592 1.053 1.03.228.437.341.934.341 1.49 0 .558-.113 1.052-.341 1.483a2.41 2.41 0 0 1-1.048 1.015c-.471.243-1.073.365-1.805.365h-2.585v-1.034h2.548c.505 0 .911-.074 1.219-.222.311-.148.535-.357.674-.628.141-.274.212-.6.212-.978a2.2 2.2 0 0 0-.212-.993 1.45 1.45 0 0 0-.679-.656c-.311-.156-.722-.235-1.233-.235h-2.012V73.5h-1.145Zm4.45-4.247 2.327 4.247h-1.33l-2.29-4.247h1.293Zm9.036-2.844a1.45 1.45 0 0 0-.674-1.09c-.394-.258-.877-.387-1.45-.387a2.76 2.76 0 0 0-1.099.203 1.76 1.76 0 0 0-.729.558 1.342 1.342 0 0 0-.259.808c0 .253.06.47.181.651.123.179.28.328.47.448.191.117.391.214.601.291.209.074.401.134.577.18l.96.258a8.5 8.5 0 0 1 .822.268c.304.114.595.27.872.467.28.194.511.443.693.747.181.305.272.68.272 1.122 0 .511-.134.973-.402 1.385-.264.413-.652.74-1.163.984-.508.243-1.125.364-1.851.364-.677 0-1.264-.11-1.759-.328a2.807 2.807 0 0 1-1.164-.914 2.609 2.609 0 0 1-.475-1.362h1.182c.031.358.151.653.36.887.212.23.48.403.803.517.326.11.677.166 1.053.166.437 0 .829-.07 1.177-.212.348-.145.623-.345.826-.6.203-.259.305-.56.305-.905 0-.314-.088-.57-.263-.767a1.932 1.932 0 0 0-.693-.48 7.23 7.23 0 0 0-.928-.323l-1.163-.332c-.739-.213-1.323-.516-1.754-.91-.431-.394-.646-.91-.646-1.546 0-.53.143-.991.429-1.385a2.85 2.85 0 0 1 1.163-.923 3.932 3.932 0 0 1 1.639-.333c.609 0 1.151.11 1.625.328a2.8 2.8 0 0 1 1.126.886c.281.376.428.802.444 1.28h-1.108Z" fill="#7E7E7E"/><path d="M639 92.5H1v2h638v-2Z" fill="#343434" mask="url(#Dialog__path-2-inside-1_1_3)"/><g clip-path="url(#Dialog__d)"><path d="M8.415 121.5H7.307l3.204-8.727h1.091l3.205 8.727h-1.108l-2.608-7.347h-.068L8.415 121.5Zm.409-3.409h4.466v.937H8.824v-.937Zm13.955-2.591h-1.057a2.194 2.194 0 0 0-.89-1.381 2.399 2.399 0 0 0-.73-.358 2.929 2.929 0 0 0-.835-.119c-.528 0-1.007.134-1.436.401-.426.267-.765.66-1.018 1.18-.25.52-.375 1.158-.375 1.913 0 .756.125 1.394.375 1.914.253.52.592.913 1.018 1.18.43.267.908.401 1.436.401.29 0 .569-.04.836-.12.267-.079.51-.197.728-.353a2.246 2.246 0 0 0 .89-1.385h1.058c-.08.446-.225.845-.435 1.197a3.274 3.274 0 0 1-1.837 1.458c-.386.127-.8.191-1.24.191-.744 0-1.406-.181-1.985-.545-.58-.364-1.036-.881-1.368-1.551-.333-.671-.499-1.466-.499-2.387 0-.92.166-1.716.499-2.386.332-.67.788-1.188 1.368-1.551.58-.364 1.241-.546 1.985-.546.44 0 .854.064 1.24.192.39.128.74.316 1.053.563a3.2 3.2 0 0 1 .784.895c.21.349.355.748.435 1.197Zm1.23-1.79v-.937h6.546v.937H27.81v7.79h-1.056v-7.79h-2.745Zm9.233-.937v8.727h-1.056v-8.727h1.056Zm9.483 4.363c0 .921-.166 1.716-.498 2.387-.333.67-.789 1.187-1.368 1.551-.58.364-1.242.545-1.986.545s-1.406-.181-1.986-.545c-.58-.364-1.035-.881-1.368-1.551-.332-.671-.498-1.466-.498-2.387 0-.92.166-1.716.498-2.386.333-.67.788-1.188 1.368-1.551.58-.364 1.242-.546 1.986-.546s1.406.182 1.986.546c.58.363 1.035.881 1.368 1.551.332.67.498 1.466.498 2.386Zm-1.023 0c0-.755-.126-1.393-.379-1.913-.25-.52-.59-.913-1.018-1.18a2.641 2.641 0 0 0-1.432-.401c-.529 0-1.007.134-1.436.401-.426.267-.766.66-1.019 1.18-.25.52-.375 1.158-.375 1.913 0 .756.125 1.394.375 1.914.253.52.593.913 1.019 1.18.429.267.907.401 1.436.401.528 0 1.006-.134 1.432-.401.429-.267.768-.66 1.018-1.18.253-.52.38-1.158.38-1.914Zm9.72-4.363v8.727H50.4l-4.756-6.852h-.085v6.852h-1.057v-8.727h1.023l4.773 6.869h.085v-6.869h1.04Zm6.888 2.182a1.339 1.339 0 0 0-.622-1.006c-.364-.239-.81-.358-1.338-.358-.387 0-.725.062-1.014.187a1.618 1.618 0 0 0-.674.516 1.236 1.236 0 0 0-.238.746c0 .233.055.433.166.601.113.164.258.302.434.413.177.108.361.197.554.268.194.069.371.124.533.167l.887.238c.227.06.48.142.758.247.281.106.55.249.805.431.259.179.472.409.64.69.167.281.251.627.251 1.036 0 .471-.123.897-.37 1.278-.245.381-.603.683-1.075.908-.468.224-1.038.336-1.708.336-.625 0-1.166-.1-1.624-.302a2.588 2.588 0 0 1-1.074-.844 2.409 2.409 0 0 1-.439-1.257h1.091c.029.33.14.602.333.818a1.8 1.8 0 0 0 .741.477c.301.103.625.154.972.154.403 0 .765-.065 1.086-.196.321-.134.576-.318.763-.554a1.31 1.31 0 0 0 .281-.835c0-.29-.08-.526-.243-.708a1.784 1.784 0 0 0-.639-.443 6.627 6.627 0 0 0-.856-.298l-1.074-.307c-.682-.196-1.222-.476-1.62-.84-.397-.363-.596-.839-.596-1.427 0-.489.132-.915.396-1.279.267-.366.625-.65 1.074-.852a3.635 3.635 0 0 1 1.513-.307c.562 0 1.062.101 1.5.303a2.6 2.6 0 0 1 1.04.818c.258.347.395.74.409 1.181H58.31Z" fill="#7E7E7E"/><rect x="11" y="131.5" width="612" height="48" rx="6" fill="#232323"/><g clip-path="url(#Dialog__e)"><g clip-path="url(#Dialog__f)"><g clip-path="url(#Dialog__g)" fill="#BFBFBF"><path d="M48 157.5v5a2 2 0 0 1-2 2H32a2 2 0 0 1-2-2v-14a2 2 0 0 1 2-2h5v2h-5v14h14v-5h2Z"/><path d="M48 150.5h-4v-4h-2v4h-4v2h4v4h2v-4h4"/></g></g></g><path d="M76.869 153.383H74.69a2.13 2.13 0 0 0-.244-.751 1.913 1.913 0 0 0-.472-.567 2.096 2.096 0 0 0-.666-.358 2.572 2.572 0 0 0-.81-.124c-.527 0-.986.131-1.378.393-.39.258-.694.636-.91 1.133-.215.494-.323 1.094-.323 1.8 0 .726.108 1.336.324 1.83.218.493.523.866.914 1.118a2.45 2.45 0 0 0 1.358.378c.288 0 .555-.038.8-.114.249-.076.47-.188.661-.333.193-.15.352-.33.478-.542a2.12 2.12 0 0 0 .268-.726l2.178.01a4.055 4.055 0 0 1-1.322 2.51 4.223 4.223 0 0 1-1.343.806c-.517.195-1.102.293-1.755.293-.908 0-1.72-.205-2.436-.616-.713-.411-1.276-1.006-1.69-1.785-.411-.779-.617-1.722-.617-2.829 0-1.11.209-2.055.626-2.834.418-.779.985-1.372 1.7-1.78.717-.411 1.522-.616 2.417-.616.59 0 1.137.083 1.64.249.508.165.957.407 1.348.725.39.315.71.701.954 1.159.249.457.408.981.478 1.571ZM78.373 160v-7.636h2.053v1.332h.08c.138-.474.372-.832.7-1.074a1.844 1.844 0 0 1 1.134-.368c.106 0 .22.007.343.02.122.013.23.032.323.055v1.879c-.1-.03-.237-.056-.413-.079a3.574 3.574 0 0 0-.482-.035c-.311 0-.59.068-.835.204a1.5 1.5 0 0 0-.577.556 1.61 1.61 0 0 0-.209.826V160h-2.117Zm8.853.149c-.786 0-1.462-.159-2.029-.477a3.275 3.275 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.385 3.385 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.96-.497.503 0 .972.081 1.406.244.438.159.819.399 1.144.721.328.321.583.726.765 1.213.183.484.274 1.05.274 1.7v.582h-6.448v-1.313h4.454a1.62 1.62 0 0 0-.199-.81 1.43 1.43 0 0 0-.552-.552 1.573 1.573 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.568 1.568 0 0 0-.577.592c-.14.245-.21.518-.214.82v1.248c0 .378.07.704.21.979.142.275.342.487.6.636.26.15.566.224.92.224.236 0 .451-.033.647-.099a1.293 1.293 0 0 0 .82-.786l1.959.129a2.67 2.67 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.48.192-1.036.288-1.665.288Zm7.064-.005a3.18 3.18 0 0 1-1.302-.253 2.1 2.1 0 0 1-.905-.761c-.219-.338-.328-.759-.328-1.263 0-.424.078-.78.234-1.069.155-.288.367-.52.636-.696a3.09 3.09 0 0 1 .915-.397 6.86 6.86 0 0 1 1.083-.189c.444-.047.802-.09 1.074-.13.272-.043.47-.106.592-.189a.413.413 0 0 0 .184-.367v-.03c0-.315-.1-.559-.299-.731-.195-.172-.473-.259-.835-.259-.38 0-.684.085-.91.254a1.166 1.166 0 0 0-.447.626l-1.959-.159c.1-.464.295-.865.587-1.203a2.816 2.816 0 0 1 1.129-.785c.463-.186 1-.279 1.61-.279.424 0 .83.05 1.218.149.391.1.738.254 1.04.463.304.209.545.477.72.805.176.325.264.714.264 1.168V160h-2.009v-1.059h-.06a2.144 2.144 0 0 1-.492.631c-.205.179-.452.32-.74.423a3.074 3.074 0 0 1-1 .149Zm.607-1.461c.311 0 .587-.062.825-.184.239-.126.426-.295.562-.508.136-.212.204-.452.204-.72v-.811a1.156 1.156 0 0 1-.274.12c-.112.033-.24.064-.382.094-.143.027-.285.051-.428.075l-.388.054a2.668 2.668 0 0 0-.651.174c-.186.08-.33.188-.433.323a.79.79 0 0 0-.154.498c0 .288.105.508.313.661.213.149.481.224.806.224Zm9.399-6.319v1.591h-4.6v-1.591h4.6Zm-3.555-1.83h2.118v7.119c0 .196.03.348.089.458a.5.5 0 0 0 .249.224c.109.043.235.064.378.064.099 0 .199-.008.298-.025.099-.02.176-.035.229-.044l.333 1.576a5.938 5.938 0 0 1-.448.114 3.626 3.626 0 0 1-.701.084c-.51.02-.957-.048-1.342-.203a1.876 1.876 0 0 1-.89-.726c-.212-.328-.316-.743-.313-1.243v-7.398Zm8.332 9.615c-.785 0-1.461-.159-2.028-.477a3.273 3.273 0 0 1-1.303-1.362c-.305-.59-.457-1.288-.457-2.093 0-.786.152-1.475.457-2.069a3.39 3.39 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.437.159.818.399 1.143.721.328.321.584.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455c0-.305-.067-.575-.199-.81a1.435 1.435 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.562 1.562 0 0 0-.577.592 1.667 1.667 0 0 0-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.601.636.259.15.565.224.92.224.235 0 .451-.033.646-.099.196-.067.363-.166.503-.299.139-.132.245-.295.318-.487l1.959.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.666.288Zm10.246-4.564V160h-2.118v-7.636h2.018v1.347h.09c.169-.444.452-.796.85-1.054.397-.262.88-.393 1.446-.393.531 0 .993.116 1.388.348.394.232.701.564.919.995.219.427.328.938.328 1.531V160h-2.117v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-1-.398a1.51 1.51 0 0 0-.755.184 1.287 1.287 0 0 0-.508.537 1.86 1.86 0 0 0-.183.84Zm10.071 4.564c-.786 0-1.462-.159-2.029-.477a3.277 3.277 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.388 3.388 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.438.159.819.399 1.144.721.328.321.583.726.765 1.213.183.484.274 1.05.274 1.7v.582h-6.448v-1.313h4.454c0-.305-.066-.575-.199-.81a1.422 1.422 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204 1.63 1.63 0 0 0-.855.224 1.569 1.569 0 0 0-.577.592c-.139.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.143.275.343.487.602.636.258.15.565.224.92.224.235 0 .45-.033.646-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.661 2.661 0 0 1-.612 1.233c-.304.348-.699.62-1.183.816-.48.192-1.036.288-1.665.288Zm6.339-.149-2.079-7.636h2.143l1.183 5.13h.07l1.233-5.13h2.103l1.253 5.1h.064l1.164-5.1h2.138L142.927 160h-2.242l-1.312-4.803h-.095L137.966 160h-2.237Zm13.681 0v-10.182h4.017c.769 0 1.426.138 1.969.413.547.272.963.658 1.248 1.158.288.497.433 1.082.433 1.755 0 .676-.146 1.258-.438 1.745-.292.484-.714.855-1.268 1.114-.55.258-1.216.388-1.998.388h-2.69v-1.73h2.342c.411 0 .752-.057 1.024-.17.272-.112.474-.281.606-.507.136-.225.204-.505.204-.84 0-.338-.068-.623-.204-.855a1.245 1.245 0 0 0-.611-.527c-.272-.123-.615-.184-1.029-.184h-1.452V160h-2.153Zm5.499-4.634 2.53 4.634h-2.376l-2.476-4.634h2.322Zm7.006 4.783c-.785 0-1.462-.159-2.028-.477a3.273 3.273 0 0 1-1.303-1.362c-.305-.59-.457-1.288-.457-2.093 0-.786.152-1.475.457-2.069a3.384 3.384 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.503 0 .972.081 1.407.244.437.159.818.399 1.143.721.328.321.583.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.454c0-.305-.066-.575-.198-.81a1.435 1.435 0 0 0-.552-.552 1.573 1.573 0 0 0-.811-.204c-.321 0-.606.075-.855.224a1.566 1.566 0 0 0-.576.592c-.14.245-.211.518-.214.82v1.248c0 .378.069.704.209.979.142.275.343.487.601.636.259.15.565.224.92.224.235 0 .451-.033.646-.099a1.287 1.287 0 0 0 .821-.786l1.958.129a2.669 2.669 0 0 1-.611 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.666.288Zm11.241-5.608-1.939.12a.997.997 0 0 0-.214-.448 1.123 1.123 0 0 0-.432-.323 1.469 1.469 0 0 0-.632-.124c-.328 0-.605.069-.83.208-.225.136-.338.319-.338.547 0 .183.073.337.219.463.146.126.396.227.75.303l1.383.278c.742.153 1.295.398 1.66.736.365.338.547.782.547 1.333 0 .5-.148.939-.443 1.317-.291.378-.692.673-1.203.885-.507.209-1.092.313-1.755.313-1.011 0-1.816-.21-2.416-.631a2.462 2.462 0 0 1-1.049-1.73l2.083-.11c.063.309.216.544.458.706.242.159.551.239.929.239.372 0 .67-.071.895-.214.229-.146.345-.333.348-.562a.584.584 0 0 0-.243-.472c-.159-.126-.405-.222-.736-.288l-1.323-.264c-.745-.149-1.301-.408-1.665-.775-.361-.368-.542-.837-.542-1.407 0-.491.133-.913.398-1.268.268-.355.644-.628 1.128-.82.487-.193 1.058-.289 1.71-.289.965 0 1.724.204 2.277.612.557.407.882.963.975 1.665Zm4.958 5.608c-.772 0-1.44-.164-2.004-.492a3.365 3.365 0 0 1-1.297-1.382c-.305-.593-.458-1.281-.458-2.063 0-.789.153-1.479.458-2.069a3.329 3.329 0 0 1 1.297-1.382c.564-.331 1.232-.497 2.004-.497s1.438.166 1.998.497c.564.328.998.789 1.303 1.382.305.59.457 1.28.457 2.069 0 .782-.152 1.47-.457 2.063a3.353 3.353 0 0 1-1.303 1.382c-.56.328-1.226.492-1.998.492Zm.01-1.64c.351 0 .644-.1.88-.299.235-.202.412-.477.532-.825a3.58 3.58 0 0 0 .184-1.188c0-.444-.062-.84-.184-1.188-.12-.348-.297-.624-.532-.826-.236-.202-.529-.303-.88-.303-.355 0-.653.101-.895.303-.239.202-.419.478-.542.826a3.662 3.662 0 0 0-.179 1.188c0 .444.06.84.179 1.188.123.348.303.623.542.825.242.199.54.299.895.299Zm10.022-1.76v-4.385h2.118V160h-2.033v-1.387h-.08a2.256 2.256 0 0 1-.86 1.079c-.397.272-.883.407-1.456.407-.511 0-.96-.116-1.348-.348a2.387 2.387 0 0 1-.909-.989c-.216-.427-.325-.94-.329-1.536v-4.862h2.118v4.484c.004.451.125.807.363 1.069.239.262.559.393.96.393.255 0 .494-.058.716-.174.222-.12.401-.295.537-.527.139-.232.207-.519.203-.86Zm3.812 3.251v-7.636h2.054v1.332h.079c.139-.474.373-.832.701-1.074a1.845 1.845 0 0 1 1.134-.368c.106 0 .22.007.343.02.122.013.23.032.323.055v1.879a2.717 2.717 0 0 0-.413-.079 3.561 3.561 0 0 0-.482-.035c-.311 0-.59.068-.835.204a1.503 1.503 0 0 0-.577.556 1.612 1.612 0 0 0-.209.826V160h-2.118Zm8.824.149c-.782 0-1.455-.166-2.019-.497a3.36 3.36 0 0 1-1.292-1.392c-.299-.593-.448-1.276-.448-2.048 0-.783.151-1.469.453-2.059a3.366 3.366 0 0 1 1.297-1.387c.56-.334 1.227-.502 1.999-.502.666 0 1.249.121 1.75.363.5.242.896.582 1.188 1.019.292.438.452.952.482 1.542h-1.998c-.057-.382-.206-.688-.448-.92-.238-.236-.552-.353-.939-.353-.328 0-.615.089-.86.268-.242.176-.431.433-.567.771-.136.338-.204.747-.204 1.228 0 .487.066.901.199 1.243.136.341.326.601.572.78.245.179.532.269.86.269a1.4 1.4 0 0 0 .651-.149c.195-.1.356-.244.482-.433.129-.192.214-.423.254-.691h1.998a3.128 3.128 0 0 1-.477 1.541 2.88 2.88 0 0 1-1.168 1.034c-.497.249-1.086.373-1.765.373Zm8.246 0c-.785 0-1.461-.159-2.028-.477a3.28 3.28 0 0 1-1.303-1.362c-.304-.59-.457-1.288-.457-2.093 0-.786.153-1.475.457-2.069a3.39 3.39 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244a3.11 3.11 0 0 1 1.143.721c.328.321.584.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455c0-.305-.067-.575-.199-.81a1.435 1.435 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.562 1.562 0 0 0-.577.592 1.667 1.667 0 0 0-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.601.636.259.15.566.224.92.224.236 0 .451-.033.647-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.666.288Z" fill="#EDEDED"/><rect x="559" y="145.5" width="20" height="20" rx="4" fill="#232323"/><path d="m565.656 155.24-.648-.648 3.495-3.495 3.494 3.495-.648.648-2.846-2.839-2.847 2.839Z" fill="#A0A0A0"/><rect x="587" y="145.5" width="20" height="20.82" rx="4" fill="#232323"/><path d="M594.217 160.32v-8.727h2.949c.682 0 1.241.116 1.679.349.437.23.761.547.971.95.21.404.316.863.316 1.377s-.106.97-.316 1.368a2.22 2.22 0 0 1-.967.937c-.435.225-.99.337-1.666.337h-2.387v-.955h2.353c.466 0 .841-.068 1.125-.204.287-.137.494-.33.622-.58.13-.253.196-.554.196-.903 0-.35-.066-.655-.196-.916a1.336 1.336 0 0 0-.627-.605c-.287-.145-.666-.218-1.137-.218h-1.858v7.79h-1.057Zm4.108-3.92 2.148 3.92h-1.228l-2.113-3.92h1.193Z" fill="#A0A0A0"/><g clip-path="url(#Dialog__h)"><g clip-path="url(#Dialog__i)"><g clip-path="url(#Dialog__j)" fill="#BFBFBF"><path d="M37.251 191.995a3.371 3.371 0 0 1 3.498 0l7.875 4.773a3.374 3.374 0 0 1 1.626 2.886v.846a1.127 1.127 0 0 1-1.125 1.125A1.127 1.127 0 0 1 48 200.5v-.846a1.126 1.126 0 0 0-.541-.963l-7.876-4.771a1.123 1.123 0 0 0-1.166 0l-7.876 4.771a1.126 1.126 0 0 0-.541.963v7.692a1.126 1.126 0 0 0 .541.963l6.043 3.66a1.12 1.12 0 0 1 .509.694 1.128 1.128 0 0 1-1.264 1.381 1.147 1.147 0 0 1-.413-.15l-6.04-3.66a3.371 3.371 0 0 1-1.626-2.889v-7.691a3.374 3.374 0 0 1 1.626-2.886l7.875-4.773Z"/><path fill-rule="evenodd" clip-rule="evenodd" d="m44.623 202.488.002-.063v-.429a1.125 1.125 0 1 0-2.25 0v.429l.002.063a5.584 5.584 0 0 0-1.977.819.682.682 0 0 0-.045-.045l-.302-.305a1.125 1.125 0 0 0-1.59 1.59l.301.305.045.042a5.62 5.62 0 0 0-.82 1.978l-.06-.001H37.5a1.124 1.124 0 1 0 0 2.25h.429l.057-.002c.146.72.429 1.389.82 1.98a.901.901 0 0 0-.041.041l-.303.303a1.124 1.124 0 0 0 1.59 1.59l.304-.303.038-.039a5.652 5.652 0 0 0 1.983.822l-.002.054v.429a1.124 1.124 0 0 0 2.25 0v-.483a5.607 5.607 0 0 0 1.98-.822l.039.039.303.304a1.123 1.123 0 0 0 1.577-.014 1.126 1.126 0 0 0 .013-1.577l-.301-.303a.545.545 0 0 0-.042-.039 5.62 5.62 0 0 0 .82-1.982h.486a1.124 1.124 0 1 0 0-2.25h-.429l-.06.003a5.596 5.596 0 0 0-.82-1.978l.044-.042.303-.303a1.128 1.128 0 0 0-.012-1.578 1.124 1.124 0 0 0-1.578-.014l-.304.303-.044.045a5.582 5.582 0 0 0-1.977-.817Zm-1.123 2.137a3.371 3.371 0 0 0-3.12 4.667 3.375 3.375 0 1 0 6.24-2.584 3.375 3.375 0 0 0-3.12-2.083Z"/></g></g></g><path d="M69.64 208h-2.307l3.515-10.182h2.774L77.132 208h-2.307l-2.55-7.855h-.08L69.64 208Zm-.144-4.002h5.449v1.68h-5.45v-1.68Zm11.28 4.126c-.58 0-1.105-.149-1.576-.447-.467-.302-.838-.744-1.113-1.328-.272-.586-.408-1.305-.408-2.157 0-.875.14-1.603.423-2.183.281-.583.656-1.019 1.123-1.307.47-.292.986-.438 1.546-.438.428 0 .784.073 1.07.219.288.142.52.321.695.537a2.7 2.7 0 0 1 .408.626h.064v-3.828h2.113V208h-2.088v-1.223h-.09c-.099.212-.24.423-.422.631a2.08 2.08 0 0 1-.7.512c-.286.136-.634.204-1.045.204Zm.671-1.685c.342 0 .63-.093.865-.278.24-.189.421-.453.547-.791a3.32 3.32 0 0 0 .194-1.188c0-.454-.063-.849-.189-1.183-.126-.335-.308-.594-.547-.776a1.393 1.393 0 0 0-.87-.273c-.348 0-.64.094-.88.283a1.734 1.734 0 0 0-.541.785 3.377 3.377 0 0 0-.184 1.164c0 .444.06.837.184 1.178.126.338.306.603.541.796.24.188.532.283.88.283Zm8.23 1.685c-.58 0-1.106-.149-1.576-.447-.468-.302-.839-.744-1.114-1.328-.272-.586-.408-1.305-.408-2.157 0-.875.141-1.603.423-2.183.282-.583.656-1.019 1.124-1.307.47-.292.986-.438 1.546-.438.427 0 .784.073 1.069.219.288.142.52.321.696.537.179.212.314.421.407.626h.065v-3.828h2.113V208h-2.088v-1.223h-.09c-.1.212-.24.423-.422.631a2.08 2.08 0 0 1-.701.512c-.285.136-.633.204-1.044.204Zm.67-1.685c.342 0 .63-.093.866-.278.239-.189.42-.453.547-.791a3.32 3.32 0 0 0 .194-1.188c0-.454-.063-.849-.19-1.183-.125-.335-.307-.594-.546-.776a1.393 1.393 0 0 0-.87-.273c-.348 0-.641.094-.88.283-.239.189-.42.451-.542.785a3.377 3.377 0 0 0-.184 1.164c0 .444.061.837.184 1.178.126.338.306.603.542.796.239.188.532.283.88.283Zm10.774-2.854V208h-2.118v-7.636h2.019v1.347h.089c.169-.444.453-.796.85-1.054.398-.262.88-.393 1.447-.393.531 0 .993.116 1.387.348.395.232.701.564.92.995.219.427.328.938.328 1.531V208h-2.118v-4.484c.004-.468-.116-.832-.358-1.094-.242-.265-.575-.398-.999-.398-.285 0-.537.061-.756.184a1.291 1.291 0 0 0-.507.537c-.119.232-.18.512-.184.84Zm10.071 4.564c-.785 0-1.461-.159-2.028-.477a3.27 3.27 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.382 3.382 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244a3.11 3.11 0 0 1 1.143.721c.329.321.584.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455c0-.305-.066-.575-.199-.81a1.435 1.435 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.562 1.562 0 0 0-.577.592 1.667 1.667 0 0 0-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.602.636.258.15.565.224.919.224.236 0 .451-.033.647-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.666.288Zm6.339-.149-2.078-7.636h2.143l1.183 5.13h.07l1.233-5.13h2.103l1.253 5.1h.064l1.163-5.1h2.138L124.73 208h-2.242l-1.313-4.803h-.094L119.768 208h-2.237Zm19.206-7.254c-.04-.401-.211-.712-.513-.934-.301-.222-.711-.333-1.228-.333-.351 0-.648.049-.889.149-.242.096-.428.23-.557.403a.966.966 0 0 0-.189.586.832.832 0 0 0 .114.477c.086.136.204.254.353.353.149.097.322.181.517.254.196.07.405.129.627.179l.914.219a6.47 6.47 0 0 1 1.223.397c.372.166.693.37.965.612s.482.527.631.855c.153.328.231.704.234 1.129-.003.623-.162 1.163-.477 1.62-.312.454-.763.807-1.353 1.059-.586.249-1.294.373-2.122.373-.822 0-1.538-.126-2.148-.378-.607-.252-1.081-.624-1.422-1.118-.338-.497-.515-1.112-.532-1.845h2.083c.023.342.121.627.293.855.176.226.41.396.701.512.295.113.628.169 1 .169.364 0 .681-.053.949-.159a1.46 1.46 0 0 0 .632-.442c.149-.189.223-.406.223-.651a.846.846 0 0 0-.204-.577c-.132-.156-.328-.288-.586-.398a5.962 5.962 0 0 0-.94-.298l-1.108-.278c-.859-.209-1.537-.536-2.034-.98-.497-.444-.744-1.042-.741-1.795-.003-.616.161-1.155.493-1.615.334-.461.793-.821 1.377-1.079.583-.259 1.246-.388 1.988-.388.756 0 1.416.129 1.979.388.567.258 1.008.618 1.322 1.079.315.46.478.994.488 1.6h-2.063Zm7.09 7.403c-.785 0-1.461-.159-2.028-.477a3.273 3.273 0 0 1-1.303-1.362c-.305-.59-.457-1.288-.457-2.093 0-.786.152-1.475.457-2.069a3.384 3.384 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .972.081 1.407.244.437.159.818.399 1.143.721.328.321.583.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455c0-.305-.067-.575-.199-.81a1.435 1.435 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.856.224a1.566 1.566 0 0 0-.576.592c-.14.245-.211.518-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.601.636.259.15.565.224.92.224.235 0 .451-.033.646-.099a1.287 1.287 0 0 0 .821-.786l1.958.129a2.669 2.669 0 0 1-.611 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.666.288Zm4.887-.149v-7.636h2.054v1.332h.079c.139-.474.373-.832.701-1.074a1.845 1.845 0 0 1 1.134-.368c.106 0 .22.007.343.02.122.013.23.032.323.055v1.879c-.1-.03-.237-.056-.413-.079a3.561 3.561 0 0 0-.482-.035c-.312 0-.59.068-.835.204a1.503 1.503 0 0 0-.577.556 1.612 1.612 0 0 0-.209.826V208h-2.118Zm13.081-7.636-2.67 7.636h-2.387l-2.669-7.636h2.237l1.586 5.463h.079l1.581-5.463h2.243Zm1.083 7.636v-7.636h2.118V208h-2.118Zm1.064-8.621c-.315 0-.585-.104-.81-.313a1.016 1.016 0 0 1-.333-.761c0-.291.111-.542.333-.75a1.14 1.14 0 0 1 .81-.318c.315 0 .584.106.806.318a.988.988 0 0 1 .338.75c0 .295-.113.549-.338.761a1.133 1.133 0 0 1-.806.313Zm6.201 8.77c-.782 0-1.455-.166-2.018-.497a3.368 3.368 0 0 1-1.293-1.392c-.298-.593-.447-1.276-.447-2.048 0-.783.15-1.469.452-2.059a3.362 3.362 0 0 1 1.298-1.387c.56-.334 1.226-.502 1.998-.502.666 0 1.25.121 1.75.363a2.92 2.92 0 0 1 1.188 1.019c.292.438.453.952.483 1.542h-1.999c-.056-.382-.205-.688-.447-.92-.239-.236-.552-.353-.94-.353-.328 0-.615.089-.86.268-.242.176-.431.433-.567.771-.136.338-.204.747-.204 1.228 0 .487.067.901.199 1.243.136.341.327.601.572.78.245.179.532.269.86.269a1.4 1.4 0 0 0 .651-.149c.196-.1.357-.244.482-.433a1.65 1.65 0 0 0 .254-.691h1.999c-.034.583-.193 1.097-.478 1.541a2.873 2.873 0 0 1-1.168 1.034c-.497.249-1.085.373-1.765.373Zm8.247 0c-.786 0-1.462-.159-2.029-.477a3.277 3.277 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.388 3.388 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.438.159.819.399 1.144.721.328.321.583.726.765 1.213.183.484.274 1.05.274 1.7v.582h-6.448v-1.313h4.454c0-.305-.066-.575-.199-.81a1.422 1.422 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204 1.63 1.63 0 0 0-.855.224 1.569 1.569 0 0 0-.577.592c-.139.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.143.275.343.487.602.636.258.15.565.224.92.224.235 0 .45-.033.646-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.661 2.661 0 0 1-.612 1.233c-.304.348-.699.62-1.183.816-.48.192-1.036.288-1.665.288Z" fill="#A0A0A0"/><rect x="559" y="193.5" width="20" height="20" rx="4" fill="#232323"/><path d="m565.656 203.24-.648-.648 3.495-3.495 3.494 3.495-.648.648-2.846-2.839-2.847 2.839Z" fill="#A0A0A0"/><rect x="587" y="193.5" width="20" height="20.82" rx="4" fill="#232323"/><path d="M599 201.775a1.341 1.341 0 0 0-.623-1.006c-.363-.239-.809-.358-1.338-.358-.386 0-.724.062-1.014.187a1.617 1.617 0 0 0-.673.516 1.237 1.237 0 0 0-.239.746c0 .233.056.433.166.601.114.164.259.302.435.413.176.108.361.197.554.268.193.069.371.124.533.167l.886.238c.227.06.48.142.759.247.281.106.549.249.805.431.259.179.472.409.639.69.168.281.252.627.252 1.036a2.3 2.3 0 0 1-.371 1.278c-.244.381-.602.683-1.074.908-.469.224-1.038.336-1.709.336-.625 0-1.166-.1-1.623-.302a2.583 2.583 0 0 1-1.074-.844 2.404 2.404 0 0 1-.439-1.257h1.091c.028.33.139.602.332.818.196.213.443.372.742.477.301.103.625.154.971.154.404 0 .766-.065 1.087-.196.321-.134.575-.318.763-.554.187-.239.281-.517.281-.835 0-.29-.081-.526-.243-.708a1.786 1.786 0 0 0-.639-.443 6.614 6.614 0 0 0-.857-.298l-1.074-.307c-.681-.196-1.221-.476-1.619-.84-.398-.363-.597-.839-.597-1.427 0-.489.133-.915.397-1.278a2.631 2.631 0 0 1 1.074-.853 3.632 3.632 0 0 1 1.512-.307c.563 0 1.063.101 1.5.303.438.199.785.472 1.04.818.259.347.395.74.409 1.181H599Z" fill="#A0A0A0"/><g clip-path="url(#Dialog__k)"><g clip-path="url(#Dialog__l)" stroke="#BFBFBF" stroke-width="1.5"><path d="M39 254.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"/><path d="M30.661 250.139c.473.297.777.803.777 1.361 0 .558-.304 1.064-.777 1.361-.321.202-.529.363-.676.555a2.001 2.001 0 0 0-.396 1.479c.052.394.285.798.75 1.605.467.807.7 1.21 1.015 1.453.421.322.953.465 1.479.396.24-.032.483-.131.819-.308a1.617 1.617 0 0 1 1.567.008c.483.279.77.795.79 1.353.014.379.05.64.143.863.203.49.593.88 1.083 1.083.367.152.833.152 1.765.152.932 0 1.398 0 1.765-.152.49-.203.88-.593 1.083-1.083.092-.223.129-.484.143-.863.02-.558.307-1.074.79-1.353a1.617 1.617 0 0 1 1.567-.008c.336.178.58.276.82.308a2 2 0 0 0 1.478-.396c.315-.242.548-.646 1.014-1.453a21 21 0 0 0 .489-.873m-.81-2.766a1.618 1.618 0 0 1-.777-1.361c0-.558.304-1.064.777-1.361.321-.202.528-.363.676-.555.323-.421.465-.953.396-1.479-.052-.394-.285-.798-.75-1.605-.467-.807-.7-1.211-1.015-1.453a2 2 0 0 0-1.479-.396c-.24.032-.483.13-.82.308a1.617 1.617 0 0 1-1.566-.008 1.616 1.616 0 0 1-.79-1.353c-.014-.379-.05-.64-.143-.863a2.002 2.002 0 0 0-1.083-1.083c-.367-.152-.833-.152-1.765-.152-.932 0-1.398 0-1.765.152-.49.203-.88.593-1.083 1.083-.092.223-.129.483-.143.863a1.616 1.616 0 0 1-.79 1.353 1.617 1.617 0 0 1-1.567.008c-.336-.178-.58-.276-.82-.308a2 2 0 0 0-1.478.396c-.315.242-.548.646-1.014 1.453a21 21 0 0 0-.489.873" stroke-linecap="round"/></g></g><path d="M77.242 250.909c0 1.11-.211 2.055-.632 2.834-.418.779-.988 1.374-1.71 1.785-.72.407-1.528.611-2.426.611-.905 0-1.717-.205-2.436-.616-.72-.411-1.288-1.006-1.706-1.785-.417-.779-.626-1.722-.626-2.829 0-1.11.209-2.055.626-2.834.418-.779.986-1.372 1.706-1.78.719-.411 1.53-.616 2.436-.616.898 0 1.707.205 2.426.616.722.408 1.292 1.001 1.71 1.78.421.779.632 1.724.632 2.834Zm-2.183 0c0-.719-.108-1.326-.323-1.82-.212-.493-.512-.868-.9-1.123s-.842-.383-1.362-.383c-.52 0-.975.128-1.362.383-.388.255-.69.63-.905 1.123-.212.494-.319 1.101-.319 1.82 0 .719.107 1.326.319 1.82.215.494.517.868.905 1.123.387.255.841.383 1.362.383.52 0 .974-.128 1.362-.383.388-.255.688-.629.9-1.123.215-.494.323-1.101.323-1.82Zm3.737 7.955v-10.5h2.088v1.282h.095c.093-.205.227-.414.403-.626.178-.216.41-.395.696-.537.288-.146.646-.219 1.073-.219.557 0 1.071.146 1.542.438.47.288.847.724 1.128 1.307.282.58.423 1.308.423 2.183 0 .852-.138 1.571-.413 2.157-.272.584-.643 1.026-1.114 1.328a2.86 2.86 0 0 1-1.57.447c-.412 0-.761-.068-1.05-.204a2.149 2.149 0 0 1-.7-.512 2.585 2.585 0 0 1-.418-.631h-.065v4.087h-2.118Zm2.073-6.682c0 .454.064.85.19 1.188.125.338.308.602.546.791.239.185.529.278.87.278.345 0 .637-.095.875-.283a1.77 1.77 0 0 0 .542-.796 3.39 3.39 0 0 0 .19-1.178 3.38 3.38 0 0 0-.185-1.164 1.736 1.736 0 0 0-.542-.785c-.238-.189-.532-.283-.88-.283-.344 0-.636.091-.875.273-.235.182-.416.441-.542.776-.126.334-.189.729-.189 1.183Zm10.267 3.967c-.786 0-1.462-.159-2.029-.477a3.275 3.275 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.386 3.386 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.96-.497.503 0 .972.081 1.406.244.438.159.819.399 1.144.721.328.321.583.726.765 1.213.183.484.274 1.05.274 1.7v.582h-6.448v-1.313h4.454a1.62 1.62 0 0 0-.199-.81 1.43 1.43 0 0 0-.551-.552 1.573 1.573 0 0 0-.81-.204c-.322 0-.607.075-.856.224a1.567 1.567 0 0 0-.577.592c-.139.245-.21.518-.213.82v1.248c0 .378.07.704.208.979.143.275.343.487.602.636a1.8 1.8 0 0 0 .92.224c.235 0 .45-.033.646-.099a1.295 1.295 0 0 0 .82-.786l1.96.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.7.62-1.184.816-.48.192-1.035.288-1.665.288Zm7.005-4.564V256h-2.118v-7.636h2.018v1.347h.09c.169-.444.452-.796.85-1.054.398-.262.88-.393 1.447-.393.53 0 .992.116 1.387.348.394.232.701.564.92.995.218.427.328.938.328 1.531V256h-2.118v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-1-.398-.285 0-.536.061-.755.184a1.286 1.286 0 0 0-.507.537c-.12.232-.18.512-.184.84Zm16.185-1.044-1.939.12a1.008 1.008 0 0 0-.214-.448 1.123 1.123 0 0 0-.432-.323 1.472 1.472 0 0 0-.632-.124c-.328 0-.605.069-.83.208-.225.136-.338.319-.338.547 0 .183.073.337.219.463.145.126.396.227.75.303l1.382.278c.743.153 1.296.398 1.661.736.365.338.547.782.547 1.333 0 .5-.148.939-.443 1.317-.291.378-.692.673-1.203.885-.507.209-1.092.313-1.755.313-1.011 0-1.816-.21-2.416-.631a2.46 2.46 0 0 1-1.049-1.73l2.083-.11c.063.309.216.544.458.706.241.159.551.239.929.239.371 0 .67-.071.895-.214.229-.146.345-.333.348-.562a.584.584 0 0 0-.243-.472c-.16-.126-.405-.222-.736-.288l-1.323-.264c-.745-.149-1.301-.408-1.665-.775-.361-.368-.542-.837-.542-1.407 0-.491.132-.913.398-1.268.268-.355.644-.628 1.128-.82.487-.193 1.057-.289 1.71-.289.965 0 1.724.204 2.277.612.557.407.882.963.975 1.665Zm4.988 5.608c-.786 0-1.462-.159-2.029-.477a3.277 3.277 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.388 3.388 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.438.159.819.399 1.143.721.329.321.584.726.766 1.213.182.484.274 1.05.274 1.7v.582h-6.449v-1.313h4.455c0-.305-.066-.575-.199-.81a1.429 1.429 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.562 1.562 0 0 0-.577.592c-.139.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.143.275.343.487.602.636.258.15.565.224.919.224.236 0 .451-.033.647-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.67 2.67 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.665.288Zm8.948-7.785v1.591h-4.598v-1.591h4.598Zm-3.554-1.83h2.118v7.119c0 .196.029.348.089.458a.5.5 0 0 0 .249.224c.109.043.235.064.378.064.099 0 .198-.008.298-.025.099-.02.176-.035.229-.044l.333 1.576a6.067 6.067 0 0 1-.448.114 3.626 3.626 0 0 1-.701.084c-.51.02-.958-.048-1.342-.203a1.876 1.876 0 0 1-.89-.726c-.212-.328-.317-.743-.313-1.243v-7.398Zm8.996 1.83v1.591h-4.599v-1.591h4.599Zm-3.555-1.83h2.118v7.119c0 .196.03.348.09.458.059.106.142.18.248.224.109.043.235.064.378.064.099 0 .199-.008.298-.025.1-.02.176-.035.229-.044l.333 1.576a6.018 6.018 0 0 1-.447.114 3.636 3.636 0 0 1-.701.084c-.511.02-.958-.048-1.343-.203a1.876 1.876 0 0 1-.89-.726c-.212-.328-.316-.743-.313-1.243v-7.398Zm4.934 9.466v-7.636h2.118V256h-2.118Zm1.064-8.621a1.15 1.15 0 0 1-.81-.313 1.016 1.016 0 0 1-.333-.761c0-.291.111-.542.333-.75.225-.212.496-.318.81-.318.315 0 .584.106.806.318a.988.988 0 0 1 .338.75c0 .295-.113.549-.338.761a1.133 1.133 0 0 1-.806.313Zm4.869 4.206V256h-2.118v-7.636h2.018v1.347h.09c.169-.444.452-.796.85-1.054.398-.262.88-.393 1.447-.393.53 0 .992.116 1.387.348.394.232.701.564.92.995.218.427.328.938.328 1.531V256h-2.118v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-.999-.398-.286 0-.537.061-.756.184a1.279 1.279 0 0 0-.507.537c-.12.232-.181.512-.184.84Zm10.031 7.438c-.686 0-1.274-.095-1.765-.284-.487-.185-.875-.439-1.163-.76a2.344 2.344 0 0 1-.562-1.084l1.959-.264c.06.153.154.295.283.428.13.133.3.239.512.318.216.083.478.124.786.124.461 0 .84-.112 1.138-.338.302-.222.453-.595.453-1.118v-1.397h-.09a2.007 2.007 0 0 1-.417.601 2.116 2.116 0 0 1-.716.463c-.292.119-.64.179-1.044.179a3.133 3.133 0 0 1-1.566-.398c-.468-.269-.84-.678-1.119-1.228-.275-.554-.412-1.253-.412-2.098 0-.865.14-1.588.422-2.168.282-.58.656-1.014 1.124-1.302.47-.289.986-.433 1.546-.433.427 0 .785.073 1.074.219.288.142.52.321.696.537.179.212.316.421.412.626h.08v-1.282h2.103v7.711c0 .649-.159 1.193-.477 1.63-.319.438-.759.766-1.323.985-.56.222-1.205.333-1.934.333Zm.045-4.723c.341 0 .63-.085.865-.254.239-.172.421-.417.547-.736.129-.321.194-.706.194-1.153 0-.447-.063-.835-.189-1.163-.126-.332-.308-.589-.547-.771a1.394 1.394 0 0 0-.87-.273c-.348 0-.641.094-.88.283a1.702 1.702 0 0 0-.542.776 3.288 3.288 0 0 0-.184 1.148c0 .441.061.822.184 1.143.126.319.307.566.542.741.239.173.532.259.88.259Zm11.728-3.759-1.939.12a.997.997 0 0 0-.214-.448 1.123 1.123 0 0 0-.432-.323 1.469 1.469 0 0 0-.632-.124c-.328 0-.605.069-.83.208-.225.136-.338.319-.338.547 0 .183.073.337.219.463.146.126.396.227.75.303l1.383.278c.742.153 1.296.398 1.66.736.365.338.547.782.547 1.333 0 .5-.148.939-.443 1.317-.291.378-.692.673-1.203.885-.507.209-1.092.313-1.755.313-1.01 0-1.816-.21-2.416-.631a2.462 2.462 0 0 1-1.049-1.73l2.083-.11c.063.309.216.544.458.706.242.159.552.239.929.239.372 0 .67-.071.895-.214.229-.146.345-.333.348-.562a.584.584 0 0 0-.243-.472c-.159-.126-.405-.222-.736-.288l-1.323-.264c-.745-.149-1.3-.408-1.665-.775-.361-.368-.542-.837-.542-1.407 0-.491.133-.913.398-1.268.268-.355.644-.628 1.128-.82.488-.193 1.058-.289 1.711-.289.964 0 1.723.204 2.277.612.556.407.881.963.974 1.665Z" fill="#A0A0A0"/><rect x="559" y="241.5" width="20" height="20" rx="4" fill="#232323"/><path d="m565.656 251.24-.648-.648 3.495-3.495 3.494 3.495-.648.648-2.846-2.839-2.847 2.839Z" fill="#A0A0A0"/><rect x="587" y="241.5" width="20" height="20.82" rx="4" fill="#232323"/><path d="m597.73 255.127-.068.46a9.29 9.29 0 0 1-.221 1.04c-.097.369-.198.717-.303 1.044-.105.327-.192.587-.26.78h-.767l.145-.72c.06-.299.119-.633.179-1.002.062-.366.114-.741.153-1.125l.052-.477h1.09Z" fill="#A0A0A0"/><g clip-path="url(#Dialog__m)"><g clip-path="url(#Dialog__n)"><path d="M30 296.5h18m-14-6v2m10-2v2m-11 7h2m3 0h2m3 0h2m-12 3h2m3 0h2m3 0h2m-12 3h2m3 0h2m3 0h2m-11.8 3h11.6c1.12 0 1.68 0 2.108-.218.376-.192.682-.498.874-.874.218-.428.218-.988.218-2.108v-9.6c0-1.12 0-1.68-.218-2.108a2.003 2.003 0 0 0-.874-.874c-.428-.218-.988-.218-2.108-.218H33.2c-1.12 0-1.68 0-2.108.218a2.003 2.003 0 0 0-.874.874C30 294.02 30 294.58 30 295.7v9.6c0 1.12 0 1.68.218 2.108.192.376.498.682.874.874.428.218.988.218 2.108.218Z" stroke="#BFBFBF" stroke-width="2" stroke-linecap="round"/></g></g><path d="M77.242 298.909c0 1.11-.211 2.055-.632 2.834-.418.779-.988 1.374-1.71 1.785-.72.407-1.528.611-2.426.611-.905 0-1.717-.205-2.436-.616-.72-.411-1.288-1.006-1.706-1.785-.417-.779-.626-1.722-.626-2.829 0-1.11.209-2.055.626-2.834.418-.779.986-1.372 1.706-1.78.719-.411 1.53-.616 2.436-.616.898 0 1.707.205 2.426.616.722.408 1.292 1.001 1.71 1.78.421.779.632 1.724.632 2.834Zm-2.183 0c0-.719-.108-1.326-.323-1.82-.212-.493-.512-.868-.9-1.123s-.842-.383-1.362-.383c-.52 0-.975.128-1.362.383-.388.255-.69.63-.905 1.123-.212.494-.319 1.101-.319 1.82 0 .719.107 1.326.319 1.82.215.494.517.868.905 1.123.387.255.841.383 1.362.383.52 0 .974-.128 1.362-.383.388-.255.688-.629.9-1.123.215-.494.323-1.101.323-1.82Zm3.737 7.955v-10.5h2.088v1.282h.095c.093-.205.227-.414.403-.626.178-.216.41-.395.696-.537.288-.146.646-.219 1.073-.219.557 0 1.071.146 1.542.438.47.288.847.724 1.128 1.307.282.58.423 1.308.423 2.183 0 .852-.138 1.571-.413 2.157-.272.584-.643 1.026-1.114 1.328a2.86 2.86 0 0 1-1.57.447c-.412 0-.761-.068-1.05-.204a2.149 2.149 0 0 1-.7-.512 2.585 2.585 0 0 1-.418-.631h-.065v4.087h-2.118Zm2.073-6.682c0 .454.064.85.19 1.188.125.338.308.602.546.791.239.185.529.278.87.278.345 0 .637-.095.875-.283a1.77 1.77 0 0 0 .542-.796 3.39 3.39 0 0 0 .19-1.178 3.38 3.38 0 0 0-.185-1.164 1.736 1.736 0 0 0-.542-.785c-.238-.189-.532-.283-.88-.283-.344 0-.636.091-.875.273-.235.182-.416.441-.542.776-.126.334-.189.729-.189 1.183Zm10.267 3.967c-.786 0-1.462-.159-2.029-.477a3.275 3.275 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.386 3.386 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.96-.497.503 0 .972.081 1.406.244.438.159.819.399 1.144.721.328.321.583.726.765 1.213.183.484.274 1.05.274 1.7v.582h-6.448v-1.313h4.454a1.62 1.62 0 0 0-.199-.81 1.43 1.43 0 0 0-.551-.552 1.573 1.573 0 0 0-.81-.204c-.322 0-.607.075-.856.224a1.567 1.567 0 0 0-.577.592c-.139.245-.21.518-.213.82v1.248c0 .378.07.704.208.979.143.275.343.487.602.636a1.8 1.8 0 0 0 .92.224c.235 0 .45-.033.646-.099a1.295 1.295 0 0 0 .82-.786l1.96.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.7.62-1.184.816-.48.192-1.035.288-1.665.288Zm7.005-4.564V304h-2.118v-7.636h2.018v1.347h.09c.169-.444.452-.796.85-1.054.398-.262.88-.393 1.447-.393.53 0 .992.116 1.387.348.394.232.701.564.92.995.218.427.328.938.328 1.531V304h-2.118v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-1-.398-.285 0-.536.061-.755.184a1.286 1.286 0 0 0-.507.537c-.12.232-.18.512-.184.84Zm13.281 4.564c-.782 0-1.455-.166-2.018-.497a3.368 3.368 0 0 1-1.293-1.392c-.298-.593-.447-1.276-.447-2.048 0-.783.151-1.469.452-2.059a3.368 3.368 0 0 1 1.298-1.387c.56-.334 1.226-.502 1.998-.502.667 0 1.25.121 1.75.363a2.93 2.93 0 0 1 1.189 1.019c.291.438.452.952.482 1.542h-1.999c-.056-.382-.205-.688-.447-.92-.239-.236-.552-.353-.94-.353-.328 0-.615.089-.86.268-.242.176-.431.433-.567.771-.135.338-.203.747-.203 1.228 0 .487.066.901.198 1.243.136.341.327.601.572.78.245.179.532.269.86.269.242 0 .459-.05.652-.149.195-.1.356-.244.482-.433a1.65 1.65 0 0 0 .253-.691h1.999a3.128 3.128 0 0 1-.477 1.541 2.882 2.882 0 0 1-1.169 1.034c-.497.249-1.085.373-1.765.373Zm6.944-.005a3.18 3.18 0 0 1-1.302-.253 2.101 2.101 0 0 1-.905-.761c-.219-.338-.328-.759-.328-1.263 0-.424.078-.78.234-1.069.155-.288.368-.52.636-.696.268-.175.573-.308.915-.397.344-.09.706-.153 1.084-.189.444-.047.802-.09 1.073-.13.272-.043.469-.106.592-.189a.412.412 0 0 0 .184-.367v-.03c0-.315-.099-.559-.298-.731-.196-.172-.474-.259-.836-.259-.381 0-.684.085-.909.254a1.164 1.164 0 0 0-.448.626l-1.959-.159c.1-.464.295-.865.587-1.203a2.817 2.817 0 0 1 1.129-.785c.464-.186 1.001-.279 1.61-.279.425 0 .831.05 1.218.149.392.1.738.254 1.04.463.304.209.545.477.72.805.176.325.264.714.264 1.168V304h-2.009v-1.059h-.059a2.159 2.159 0 0 1-.492.631c-.206.179-.453.32-.741.423a3.08 3.08 0 0 1-1 .149Zm.607-1.461c.312 0 .587-.062.825-.184.239-.126.426-.295.562-.508.136-.212.204-.452.204-.72v-.811a1.158 1.158 0 0 1-.274.12c-.112.033-.24.064-.382.094-.143.027-.285.051-.428.075l-.388.054a2.678 2.678 0 0 0-.651.174c-.186.08-.33.188-.432.323a.79.79 0 0 0-.155.498c0 .288.105.508.314.661.212.149.48.224.805.224Zm7.455-8.865V304h-2.118v-10.182h2.118Zm5.177 10.331c-.786 0-1.462-.159-2.029-.477a3.277 3.277 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.458-2.069a3.388 3.388 0 0 1 1.287-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.438.159.819.399 1.143.721.329.321.584.726.766 1.213.182.484.274 1.05.274 1.7v.582h-6.449v-1.313h4.455c0-.305-.066-.575-.199-.81a1.422 1.422 0 0 0-.552-.552 1.572 1.572 0 0 0-.81-.204c-.322 0-.607.075-.855.224a1.562 1.562 0 0 0-.577.592c-.139.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.143.275.343.487.602.636.258.15.565.224.919.224.236 0 .451-.033.647-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.67 2.67 0 0 1-.612 1.233c-.305.348-.699.62-1.183.816-.481.192-1.036.288-1.665.288Zm7.005-4.564V304h-2.118v-7.636h2.018v1.347h.09c.169-.444.452-.796.85-1.054.397-.262.88-.393 1.446-.393.531 0 .993.116 1.388.348.394.232.701.564.919.995.219.427.328.938.328 1.531V304h-2.117v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-1-.398a1.51 1.51 0 0 0-.755.184 1.279 1.279 0 0 0-.507.537c-.12.232-.181.512-.184.84Zm9.405 4.539c-.58 0-1.106-.149-1.576-.447-.468-.302-.839-.744-1.114-1.328-.272-.586-.408-1.305-.408-2.157 0-.875.141-1.603.423-2.183.282-.583.656-1.019 1.123-1.307a2.878 2.878 0 0 1 1.547-.438c.427 0 .783.073 1.068.219.289.142.521.321.697.537.178.212.314.421.407.626h.065v-3.828h2.113V304h-2.088v-1.223h-.09c-.099.212-.24.423-.422.631a2.085 2.085 0 0 1-.701.512c-.285.136-.633.204-1.044.204Zm.671-1.685c.341 0 .629-.093.865-.278.238-.189.421-.453.547-.791.129-.338.194-.734.194-1.188 0-.454-.063-.849-.189-1.183-.126-.335-.309-.594-.547-.776a1.394 1.394 0 0 0-.87-.273c-.348 0-.642.094-.88.283-.239.189-.42.451-.542.785a3.37 3.37 0 0 0-.184 1.164c0 .444.061.837.184 1.178.126.338.306.603.542.796.238.188.532.283.88.283Zm7.593 1.705c-.488 0-.922-.084-1.303-.253a2.101 2.101 0 0 1-.905-.761c-.219-.338-.328-.759-.328-1.263 0-.424.078-.78.234-1.069.156-.288.368-.52.636-.696a3.09 3.09 0 0 1 .915-.397c.345-.09.706-.153 1.084-.189.444-.047.802-.09 1.074-.13.271-.043.469-.106.591-.189a.412.412 0 0 0 .184-.367v-.03c0-.315-.099-.559-.298-.731-.196-.172-.474-.259-.835-.259-.382 0-.685.085-.91.254a1.164 1.164 0 0 0-.448.626l-1.958-.159c.099-.464.295-.865.586-1.203a2.817 2.817 0 0 1 1.129-.785c.464-.186 1.001-.279 1.611-.279.424 0 .83.05 1.218.149a3.2 3.2 0 0 1 1.039.463c.305.209.545.477.721.805.175.325.263.714.263 1.168V304h-2.009v-1.059h-.059a2.159 2.159 0 0 1-.492.631c-.206.179-.453.32-.741.423a3.074 3.074 0 0 1-.999.149Zm.606-1.461c.312 0 .587-.062.825-.184.239-.126.426-.295.562-.508.136-.212.204-.452.204-.72v-.811a1.149 1.149 0 0 1-.273.12 5.264 5.264 0 0 1-.383.094c-.143.027-.285.051-.428.075l-.388.054a2.678 2.678 0 0 0-.651.174 1.05 1.05 0 0 0-.432.323.789.789 0 0 0-.154.498c0 .288.104.508.313.661.212.149.48.224.805.224Zm5.337 1.317v-7.636h2.053v1.332h.08c.139-.474.373-.832.701-1.074a1.844 1.844 0 0 1 1.133-.368 3.25 3.25 0 0 1 .667.075v1.879c-.1-.03-.237-.056-.413-.079a3.572 3.572 0 0 0-.482-.035c-.312 0-.59.068-.835.204a1.496 1.496 0 0 0-.577.556 1.612 1.612 0 0 0-.209.826V304h-2.118Z" fill="#A0A0A0"/><rect x="559" y="289.5" width="20" height="20" rx="4" fill="#232323"/><path d="m565.656 299.24-.648-.648 3.495-3.495 3.494 3.495-.648.648-2.846-2.839-2.847 2.839Z" fill="#A0A0A0"/><rect x="587" y="289.5" width="20" height="20.82" rx="4" fill="#232323"/><path d="M600.71 298.32h-1.057a2.208 2.208 0 0 0-.891-1.381 2.405 2.405 0 0 0-.729-.358 2.926 2.926 0 0 0-.835-.119c-.528 0-1.007.134-1.436.401-.426.267-.766.66-1.018 1.18-.25.52-.375 1.158-.375 1.913 0 .756.125 1.394.375 1.914.252.52.592.913 1.018 1.18.429.267.908.401 1.436.401.29 0 .568-.04.835-.12a2.44 2.44 0 0 0 .729-.353c.222-.159.409-.354.563-.584.156-.233.265-.5.328-.801h1.057c-.08.446-.225.845-.435 1.197a3.278 3.278 0 0 1-1.837 1.458 3.942 3.942 0 0 1-1.24.191c-.744 0-1.406-.181-1.986-.545-.579-.364-1.035-.881-1.368-1.551-.332-.671-.498-1.466-.498-2.387 0-.92.166-1.716.498-2.386.333-.67.789-1.187 1.368-1.551.58-.364 1.242-.546 1.986-.546.441 0 .854.064 1.24.192.389.128.74.316 1.053.563.312.244.574.542.784.895.21.349.355.748.435 1.197Z" fill="#A0A0A0"/><path d="M13.784 334.773h1.057v5.778c0 .597-.14 1.129-.422 1.598a2.954 2.954 0 0 1-1.18 1.104c-.509.267-1.106.4-1.79.4-.685 0-1.281-.133-1.79-.4a2.985 2.985 0 0 1-1.185-1.104 3.069 3.069 0 0 1-.417-1.598v-5.778h1.057v5.693c0 .426.093.805.28 1.138.188.329.455.589.802.78.35.187.767.281 1.253.281.486 0 .903-.094 1.253-.281.35-.191.616-.451.8-.78.188-.333.282-.712.282-1.138v-5.693Zm7.94 2.182a1.339 1.339 0 0 0-.622-1.006c-.364-.239-.81-.358-1.338-.358-.386 0-.725.062-1.014.187a1.619 1.619 0 0 0-.674.516 1.237 1.237 0 0 0-.238.746c0 .233.055.433.166.601.113.164.258.302.435.413a3.1 3.1 0 0 0 .553.268c.194.069.371.124.533.167l.887.238c.227.06.48.142.758.247.281.106.55.249.805.431.259.179.472.409.64.69.167.281.251.627.251 1.036 0 .471-.123.897-.37 1.278-.245.381-.603.683-1.074.908-.47.224-1.039.336-1.71.336-.624 0-1.165-.1-1.623-.302a2.588 2.588 0 0 1-1.074-.844 2.408 2.408 0 0 1-.439-1.257h1.091c.029.33.14.602.333.818a1.8 1.8 0 0 0 .741.477c.301.103.625.154.972.154.403 0 .765-.065 1.086-.196.321-.134.576-.318.763-.554a1.31 1.31 0 0 0 .281-.835c0-.29-.08-.526-.242-.708a1.784 1.784 0 0 0-.64-.443 6.627 6.627 0 0 0-.856-.298l-1.074-.307c-.682-.196-1.222-.476-1.62-.84-.397-.363-.596-.839-.596-1.427 0-.489.132-.915.396-1.279.267-.366.625-.65 1.074-.852a3.635 3.635 0 0 1 1.513-.307c.562 0 1.062.101 1.5.303a2.6 2.6 0 0 1 1.04.818c.258.347.395.74.409 1.181h-1.023Zm2.88 6.545v-8.727h5.267v.937h-4.21v2.949h3.937v.938H25.66v2.965h4.279v.938h-5.335Zm7.172 0v-8.727h2.948c.682 0 1.242.116 1.68.349.437.23.76.547.971.95.21.404.315.863.315 1.377s-.105.97-.315 1.368c-.21.397-.533.71-.967.937-.435.225-.99.337-1.666.337h-2.387v-.955h2.352c.466 0 .841-.068 1.125-.204.287-.137.495-.33.623-.58.13-.253.196-.554.196-.903 0-.35-.066-.655-.197-.916a1.332 1.332 0 0 0-.626-.605c-.287-.145-.666-.218-1.138-.218h-1.858v7.79h-1.056Zm4.107-3.92 2.148 3.92h-1.227l-2.114-3.92h1.194Zm8.341-2.625a1.339 1.339 0 0 0-.622-1.006c-.364-.239-.81-.358-1.338-.358-.387 0-.725.062-1.014.187a1.619 1.619 0 0 0-.674.516 1.237 1.237 0 0 0-.238.746c0 .233.055.433.166.601.114.164.258.302.435.413a3.1 3.1 0 0 0 .553.268c.194.069.371.124.533.167l.887.238c.227.06.48.142.758.247.281.106.55.249.805.431.259.179.472.409.64.69.167.281.251.627.251 1.036 0 .471-.123.897-.37 1.278-.245.381-.603.683-1.075.908-.468.224-1.038.336-1.708.336-.625 0-1.166-.1-1.624-.302a2.588 2.588 0 0 1-1.074-.844 2.408 2.408 0 0 1-.439-1.257h1.091c.029.33.14.602.333.818a1.8 1.8 0 0 0 .741.477c.301.103.625.154.972.154.403 0 .765-.065 1.086-.196.321-.134.576-.318.763-.554a1.31 1.31 0 0 0 .281-.835c0-.29-.08-.526-.243-.708a1.784 1.784 0 0 0-.639-.443 6.627 6.627 0 0 0-.856-.298l-1.074-.307c-.682-.196-1.222-.476-1.62-.84-.397-.363-.596-.839-.596-1.427 0-.489.132-.915.396-1.279.267-.366.625-.65 1.074-.852a3.635 3.635 0 0 1 1.513-.307c.562 0 1.062.101 1.5.303a2.6 2.6 0 0 1 1.04.818c.258.347.395.74.409 1.181h-1.023Z" fill="#7E7E7E"/><g clip-path="url(#Dialog__o)"><g clip-path="url(#Dialog__p)"><path d="M32 386.5a7 7 0 1 1 14 0m-3-14a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z" stroke="#BFBFBF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g></g><path d="M67.497 373.593v-1.775h8.362v1.775h-3.117V382h-2.128v-8.407h-3.117Zm12.072 8.556c-.785 0-1.461-.159-2.028-.477a3.275 3.275 0 0 1-1.302-1.362c-.306-.59-.458-1.288-.458-2.093 0-.786.152-1.475.457-2.069a3.386 3.386 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244a3.11 3.11 0 0 1 1.143.721c.329.321.584.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455a1.62 1.62 0 0 0-.2-.81 1.43 1.43 0 0 0-.55-.552 1.573 1.573 0 0 0-.811-.204c-.322 0-.607.075-.855.224a1.567 1.567 0 0 0-.577.592c-.14.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.602.636a1.8 1.8 0 0 0 .92.224c.234 0 .45-.033.645-.099a1.293 1.293 0 0 0 .82-.786l1.96.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.7.62-1.183.816-.48.192-1.036.288-1.666.288Zm4.888-.149v-7.636h2.053v1.332h.08c.138-.474.372-.832.7-1.074a1.844 1.844 0 0 1 1.134-.368c.106 0 .22.007.343.02.123.013.23.032.323.055v1.879a2.73 2.73 0 0 0-.413-.079 3.574 3.574 0 0 0-.482-.035c-.311 0-.59.068-.835.204a1.5 1.5 0 0 0-.577.556 1.61 1.61 0 0 0-.209.826V382h-2.117Zm5.728 0v-7.636h2.053v1.332h.08c.139-.474.373-.832.7-1.074a1.844 1.844 0 0 1 1.134-.368c.106 0 .22.007.343.02.123.013.23.032.323.055v1.879a2.7 2.7 0 0 0-.412-.079 3.574 3.574 0 0 0-.482-.035c-.312 0-.59.068-.836.204a1.5 1.5 0 0 0-.576.556 1.61 1.61 0 0 0-.21.826V382h-2.117Zm7.269 2.864c-.269 0-.52-.022-.756-.065a2.765 2.765 0 0 1-.577-.154l.477-1.581c.249.076.473.118.671.124a.853.853 0 0 0 .522-.139c.15-.099.27-.268.364-.507l.124-.323-2.74-7.855h2.228l1.58 5.608h.08l1.596-5.608h2.242l-2.968 8.461a3.545 3.545 0 0 1-.581 1.074 2.39 2.39 0 0 1-.92.711c-.371.169-.819.254-1.343.254Zm10.175-13.046h2.655l2.804 6.841h.119l2.804-6.841h2.655V382h-2.088v-6.627h-.085l-2.635 6.577h-1.421l-2.635-6.602h-.085V382h-2.088v-10.182Zm16.251 10.331c-.786 0-1.462-.159-2.028-.477a3.273 3.273 0 0 1-1.303-1.362c-.305-.59-.457-1.288-.457-2.093 0-.786.152-1.475.457-2.069a3.384 3.384 0 0 1 1.288-1.387c.556-.331 1.209-.497 1.958-.497.504 0 .973.081 1.407.244.438.159.819.399 1.144.721.328.321.583.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.454c0-.305-.066-.575-.199-.81a1.426 1.426 0 0 0-.551-.552 1.576 1.576 0 0 0-.811-.204c-.321 0-.606.075-.855.224a1.576 1.576 0 0 0-.577.592c-.139.245-.21.518-.213.82v1.248c0 .378.069.704.208.979.143.275.344.487.602.636.259.15.565.224.92.224.235 0 .451-.033.646-.099a1.297 1.297 0 0 0 .82-.786l1.959.129a2.669 2.669 0 0 1-.611 1.233c-.305.348-.7.62-1.184.816-.48.192-1.035.288-1.665.288Zm7.701-.025c-.58 0-1.105-.149-1.576-.447-.467-.302-.839-.744-1.114-1.328-.271-.586-.407-1.305-.407-2.157 0-.875.141-1.603.422-2.183.282-.583.657-1.019 1.124-1.307.47-.292.986-.438 1.546-.438.428 0 .784.073 1.069.219.288.142.52.321.696.537.179.212.315.421.408.626h.064v-3.828h2.113V382h-2.088v-1.223h-.089c-.1.212-.241.423-.423.631a2.085 2.085 0 0 1-.701.512c-.285.136-.633.204-1.044.204Zm.671-1.685c.342 0 .63-.093.865-.278.239-.189.421-.453.547-.791.129-.338.194-.734.194-1.188 0-.454-.063-.849-.189-1.183-.126-.335-.308-.594-.547-.776a1.39 1.39 0 0 0-.87-.273c-.348 0-.641.094-.88.283a1.744 1.744 0 0 0-.542.785 3.393 3.393 0 0 0-.184 1.164c0 .444.062.837.184 1.178.126.338.307.603.542.796.239.188.532.283.88.283Zm7.533-2.854V382h-2.118v-10.182h2.059v3.893h.089c.173-.451.451-.804.835-1.059.385-.259.867-.388 1.447-.388.53 0 .993.116 1.387.348.398.229.706.559.925.99.222.427.331.939.328 1.536V382h-2.118v-4.484c.003-.471-.116-.837-.358-1.099-.238-.262-.573-.393-1.004-.393-.288 0-.544.061-.766.184a1.313 1.313 0 0 0-.517.537 1.834 1.834 0 0 0-.189.84Zm11.516 1.164v-4.385h2.118V382h-2.034v-1.387h-.079a2.262 2.262 0 0 1-.86 1.079c-.398.272-.884.407-1.457.407-.51 0-.96-.116-1.347-.348a2.39 2.39 0 0 1-.91-.989c-.216-.427-.325-.94-.328-1.536v-4.862h2.118v4.484c.003.451.124.807.363 1.069.238.262.558.393.959.393.255 0 .494-.058.716-.174.222-.12.401-.295.537-.527.139-.232.207-.519.204-.86Zm3.812 3.251v-7.636h2.053v1.332h.08c.139-.474.372-.832.701-1.074a1.844 1.844 0 0 1 1.133-.368c.106 0 .22.007.343.02.123.013.23.032.323.055v1.879a2.725 2.725 0 0 0-.412-.079 3.586 3.586 0 0 0-.483-.035c-.311 0-.59.068-.835.204a1.503 1.503 0 0 0-.577.556 1.612 1.612 0 0 0-.208.826V382h-2.118Zm12.082-5.459-1.939.12a.997.997 0 0 0-.214-.448 1.123 1.123 0 0 0-.432-.323 1.469 1.469 0 0 0-.632-.124c-.328 0-.605.069-.83.208-.225.136-.338.319-.338.547 0 .183.073.337.219.463.146.126.396.227.75.303l1.383.278c.742.153 1.296.398 1.66.736.365.338.547.782.547 1.333 0 .5-.148.939-.443 1.317-.291.378-.692.673-1.203.885-.507.209-1.092.313-1.755.313-1.01 0-1.816-.21-2.416-.631a2.462 2.462 0 0 1-1.049-1.73l2.083-.11c.063.309.216.544.458.706.242.159.552.239.929.239.372 0 .67-.071.895-.214.229-.146.345-.333.348-.562a.584.584 0 0 0-.243-.472c-.159-.126-.405-.222-.736-.288l-1.323-.264c-.745-.149-1.3-.408-1.665-.775-.361-.368-.542-.837-.542-1.407 0-.491.133-.913.398-1.268.268-.355.644-.628 1.128-.82.488-.193 1.058-.289 1.711-.289.964 0 1.723.204 2.277.612.556.407.881.963.974 1.665Zm5.569-2.177v1.591h-4.598v-1.591h4.598Zm-3.554-1.83h2.118v7.119c0 .196.029.348.089.458a.5.5 0 0 0 .249.224c.109.043.235.064.378.064.099 0 .198-.008.298-.025.099-.02.175-.035.228-.044l.334 1.576a6.067 6.067 0 0 1-.448.114 3.626 3.626 0 0 1-.701.084c-.51.02-.958-.048-1.342-.203a1.876 1.876 0 0 1-.89-.726c-.212-.328-.317-.743-.313-1.243v-7.398Z" fill="#A0A0A0"/><g clip-path="url(#Dialog__q)"><g clip-path="url(#Dialog__r)"><path d="M32 434.5a7 7 0 1 1 14 0m-3-14a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z" stroke="#BFBFBF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g></g><path d="M73.408 422.746c-.04-.401-.21-.712-.512-.934-.301-.222-.71-.333-1.228-.333-.351 0-.648.049-.89.149-.242.096-.427.23-.556.403a.966.966 0 0 0-.19.586.836.836 0 0 0 .115.477c.086.136.204.254.353.353.15.097.322.181.517.254.196.07.404.129.627.179l.914.219a6.47 6.47 0 0 1 1.223.397c.371.166.693.37.965.612s.482.527.631.855a2.7 2.7 0 0 1 .234 1.129c-.004.623-.163 1.163-.478 1.62-.311.454-.762.807-1.352 1.059-.586.249-1.294.373-2.123.373-.822 0-1.537-.126-2.147-.378-.607-.252-1.08-.624-1.422-1.118-.338-.497-.516-1.112-.532-1.845h2.083c.023.342.12.627.293.855.176.226.41.396.701.512.295.113.628.169 1 .169.364 0 .68-.053.95-.159.27-.106.481-.253.63-.442.15-.189.224-.406.224-.651a.847.847 0 0 0-.204-.577c-.132-.156-.328-.288-.586-.398a5.956 5.956 0 0 0-.94-.298l-1.109-.278c-.858-.209-1.536-.536-2.033-.98-.497-.444-.744-1.042-.74-1.795-.004-.616.16-1.155.492-1.615.334-.461.793-.821 1.377-1.079.583-.259 1.246-.388 1.988-.388.756 0 1.415.129 1.979.388.567.258 1.007.618 1.322 1.079.315.46.478.994.488 1.6h-2.064Zm5.729 2.839V430h-2.118v-10.182h2.058v3.893h.09a2.16 2.16 0 0 1 .835-1.059c.384-.259.867-.388 1.447-.388.53 0 .992.116 1.387.348.398.229.706.559.924.99.222.427.332.939.329 1.536V430H81.97v-4.484c.003-.471-.116-.837-.358-1.099-.239-.262-.574-.393-1.004-.393-.289 0-.544.061-.766.184a1.309 1.309 0 0 0-.517.537 1.817 1.817 0 0 0-.19.84Zm10.098 4.564c-.785 0-1.461-.159-2.028-.477a3.275 3.275 0 0 1-1.302-1.362c-.305-.59-.458-1.288-.458-2.093 0-.786.153-1.475.457-2.069a3.386 3.386 0 0 1 1.288-1.387c.557-.331 1.21-.497 1.959-.497.504 0 .973.081 1.407.244.437.159.818.399 1.143.721.329.321.584.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.455a1.62 1.62 0 0 0-.2-.81 1.43 1.43 0 0 0-.55-.552 1.573 1.573 0 0 0-.811-.204c-.322 0-.607.075-.855.224a1.567 1.567 0 0 0-.577.592c-.14.245-.21.518-.214.82v1.248c0 .378.07.704.209.979.142.275.343.487.602.636a1.8 1.8 0 0 0 .92.224c.235 0 .45-.033.645-.099a1.295 1.295 0 0 0 .82-.786l1.96.129a2.68 2.68 0 0 1-.612 1.233c-.305.348-.7.62-1.183.816-.48.192-1.036.288-1.666.288Zm7.005-10.331V430h-2.117v-10.182h2.117Zm4.511 10.306c-.58 0-1.106-.149-1.576-.447-.467-.302-.839-.744-1.114-1.328-.272-.586-.407-1.305-.407-2.157 0-.875.14-1.603.422-2.183.282-.583.656-1.019 1.124-1.307.47-.292.986-.438 1.546-.438.427 0 .784.073 1.069.219.288.142.52.321.696.537.179.212.315.421.408.626h.064v-3.828h2.113V430h-2.088v-1.223h-.089c-.1.212-.241.423-.423.631a2.085 2.085 0 0 1-.701.512c-.285.136-.633.204-1.044.204Zm.671-1.685c.341 0 .63-.093.865-.278.239-.189.421-.453.547-.791.129-.338.194-.734.194-1.188 0-.454-.063-.849-.189-1.183-.126-.335-.308-.594-.547-.776a1.394 1.394 0 0 0-.87-.273c-.348 0-.641.094-.88.283a1.736 1.736 0 0 0-.542.785 3.382 3.382 0 0 0-.184 1.164c0 .444.061.837.184 1.178.126.338.307.603.542.796.239.188.532.283.88.283Zm8.866 1.71c-.773 0-1.44-.164-2.004-.492a3.358 3.358 0 0 1-1.297-1.382c-.305-.593-.458-1.281-.458-2.063 0-.789.153-1.479.458-2.069a3.322 3.322 0 0 1 1.297-1.382c.564-.331 1.231-.497 2.004-.497.772 0 1.438.166 1.998.497.564.328.998.789 1.303 1.382.305.59.457 1.28.457 2.069 0 .782-.152 1.47-.457 2.063a3.353 3.353 0 0 1-1.303 1.382c-.56.328-1.226.492-1.998.492Zm.01-1.64c.351 0 .644-.1.88-.299.235-.202.412-.477.532-.825a3.58 3.58 0 0 0 .183-1.188c0-.444-.061-.84-.183-1.188-.12-.348-.297-.624-.532-.826-.236-.202-.529-.303-.88-.303-.355 0-.653.101-.895.303-.239.202-.42.478-.542.826-.12.348-.179.744-.179 1.188 0 .444.059.84.179 1.188.122.348.303.623.542.825.242.199.54.299.895.299Zm7.243-2.924V430h-2.118v-7.636h2.019v1.347h.089c.169-.444.453-.796.85-1.054.398-.262.88-.393 1.447-.393.53 0 .993.116 1.387.348.395.232.701.564.92.995.219.427.328.938.328 1.531V430h-2.118v-4.484c.003-.468-.116-.832-.358-1.094-.242-.265-.575-.398-.999-.398-.285 0-.537.061-.756.184a1.291 1.291 0 0 0-.507.537c-.119.232-.18.512-.184.84Zm13.714.875h1.83l.92 1.183.904 1.054 1.706 2.138h-2.009l-1.173-1.442-.602-.855-1.576-2.078Zm5.514-1.551c0 1.11-.211 2.055-.632 2.834-.417.779-.987 1.374-1.71 1.785-.719.407-1.528.611-2.426.611-.905 0-1.717-.205-2.436-.616-.719-.411-1.288-1.006-1.705-1.785-.418-.779-.627-1.722-.627-2.829 0-1.11.209-2.055.627-2.834.417-.779.986-1.372 1.705-1.78.719-.411 1.531-.616 2.436-.616.898 0 1.707.205 2.426.616.723.408 1.293 1.001 1.71 1.78.421.779.632 1.724.632 2.834Zm-2.183 0c0-.719-.107-1.326-.323-1.82-.212-.493-.512-.868-.9-1.123s-.842-.383-1.362-.383c-.52 0-.974.128-1.362.383-.388.255-.69.63-.905 1.123-.212.494-.318 1.101-.318 1.82 0 .719.106 1.326.318 1.82.215.494.517.868.905 1.123s.842.383 1.362.383c.52 0 .974-.128 1.362-.383.388-.255.688-.629.9-1.123.216-.494.323-1.101.323-1.82Zm8.635 1.84v-4.385h2.118V430h-2.034v-1.387h-.079a2.262 2.262 0 0 1-.86 1.079c-.398.272-.884.407-1.457.407-.511 0-.96-.116-1.347-.348a2.39 2.39 0 0 1-.91-.989c-.216-.427-.325-.94-.328-1.536v-4.862h2.118v4.484c.003.451.124.807.363 1.069.238.262.558.393.959.393.255 0 .494-.058.716-.174.222-.12.401-.295.537-.527.139-.232.207-.519.204-.86Zm3.812 3.251v-7.636h2.118V430h-2.118Zm1.064-8.621c-.315 0-.585-.104-.811-.313a1.016 1.016 0 0 1-.333-.761c0-.291.111-.542.333-.75.226-.212.496-.318.811-.318.314 0 .583.106.805.318a.988.988 0 0 1 .338.75c0 .295-.113.549-.338.761a1.133 1.133 0 0 1-.805.313Zm6.19 11.644c-.686 0-1.274-.095-1.764-.284-.488-.185-.875-.439-1.164-.76a2.353 2.353 0 0 1-.562-1.084l1.959-.264c.06.153.154.295.284.428.129.133.3.239.512.318.215.083.477.124.785.124.461 0 .84-.112 1.139-.338.301-.222.452-.595.452-1.118v-1.397h-.089a2.01 2.01 0 0 1-.418.601 2.116 2.116 0 0 1-.716.463c-.292.119-.64.179-1.044.179a3.139 3.139 0 0 1-1.566-.398c-.467-.269-.84-.678-1.119-1.228-.275-.554-.412-1.253-.412-2.098 0-.865.141-1.588.422-2.168.282-.58.657-1.014 1.124-1.302a2.899 2.899 0 0 1 1.546-.433c.428 0 .786.073 1.074.219.288.142.52.321.696.537.179.212.316.421.413.626h.079v-1.282h2.103v7.711c0 .649-.159 1.193-.477 1.63-.318.438-.759.766-1.323.985-.56.222-1.204.333-1.934.333Zm.045-4.723c.342 0 .63-.085.865-.254.239-.172.421-.417.547-.736.129-.321.194-.706.194-1.153 0-.447-.063-.835-.189-1.163-.126-.332-.308-.589-.547-.771a1.39 1.39 0 0 0-.87-.273c-.348 0-.641.094-.88.283a1.71 1.71 0 0 0-.542.776 3.311 3.311 0 0 0-.184 1.148c0 .441.062.822.184 1.143.126.319.307.566.542.741.239.173.532.259.88.259Zm7.492-8.482V430h-2.118v-10.182h2.118Zm5.177 10.331c-.785 0-1.462-.159-2.028-.477a3.273 3.273 0 0 1-1.303-1.362c-.305-.59-.457-1.288-.457-2.093 0-.786.152-1.475.457-2.069a3.384 3.384 0 0 1 1.288-1.387c.557-.331 1.209-.497 1.959-.497.503 0 .972.081 1.407.244.437.159.818.399 1.143.721.328.321.583.726.766 1.213.182.484.273 1.05.273 1.7v.582h-6.448v-1.313h4.454c0-.305-.066-.575-.198-.81a1.435 1.435 0 0 0-.552-.552 1.573 1.573 0 0 0-.811-.204c-.321 0-.606.075-.855.224a1.566 1.566 0 0 0-.576.592c-.14.245-.211.518-.214.82v1.248c0 .378.069.704.209.979.142.275.343.487.601.636.259.15.565.224.92.224.235 0 .451-.033.646-.099a1.34 1.34 0 0 0 .502-.299c.14-.132.246-.295.318-.487l1.959.129a2.669 2.669 0 0 1-.611 1.233c-.305.348-.7.62-1.183.816-.481.192-1.036.288-1.666.288Zm5.99 2.715a4.2 4.2 0 0 1-.756-.065 2.777 2.777 0 0 1-.577-.154l.477-1.581c.249.076.473.118.672.124a.853.853 0 0 0 .522-.139c.149-.099.27-.268.363-.507l.124-.323-2.739-7.855h2.227l1.581 5.608h.079l1.596-5.608h2.242l-2.968 8.461a3.548 3.548 0 0 1-.581 1.074 2.392 2.392 0 0 1-.92.711c-.371.169-.819.254-1.342.254Z" fill="#A0A0A0"/></g><mask id="Dialog__s" fill="#fff"><path d="M1 445.5h638v28c0 6.627-5.373 12-12 12H13c-6.627 0-12-5.373-12-12v-28Z"/></mask><path d="M1 445.5h638v28c0 6.627-5.373 12-12 12H13c-6.627 0-12-5.373-12-12v-28Z" fill="#1C1C1C"/><path d="M359.549 470.41v-8.727h5.471v1.133h-4.154v2.659h3.869v1.13h-3.869v2.671h4.206v1.134h-5.523Zm7.884-6.545 1.444 2.548 1.458-2.548h1.393l-2.041 3.272 2.058 3.273h-1.393l-1.475-2.446-1.47 2.446h-1.398l2.037-3.273-2.011-3.272h1.398Zm7.917 6.677c-.645 0-1.201-.138-1.667-.413a2.8 2.8 0 0 1-1.073-1.172c-.25-.506-.375-1.098-.375-1.777 0-.671.125-1.262.375-1.773a2.91 2.91 0 0 1 1.056-1.197c.455-.287.986-.431 1.594-.431.369 0 .727.061 1.074.184.347.122.658.313.933.575.276.261.493.601.652 1.018.159.415.239.919.239 1.513v.452h-5.203v-.955h3.954c0-.335-.068-.632-.204-.89a1.54 1.54 0 0 0-.576-.618 1.601 1.601 0 0 0-.86-.226c-.358 0-.671.088-.938.264a1.777 1.777 0 0 0-.614.682 1.968 1.968 0 0 0-.213.908v.745c0 .438.077.81.231 1.117.156.307.373.541.652.703.278.159.603.239.975.239.242 0 .462-.035.661-.103a1.43 1.43 0 0 0 .516-.315 1.38 1.38 0 0 0 .332-.516l1.206.218c-.097.355-.27.666-.52.933-.247.264-.558.47-.933.618a3.49 3.49 0 0 1-1.274.217Zm6.729 0c-.634 0-1.179-.143-1.637-.43a2.85 2.85 0 0 1-1.048-1.198c-.244-.508-.367-1.091-.367-1.747 0-.665.125-1.251.375-1.76.25-.511.603-.91 1.057-1.197.455-.287.99-.431 1.607-.431.497 0 .94.093 1.329.277.39.182.704.438.942.767.242.33.385.715.431 1.155h-1.241a1.481 1.481 0 0 0-.468-.792c-.242-.222-.566-.333-.972-.333-.355 0-.666.094-.933.281-.264.185-.47.449-.618.793-.148.341-.222.744-.222 1.21 0 .478.073.889.218 1.236.145.347.349.615.613.805.267.191.581.286.942.286.242 0 .46-.044.656-.132.199-.091.365-.22.499-.388a1.45 1.45 0 0 0 .285-.605h1.241a2.415 2.415 0 0 1-.414 1.133c-.23.333-.538.594-.925.785-.383.19-.833.285-1.35.285Zm7.947-2.847v-3.83h1.279v6.545h-1.253v-1.134h-.068c-.151.35-.392.641-.725.874-.329.23-.74.345-1.231.345-.421 0-.793-.092-1.117-.277a1.942 1.942 0 0 1-.758-.831c-.182-.366-.273-.819-.273-1.359v-4.163h1.274v4.009c0 .446.124.802.371 1.066s.568.396.963.396c.239 0 .476-.06.712-.179.238-.119.436-.3.592-.541.159-.242.237-.548.234-.921Zm5.796-3.83v1.022h-3.575v-1.022h3.575Zm-2.616-1.569h1.274v6.192c0 .247.037.433.111.558a.584.584 0 0 0 .285.252c.12.042.249.064.388.064.102 0 .192-.007.268-.022a6.69 6.69 0 0 0 .179-.034l.231 1.053a2.523 2.523 0 0 1-.827.136 2.242 2.242 0 0 1-.938-.179 1.614 1.614 0 0 1-.703-.579c-.179-.262-.268-.59-.268-.985v-6.456Zm6.526 8.246c-.644 0-1.2-.138-1.666-.413a2.808 2.808 0 0 1-1.074-1.172c-.25-.506-.375-1.098-.375-1.777 0-.671.125-1.262.375-1.773.253-.511.605-.91 1.057-1.197.455-.287.986-.431 1.594-.431.369 0 .727.061 1.074.184.346.122.657.313.933.575.276.261.493.601.652 1.018.159.415.239.919.239 1.513v.452h-5.203v-.955h3.954c0-.335-.068-.632-.204-.89a1.546 1.546 0 0 0-.576-.618 1.603 1.603 0 0 0-.861-.226c-.358 0-.67.088-.937.264a1.777 1.777 0 0 0-.614.682 1.968 1.968 0 0 0-.213.908v.745c0 .438.077.81.23 1.117.157.307.374.541.652.703.279.159.604.239.976.239.242 0 .462-.035.661-.103a1.37 1.37 0 0 0 .848-.831l1.206.218c-.097.355-.27.666-.52.933-.247.264-.558.47-.933.618a3.496 3.496 0 0 1-1.275.217Zm14.249-6.021h-1.33a2.035 2.035 0 0 0-.796-1.3 2.206 2.206 0 0 0-.678-.341 2.635 2.635 0 0 0-.788-.115c-.503 0-.953.127-1.351.379-.395.253-.708.624-.938 1.113-.227.488-.341 1.085-.341 1.789 0 .711.114 1.31.341 1.799.23.488.544.858.942 1.108.398.25.845.375 1.342.375.276 0 .537-.037.784-.111.25-.077.476-.189.678-.337a2.058 2.058 0 0 0 .805-1.283l1.33.005a3.561 3.561 0 0 1-.413 1.184 3.272 3.272 0 0 1-.78.929 3.518 3.518 0 0 1-1.083.601 4 4 0 0 1-1.329.213c-.756 0-1.429-.179-2.02-.537-.591-.36-1.057-.876-1.398-1.547-.338-.67-.507-1.47-.507-2.399 0-.931.171-1.731.512-2.399.34-.67.806-1.184 1.397-1.542.591-.361 1.263-.542 2.016-.542.463 0 .895.067 1.295.201.404.13.766.324 1.087.579.321.253.587.563.797.929.21.364.352.78.426 1.249Zm3.98 6.021c-.613 0-1.149-.141-1.606-.422a2.843 2.843 0 0 1-1.065-1.18c-.253-.506-.38-1.097-.38-1.773 0-.679.127-1.273.38-1.781a2.832 2.832 0 0 1 1.065-1.185c.457-.281.993-.422 1.606-.422.614 0 1.15.141 1.607.422.457.281.812.676 1.065 1.185.253.508.38 1.102.38 1.781 0 .676-.127 1.267-.38 1.773a2.85 2.85 0 0 1-1.065 1.18c-.457.281-.993.422-1.607.422Zm.005-1.07c.397 0 .727-.105.988-.315.262-.21.455-.49.58-.839a3.34 3.34 0 0 0 .192-1.155c0-.418-.064-.801-.192-1.151a1.871 1.871 0 0 0-.58-.848c-.261-.213-.591-.319-.988-.319-.401 0-.733.106-.997.319a1.902 1.902 0 0 0-.584.848c-.125.35-.188.733-.188 1.151 0 .42.063.805.188 1.155.128.349.322.629.584.839.264.21.596.315.997.315Zm4.219.938v-6.545h1.223v1.065h.081c.136-.361.359-.642.669-.844.309-.204.68-.307 1.112-.307.438 0 .804.103 1.099.307.299.205.519.486.661.844h.068c.156-.35.405-.628.746-.835.341-.211.747-.316 1.219-.316.593 0 1.078.186 1.453.559.378.372.567.933.567 1.683v4.389h-1.275v-4.27c0-.443-.12-.764-.362-.963a1.316 1.316 0 0 0-.865-.298c-.415 0-.737.128-.967.383-.23.253-.345.578-.345.976v4.172h-1.27v-4.351c0-.355-.111-.641-.333-.856-.221-.216-.51-.324-.865-.324-.241 0-.464.064-.669.191-.201.125-.365.3-.49.525a1.604 1.604 0 0 0-.183.779v4.036h-1.274Zm10.355 0v-6.545h1.223v1.065h.081c.137-.361.36-.642.669-.844.31-.204.681-.307 1.113-.307.437 0 .803.103 1.099.307.298.205.518.486.66.844h.069c.156-.35.404-.628.745-.835.341-.211.748-.316 1.219-.316.594 0 1.078.186 1.453.559.378.372.567.933.567 1.683v4.389h-1.274v-4.27c0-.443-.121-.764-.362-.963a1.318 1.318 0 0 0-.865-.298c-.415 0-.738.128-.968.383-.23.253-.345.578-.345.976v4.172h-1.27v-4.351c0-.355-.111-.641-.332-.856-.222-.216-.51-.324-.865-.324-.242 0-.465.064-.669.191-.202.125-.365.3-.49.525a1.604 1.604 0 0 0-.184.779v4.036h-1.274Zm12.261.145c-.415 0-.79-.077-1.125-.23a1.893 1.893 0 0 1-.797-.678c-.193-.295-.29-.657-.29-1.086 0-.37.071-.674.213-.912.142-.239.334-.428.575-.567.242-.139.512-.244.81-.315a7.83 7.83 0 0 1 .912-.162l.954-.111c.245-.031.422-.081.533-.149.111-.069.166-.179.166-.333v-.03c0-.372-.105-.66-.315-.865-.207-.204-.517-.306-.929-.306-.429 0-.767.095-1.014.285-.245.188-.414.396-.507.626l-1.198-.272c.142-.398.35-.719.622-.963.276-.247.593-.426.951-.537a3.697 3.697 0 0 1 1.129-.171c.261 0 .538.032.831.094.295.06.571.17.827.332.258.162.47.394.635.695.164.298.247.686.247 1.163v4.347h-1.245v-.895h-.051a1.798 1.798 0 0 1-.371.486 1.961 1.961 0 0 1-.634.396 2.47 2.47 0 0 1-.929.158Zm.277-1.023c.352 0 .653-.069.903-.209.253-.139.445-.321.575-.545a1.41 1.41 0 0 0 .201-.729v-.844c-.046.046-.134.088-.265.128-.128.037-.274.07-.439.098-.164.026-.325.05-.481.073l-.392.051a3.148 3.148 0 0 0-.678.158c-.201.073-.363.18-.486.319-.119.136-.178.318-.178.546 0 .315.116.554.349.715.233.16.53.239.891.239Zm5.674-3.008v3.886h-1.274v-6.545h1.223v1.065h.081c.15-.347.386-.625.707-.835.324-.211.732-.316 1.223-.316.446 0 .837.094 1.172.282.335.184.595.46.78.826.185.367.277.82.277 1.36v4.163h-1.274v-4.01c0-.474-.124-.845-.371-1.112-.247-.27-.587-.405-1.019-.405-.295 0-.558.064-.788.192a1.378 1.378 0 0 0-.541.562c-.131.245-.196.54-.196.887Zm8.098 4.014c-.528 0-1-.135-1.415-.405-.412-.273-.736-.661-.971-1.163-.233-.506-.35-1.113-.35-1.82 0-.707.118-1.312.354-1.815.238-.503.565-.888.98-1.155a2.55 2.55 0 0 1 1.41-.401c.407 0 .733.068.981.205.25.133.443.29.579.469.139.179.247.336.324.473h.077v-3.243h1.274v8.727h-1.244v-1.018h-.107a3.48 3.48 0 0 1-.332.477 1.853 1.853 0 0 1-.588.469c-.25.133-.574.2-.972.2Zm.281-1.087c.367 0 .676-.096.929-.29.256-.196.449-.467.58-.814.133-.346.2-.75.2-1.21 0-.454-.065-.852-.196-1.193a1.757 1.757 0 0 0-.575-.797c-.253-.19-.566-.285-.938-.285-.383 0-.703.099-.959.298a1.83 1.83 0 0 0-.579.814 3.314 3.314 0 0 0-.192 1.163c0 .438.065.831.196 1.181.131.349.324.626.58.831.258.201.576.302.954.302Z" fill="#A0A0A0"/><rect x="469.53" y="456" width="20" height="20" rx="4" fill="#232323"/><path d="m477.376 469.123-2.531-2.531 2.531-2.531v5.062Zm-.776-2.071v-.92h7.662v.92H476.6Zm6.767 0v-5.369h.921v5.369h-.921Z" fill="#A0A0A0"/><path fill="#343434" d="M505.53 452h1v12h-1z"/><path d="M526.533 461.683v8.727h-1.21l-4.436-6.401h-.081v6.401h-1.317v-8.727h1.219l4.44 6.409h.081v-6.409h1.304Zm3.473 8.872c-.415 0-.79-.077-1.125-.23a1.9 1.9 0 0 1-.797-.678c-.193-.295-.289-.657-.289-1.086 0-.37.071-.674.213-.912.142-.239.333-.428.575-.567.241-.139.511-.244.81-.315a7.83 7.83 0 0 1 .912-.162l.954-.111c.244-.031.422-.081.533-.149.111-.069.166-.179.166-.333v-.03c0-.372-.105-.66-.315-.865-.208-.204-.517-.306-.929-.306-.429 0-.767.095-1.015.285-.244.188-.413.396-.507.626l-1.197-.272c.142-.398.349-.719.622-.963a2.53 2.53 0 0 1 .95-.537 3.703 3.703 0 0 1 1.13-.171c.261 0 .538.032.831.094.295.06.571.17.826.332.259.162.47.394.635.695.165.298.247.686.247 1.163v4.347h-1.244v-.895h-.051a1.818 1.818 0 0 1-.371.486 1.966 1.966 0 0 1-.635.396 2.463 2.463 0 0 1-.929.158Zm.277-1.023c.352 0 .654-.069.904-.209a1.47 1.47 0 0 0 .575-.545c.133-.227.2-.47.2-.729v-.844c-.045.046-.133.088-.264.128-.128.037-.274.07-.439.098l-.481.073-.393.051a3.125 3.125 0 0 0-.677.158c-.202.073-.364.18-.486.319-.119.136-.179.318-.179.546 0 .315.117.554.35.715.233.16.529.239.89.239Zm9.765-5.667-2.373 6.545h-1.364l-2.378-6.545h1.368l1.658 5.036h.068l1.654-5.036h1.367Zm.948 6.545v-6.545h1.274v6.545h-1.274Zm.643-7.555a.81.81 0 0 1-.571-.222.722.722 0 0 1-.234-.537c0-.21.078-.389.234-.537a.805.805 0 0 1 .571-.226c.222 0 .411.076.567.226a.707.707 0 0 1 .239.537c0 .207-.08.386-.239.537a.794.794 0 0 1-.567.222Zm4.84 10.146c-.52 0-.968-.068-1.343-.205a2.59 2.59 0 0 1-.912-.541 2.256 2.256 0 0 1-.528-.737l1.095-.452c.077.125.179.257.307.397.131.142.307.262.528.362.225.099.513.149.865.149.483 0 .882-.118 1.198-.354.315-.233.473-.605.473-1.116v-1.287h-.081a2.911 2.911 0 0 1-.333.464 1.789 1.789 0 0 1-.588.443c-.25.125-.575.188-.976.188a2.73 2.73 0 0 1-1.397-.362c-.412-.245-.739-.604-.98-1.078-.239-.478-.358-1.064-.358-1.76s.118-1.293.353-1.79c.239-.497.566-.878.98-1.142a2.55 2.55 0 0 1 1.411-.401c.406 0 .734.068.984.205.25.133.445.29.584.469.142.179.252.336.328.473h.094v-1.061h1.249v6.69c0 .562-.131 1.024-.392 1.385a2.306 2.306 0 0 1-1.061.801c-.444.173-.944.26-1.5.26Zm-.013-3.746c.366 0 .676-.085.929-.256.255-.173.449-.42.579-.741.134-.324.201-.712.201-1.163 0-.441-.066-.828-.196-1.164a1.735 1.735 0 0 0-.576-.784c-.253-.19-.565-.285-.937-.285-.384 0-.703.099-.959.298a1.8 1.8 0 0 0-.58.801 3.204 3.204 0 0 0-.191 1.134c0 .429.065.805.196 1.129.13.324.323.577.579.758.259.182.577.273.955.273Zm6.329 1.3c-.415 0-.79-.077-1.125-.23a1.9 1.9 0 0 1-.797-.678c-.193-.295-.289-.657-.289-1.086 0-.37.071-.674.213-.912.142-.239.333-.428.575-.567.241-.139.511-.244.81-.315a7.83 7.83 0 0 1 .912-.162l.954-.111c.244-.031.422-.081.533-.149.111-.069.166-.179.166-.333v-.03c0-.372-.105-.66-.315-.865-.208-.204-.517-.306-.929-.306-.429 0-.767.095-1.015.285-.244.188-.413.396-.507.626l-1.197-.272c.142-.398.349-.719.622-.963a2.53 2.53 0 0 1 .95-.537 3.703 3.703 0 0 1 1.13-.171c.261 0 .538.032.831.094.295.06.571.17.826.332.259.162.47.394.635.695.165.298.247.686.247 1.163v4.347h-1.244v-.895h-.051a1.798 1.798 0 0 1-.371.486 1.966 1.966 0 0 1-.635.396 2.463 2.463 0 0 1-.929.158Zm.277-1.023c.353 0 .654-.069.904-.209.253-.139.444-.321.575-.545.133-.227.2-.47.2-.729v-.844c-.045.046-.133.088-.264.128-.128.037-.274.07-.439.098l-.481.073-.392.051a3.135 3.135 0 0 0-.678.158c-.202.073-.364.18-.486.319-.119.136-.179.318-.179.546 0 .315.117.554.35.715.233.16.529.239.89.239Zm7.456-5.667v1.022h-3.575v-1.022h3.575Zm-2.617-1.569h1.275v6.192c0 .247.036.433.11.558a.582.582 0 0 0 .286.252c.119.042.248.064.388.064.102 0 .191-.007.268-.022a7.57 7.57 0 0 0 .179-.034l.23 1.053a2.534 2.534 0 0 1-.827.136 2.237 2.237 0 0 1-.937-.179 1.608 1.608 0 0 1-.703-.579c-.179-.262-.269-.59-.269-.985v-6.456Zm6.527 8.246c-.645 0-1.2-.138-1.666-.413a2.808 2.808 0 0 1-1.074-1.172c-.25-.506-.375-1.098-.375-1.777 0-.671.125-1.262.375-1.773.253-.511.605-.91 1.057-1.197.454-.287.986-.431 1.594-.431.369 0 .727.061 1.073.184.347.122.658.313.934.575.275.261.493.601.652 1.018.159.415.238.919.238 1.513v.452h-5.203v-.955h3.955a1.87 1.87 0 0 0-.205-.89 1.537 1.537 0 0 0-.575-.618 1.603 1.603 0 0 0-.861-.226c-.358 0-.67.088-.937.264a1.769 1.769 0 0 0-.614.682 1.968 1.968 0 0 0-.213.908v.745c0 .438.077.81.23 1.117.156.307.374.541.652.703.278.159.604.239.976.239.241 0 .461-.035.66-.103a1.356 1.356 0 0 0 .848-.831l1.206.218c-.096.355-.27.666-.52.933-.247.264-.558.47-.933.618a3.49 3.49 0 0 1-1.274.217Z" fill="#A0A0A0"/><rect x="581" y="456" width="20" height="20" rx="4" fill="#232323"/><path d="M590.649 470.41v-7.006l-2.694 2.702-.664-.656 3.826-3.818 3.818 3.818-.647.656-2.702-2.702v7.006h-.937Z" fill="#A0A0A0"/><rect x="607" y="456" width="20" height="20" rx="4" fill="#232323"/><path d="M617.586 461.683v7.005l2.693-2.701.665.656-3.827 3.818-3.818-3.818.648-.656 2.702 2.701v-7.005h.937Z" fill="#A0A0A0"/><path d="M1 444.5h638v2H1v-2Zm638 41H1h638Zm-638 0v-40 40Zm638-40v40-40Z" fill="#343434" mask="url(#Dialog__s)"/><rect x=".5" y="1" width="639" height="485" rx="11.5" stroke="#343434"/><defs><clipPath id="Dialog__a"><path fill="#fff" transform="translate(17 20)" d="M0 0h20v20H0z"/></clipPath><clipPath id="Dialog__b"><path fill="#fff" transform="translate(17 20)" d="M0 0h20v20H0z"/></clipPath><clipPath id="Dialog__c"><path fill="#fff" transform="translate(46 18.5)" d="M0 0h533.98v21H0z"/></clipPath><clipPath id="Dialog__d"><path fill="#fff" transform="translate(1 101.5)" d="M0 0h638v336H0z"/></clipPath><clipPath id="Dialog__e"><path fill="#fff" transform="translate(27 143.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__f"><path fill="#fff" transform="translate(27 143.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__g"><path fill="#fff" transform="translate(27 143.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__h"><path fill="#fff" transform="translate(27 191.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__i"><path fill="#fff" transform="translate(27 191.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__j"><path fill="#fff" transform="translate(27 191.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__k"><path fill="#fff" transform="translate(27 239.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__l"><path fill="#fff" transform="translate(27 239.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__m"><path fill="#fff" transform="translate(27 287.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__n"><path fill="#fff" transform="translate(27 287.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__o"><path fill="#fff" transform="translate(27 365.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__p"><path fill="#fff" transform="translate(27 365.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__q"><path fill="#fff" transform="translate(27 413.5)" d="M0 0h24v24H0z"/></clipPath><clipPath id="Dialog__r"><path fill="#fff" transform="translate(27 413.5)" d="M0 0h24v24H0z"/></clipPath></defs>
</svg>
</div>
::

::card-grid
#title
What's included

#root
:ellipsis{left=0px width=40rem top=10rem blur=140px}

#default
  ::card{icon=logos:vue}
  #title
    Vue compound components
  #description
    Just import CmdBar and use all its children via a dot notation.
  ::

  ::card{icon=logos:vueuse}
  #title
    List virtualization
  #description
    The list component, uses [useVirtualList | VueUse](https://vueuse.org/core/useVirtualList/#usevirtuallist) under the hood, to render only the visible items. 
  ::

  ::card{icon=twemoji:keyboard}
  #title
    Keybindings
  #description
    A useKeyMap composable is provided, to handle keybindings with ease.
  ::

  ::card{icon=logos:css-3}
  #title
  Unstyled
  #description
    No CSS is included. You can style it as you want.
  ::

  ::card{icon=noto:puzzle-piece}
  #title
    Extensible.
  #description
    Cause of the way it's built, you can extend it as you want.
  ::

  ::card{icon=twemoji:page-facing-up}
  #title
    Examples. 
  #description
    You can find **multiple** examples of how to use it in the [examples folder](https://github.com/fabkho/cmd-bar/tree/main/packages/examples/anny).
  ::
::
