# Data Structure

Commands are represented as an array of `Command` objects. A `Command` object must at least have an `id`,`label` and `action` property. Here is an example:

```vue
<script setup lang="ts">
const commands: Command[] = [
  {
    id: '1',
    label: 'Command 1',
    action: () => {
      console.log('Command 1')
    },
  },
  {
    id: '2',
    label: 'Command 2',
    action: () => {}
  },
  {
    id: '3',
    label: 'Command 3',
    action: () => {},
  },
]
</script>

<template>
  <CmdBar :groups="[{key: 'people', commands: 'people'}]">
    <template #header>
      <CmdBar.Input placeholder="search fo anything" />
    </template>
    <template #content>
      <CmdBar.VirtualList :config="listConfig">
          {{ command.label }}
      </CmdBar.VirtualList>
    </template>
  </CmdBar>
</template>
```

### Define your groups

Commands are always grouped. You can define your groups by providing an array of `Group` objects to the `groups` prop. It **must** at least have a `key`. The `commands` property is **optional** to support asynchronous loading of commands. Here is an example:

```vue
<script setup lang="ts">
const groups: Group[] = [
  {
    key: 'people',
    commands: [
      {
        id: '1',
        label: 'Command 1',
      },
      {
        id: '2',
        label: 'Command 2',
      },
      {
        id: '3',
        label: 'Command 3',
      },
    ],
  },
  {
    key: 'places',
    commands: [
      {
        id: '4',
        label: 'Command 4',
      },
      {
        id: '5',
        label: 'Command 5',
      },
      {
        id: '6',
        label: 'Command 6',
      },
    ],
  }
]
</script>

<template>
<CmdBar :groups="groups">
    <template #header>
      <CmdBar.Input placeholder="search fo anything" />
    </template>
    <template #content>
      <CmdBar.VirtualList :config="listConfig">
        <template #default="{ command }">
            {{ command.label }}
        </template>
      </CmdBar.VirtualList>
    </template>
  </CmdBar>
</template>
```





