# Components

Discover every provided component. 


## `<CmdBar />`
Is the **main** component of this library. It is used to Provide the data to the other components. It takes the following props:
- `commands`: An array of `Group` objects.

## `<CmdBar.Dialog />`
Uses the HTML `<dialog>` element to display the command bar. It takes the following props:
- `visible`: Whether the command bar is visible or not. (Default: `false`)

Inside the `CmdBar.Dialog` component, you can use the following slots:
- `header`: The header of the dialog.
- `content`: The content of the dialog.
- `footer`: The footer of the dialog.

::alert{type="info"}
This is completely **optional**, you can use your **own modal system**.
::

## `<CmdBar.Input />`
Provides an input to search through the commands. It takes the following props:
- `placeholder`: The placeholder of the input. (Default: `Search for anything`)
<!-- is this even needed? -->
- `fuse`: The fuse options of the input. (Default: `{ minMatchCharLength: 2, keys: ['commands.label'] }`)

To get the current query, you can use the `@input` event. It will provide the current input string.

## `<CmdBar.Filter />`
Built-in solution to filter the commands. It takes the following props:
- `filterOptions`: An array of `FilterOption` objects.
- `asCheckbox`: Whether it should be possible to select multiple options or not. (Default: `false`)

Example:
```ts
const filterOptions = [
  {
    groupKey: 'default',
    label: 'All',
    visible: true
  },
  {
    groupKey: 'actions',
    label: 'Actions',
    visible: true
  },
  {
    groupKey: 'users',
    label: 'Users',
    visible: false
  }
]
```

- As you can see, the `groupKey` is used to filter the commands. If you want to **show all commands**, you can use the `default` groupKey.
- Use the `visible` property to hide a filter option.

## `<CmdBar.VirtualList />`
To ensure great performance and scalability, the `CmdBarVirtualList` component uses [useVirtualList](https://vueuse.org/core/useVirtualList/#usevirtuallist) under the hood, to render a virtualized list of commands.
To work properly, it needs some configuration passed via the `config` prop. Here is an example:
```ts
const listConfig = {
  /* The height of a single item, in Pixel. */
  itemHeightInPixel: {
    actions: 48,
    users: 48
  },
  /* The height of the container, as a string with a unit of your choice. */
  containerHeight: '21rem',
  /* The height of a group label, in Pixel. */
  groupLabelHeightInPixel: 20
}
```
::alert{type="info"}
The `itemHeightInPixel` can be an object, which contains the height of each group. Or it can be a number, which will be applied to all groups.
::

Inside the `CmdBar.List` component, you can use the following slots:
- `default`: The default slot, which is used to render the items and provides the `command` object. 
- `loading`: The loading slot, which is used to render the loading state and provides the currently loading `group`object.
- `preview`: Can be used to render a preview of the currently selected command. (See [Command](../examples/2.preview.md))

## `<CmdBar.Magnet />`
:badge[WIP]{type="warning"}
A quick-actions container where you can drag&drop you most used commands, to access them quickly. 
Keep an eye on the [GitHub repository](https://github.com/fabkho/cmd-bar) for updates.


