# Keybindings

To make your application more accessible, you can use the `useKeymap()` composable to define your own key bindings.

To [bind a key to a command](#command-shortcut), you can use the `shortcut` property of the `Command` object.

Some **default** key bindings are already defined:
- `ArrowUp`: Select the previous item in the list.
- `ArrowDown`: Select the next item in the list.
- `Enter`: Execute the selected item.

## `useKeymap()`

`useKeymap()` let's you define your own key bindings with ease.

You can just pass an object with the following structure:
```ts
useKeymap((nav) => {
  return [
    {
      key: 'ArrowRight',
      action: () => nav.prev(),
      override: true,
      autoRepeat: true 
    },
    {
      key: 'ArrowLeft',
      action: () => nav.next(),
      override: true,
      autoRepeat: true
    }
  ]
})
```
::alert{type="info"}
The properties `override` and `autoRepeat` are optional, and both default to `false`.
::

The composable also gives you access to the `nav` object, which provides the following methods:
- `prev()`: Select the previous item in the list.
- `next()`: Select the next item in the list.
- `execute()`: Execute the selected item.

::source-link
---
source: "useKeymap.ts"
---
::


## Command Shortcut

You can also define a shortcut for a command by using the `shortcut` property of the `Command` object.

```ts
const actions = [
  {
    id: 'new-resource',
    label: 'Create new Resource',
    leading: './src/assets/icons/create.svg',
    action: () => alert('New Resource created'),
    shortcut: 'Ctrl+R'
  },
  {
    id: 'new-service',
    label: 'Add new Service',
    leading: './src/assets/icons/service_1.svg',
    action: () => alert('New Service added'),
    shortcut: 'Ctrl+S'
  },
]
```

::alert{type="info"}
Keybindings are internally handled by [useMagicKeys | VueUse](https://vueuse.org/core/useMagicKeys/#usemagickeys). If you have any questions about the syntax, please refer to their documentation.
::
