import React from 'react';
import { storiesOf } from '@storybook/react';
import cx from 'classnames';

import {
  Medallion,
  Modifiers as m,
  BtnGroup,
  Icon,
  Btn
} from '@appearhere/bloom';

storiesOf('BtnGroup', module)
  .add('Default Button Group', () => (
    <BtnGroup>
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion className={cx(m.mlRegular, m.fr)}>1</Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ))
  .add('Primary Button Group', () => (
    <BtnGroup context="primary">
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion className={cx(m.mlRegular, m.fr)}>1</Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ))
  .add('Action Button Group', () => (
    <BtnGroup context="action">
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion className={cx(m.mlRegular, m.fr)}>12</Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ))
  .add('Danger Button Group', () => (
    <BtnGroup context="danger">
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion className={cx(m.mlRegular, m.fr)}>124</Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ))
  .add('Whiteout Button Group', () => (
    <BtnGroup context="whiteout">
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion variant="dark" className={cx(m.mlRegular, m.fr)}>
          9001
        </Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ))
  .add('High priority Button Group', () => (
    <BtnGroup priority="high">
      <Btn>
        <Icon className={m.mrRegular} name="filter" />
        Filters
        <Medallion className={cx(m.mlRegular, m.fr)}>1</Medallion>
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="map" /> Map
      </Btn>
      <Btn>
        <Icon className={m.mrRegular} name="bogroll" /> Flush
      </Btn>
    </BtnGroup>
  ));
