import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';

import defaultcss from './ValueIcon.css';
import css from './ValueIconOpen.css';

const ValueIconOpen = props => {
  const { className, ...rest } = props;

  return (
    <span className={cx(defaultcss.root, className)} {...rest}>
      <svg viewBox="0 0 63.06 42">
        <rect x="5.2" y="18.16" width="52.67" height="21.46" />
        <g className={css.letter}>
          <path
            d={
              'M14,28.58a4.69,4.69,0,0,1,.33-1.8,4,4,0,0,1,.93-1.38,4.1,4.1,0,0,1,1.42-.87,' +
              '5.42,5.42,0,0,1,3.58,0,4.1,4.1,0,0,1,1.42.87,4,4,0,0,1,.93,1.38,5.05,5.05,0,0,1,0,' +
              '3.61,4,4,0,0,1-.93,1.38,4.1,4.1,0,0,1-1.42.87,5.42,5.42,0,0,1-3.58,0,4.1,4.1,0,0,' +
              '1-1.42-.87,4,4,0,0,1-.93-1.38A4.68,4.68,0,0,1,14,28.58Zm1.9,0a3,3,0,0,0,.18,1.07,' +
              '2.43,2.43,0,0,0,.52.84,2.36,2.36,0,0,0,.81.56,2.92,2.92,0,0,0,2.12,0,2.37,2.37,0,' +
              '0,0,.81-.56,2.45,2.45,0,0,0,.52-.84,3.22,3.22,0,0,0,0-2.14,2.43,2.43,0,' +
              '0,0-.52-.85,2.37,2.37,0,0,0-.81-.56,2.92,2.92,0,0,0-2.12,0,2.36,2.36,0,0,' +
              '0-.81.56,2.41,2.41,0,0,0-.52.85A3.05,3.05,0,0,0,15.92,28.58Z'
            }
          />
          <path
            d={
              'M24.27,24.44h3.08a6.06,6.06,0,0,1,1.22.12,2.78,2.78,0,0,1,1,.4,2,2,0,0,1,' +
              '.68.77A2.64,2.64,0,0,1,30.49,27a2.83,2.83,0,0,1-.23,1.22,2,2,0,0,1-.64.78,2.6,' +
              '2.6,0,0,1-1,.41,5.68,5.68,0,0,1-1.22.12H26.09v3.23H24.27Zm1.83,3.51h1.22a2.3,2.3,' +
              '0,0,0,.48,0,1.26,1.26,0,0,0,.41-.16.83.83,0,0,0,.29-.3A1,1,0,0,0,28.6,27a.83.83,' +
              '0,0,0-.15-.51,1,1,0,0,0-.37-.3,1.58,1.58,0,0,0-.51-.13L27,26h-.94Z'
            }
          />
          <path d="M31.77,24.44H37.4v1.69h-3.8v1.54h3.59v1.69H33.59V31h4v1.69H31.77Z" />
          <path d="M39.13,24.44h2.48l3.52,5.76h0V24.44H47v8.29H44.59L41,26.82h0v5.9H39.13Z" />
        </g>
        <path d="M18.53,17.92,30.46,3.11a2,2,0,0,1,3.07,0L44.86,17.92" />
        <path d="M33.07,5a1,1,0,1,1-1-1,1,1,0,0,1,1,1" />
      </svg>
    </span>
  );
};

ValueIconOpen.propTypes = {
  className: PropTypes.string,
};

export default ValueIconOpen;
