# Overview

Bloom is [Appear Here’s](https://www.appearhere.co.uk/) central repository for design patterns and guidelines. It was created to help us define our visual language, and to aide development of our brand and applications. It’s the outcome of us attempting to make a system which scales with the business, and eases the load on our team.

It manifests itself as a living style guide and as a [node module](https://www.npmjs.com/package/@appearhere/bloom) of [React components](https://facebook.github.io/react/), styles and utility functions.

## Goals
1. Promote consistency across the brand and applications, allowing us to create a unified experience across all touch points with Appear Here.
2. Improve the efficiency of development by ensuring we’re speaking the same language. It allows our conversations to be shaped less around low-level design, and more around what really matters.

## For developers

By publishing Bloom to npm, it is a living style guide in it’s truest form. Changes to Bloom propogate out across our applications as new versions are released, making maintenance of our core components relatively easy.

What this does mean however is it must be protected. Changes to Bloom must be justified at both a code and design level. They must take into account the numerous places where each component, style or function is used before making it in to the next release.

### Usage

See [README.md](https://github.com/appearhere/bloom/blob/master/README.md).

### Storybook

To aide development, we also [maintain a set of stories](/storybook) using [Storybook](https://github.com/storybooks/storybook).
