package io.quarkus.websockets.next.test.endpoints;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.websockets.next.OnOpen;
import io.quarkus.websockets.next.WebSocket;
import io.quarkus.websockets.next.WebSocketException;

public class TooManyOnOpenTest {

    @RegisterExtension
    public static final QuarkusUnitTest test = new QuarkusUnitTest()
            .withApplicationRoot(root -> {
                root.addClasses(TooManyOnOpen.class);
            })
            .setExpectedException(WebSocketException.class);

    @Test
    void verifyThatEndpointWithMultipleOnOpenMethodsFailsToDeploy() {

    }

    @WebSocket(path = "/ws")
    public static class TooManyOnOpen {
        @OnOpen
        public void onOpen() {
        }

        @OnOpen
        public void onOpen2() {
        }
    }

}
