package io.quarkus.logging;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;

import org.jboss.logging.Logger;

public class GenerateAllLogUsages {
    public static void main(String[] args) {
        println("package io.quarkus.logging;");
        println("");
        println("// generated by GenerateAllLogUsages, don't update manually");
        println("public class GeneratedBean {");
        println("    public void testLogging() {");
        Arrays.stream(Log.class.getDeclaredMethods())
                .filter(method -> Modifier.isPublic(method.getModifiers()))
                .sorted(Comparator.comparing(Method::getName).thenComparingInt(Method::getParameterCount)
                        .thenComparing(Method::toString))
                .forEach(method -> {
                    Parameter[] parameters = method.getParameters();
                    String[] arguments = new String[method.getParameterCount()];
                    for (int i = 0; i < parameters.length; i++) {
                        Parameter parameter = parameters[i];
                        String argument;
                        if (parameter.getType() == Object.class && "message".equals(parameter.getName())) {
                            argument = "\"foobar\"";
                        } else if (parameter.getType() == Object.class
                                && (parameter.getName().startsWith("param") || parameter.getName().startsWith("arg"))) {
                            argument = "new Object()";
                        } else if (parameter.getType() == Object[].class && "params".equals(parameter.getName())) {
                            argument = "new Object[] {}";
                        } else if (parameter.getType() == String.class && "loggerFqcn".equals(parameter.getName())) {
                            argument = "\"io.quarkus.logging.GeneratedBean\"";
                        } else if (parameter.getType() == String.class && "format".equals(parameter.getName())) {
                            argument = "\"foobar\"";
                        } else if (parameter.getType() == int.class) {
                            argument = "13";
                        } else if (parameter.getType() == long.class) {
                            argument = "42L";
                        } else if (parameter.getType() == Throwable.class) {
                            argument = "new NoStackTraceTestException()";
                        } else if (parameter.getType() == Logger.Level.class) {
                            argument = "org.jboss.logging.Logger.Level.INFO";
                        } else {
                            throw new RuntimeException("Couldn't generate argument value for parameter " + i + " of type "
                                    + method.getParameterTypes()[i] + ": " + method);
                        }
                        arguments[i] = argument;
                    }

                    println("        Log." + method.getName() + "(" + String.join(", ", arguments) + ");");
                });
        println("    }");
        println("}");
    }

    private static void println(String string) {
        System.out.println(string);
    }
}
