/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2017 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 5.6.0
 * @date    2017-04-15
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(this,function(){return function(e){function t(n){if(i[n])return i[n].exports;var o=i[n]={exports:{},id:n,loaded:!1};return e[n].call(o.exports,o,o.exports,t),o.loaded=!0,o.exports}var i={};return t.m=e,t.c=i,t.p="",t(0)}([function(e,t,i){"use strict";function n(e,t,i){if(!(this instanceof n))throw new Error('JSONEditor constructor called without "new".');var o=a.getInternetExplorerVersion();if(-1!=o&&o<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");if(t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t)){var r=["ace","theme","ajv","schema","onChange","onEditable","onError","onModeChange","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys"];Object.keys(t).forEach(function(e){-1===r.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})}arguments.length&&this._create(e,t,i)}var o;try{o=i(!function(){var e=new Error('Cannot find module "ajv"');throw e.code="MODULE_NOT_FOUND",e}())}catch(e){}var r=i(1),s=i(12),a=i(4);n.modes={},n.prototype.DEBOUNCE_INTERVAL=150,n.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||"tree";this.setMode(n)},n.prototype.destroy=function(){},n.prototype.set=function(e){this.json=e},n.prototype.get=function(){return this.json},n.prototype.setText=function(e){this.json=a.parse(e)},n.prototype.getText=function(){return JSON.stringify(this.json)},n.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},n.prototype.getName=function(){return this.options&&this.options.name},n.prototype.setMode=function(e){var t,i,o=this.container,r=a.extend({},this.options),s=r.mode;r.mode=e;var l=n.modes[e];if(!l)throw new Error('Unknown mode "'+r.mode+'"');try{var c="text"==l.data;if(i=this.getName(),t=this[c?"getText":"get"](),this.destroy(),a.clear(this),a.extend(this,l.mixin),this.create(o,r),this.setName(i),this[c?"setText":"set"](t),"function"==typeof l.load)try{l.load.call(this)}catch(e){console.error(e)}if("function"==typeof r.onModeChange&&e!==s)try{r.onModeChange(e,s)}catch(e){console.error(e)}}catch(e){this._onError(e)}},n.prototype.getMode=function(){return this.options.mode},n.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},n.prototype.setSchema=function(e){if(e){var t;try{t=this.options.ajv||o({allErrors:!0,verbose:!0})}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}t&&(this.validateSchema=t.compile(e),this.options.schema=e,this.validate()),this.refresh()}else this.validateSchema=null,this.options.schema=null,this.validate(),this.refresh()},n.prototype.validate=function(){},n.prototype.refresh=function(){},n.registerMode=function(e){var t,i;if(a.isArray(e))for(t=0;t<e.length;t++)n.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var o=e.mode;if(o in n.modes)throw new Error('Mode "'+o+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if((i=r[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');n.modes[o]=e}},n.registerMode(r),n.registerMode(s),e.exports=n},function(e,t,i){"use strict";var n=i(2),o=i(3),r=i(6),s=i(7),a=i(8),l=i(11),c=i(4),d={};d.create=function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new n,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},d.destroy=function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},d._setOptions=function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema),this._debouncedValidate=c.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL)},d.set=function(e,t){if(t&&(console.warn('Second parameter "name" is deprecated. Use setName(name) instead.'),this.options.name=t),e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var i={field:this.options.name,value:e},n=new a(this,i);this._setRoot(n),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},d.get=function(){if(this.focusTarget){var e=a.getNodeFromTarget(this.focusTarget);e&&e.blur()}return this.node?this.node.getValue():void 0},d.getText=function(){return JSON.stringify(this.get())},d.setText=function(e){this.set(c.parse(e))},d.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},d.getName=function(){return this.options.name},d.focus=function(){var e=this.content.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},d.clear=function(){this.node&&(this.node.collapse(),this.tbody.removeChild(this.node.getDom()),delete this.node)},d._setRoot=function(e){this.clear(),this.node=e,this.tbody.appendChild(e.getDom())},d.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},d.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},d.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},d._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},d._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},d.validate=function(){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var e=this.node;if(e){var t=e.validate(),i=[];if(this.validateSchema){this.validateSchema(e.getValue())||(i=this.validateSchema.errors.map(function(e){return c.improveSchemaError(e)}).map(function(t){return{node:e.findNode(t.dataPath),error:t}}).filter(function(e){return null!=e.node}))}this.errorNodes=t.concat(i).reduce(function(e,t){return t.node.findParents().map(function(e){return{node:e,child:t.node,error:{message:"object"===e.type?"Contains invalid properties":"Contains invalid items"}}}).concat(e,[t])},[]).map(function(e){return e.node.setError(e.error,e.child),e.node})}},d.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},d.startAutoScroll=function(e){var t=this,i=this.content,n=c.getAbsoluteTop(i),o=i.clientHeight,r=n+o;e<n+24&&i.scrollTop>0?this.autoScrollStep=(n+24-e)/3:e>r-24&&o+i.scrollTop<i.scrollHeight?this.autoScrollStep=(r-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},d.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},d.setSelection=function(e){e&&("scrollTop"in e&&this.content&&(this.content.scrollTop=e.scrollTop),e.nodes&&this.select(e.nodes),e.range&&c.setSelectionOffset(e.range),e.dom&&e.dom.focus())},d.getSelection=function(){var e=c.getSelectionOffset();return e&&"DIV"!==e.container.nodeName&&(e=null),{dom:this.focusTarget,range:e,nodes:this.multiselection.nodes.slice(0),scrollTop:this.content?this.content.scrollTop:0}},d.scrollTo=function(e,t){var i=this.content;if(i){var n=this;n.animateTimeout&&(clearTimeout(n.animateTimeout),delete n.animateTimeout),n.animateCallback&&(n.animateCallback(!1),delete n.animateCallback);var o=i.clientHeight,r=i.scrollHeight-o,s=Math.min(Math.max(e-o/4,0),r),a=function(){var e=i.scrollTop,o=s-e;Math.abs(o)>3?(i.scrollTop+=o/3,n.animateCallback=t,n.animateTimeout=setTimeout(a,50)):(t&&t(!0),i.scrollTop=s,delete n.animateTimeout,delete n.animateCallback)};a()}else t&&t(!1)},d._createFrame=function(){function e(e){t._onEvent&&t._onEvent(e)}this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame);var t=this;this.frame.onclick=function(t){var i=t.target;e(t),"BUTTON"==i.nodeName&&t.preventDefault()},this.frame.oninput=e,this.frame.onchange=e,this.frame.onkeydown=e,this.frame.onkeyup=e,this.frame.oncut=e,this.frame.onpaste=e,this.frame.onmousedown=e,this.frame.onmouseup=e,this.frame.onmouseover=e,this.frame.onmouseout=e,c.addEventListener(this.frame,"focus",e,!0),c.addEventListener(this.frame,"blur",e,!0),this.frame.onfocusin=e,this.frame.onfocusout=e,this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var i=document.createElement("button");i.type="button",i.className="jsoneditor-expand-all",i.title="Expand all fields",i.onclick=function(){t.expandAll()},this.menu.appendChild(i);var n=document.createElement("button");if(n.type="button",n.title="Collapse all fields",n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.history){var o=document.createElement("button");o.type="button",o.className="jsoneditor-undo jsoneditor-separator",o.title="Undo last action (Ctrl+Z)",o.onclick=function(){t._onUndo()},this.menu.appendChild(o),this.dom.undo=o;var s=document.createElement("button");s.type="button",s.className="jsoneditor-redo",s.title="Redo (Ctrl+Shift+Z)",s.onclick=function(){t._onRedo()},this.menu.appendChild(s),this.dom.redo=s,this.history.onChange=function(){o.disabled=!t.history.canUndo(),s.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var a=this;this.modeSwitcher=new l(this.menu,this.options.modes,this.options.mode,function(e){a.modeSwitcher.destroy(),a.setMode(e),a.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new r(this,this.menu))},d._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},d._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},d._onEvent=function(e){"keydown"==e.type&&this._onKeyDown(e),"focus"==e.type&&(this.focusTarget=e.target),"mousedown"==e.type&&this._startDragDistance(e),"mousemove"!=e.type&&"mouseup"!=e.type&&"click"!=e.type||this._updateDragDistance(e);var t=a.getNodeFromTarget(e.target);if(t&&t.selected){if("click"==e.type){if(e.target==t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"==e.type&&a.onDragStart(this.multiselection.nodes,e)}else"mousedown"==e.type&&(this.deselect(),t&&e.target==t.dom.drag?a.onDragStart(t,e):(!t||e.target!=t.dom.field&&e.target!=t.dom.value&&e.target!=t.dom.select)&&this._onMultiSelectStart(e));t&&t.onEvent(e)},d._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},d._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||this.dragDistanceEvent.dragDistance>10,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},d._onMultiSelectStart=function(e){var t=a.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=c.addEventListener(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=c.addEventListener(window,"mouseup",function(e){i._onMultiSelectEnd(e)}))}},d._onMultiSelect=function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=a.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;i&&n&&(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.select(this.multiselection.nodes))}},d._onMultiSelectEnd=function(e){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(c.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(c.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},d.deselect=function(e){this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null)},d.select=function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];e.forEach(function(e){e.setSelected(!0,e===t)})}},d._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),o=0;o<i.length&&i[o]===n[o];)o++;var r=i[o-1],s=i[o],a=n[o];if(s&&a||(r.parent?(s=r,a=r,r=r.parent):(s=r.childs[0],a=r.childs[r.childs.length-1])),r&&s&&a){var l=r.childs.indexOf(s),c=r.childs.indexOf(a),d=Math.min(l,c),h=Math.max(l,c);return r.childs.slice(d,h+1)}return[]},d._onKeyDown=function(e){var t=e.which||e.keyCode,i=e.ctrlKey,n=e.shiftKey,o=!1;if(9==t){var r=this;setTimeout(function(){c.selectContentEditable(r.focusTarget)},0)}if(this.searchBox)if(i&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),o=!0;else if(114==t||i&&71==t){n?this.searchBox.previous(!0):this.searchBox.next(!0),o=!0}this.history&&(i&&!n&&90==t?(this._onUndo(),o=!0):i&&n&&90==t&&(this._onRedo(),o=!0)),o&&(e.preventDefault(),e.stopPropagation())},d._createTable=function(){var e=document.createElement("div");e.className="jsoneditor-outer",this.contentOuter=e,this.content=document.createElement("div"),this.content.className="jsoneditor-tree",e.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table);var t;this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&(t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t)),t=document.createElement("col"),t.width="24px",this.colgroupContent.appendChild(t),t=document.createElement("col"),this.colgroupContent.appendChild(t),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(e)},d.showContextMenu=function(e,t){var i=[],n=this;i.push({text:"Duplicate",title:"Duplicate selected fields (Ctrl+D)",className:"jsoneditor-duplicate",click:function(){a.onDuplicate(n.multiselection.nodes)}}),i.push({text:"Remove",title:"Remove selected fields (Ctrl+Del)",className:"jsoneditor-remove",click:function(){a.onRemove(n.multiselection.nodes)}}),new s(i,{close:t}).show(e,this.content)},e.exports=[{mode:"tree",mixin:d,data:"json"},{mode:"view",mixin:d,data:"json"},{mode:"form",mixin:d,data:"json"}]},function(e,t){"use strict";function i(){this.locked=!1}i.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},i.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},i.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},i.prototype.lock=function(){this.locked=!0},i.prototype.unlock=function(){this.locked=!1},e.exports=i},function(e,t,i){"use strict";function n(e){this.editor=e,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){e.node.updateField(e.oldValue)},redo:function(e){e.node.updateField(e.newValue)}},editValue:{undo:function(e){e.node.updateValue(e.oldValue)},redo:function(e){e.node.updateValue(e.newValue)}},changeType:{undo:function(e){e.node.changeType(e.oldType)},redo:function(e){e.node.changeType(e.newType)}},appendNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.appendChild(t)})}},insertBeforeNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){e.nodes.forEach(function(t){e.parent.insertBefore(t,e.beforeNode)})}},insertAfterNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(i){e.parent.insertAfter(e.node,t),t=i})}},removeNodes:{undo:function(e){var t=e.parent,i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})}},duplicateNodes:{undo:function(e){e.nodes.forEach(function(t){e.parent.removeChild(t)})},redo:function(e){var t=e.afterNode;e.nodes.forEach(function(i){e.parent.insertAfter(i,t),t=i})}},moveNodes:{undo:function(e){e.nodes.forEach(function(t){e.oldBeforeNode.parent.moveBefore(t,e.oldBeforeNode)})},redo:function(e){e.nodes.forEach(function(t){e.newBeforeNode.parent.moveBefore(t,e.newBeforeNode)})}},sort:{undo:function(e){var t=e.node;t.hideChilds(),t.sort=e.oldSort,t.childs=e.oldChilds,t.showChilds()},redo:function(e){var t=e.node;t.hideChilds(),t.sort=e.newSort,t.childs=e.newChilds,t.showChilds()}}}}i(4);n.prototype.onChange=function(){},n.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},n.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},n.prototype.canUndo=function(){return this.index>=0},n.prototype.canRedo=function(){return this.index<this.history.length-1},n.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.undo?(t.undo(e.params),e.params.oldSelection&&this.editor.setSelection(e.params.oldSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},n.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];t&&t.redo?(t.redo(e.params),e.params.newSelection&&this.editor.setSelection(e.params.newSelection)):console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},n.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=n},function(e,t,i){"use strict";var n=i(5);t.parse=function(e){try{return JSON.parse(e)}catch(i){throw t.validate(e),i}},t.sanitize=function(e){function t(){return e.charAt(r)}function i(){return e.charAt(r+1)}function n(){return e.charAt(r-1)}var o=[],r=0,s=e.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);for(s&&(e=s[3]);r<e.length;){var a=t();"/"===a&&"*"===i()?function(){for(r+=2;r<e.length&&("*"!==t()||"/"!==i());)r++;r+=2}():"/"===a&&"/"===i()?function(){for(r+=2;r<e.length&&"\n"!==t();)r++}():"'"===a||'"'===a?function(i){o.push('"'),r++;for(var s=t();r<e.length&&s!==i;)'"'===s&&"\\"!==n()&&o.push("\\"),"\\"===s&&(r++,"'"!==(s=t())&&o.push("\\")),o.push(s),r++,s=t();s===i&&(o.push('"'),r++)}(a):/[a-zA-Z_$]/.test(a)&&-1!==["{",","].indexOf(function(){for(var e=o.length-1;e>=0;){var t=o[e];if(" "!==t&&"\n"!==t&&"\r"!==t&&"\t"!==t)return t;e--}return""}())?function(){for(var e=["null","true","false"],i="",n=t(),s=/[a-zA-Z_$\d]/;s.test(n);)i+=n,r++,n=t();-1===e.indexOf(i)?o.push('"'+i+'"'):o.push(i)}():(o.push(a),r++)}return o.join("")},t.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},t.validate=function(e){void 0!==n?n.parse(e):JSON.parse(e)},t.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},t.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},t.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":t.isArray(e)?"array":"object"};var o=/^https?:\/\/\S+$/;t.isUrl=function(e){return("string"==typeof e||e instanceof String)&&o.test(e)},t.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},t.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},t.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},t.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},t.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},t.stripFormatting=function(e){for(var i=e.childNodes,n=0,o=i.length;n<o;n++){var r=i[n];r.style&&r.removeAttribute("style");var s=r.attributes;if(s)for(var a=s.length-1;a>=0;a--){var l=s[a];!0===l.specified&&r.removeAttribute(l.name)}t.stripFormatting(r)}},t.setEndOfContentEditable=function(e){var t,i;document.createRange&&(t=document.createRange(),t.selectNodeContents(e),t.collapse(!1),i=window.getSelection(),i.removeAllRanges(),i.addRange(t))},t.selectContentEditable=function(e){if(e&&"DIV"==e.nodeName){var t,i;window.getSelection&&document.createRange&&(i=document.createRange(),i.selectNodeContents(e),t=window.getSelection(),t.removeAllRanges(),t.addRange(i))}},t.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},t.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},t.getSelectionOffset=function(){var e=t.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},t.setSelectionOffset=function(e){if(document.createRange&&window.getSelection){if(window.getSelection()){var i=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),i.setStart(e.container.firstChild,e.startOffset),i.setEnd(e.container.firstChild,e.endOffset),t.setSelection(i)}}},t.getInnerText=function(e,i){if(void 0==i&&(i={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return i.flush()+e.nodeValue;if(e.hasChildNodes()){for(var n=e.childNodes,o="",r=0,s=n.length;r<s;r++){var a=n[r];if("DIV"==a.nodeName||"P"==a.nodeName){var l=n[r-1],c=l?l.nodeName:void 0;c&&"DIV"!=c&&"P"!=c&&"BR"!=c&&(o+="\n",i.flush()),o+=t.getInnerText(a,i),i.set("\n")}else"BR"==a.nodeName?(o+=i.flush(),i.set("\n")):o+=t.getInnerText(a,i)}return o}return"P"==e.nodeName&&-1!=t.getInternetExplorerVersion()?i.flush():""},t.getInternetExplorerVersion=function(){if(-1==r){var e=-1;if("Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}r=e}return r},t.isFirefox=function(){return-1!=navigator.userAgent.indexOf("Firefox")};var r=-1;t.addEventListener=function(e,i,n,o){if(e.addEventListener)return void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.addEventListener(i,n,o),n;if(e.attachEvent){var r=function(){return n.call(e,window.event)};return e.attachEvent("on"+i,r),r}},t.removeEventListener=function(e,i,n,o){e.removeEventListener?(void 0===o&&(o=!1),"mousewheel"===i&&t.isFirefox()&&(i="DOMMouseScroll"),e.removeEventListener(i,n,o)):e.detachEvent&&e.detachEvent("on"+i,n)},t.parsePath=function e(t){var i,n;if(0===t.length)return[];var o=t.match(/^\.(\w+)/);if(o)i=o[1],n=t.substr(i.length+1);else{if("["!==t[0])throw new SyntaxError("Failed to parse path");var r=t.indexOf("]");if(-1===r)throw new SyntaxError("Character ] expected in path");if(1===r)throw new SyntaxError("Index expected after [");var s=t.substring(1,r);"'"===s[0]&&(s='"'+s.substring(1,s.length-1)+'"'),i="*"===s?s:JSON.parse(s),n=t.substr(r+1)}return[i].concat(e(n))},t.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(t=t.map(function(e){return JSON.stringify(e)}),t.length>5){var i=["("+(t.length-5)+" more...)"];t=t.slice(0,5),t.push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},t.insideRect=function(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom},t.debounce=function(e,t,i){var n;return function(){var o=this,r=arguments,s=function(){n=null,i||e.apply(o,r)},a=i&&!n;clearTimeout(n),n=setTimeout(s,t),a&&e.apply(o,r)}},t.textDiff=function(e,t){for(var i=t.length,n=0,o=e.length,r=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(r-1)===e.charAt(o-1)&&r>n&&o>0;)r--,o--;return{start:n,end:r}}},function(e,t,i){var n=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,o,r,s){var a=r.length-1;switch(o){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=r[a-1];case 13:this.$={};break;case 14:this.$=r[a-1];break;case 15:this.$=[r[a-2],r[a]];break;case 16:this.$={},this.$[r[a][0]]=r[a][1];break;case 17:this.$=r[a-2],r[a-2][r[a][0]]=r[a][1];break;case 18:this.$=[];break;case 19:this.$=r[a-1];break;case 20:this.$=[r[a]];break;case 21:this.$=r[a-2],r[a-2].push(r[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){function t(){var e;return e=i.lexer.lex()||1,"number"!=typeof e&&(e=i.symbols_[e]||e),e}var i=this,n=[0],o=[null],r=[],s=this.table,a="",l=0,c=0,d=0,h=2;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var u=this.lexer.yylloc;r.push(u),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var p,f,m,g,v,y,b,w,x,_={};;){if(m=n[n.length-1],this.defaultActions[m]?g=this.defaultActions[m]:(null==p&&(p=t()),g=s[m]&&s[m][p]),void 0===g||!g.length||!g[0]){if(!d){x=[];for(y in s[m])this.terminals_[y]&&y>2&&x.push("'"+this.terminals_[y]+"'");var E="";E=this.lexer.showPosition?"Parse error on line "+(l+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+x.join(", ")+", got '"+this.terminals_[p]+"'":"Parse error on line "+(l+1)+": Unexpected "+(1==p?"end of input":"'"+(this.terminals_[p]||p)+"'"),this.parseError(E,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:u,expected:x})}if(3==d){if(1==p)throw new Error(E||"Parsing halted.");c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,p=t()}for(;;){if(h.toString()in s[m])break;if(0==m)throw new Error(E||"Parsing halted.");!function(e){n.length=n.length-2*e,o.length=o.length-e,r.length=r.length-e}(1),m=n[n.length-1]}f=p,p=h,m=n[n.length-1],g=s[m]&&s[m][h],d=3}if(g[0]instanceof Array&&g.length>1)throw new Error("Parse Error: multiple actions possible at state: "+m+", token: "+p);switch(g[0]){case 1:n.push(p),o.push(this.lexer.yytext),r.push(this.lexer.yylloc),n.push(g[1]),p=null,f?(p=f,f=null):(c=this.lexer.yyleng,a=this.lexer.yytext,l=this.lexer.yylineno,u=this.lexer.yylloc,d>0&&d--);break;case 2:if(b=this.productions_[g[1]][1],_.$=o[o.length-b],_._$={first_line:r[r.length-(b||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(b||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(v=this.performAction.call(_,a,c,l,this.yy,g[1],o,r)))return v;b&&(n=n.slice(0,-1*b*2),o=o.slice(0,-1*b),r=r.slice(0,-1*b)),n.push(this.productions_[g[1]][0]),o.push(_.$),r.push(_._$),w=s[n[n.length-2]][n[n.length-1]],n.push(w);break;case 3:return!0}}return!0}},t=function(){var e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(e.length>20?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(e.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var e,t,i,n,o;this._more||(this.yytext="",this.match="");for(var r=this._currentRules(),s=0;s<r.length&&(!(i=this._input.match(this.rules[r[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?(o=t[0].match(/\n.*/g),o&&(this.yylineno+=o.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:o?o[o.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,r[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)}};return e.options={},e.performAction=function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},e.rules=[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt\/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],e.conditions={INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}},e}();return e.lexer=t,e}();t.parser=n,t.parse=n.parse.bind(n)},function(e,t){"use strict";function i(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");this.dom.table=n,n.className="jsoneditor-search",t.appendChild(n);var o=document.createElement("tbody");this.dom.tbody=o,n.appendChild(o);var r=document.createElement("tr");o.appendChild(r);var s=document.createElement("td");r.appendChild(s);var a=document.createElement("div");this.dom.results=a,a.className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),r.appendChild(s);var l=document.createElement("div");this.dom.input=l,l.className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var d=document.createElement("tbody");c.appendChild(d),r=document.createElement("tr"),d.appendChild(r);var h=document.createElement("button");h.type="button",h.className="jsoneditor-refresh",s=document.createElement("td"),s.appendChild(h),r.appendChild(s);var u=document.createElement("input");this.dom.search=u,u.oninput=function(e){i._onDelayedSearch(e)},u.onchange=function(e){i._onSearch()},u.onkeydown=function(e){i._onKeyDown(e)},u.onkeyup=function(e){i._onKeyUp(e)},h.onclick=function(e){u.select()},s=document.createElement("td"),s.appendChild(u),r.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Next result (Enter)",p.className="jsoneditor-next",p.onclick=function(){i.next()},s=document.createElement("td"),s.appendChild(p),r.appendChild(s);var f=document.createElement("button");f.type="button",f.title="Previous result (Shift+Enter)",f.className="jsoneditor-previous",f.onclick=function(){i.previous()},s=document.createElement("td"),s.appendChild(f),r.appendChild(s)}i.prototype.next=function(e){if(void 0!=this.results){var t=void 0!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},i.prototype.previous=function(e){if(void 0!=this.results){var t=this.results.length-1,i=void 0!=this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}},i.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"==this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,o=this.results[this.resultIndex].elem;"field"==o?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(o)})},i.prototype._clearDelay=function(){void 0!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},i.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},i.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,i=t.length>0?t:void 0;if(i!=this.lastText||e)if(this.lastText=i,this.results=this.editor.search(i),this._setActiveResult(void 0),void 0!=i){var n=this.results.length;switch(n){case 0:this.dom.results.innerHTML="no&nbsp;results";break;case 1:this.dom.results.innerHTML="1&nbsp;result";break;default:this.dom.results.innerHTML=n+"&nbsp;results"}}else this.dom.results.innerHTML=""},i.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},i.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},i.prototype.clear=function(){this.dom.search.value="",this._onSearch()},i.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=i},function(e,t,i){"use strict";function n(e,t){function i(e,t,o){o.forEach(function(o){if("separator"==o.type){var r=document.createElement("div");r.className="jsoneditor-separator",a=document.createElement("li"),a.appendChild(r),e.appendChild(a)}else{var s={},a=document.createElement("li");e.appendChild(a);var l=document.createElement("button");if(l.type="button",l.className=o.className,s.button=l,o.title&&(l.title=o.title),o.click&&(l.onclick=function(e){e.preventDefault(),n.hide(),o.click()}),a.appendChild(l),o.submenu){var c=document.createElement("div");c.className="jsoneditor-icon",l.appendChild(c),l.appendChild(document.createTextNode(o.text));var d;if(o.click){l.className+=" jsoneditor-default";var h=document.createElement("button");h.type="button",s.buttonExpand=h,h.className="jsoneditor-expand",h.innerHTML='<div class="jsoneditor-expand"></div>',a.appendChild(h),o.submenuTitle&&(h.title=o.submenuTitle),d=h}else{var u=document.createElement("div");u.className="jsoneditor-expand",l.appendChild(u),d=l}d.onclick=function(e){e.preventDefault(),n._onExpandItem(s),d.focus()};var p=[];s.subItems=p;var f=document.createElement("ul");s.ul=f,f.className="jsoneditor-menu",f.style.height="0",a.appendChild(f),i(f,p,o.submenu)}else l.innerHTML='<div class="jsoneditor-icon"></div>'+o.text;t.push(s)}})}this.dom={};var n=this,o=this.dom;this.anchor=void 0,this.items=e,this.eventListeners={},this.selection=void 0,this.onClose=t?t.close:void 0;var r=document.createElement("div");r.className="jsoneditor-contextmenu-root",o.root=r;var s=document.createElement("div");s.className="jsoneditor-contextmenu",o.menu=s,r.appendChild(s);var a=document.createElement("ul");a.className="jsoneditor-menu",s.appendChild(a),o.list=a,o.items=[];var l=document.createElement("button");l.type="button",o.focusButton=l;var c=document.createElement("li");c.style.overflow="hidden",c.style.height="0",c.appendChild(l),a.appendChild(c),i(a,this.dom.items,e),this.maxHeight=0,e.forEach(function(t){var i=24*(e.length+(t.submenu?t.submenu.length:0));n.maxHeight=Math.max(n.maxHeight,i)})}var o=i(4);n.prototype._getVisibleButtons=function(){var e=[],t=this;return this.dom.items.forEach(function(i){e.push(i.button),i.buttonExpand&&e.push(i.buttonExpand),i.subItems&&i==t.expandedItem&&i.subItems.forEach(function(t){e.push(t.button),t.buttonExpand&&e.push(t.buttonExpand)})}),e},n.visibleMenu=void 0,n.prototype.show=function(e,t){this.hide();var i=!0;if(t){var r=e.getBoundingClientRect(),s=t.getBoundingClientRect();r.bottom+this.maxHeight<s.bottom||r.top-this.maxHeight>s.top&&(i=!1)}if(i){var a=e.offsetHeight;this.dom.menu.style.left="0px",this.dom.menu.style.top=a+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0px",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";var l=e.parentNode;l.insertBefore(this.dom.root,l.firstChild);var c=this,d=this.dom.list;this.eventListeners.mousedown=o.addEventListener(window,"mousedown",function(e){var t=e.target;t==d||c._isChildOf(t,d)||(c.hide(),e.stopPropagation(),e.preventDefault())}),this.eventListeners.keydown=o.addEventListener(window,"keydown",function(e){c._onKeyDown(e)}),this.selection=o.getSelection(),this.anchor=e,setTimeout(function(){c.dom.focusButton.focus()},0),n.visibleMenu&&n.visibleMenu.hide(),n.visibleMenu=this},n.prototype.hide=function(){this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose());for(var e in this.eventListeners)if(this.eventListeners.hasOwnProperty(e)){var t=this.eventListeners[e];t&&o.removeEventListener(window,e,t),delete this.eventListeners[e]}n.visibleMenu==this&&(n.visibleMenu=void 0)},n.prototype._onExpandItem=function(e){var t=this,i=e==this.expandedItem,n=this.expandedItem;if(n&&(n.ul.style.height="0",n.ul.style.padding="",setTimeout(function(){t.expandedItem!=n&&(n.ul.style.display="",o.removeClassName(n.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!i){var r=e.ul;r.style.display="block";r.clientHeight;setTimeout(function(){t.expandedItem==e&&(r.style.height=24*r.childNodes.length+"px",r.style.padding="5px 10px")},0),o.addClassName(r.parentNode,"jsoneditor-selected"),this.expandedItem=e}},n.prototype._onKeyDown=function(e){var t,i,n,r,s=e.target,a=e.which,l=!1;27==a?(this.selection&&o.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9==a?e.shiftKey?(t=this._getVisibleButtons(),0==(i=t.indexOf(s))&&(t[t.length-1].focus(),l=!0)):(t=this._getVisibleButtons(),(i=t.indexOf(s))==t.length-1&&(t[0].focus(),l=!0)):37==a?("jsoneditor-expand"==s.className&&(t=this._getVisibleButtons(),i=t.indexOf(s),(n=t[i-1])&&n.focus()),l=!0):38==a?(t=this._getVisibleButtons(),i=t.indexOf(s),n=t[i-1],n&&"jsoneditor-expand"==n.className&&(n=t[i-2]),n||(n=t[t.length-1]),n&&n.focus(),l=!0):39==a?(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"jsoneditor-expand"==r.className&&r.focus(),l=!0):40==a&&(t=this._getVisibleButtons(),i=t.indexOf(s),r=t[i+1],r&&"jsoneditor-expand"==r.className&&(r=t[i+2]),r||(r=t[0]),r&&(r.focus(),l=!0),l=!0),l&&(e.stopPropagation(),e.preventDefault())},n.prototype._isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i==t)return!0;i=i.parentNode}return!1},e.exports=n},function(e,t,i){"use strict";function n(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),this.setValue(t.value,t.type)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=a.debounce(this._onChangeValue.bind(this),n.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=a.debounce(this._onChangeField.bind(this),n.prototype.DEBOUNCE_INTERVAL)}var o=i(9),r=i(7),s=i(10),a=i(4);n.prototype.DEBOUNCE_INTERVAL=150,n.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},n.prototype.getPath=function(){for(var e=this,t=[];e;){var i=e.parent?"array"!=e.parent.type?e.field:e.index:void 0;void 0!==i&&t.unshift(i),e=e.parent}return t},n.prototype.findNode=function(e){for(var t=a.parsePath(e),i=this;i&&t.length>0;){var n=t.shift();if("number"==typeof n){if("array"!==i.type)throw new Error("Cannot get child node at index "+n+": node is no array");i=i.childs[n]}else{if("object"!==i.type)throw new Error("Cannot get child node "+n+": node is no object");i=i.childs.filter(function(e){return e.field===n})[0]}}return i},n.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},n.prototype.setError=function(e,t){this.getDom(),this.error=e;var i=this.dom.tdError;if(e){i||(i=document.createElement("td"),this.dom.tdError=i,this.dom.tdValue.parentNode.appendChild(i));var n=document.createElement("div");n.className="jsoneditor-popover jsoneditor-right",n.appendChild(document.createTextNode(e.message));var o=document.createElement("button");for(o.type="button",o.className="jsoneditor-schema-error",o.appendChild(n),o.onmouseover=o.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var i=e[t];n.className="jsoneditor-popover jsoneditor-"+i;var o=this.editor.content.getBoundingClientRect(),r=n.getBoundingClientRect();if(a.insideRect(o,r,20))break}}.bind(this),t&&(o.onclick=function(){t.findParents().forEach(function(e){e.expand(!1)}),t.scrollTo(function(){t.focus()})});i.firstChild;)i.removeChild(i.firstChild);i.appendChild(o)}else i&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},n.prototype.getIndex=function(){return this.parent?this.parent.childs.indexOf(this):-1},n.prototype.setParent=function(e){this.parent=e},n.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},n.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},n.prototype.setValue=function(e,t){var i,o,r=this.childs;if(r)for(;r.length;)this.removeChild(r[0]);if(this.type=this._getType(e),t&&t!=this.type){if("string"!=t||"auto"!=this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"==this.type){this.childs=[];for(var s=0,a=e.length;s<a;s++)void 0===(i=e[s])||i instanceof Function||(o=new n(this.editor,{value:i}),this.appendChild(o));this.value=""}else if("object"==this.type){this.childs=[];for(var l in e)e.hasOwnProperty(l)&&(void 0===(i=e[l])||i instanceof Function||(o=new n(this.editor,{field:l,value:i}),this.appendChild(o)));this.value="",!0===this.editor.options.sortObjectKeys&&this.sort("asc")}else this.childs=void 0,this.value=e;this.previousValue=this.value},n.prototype.getValue=function(){if("array"==this.type){var e=[];return this.childs.forEach(function(t){e.push(t.getValue())}),e}if("object"==this.type){var t={};return this.childs.forEach(function(e){t[e.getField()]=e.getValue()}),t}return void 0===this.value&&this._getDomValue(),this.value},n.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},n.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},n.prototype.clone=function(){var e=new n(this.editor);if(e.type=this.type,e.field=this.field,e.fieldInnerText=this.fieldInnerText,e.fieldEditable=this.fieldEditable,e.value=this.value,e.valueInnerText=this.valueInnerText,e.expanded=this.expanded,this.childs){var t=[];this.childs.forEach(function(i){var n=i.clone();n.setParent(e),t.push(n)}),e.childs=t}else e.childs=void 0;return e},n.prototype.expand=function(e){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-expanded"),this.showChilds(),!1!==e&&this.childs.forEach(function(t){t.expand(e)}))},n.prototype.collapse=function(e){this.childs&&(this.hideChilds(),!1!==e&&this.childs.forEach(function(t){t.collapse(e)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-collapsed"),this.expanded=!1)},n.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppend(),n=e.nextSibling;n?t.insertBefore(i,n):t.appendChild(i),this.childs.forEach(function(e){t.insertBefore(e.getDom(),i),e.showChilds()})}}},n.prototype.hide=function(){var e=this.dom.tr,t=e?e.parentNode:void 0;t&&t.removeChild(e),this.hideChilds()},n.prototype.hideChilds=function(){if(this.childs&&this.expanded){var e=this.getAppend();e.parentNode&&e.parentNode.removeChild(e),this.childs.forEach(function(e){e.hide()})}},n.prototype.appendChild=function(e){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),this.childs.push(e),this.expanded){var t=e.getDom(),i=this.getAppend(),n=i?i.parentNode:void 0;i&&n&&n.insertBefore(t,i),e.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}e.parent&&e.parent.removeChild(e),t instanceof l?this.appendChild(e):this.insertBefore(e,t),i&&i.removeChild(n)}},n.prototype.moveTo=function(e,t){if(e.parent==this){this.childs.indexOf(e)<t&&t++}var i=this.childs[t]||this.append;this.moveBefore(e,i)},n.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(t==this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),o=t.getDom(),r=o?o.parentNode:void 0;o&&r&&r.insertBefore(n,o),e.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},n.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},n.prototype.search=function(e){var t,i=[],n=e?e.toLowerCase():void 0;if(delete this.searchField,delete this.searchValue,void 0!=this.field){t=String(this.field).toLowerCase().indexOf(n),-1!=t&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField()}if(this._hasChilds()){if(this.childs){var o=[];this.childs.forEach(function(t){o=o.concat(t.search(e))}),i=i.concat(o)}if(void 0!=n){0==o.length?this.collapse(!1):this.expand(!1)}}else{if(void 0!=this.value){t=String(this.value).toLowerCase().indexOf(n),-1!=t&&(this.searchValue=!0,i.push({node:this,elem:"value"}))}this._updateDomValue()}return i},n.prototype.scrollTo=function(e){if(!this.dom.tr||!this.dom.tr.parentNode)for(var t=this.parent;t;)t.expand(!1),t=t.parent;this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},n.focusElement=void 0,n.prototype.focus=function(e){if(n.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),a.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),a.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),a.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),a.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),a.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),a.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},n.select=function(e){setTimeout(function(){a.selectContentEditable(e)},0)},n.prototype.blur=function(){this._getDomValue(!1),this._getDomField(!1)},n.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1},n.prototype._move=function(e,t){if(e!=t){if(e.containsNode(this))throw new Error("Cannot move a field into a child of itself");e.parent&&e.parent.removeChild(e);var i=e.clone();e.clearDom(),t?this.insertBefore(i,t):this.appendChild(i)}},n.prototype.removeChild=function(e){if(this.childs){var t=this.childs.indexOf(e);if(-1!=t){e.hide(),delete e.searchField,delete e.searchValue;var i=this.childs.splice(t,1)[0];return i.parent=null,this.updateDom({updateIndexes:!0}),i}}},n.prototype._remove=function(e){this.removeChild(e)},n.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i,n=this.dom.tr?this.dom.tr.parentNode:void 0;i=this.expanded?this.getAppend():this.getDom();var o=i&&i.parentNode?i.nextSibling:void 0;this.hide(),this.clearDom(),this.type=e,"object"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,n&&(o?n.insertBefore(this.getDom(),o):n.appendChild(this.getDom())),this.showChilds()}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):this._stringCast(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},n.prototype._getDomValue=function(e){if(this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=a.getInnerText(this.dom.value)),void 0!=this.valueInnerText)try{var t;if("string"==this.type)t=this._unescapeHTML(this.valueInnerText);else{var i=this._unescapeHTML(this.valueInnerText);t=this._stringCast(i)}t!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(t){if(this.value=void 0,!0!==e)throw t}},n.prototype._onChangeValue=function(){var e=this.editor.getSelection();if(e.range){var t=a.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getSelection();if(i.range){var n=a.textDiff(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{node:this,oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value},n.prototype._onChangeField=function(){var e=this.editor.getSelection();if(e.range){var t=a.textDiff(this.field,this.previousField);e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getSelection();if(i.range){var n=a.textDiff(this.previousField,this.field);i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editField",{node:this,oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:i}),this.previousField=this.field},n.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"==this.type?a.type(i):this.type,o="string"==n&&a.isUrl(i);t.push("jsoneditor-"+n),o&&t.push("jsoneditor-url");if(""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==n||"object"==n){var r=this.childs?this.childs.length:0;e.title=this.type+" containing "+r+" items"}else o&&this.editable.value?e.title="Ctrl+Click or Ctrl+Enter to open url in new window":e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);a.stripFormatting(e)}},n.prototype._updateDomField=function(){var e=this.dom.field;if(e){""==String(this.field)&&"array"!=this.parent.type?a.addClassName(e,"jsoneditor-empty"):a.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?a.addClassName(e,"jsoneditor-highlight-active"):a.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?a.addClassName(e,"jsoneditor-highlight"):a.removeClassName(e,"jsoneditor-highlight"),a.stripFormatting(e)}},n.prototype._getDomField=function(e){if(this.dom.field&&this.fieldEditable&&(this.fieldInnerText=a.getInnerText(this.dom.field)),void 0!=this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText);t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(t){if(this.field=void 0,!0!==e)throw t}},n.prototype.validate=function(){var e=[];if("object"===this.type){for(var t={},i=[],n=0;n<this.childs.length;n++){var o=this.childs[n];t.hasOwnProperty(o.field)&&i.push(o.field),t[o.field]=!0}i.length>0&&(e=this.childs.filter(function(e){return-1!==i.indexOf(e.field)}).map(function(e){return{node:e,error:{message:'duplicate key "'+e.field+'"'}}}))}if(this.childs)for(var n=0;n<this.childs.length;n++){var r=this.childs[n].validate();r.length>0&&(e=e.concat(r))}return e},n.prototype.clearDom=function(){this.dom={}},n.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),e.tr.node=this,"tree"===this.editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",e.drag=i,i.className="jsoneditor-dragarea",i.title="Drag to move this field (Alt+Shift+Arrows)",t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),o=document.createElement("button");o.type="button",e.menu=o,o.className="jsoneditor-contextmenu",o.title="Click to open the actions menu (Ctrl+M)",n.appendChild(e.menu),e.tr.appendChild(n)}var r=document.createElement("td");return e.tr.appendChild(r),e.tree=this._createDomTree(),r.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},n.onDragStart=function(e,t){if(!Array.isArray(e))return n.onDragStart([e],t);if(0!==e.length){var i=e[0],o=e[e.length-1],r=n.getNodeFromTarget(t.target),s=o._nextSibling(),l=i.editor,c=a.getAbsoluteTop(r.dom.tr)-a.getAbsoluteTop(i.dom.tr);l.mousemove||(l.mousemove=a.addEventListener(window,"mousemove",function(t){n.onDrag(e,t)})),l.mouseup||(l.mouseup=a.addEventListener(window,"mouseup",function(t){n.onDragEnd(e,t)})),l.highlighter.lock(),l.drag={oldCursor:document.body.style.cursor,oldSelection:l.getSelection(),oldBeforeNode:s,mouseX:t.pageX,offsetY:c,level:i.getLevel()},document.body.style.cursor="move",t.preventDefault()}},n.onDrag=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i,o,r,s,c,d,h,u,p,f,m,g,v,y,b=e[0].editor,w=t.pageY-b.drag.offsetY,x=t.pageX,_=!1,E=e[0];if(i=E.dom.tr,p=a.getAbsoluteTop(i),g=i.offsetHeight,w<p){o=i;do{o=o.previousSibling,h=n.getNodeFromTarget(o),f=o?a.getAbsoluteTop(o):0}while(o&&w<f);h&&!h.parent&&(h=void 0),h||(d=i.parentNode.firstChild,o=d?d.nextSibling:void 0,(h=n.getNodeFromTarget(o))==E&&(h=void 0)),h&&(o=h.dom.tr,f=o?a.getAbsoluteTop(o):0,w>f+g&&(h=void 0)),h&&(e.forEach(function(e){h.parent.moveBefore(e,h)}),_=!0)}else{var C=e[e.length-1];if(c=C.expanded&&C.append?C.append.getDom():C.dom.tr,s=c?c.nextSibling:void 0){m=a.getAbsoluteTop(s),r=s;do{u=n.getNodeFromTarget(r),r&&(v=r.nextSibling?a.getAbsoluteTop(r.nextSibling):0,y=r?v-m:0,u.parent.childs.length==e.length&&u.parent.childs[e.length-1]==C&&(p+=27)),r=r.nextSibling}while(r&&w>p+y);if(u&&u.parent){var j=x-b.drag.mouseX,S=Math.round(j/24/2),N=b.drag.level+S,k=u.getLevel();for(o=u.dom.tr.previousSibling;k<N&&o;){h=n.getNodeFromTarget(o);if(e.some(function(e){return e===h||h._isChildOf(e)}));else{
if(!(h instanceof l))break;var A=h.parent.childs;if(A.length==e.length&&A[e.length-1]==C)break;u=n.getNodeFromTarget(o),k=u.getLevel()}o=o.previousSibling}c.nextSibling!=u.dom.tr&&(e.forEach(function(e){u.parent.moveBefore(e,u)}),_=!0)}}}_&&(b.drag.mouseX=x,b.drag.level=E.getLevel()),b.startAutoScroll(w),t.preventDefault()}},n.onDragEnd=function(e,t){if(!Array.isArray(e))return n.onDrag([e],t);if(0!==e.length){var i=e[0],o=i.editor,r=i.parent,s=r.childs.indexOf(i),l=r.childs[s+e.length]||r.append;e[0]&&e[0].dom.menu.focus();var c={nodes:e,oldSelection:o.drag.oldSelection,newSelection:o.getSelection(),oldBeforeNode:o.drag.oldBeforeNode,newBeforeNode:l};c.oldBeforeNode!=c.newBeforeNode&&o._onAction("moveNodes",c),document.body.style.cursor=o.drag.oldCursor,o.highlighter.unlock(),e.forEach(function(e){t.target!==e.dom.drag&&t.target!==e.dom.menu&&o.highlighter.unhighlight()}),delete o.drag,o.mousemove&&(a.removeEventListener(window,"mousemove",o.mousemove),delete o.mousemove),o.mouseup&&(a.removeEventListener(window,"mouseup",o.mouseup),delete o.mouseup),o.stopAutoScroll(),t.preventDefault()}},n.prototype._isChildOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},n.prototype._createDomField=function(){return document.createElement("div")},n.prototype.setHighlight=function(e){this.dom.tr&&(e?a.addClassName(this.dom.tr,"jsoneditor-highlight"):a.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(e),this.childs&&this.childs.forEach(function(t){t.setHighlight(e)}))},n.prototype.setSelected=function(e,t){this.selected=e,this.dom.tr&&(e?a.addClassName(this.dom.tr,"jsoneditor-selected"):a.removeClassName(this.dom.tr,"jsoneditor-selected"),t?a.addClassName(this.dom.tr,"jsoneditor-first"):a.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(e),this.childs&&this.childs.forEach(function(t){t.setSelected(e)}))},n.prototype.updateValue=function(e){this.value=e,this.updateDom()},n.prototype.updateField=function(e){this.field=e,this.updateDom()},n.prototype.updateDom=function(e){var t=this.dom.tree;t&&(t.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):i.className="jsoneditor-readonly";var n;n=void 0!=this.index?this.index:void 0!=this.field?this.field:this._hasChilds()?this.type:"",i.innerHTML=this._escapeHTML(n),this._updateSchema()}var o=this.dom.value;if(o){var r=this.childs?this.childs.length:0;"array"==this.type?(o.innerHTML="["+r+"]",a.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(o.innerHTML="{"+r+"}",a.addClassName(this.dom.tr,"jsoneditor-expandable")):(o.innerHTML=this._escapeHTML(this.value),a.removeClassName(this.dom.tr,"jsoneditor-expandable"))}this._updateDomField(),this._updateDomValue(),e&&!0===e.updateIndexes&&this._updateDomIndexes(),e&&!0===e.recurse&&this.childs&&this.childs.forEach(function(t){t.updateDom(e)}),this.append&&this.append.updateDom()},n.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=n._findSchema(this.editor.options.schema,this.getPath()),this.schema?this.enum=n._findEnum(this.schema):delete this.enum)},n._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(i.length>0)return i[0].enum}return null},n._findSchema=function(e,t){for(var i=e,n=0;n<t.length&&i;n++){var o=t[n];"string"==typeof o&&i.properties?i=i.properties[o]||null:"number"==typeof o&&i.items&&(i=i.items)}return i},n.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){void 0!=e.index&&(delete e.index,void 0==e.field&&(e.field=""))}))},n.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div"),e.innerHTML="[...]"):"object"==this.type?(e=document.createElement("div"),e.innerHTML="{...}"):!this.editable.value&&a.isUrl(this.value)?(e=document.createElement("a"),e.href=this.value,e.target="_blank",e.innerHTML=this._escapeHTML(this.value)):(e=document.createElement("div"),e.contentEditable=this.editable.value,e.spellcheck=!1,e.innerHTML=this._escapeHTML(this.value)),e},n.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-expanded":"jsoneditor-collapsed",e.title="Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs."):(e.className="jsoneditor-invisible",e.title=""),e},n.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.expand=this._createDomExpandButton(),o.appendChild(e.expand),e.tdExpand=o;var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.field=this._createDomField(),r.appendChild(e.field),e.tdField=r;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},n.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,o=this,r=this._hasChilds();if(i!=n.drag&&i!=n.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=o.editor.highlighter;s.highlight(o),s.lock(),a.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){a.removeClassName(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(i==n.expand||("view"===o.editor.options.mode||"form"===o.editor.options.mode)&&"DIV"===i.nodeName)&&r){var l=e.ctrlKey;this._onExpand(l)}"change"==t&&i==n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue()),"change"==t&&i==n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var c=n.value;if(i==c)switch(t){case"blur":case"change":this._getDomValue(!0),this._updateDomValue(),this.value&&(c.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(!0),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getSelection();break;case"click":!e.ctrlKey&&this.editable.value||a.isUrl(this.value)&&window.open(this.value,"_blank");break;case"keyup":this._getDomValue(!0),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(!0),o._updateDomValue()},1)}var d=n.field;if(i==d)switch(t){case"blur":case"change":this._getDomField(!0),this._updateDomField(),this.field&&(d.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(!0),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getSelection();break;case"keyup":this._getDomField(!0),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(!0),o._updateDomField()},1)}i!=n.tree.parentNode||"click"!=t||e.hasMoved||((void 0!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<a.getAbsoluteLeft(n.tdSeparator))||r?d&&(a.setEndOfContentEditable(d),d.focus()):c&&!this.enum&&(a.setEndOfContentEditable(c),c.focus()));(i!=n.tdExpand||r)&&i!=n.tdField&&i!=n.tdSeparator||"click"!=t||e.hasMoved||d&&(a.setEndOfContentEditable(d),d.focus()),"keydown"==t&&this.onKeyDown(e)},n.prototype.onKeyDown=function(e){var t,i,o,r,s,c,d,h,u=e.which||e.keyCode,p=e.target||e.srcElement,f=e.ctrlKey,m=e.shiftKey,g=e.altKey,v=!1,y="tree"===this.editor.options.mode,b=this.editor.multiselection.nodes.length>0?this.editor.multiselection.nodes:[this],w=b[0],x=b[b.length-1];if(13==u){if(p==this.dom.value)this.editable.value&&!e.ctrlKey||a.isUrl(this.value)&&(window.open(this.value,"_blank"),v=!0);else if(p==this.dom.expand){var _=this._hasChilds();if(_){var E=e.ctrlKey;this._onExpand(E),p.focus(),v=!0}}}else if(68==u)f&&y&&(n.onDuplicate(b),v=!0);else if(69==u)f&&(this._onExpand(m),p.focus(),v=!0);else if(77==u&&y)f&&(this.showContextMenu(p),v=!0);else if(46==u&&y)f&&(n.onRemove(b),v=!0);else if(45==u&&y)f&&!m?(this._onInsertBefore(),v=!0):f&&m&&(this._onInsertAfter(),v=!0);else if(35==u){if(g){var C=this._lastNode();C&&C.focus(n.focusElement||this._getElementName(p)),v=!0}}else if(36==u){if(g){var j=this._firstNode();j&&j.focus(n.focusElement||this._getElementName(p)),v=!0}}else if(37==u){if(g&&!m){var S=this._previousElement(p);S&&this.focus(this._getElementName(S)),v=!0}else if(g&&m&&y){if(x.expanded){var N=x.getAppend();o=N?N.nextSibling:void 0}else{var k=x.getDom();o=k.nextSibling}o&&(i=n.getNodeFromTarget(o),r=o.nextSibling,T=n.getNodeFromTarget(r),i&&i instanceof l&&1!=x.parent.childs.length&&T&&T.parent&&(s=this.editor.getSelection(),c=x._nextSibling(),b.forEach(function(e){T.parent.moveBefore(e,T)}),this.focus(n.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:c,newBeforeNode:T,oldSelection:s,newSelection:this.editor.getSelection()})))}}else if(38==u)g&&!m?(t=this._previousNode(),t&&(this.editor.deselect(!0),t.focus(n.focusElement||this._getElementName(p))),v=!0):!g&&f&&m&&y?(t=this._previousNode(),t&&(h=this.editor.multiselection,h.start=h.start||this,h.end=t,d=this.editor._findTopLevelNodes(h.start,h.end),this.editor.select(d),t.focus("field")),v=!0):g&&m&&y&&(t=w._previousNode(),t&&t.parent&&(s=this.editor.getSelection(),c=x._nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:c,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getSelection()})),v=!0);else if(39==u){if(g&&!m){var A=this._nextElement(p);A&&this.focus(this._getElementName(A)),v=!0}else if(g&&m&&y){k=w.getDom();var O=k.previousSibling;O&&(t=n.getNodeFromTarget(O))&&t.parent&&t instanceof l&&!t.isVisible()&&(s=this.editor.getSelection(),c=x._nextSibling(),b.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(n.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:c,newBeforeNode:t,oldSelection:s,newSelection:this.editor.getSelection()}))}}else if(40==u)if(g&&!m)i=this._nextNode(),i&&(this.editor.deselect(!0),i.focus(n.focusElement||this._getElementName(p))),v=!0;else if(!g&&f&&m&&y)i=this._nextNode(),i&&(h=this.editor.multiselection,h.start=h.start||this,h.end=i,d=this.editor._findTopLevelNodes(h.start,h.end),this.editor.select(d),i.focus("field")),v=!0;else if(g&&m&&y){i=x.expanded?x.append?x.append._nextNode():void 0:x._nextNode();var T=i&&(i._nextNode()||i.parent.append);T&&T.parent&&(s=this.editor.getSelection(),c=x._nextSibling(),b.forEach(function(e){T.parent.moveBefore(e,T)}),this.focus(n.focusElement||this._getElementName(p)),this.editor._onAction("moveNodes",{nodes:b,oldBeforeNode:c,newBeforeNode:T,oldSelection:s,newSelection:this.editor.getSelection()})),v=!0}v&&(e.preventDefault(),e.stopPropagation())},n.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},n.onRemove=function(e){if(!Array.isArray(e))return n.onRemove([e]);if(e&&e.length>0){var t=e[0],i=t.parent,o=t.editor,r=t.getIndex();o.highlighter.unhighlight();var s=o.getSelection();n.blurNodes(e);var a=o.getSelection();e.forEach(function(e){e.parent._remove(e)}),o._onAction("removeNodes",{nodes:e.slice(0),parent:i,index:r,oldSelection:s,newSelection:a})}},n.onDuplicate=function(e){if(!Array.isArray(e))return n.onDuplicate([e]);if(e&&e.length>0){var t=e[e.length-1],i=t.parent,o=t.editor;o.deselect(o.multiselection.nodes);var r=o.getSelection(),s=t,a=e.map(function(e){var t=e.clone();return i.insertAfter(t,s),s=t,t});1===e.length?a[0].focus():o.select(a);var l=o.getSelection();o._onAction("duplicateNodes",{afterNode:t,nodes:a,parent:i,oldSelection:r,newSelection:l})}},n.prototype._onInsertBefore=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],beforeNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onInsertAfter=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],afterNode:this,parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onAppend=function(e,t,i){var o=this.editor.getSelection(),r=new n(this.editor,{field:void 0!=e?e:"",value:void 0!=t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getSelection();this.editor._onAction("appendNodes",{nodes:[r],parent:this.parent,oldSelection:o,newSelection:s})},n.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getSelection();this.changeType(e);var n=this.editor.getSelection();this.editor._onAction("changeType",{node:this,oldType:t,newType:e,oldSelection:i,newSelection:n})}},n.prototype.sort=function(e){if(this._hasChilds()){var t="desc"==e?-1:1,i="array"==this.type?"value":"field";this.hideChilds();var n=this.childs,r=this.sortOrder;this.childs=this.childs.concat(),this.childs.sort(function(e,n){return t*o(e[i],n[i])}),this.sortOrder=1==t?"asc":"desc",this.editor._onAction("sort",{node:this,oldChilds:n,oldSort:r,newChilds:this.childs,newSort:this.sortOrder}),this.showChilds()}},n.prototype.getAppend=function(){return this.append||(this.append=new l(this.editor),this.append.setParent(this)),this.append.getDom()},n.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},n.blurNodes=function(e){if(!Array.isArray(e))return void n.blurNodes([e]);var t=e[0],i=t.parent,o=t.getIndex();i.childs[o+e.length]?i.childs[o+e.length].focus():i.childs[o-1]?i.childs[o-1].focus():i.focus()},n.prototype._nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},n.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.previousSibling,e=n.getNodeFromTarget(i)}while(i&&e instanceof l&&!e.isVisible())}return e},n.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t;do{i=i.nextSibling,e=n.getNodeFromTarget(i)}while(i&&e instanceof l&&!e.isVisible())}return e},n.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=n.getNodeFromTarget(i)}return e},n.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=n.getNodeFromTarget(i);i&&e instanceof l&&!e.isVisible();)i=i.previousSibling,e=n.getNodeFromTarget(i)}return e},n.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},n.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},n.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},n.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},n.TYPE_TITLES={auto:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',object:'Field type "object". An object contains an unordered set of key/value pairs.',array:'Field type "array". An array contains an ordered collection of values.',string:'Field type "string". Field type is not determined from the value, but always returned as string.'},n.prototype.showContextMenu=function(e,t){var i=this,o=n.TYPE_TITLES,s=[];if(this.editable.value&&s.push({text:"Type",title:"Change the type of this field",className:"jsoneditor-type-"+this.type,submenu:[{text:"Auto",className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:o.auto,click:function(){i._onChangeType("auto")}},{text:"Array",className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:o.array,click:function(){i._onChangeType("array")}},{text:"Object",className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:o.object,click:function(){i._onChangeType("object")}},{text:"String",className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:o.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()){var a="asc"==this.sortOrder?"desc":"asc";s.push({text:"Sort",title:"Sort the childs of this "+this.type,className:"jsoneditor-sort-"+a,click:function(){i.sort(a)},submenu:[{text:"Ascending",className:"jsoneditor-sort-asc",title:"Sort the childs of this "+this.type+" in ascending order",click:function(){i.sort("asc")}},{text:"Descending",className:"jsoneditor-sort-desc",title:"Sort the childs of this "+this.type+" in descending order",click:function(){i.sort("desc")}}]})}if(this.parent&&this.parent._hasChilds()){s.length&&s.push({type:"separator"});var l=i.parent.childs;i==l[l.length-1]&&s.push({text:"Append",title:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",submenuTitle:"Select the type of the field to be appended",className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:[{text:"Auto",className:"jsoneditor-type-auto",title:o.auto,click:function(){i._onAppend("","","auto")}},{text:"Array",className:"jsoneditor-type-array",title:o.array,click:function(){i._onAppend("",[])}},{text:"Object",className:"jsoneditor-type-object",title:o.object,click:function(){i._onAppend("",{})}},{text:"String",className:"jsoneditor-type-string",title:o.string,click:function(){i._onAppend("","","string")}}]}),s.push({text:"Insert",title:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",submenuTitle:"Select the type of the field to be inserted",className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:[{text:"Auto",className:"jsoneditor-type-auto",title:o.auto,click:function(){i._onInsertBefore("","","auto")}},{text:"Array",className:"jsoneditor-type-array",title:o.array,click:function(){i._onInsertBefore("",[])}},{text:"Object",className:"jsoneditor-type-object",title:o.object,click:function(){i._onInsertBefore("",{})}},{text:"String",className:"jsoneditor-type-string",title:o.string,click:function(){i._onInsertBefore("","","string")}}]}),this.editable.field&&(s.push({text:"Duplicate",title:"Duplicate this field (Ctrl+D)",className:"jsoneditor-duplicate",click:function(){n.onDuplicate(i)}}),s.push({text:"Remove",title:"Remove this field (Ctrl+Del)",className:"jsoneditor-remove",click:function(){n.onRemove(i)}}))}new r(s,{close:t}).show(e,this.editor.content)},n.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof this._stringCast(e)?"string":"auto"},n.prototype._stringCast=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""==e?"":"null"==t?null:"true"==t||"false"!=t&&(isNaN(i)||isNaN(n)?e:i)},n.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=a.escapeUnicodeChars(n)),n},n.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return a.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},n.prototype._escapeJSON=function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"==n?t+="\\n":"\\"==n?(t+=n,i++,n=e.charAt(i),""!==n&&-1!='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'==n?'\\"':n,i++}return t};var l=s(n);e.exports=n},function(e,t){e.exports=function e(t,i){"use strict";var n,o,r=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,a=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,l=/^0x[0-9a-f]+$/i,c=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},d=c(t).replace(s,"")||"",h=c(i).replace(s,"")||"",u=d.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=h.replace(r,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),f=parseInt(d.match(l),16)||1!==u.length&&d.match(a)&&Date.parse(d),m=parseInt(h.match(l),16)||f&&h.match(a)&&Date.parse(h)||null;if(m){if(f<m)return-1;if(f>m)return 1}for(var g=0,v=Math.max(u.length,p.length);g<v;g++){if(n=!(u[g]||"").match(/^0/)&&parseFloat(u[g])||u[g]||0,o=!(p[g]||"").match(/^0/)&&parseFloat(p[g])||p[g]||0,isNaN(n)!==isNaN(o))return isNaN(n)?1:-1;if(typeof n!=typeof o&&(n+="",o+=""),n<o)return-1;if(n>o)return 1}return 0}},function(e,t,i){"use strict";function n(e){function t(e){this.editor=e,this.dom={}}return t.prototype=new e,t.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var o=document.createElement("td"),r=document.createElement("div");return r.innerHTML="(empty)",r.className="jsoneditor-readonly",o.appendChild(r),e.td=o,e.text=r,this.updateDom(),t},t.prototype.updateDom=function(){var e=this.dom,t=e.td;t&&(t.style.paddingLeft=24*this.getLevel()+26+"px");var i=e.text;i&&(i.innerHTML="(empty "+this.parent.type+")");var n=e.tr;this.isVisible()?e.tr.firstChild||(e.tdDrag&&n.appendChild(e.tdDrag),e.tdMenu&&n.appendChild(e.tdMenu),n.appendChild(t)):e.tr.firstChild&&(e.tdDrag&&n.removeChild(e.tdDrag),e.tdMenu&&n.removeChild(e.tdMenu),n.removeChild(t))},t.prototype.isVisible=function(){return 0==this.parent.childs.length},t.prototype.showContextMenu=function(t,i){var n=this,o=e.TYPE_TITLES,s=[{text:"Append",title:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",submenuTitle:"Select the type of the field to be appended",className:"jsoneditor-insert",click:function(){n._onAppend("","","auto")},submenu:[{text:"Auto",className:"jsoneditor-type-auto",title:o.auto,click:function(){n._onAppend("","","auto")}},{text:"Array",className:"jsoneditor-type-array",title:o.array,click:function(){n._onAppend("",[])}},{text:"Object",className:"jsoneditor-type-object",title:o.object,click:function(){n._onAppend("",{})}},{text:"String",className:"jsoneditor-type-string",title:o.string,click:function(){n._onAppend("","","string")}}]}];new r(s,{close:i}).show(t,this.editor.content)},t.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i==n.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var r=this.editor.highlighter;r.highlight(this.parent),r.lock(),o.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){o.removeClassName(n.menu,"jsoneditor-selected"),r.unlock(),r.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},t}var o=i(4),r=i(7);e.exports=n},function(e,t,i){"use strict";function n(e,t,i,n){for(var r={code:{text:"Code",title:"Switch to code highlighter",click:function(){n("code")}},form:{text:"Form",title:"Switch to form editor",click:function(){n("form")}},text:{text:"Text",title:"Switch to plain text editor",click:function(){n("text")}},tree:{text:"Tree",title:"Switch to tree editor",click:function(){n("tree")}},view:{text:"View",title:"Switch to tree view",click:function(){n("view")}}},s=[],a=0;a<t.length;a++){var l=t[a],c=r[l];if(!c)throw new Error('Unknown mode "'+l+'"');c.className="jsoneditor-type-modes"+(i==l?" jsoneditor-selected":""),s.push(c)}var d=r[i];if(!d)throw new Error('Unknown mode "'+i+'"');var h=d.text,u=document.createElement("button");u.type="button",u.className="jsoneditor-modes jsoneditor-separator",u.innerHTML=h+" &#x25BE;",u.title="Switch editor mode",u.onclick=function(){new o(s).show(u)};var p=document.createElement("div");p.className="jsoneditor-modes",p.style.position="relative",p.appendChild(u),e.appendChild(p),this.dom={container:e,box:u,frame:p}}var o=i(7);n.prototype.focus=function(){this.dom.box.focus()},n.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=n},function(e,t,i){"use strict";var n=i(13),o=i(11),r=i(4),s={};s.create=function(e,t){t=t||{},this.options=t,t.indentation?this.indentation=Number(t.indentation):this.indentation=2;var s=t.ace?t.ace:n;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||"ace/theme/jsoneditor","ace/theme/jsoneditor"===this.theme&&s)try{i(17)}catch(e){console.error(e)}var a=this;this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this._debouncedValidate=r.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var l=document.createElement("button");l.type="button",l.className="jsoneditor-format",l.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(l),l.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}};var c=document.createElement("button");c.type="button",c.className="jsoneditor-compact",c.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(c),c.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new o(this.menu,this.options.modes,this.options.mode,function(e){a.setMode(e),a.modeSwitcher.focus()}));var d={},h=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable(d);if(this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"==this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var u=s.edit(this.editorDom);u.$blockScrolling=1/0,u.setTheme(this.theme),u.setOptions({readOnly:h}),u.setShowPrintMargin(!1),u.setFontSize(13),u.getSession().setMode("ace/mode/json"),u.getSession().setTabSize(this.indentation),u.getSession().setUseSoftTabs(!0),u.getSession().setUseWrapMode(!0),u.commands.bindKey("Ctrl-L",null),u.commands.bindKey("Command-L",null),this.aceEditor=u,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),a.aceEditor=e}});var p=document.createElement("a");p.appendChild(document.createTextNode("powered by ace")),p.href="http://ace.ajax.org",p.target="_blank",p.className="jsoneditor-poweredBy",p.onclick=function(){window.open(p.href,p.target)},this.menu.appendChild(p),u.on("change",this._onChange.bind(this))}else{var f=document.createElement("textarea");f.className="jsoneditor-text",f.spellcheck=!1,this.content.appendChild(f),this.textarea=f,this.textarea.readOnly=h,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this)}this.setSchema(this.options.schema)},s._onChange=function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}},s._onKeyDown=function(e){var t=e.which||e.keyCode,i=!1;220==t&&e.ctrlKey&&(e.shiftKey?(this.compact(),this._onChange()):(this.format(),this._onChange()),i=!0),i&&(e.preventDefault(),e.stopPropagation())},s.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode==this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},s.compact=function(){var e=this.get(),t=JSON.stringify(e);this.setText(t)},s.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this.setText(t)},s.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},s.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},s.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},s.get=function(){var e,t=this.getText();try{e=r.parse(t)}catch(i){t=r.sanitize(t),e=r.parse(t)}return e},s.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},s.setText=function(e){var t;if(t=!0===this.options.escapeUnicode?r.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=t),this.aceEditor){var i=this.options.onChange;this.options.onChange=null,this.aceEditor.setValue(t,-1),this.options.onChange=i}this.validate()},s.validate=function(){this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.content.style.marginBottom="",this.content.style.paddingBottom="");var e,t=!1,i=[];try{e=this.get(),t=!0}catch(e){}if(t&&this.validateSchema){this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return r.improveSchemaError(e)}))}if(i.length>0){if(i.length>3){i=i.slice(0,3);var n=this.validateSchema.errors.length-3;i.push("("+n+" more errors...)")}var o=document.createElement("div");o.innerHTML='<table class="jsoneditor-text-errors"><tbody>'+i.map(function(e){return'<tr><td><button class="jsoneditor-schema-error"></button></td>'+("string"==typeof e?'<td colspan="2"><pre>'+e+"</pre></td>":"<td>"+e.dataPath+"</td><td>"+e.message+"</td>")+"</tr>"}).join("")+"</tbody></table>",this.dom.validationErrors=o,this.frame.appendChild(o);var s=o.clientHeight;this.content.style.marginBottom=-s+"px",this.content.style.paddingBottom=s+"px"}if(this.aceEditor){this.aceEditor.resize(!1)}},e.exports=[{mode:"text",mixin:s,data:"text",load:s.format},{mode:"code",mixin:s,data:"text",load:s.format}]},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(!function(){var e=new Error('Cannot find module "brace"');throw e.code="MODULE_NOT_FOUND",e}()),i(14),i(16)}catch(e){}e.exports=n},function(e,t,i){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";var n=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules,r=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"invalid.illegal",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"invalid.illegal",regex:"\\/\\/.*$"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'[^"\\\\]+'},{token:"string",regex:'"',next:"start"},{token:"string",regex:"",next:"start"}]}};n.inherits(r,o),t.JsonHighlightRules=r}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range,o=function(){};(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t),o=i.match(/^(\s*\})/);if(!o)return 0;var r=o[1].length,s=e.findMatchingBracket({row:t,column:r});if(!s||s.row==t)return 0;var a=this.$getIndent(e.getLine(s.row));e.replace(new n(t,0,t,r-1),a)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(o.prototype),t.MatchingBraceOutdent=o}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),o=e("../../range").Range,r=e("./fold_mode").FoldMode,s=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(s,r),function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var o=this._getFoldWidgetBase(e,t,i);return!o&&this.startRegionRe.test(n)?"start":o},this.getFoldWidgetRange=function(e,t,i,n){var o=e.getLine(i);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,i);var r=o.match(this.foldingStartMarker);if(r){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],i,s);var a=e.getCommentFoldRange(i,s+r[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t){var r=o.match(this.foldingStopMarker);if(r){var s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],i,s):e.getCommentFoldRange(i,s,-1)}}},this.getSectionRange=function(e,t){var i=e.getLine(t),n=i.search(/\S/),r=t,s=i.length;t+=1;for(var a=t,l=e.getLength();++t<l;){i=e.getLine(t);var c=i.search(/\S/);if(-1!==c){if(n>c)break;var d=this.getFoldWidgetRange(e,"all",t);if(d){if(d.start.row<=r)break;if(d.isMultiLine())t=d.end.row;else if(n==c)break}a=t}}return new o(r,s,a,e.getLine(a).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),s=i,a=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,l=1;++i<r;){t=e.getLine(i);var c=a.exec(t);if(c&&(c[1]?l--:l++,!l))break}var d=i;if(d>s)return new o(s,n,d,t.length)}}.call(s.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,n){"use strict";var o=e("../lib/oop"),r=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,d=e("../worker/worker_client").WorkerClient,h=function(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c};o.inherits(h,r),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);if("start"==e){t.match(/^.*[\{\(\[]\s*$/)&&(n+=i)}return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(e){var t=new d(["ace"],i(15),"JsonWorker");return t.attachToDocument(e.getDocument()),t.on("annotate",function(t){e.setAnnotations(t.data)}),t.on("terminate",function(){e.clearAnnotations()}),t},this.$id="ace/mode/json"}.call(h.prototype),t.Mode=h})},function(e,t){e.exports.id="ace/mode/json_worker",
e.exports.src='"no use strict";(function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}})(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var n=e("../lib/dom"),o=e("../lib/lang"),r=e("../lib/event"),s=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");n.importCssString("\t.ace_search {\tbackground-color: #ddd;\tborder: 1px solid #cbcbcb;\tborder-top: 0 none;\tmax-width: 325px;\toverflow: hidden;\tmargin: 0;\tpadding: 4px;\tpadding-right: 6px;\tpadding-bottom: 0;\tposition: absolute;\ttop: 0px;\tz-index: 99;\twhite-space: normal;\t}\t.ace_search.left {\tborder-left: 0 none;\tborder-radius: 0px 0px 5px 0px;\tleft: 0;\t}\t.ace_search.right {\tborder-radius: 0px 0px 0px 5px;\tborder-right: 0 none;\tright: 0;\t}\t.ace_search_form, .ace_replace_form {\tborder-radius: 3px;\tborder: 1px solid #cbcbcb;\tfloat: left;\tmargin-bottom: 4px;\toverflow: hidden;\t}\t.ace_search_form.ace_nomatch {\toutline: 1px solid red;\t}\t.ace_search_field {\tbackground-color: white;\tcolor: black;\tborder-right: 1px solid #cbcbcb;\tborder: 0 none;\t-webkit-box-sizing: border-box;\t-moz-box-sizing: border-box;\tbox-sizing: border-box;\tfloat: left;\theight: 22px;\toutline: 0;\tpadding: 0 7px;\twidth: 214px;\tmargin: 0;\t}\t.ace_searchbtn,\t.ace_replacebtn {\tbackground: #fff;\tborder: 0 none;\tborder-left: 1px solid #dcdcdc;\tcursor: pointer;\tfloat: left;\theight: 22px;\tmargin: 0;\tposition: relative;\t}\t.ace_searchbtn:last-child,\t.ace_replacebtn:last-child {\tborder-top-right-radius: 3px;\tborder-bottom-right-radius: 3px;\t}\t.ace_searchbtn:disabled {\tbackground: none;\tcursor: default;\t}\t.ace_searchbtn {\tbackground-position: 50% 50%;\tbackground-repeat: no-repeat;\twidth: 27px;\t}\t.ace_searchbtn.prev {\tbackground-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAFCAYAAAB4ka1VAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADFJREFUeNpiSU1NZUAC/6E0I0yACYskCpsJiySKIiY0SUZk40FyTEgCjGgKwTRAgAEAQJUIPCE+qfkAAAAASUVORK5CYII=);    \t}\t.ace_searchbtn.next {\tbackground-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAFCAYAAAB4ka1VAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADRJREFUeNpiTE1NZQCC/0DMyIAKwGJMUAYDEo3M/s+EpvM/mkKwCQxYjIeLMaELoLMBAgwAU7UJObTKsvAAAAAASUVORK5CYII=);    \t}\t.ace_searchbtn_close {\tbackground: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;\tborder-radius: 50%;\tborder: 0 none;\tcolor: #656565;\tcursor: pointer;\tfloat: right;\tfont: 16px/16px Arial;\theight: 14px;\tmargin: 5px 1px 9px 5px;\tpadding: 0;\ttext-align: center;\twidth: 14px;\t}\t.ace_searchbtn_close:hover {\tbackground-color: #656565;\tbackground-position: 50% 100%;\tcolor: white;\t}\t.ace_replacebtn.prev {\twidth: 54px\t}\t.ace_replacebtn.next {\twidth: 27px\t}\t.ace_button {\tmargin-left: 2px;\tcursor: pointer;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\toverflow: hidden;\topacity: 0.7;\tborder: 1px solid rgba(100,100,100,0.23);\tpadding: 1px;\t-moz-box-sizing: border-box;\tbox-sizing:    border-box;\tcolor: black;\t}\t.ace_button:hover {\tbackground-color: #eee;\topacity:1;\t}\t.ace_button:active {\tbackground-color: #ddd;\t}\t.ace_button.checked {\tborder-color: #3399ff;\topacity:1;\t}\t.ace_search_options{\tmargin-bottom: 3px;\ttext-align: right;\t-webkit-user-select: none;\t-moz-user-select: none;\t-o-user-select: none;\t-ms-user-select: none;\tuser-select: none;\t}","ace_searchbox");var l='<div class="ace_search right">\t    <button type="button" action="hide" class="ace_searchbtn_close"></button>\t    <div class="ace_search_form">\t        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>\t        <button type="button" action="findNext" class="ace_searchbtn next"></button>\t        <button type="button" action="findPrev" class="ace_searchbtn prev"></button>\t        <button type="button" action="findAll" class="ace_searchbtn" title="Alt-Enter">All</button>\t    </div>\t    <div class="ace_replace_form">\t        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>\t        <button type="button" action="replaceAndFindNext" class="ace_replacebtn">Replace</button>\t        <button type="button" action="replaceAll" class="ace_replacebtn">All</button>\t    </div>\t    <div class="ace_search_options">\t        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>\t        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>\t        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>\t    </div>\t</div>'.replace(/>\s+/g,">"),c=function(e,t,i){var o=n.createElement("div");o.innerHTML=l,this.element=o.firstChild,this.$init(),this.setEditor(e)};(function(){this.setEditor=function(e){e.searchBox=this,e.container.appendChild(this.element),this.editor=e},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOptions=e.querySelector(".ace_search_options"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field")},this.$init=function(){var e=this.element;this.$initElements(e);var t=this;r.addListener(e,"mousedown",function(e){setTimeout(function(){t.activeInput.focus()},0),r.stopPropagation(e)}),r.addListener(e,"click",function(e){var i=e.target||e.srcElement,n=i.getAttribute("action");n&&t[n]?t[n]():t.$searchBarKb.commands[n]&&t.$searchBarKb.commands[n].exec(t),r.stopPropagation(e)}),r.addCommandKeyListener(e,function(e,i,n){var o=a.keyCodeToString(n),s=t.$searchBarKb.findKeyCommand(i,o);s&&s.exec&&(s.exec(t),r.stopEvent(e))}),this.$onChange=o.delayedCall(function(){t.find(!1,!1)}),r.addListener(this.searchInput,"input",function(){t.$onChange.schedule(20)}),r.addListener(this.searchInput,"focus",function(){t.activeInput=t.searchInput,t.searchInput.value&&t.highlight()}),r.addListener(this.replaceInput,"focus",function(){t.activeInput=t.replaceInput,t.searchInput.value&&t.highlight()})},this.$closeSearchBarKb=new s([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new s,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceBox.style.display="",e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}}]),this.$syncOptions=function(){n.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),n.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),n.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.find(!1,!1)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var o=this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i}),r=!o&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",r),this.editor._emit("findSearchBox",{match:!r}),this.highlight()},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked}),t=!e&&this.searchInput.value;n.setCssClass(this.searchBox,"ace_nomatch",t),this.editor._emit("findSearchBox",{match:!t}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.element.style.display="",this.replaceBox.style.display=t?"":"none",this.isReplace=t,e&&(this.searchInput.value=e),this.find(!1,!1,!0),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(c.prototype),t.SearchBox=c,t.Search=function(e,t){(e.searchBox||new c(e)).show(e.session.getTextRange(),t)}}),function(){ace.acequire(["ace/ext/searchbox"],function(){})}()},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\tbackground: #ebebeb;\tcolor: #333\t}\t\t.ace-jsoneditor.ace_editor {\tfont-family: droid sans mono, consolas, monospace, courier new, courier, sans-serif;\tline-height: 1.3;\tbackground-color: #fff;\t}\t.ace-jsoneditor .ace_print-margin {\twidth: 1px;\tbackground: #e8e8e8\t}\t.ace-jsoneditor .ace_scroller {\tbackground-color: #FFFFFF\t}\t.ace-jsoneditor .ace_text-layer {\tcolor: gray\t}\t.ace-jsoneditor .ace_variable {\tcolor: #1a1a1a\t}\t.ace-jsoneditor .ace_cursor {\tborder-left: 2px solid #000000\t}\t.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\tborder-left: 0px;\tborder-bottom: 1px solid #000000\t}\t.ace-jsoneditor .ace_marker-layer .ace_selection {\tbackground: lightgray\t}\t.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\tbox-shadow: 0 0 3px 0px #FFFFFF;\tborder-radius: 2px\t}\t.ace-jsoneditor .ace_marker-layer .ace_step {\tbackground: rgb(255, 255, 0)\t}\t.ace-jsoneditor .ace_marker-layer .ace_bracket {\tmargin: -1px 0 0 -1px;\tborder: 1px solid #BFBFBF\t}\t.ace-jsoneditor .ace_marker-layer .ace_active-line {\tbackground: #FFFBD1\t}\t.ace-jsoneditor .ace_gutter-active-line {\tbackground-color : #dcdcdc\t}\t.ace-jsoneditor .ace_marker-layer .ace_selected-word {\tborder: 1px solid lightgray\t}\t.ace-jsoneditor .ace_invisible {\tcolor: #BFBFBF\t}\t.ace-jsoneditor .ace_keyword,\t.ace-jsoneditor .ace_meta,\t.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\tcolor: #AF956F\t}\t.ace-jsoneditor .ace_keyword.ace_operator {\tcolor: #484848\t}\t.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\tcolor: #96DC5F\t}\t.ace-jsoneditor .ace_constant.ace_language {\tcolor: darkorange\t}\t.ace-jsoneditor .ace_constant.ace_numeric {\tcolor: red\t}\t.ace-jsoneditor .ace_constant.ace_character.ace_entity {\tcolor: #BF78CC\t}\t.ace-jsoneditor .ace_invalid {\tcolor: #FFFFFF;\tbackground-color: #FF002A;\t}\t.ace-jsoneditor .ace_fold {\tbackground-color: #AF956F;\tborder-color: #000000\t}\t.ace-jsoneditor .ace_storage,\t.ace-jsoneditor .ace_support.ace_class,\t.ace-jsoneditor .ace_support.ace_function,\t.ace-jsoneditor .ace_support.ace_other,\t.ace-jsoneditor .ace_support.ace_type {\tcolor: #C52727\t}\t.ace-jsoneditor .ace_string {\tcolor: green\t}\t.ace-jsoneditor .ace_comment {\tcolor: #BCC8BA\t}\t.ace-jsoneditor .ace_entity.ace_name.ace_tag,\t.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\tcolor: #606060\t}\t.ace-jsoneditor .ace_markup.ace_underline {\ttext-decoration: underline\t}\t.ace-jsoneditor .ace_indent-guide {\tbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\t}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})}])});
//# sourceMappingURL=jsoneditor-minimalist.map