<!-- Generated with Stardoc: http://skydoc.bazel.build -->

Runs a binary as a build action. This rule does not require Bash (unlike native.genrule()).

This fork of bazel-skylib's run_binary adds directory output support and better makevar expansions.

<a id="run_binary"></a>

## run_binary

<pre>
load("@aspect_bazel_lib//lib:run_binary.bzl", "run_binary")

run_binary(<a href="#run_binary-name">name</a>, <a href="#run_binary-tool">tool</a>, <a href="#run_binary-srcs">srcs</a>, <a href="#run_binary-args">args</a>, <a href="#run_binary-env">env</a>, <a href="#run_binary-outs">outs</a>, <a href="#run_binary-out_dirs">out_dirs</a>, <a href="#run_binary-mnemonic">mnemonic</a>, <a href="#run_binary-progress_message">progress_message</a>,
           <a href="#run_binary-execution_requirements">execution_requirements</a>, <a href="#run_binary-use_default_shell_env">use_default_shell_env</a>, <a href="#run_binary-stamp">stamp</a>, <a href="#run_binary-kwargs">**kwargs</a>)
</pre>

Runs a binary as a build action.

This rule does not require Bash (unlike `native.genrule`).


**PARAMETERS**


| Name  | Description | Default Value |
| :------------- | :------------- | :------------- |
| <a id="run_binary-name"></a>name |  The target name   |  none |
| <a id="run_binary-tool"></a>tool |  The tool to run in the action.<br><br>Must be the label of a *_binary rule of a rule that generates an executable file, or of a file that can be executed as a subprocess (e.g. an .exe or .bat file on Windows or a binary with executable permission on Linux). This label is available for `$(location)` expansion in `args` and `env`.   |  none |
| <a id="run_binary-srcs"></a>srcs |  Additional inputs of the action.<br><br>These labels are available for `$(location)` expansion in `args` and `env`.   |  `[]` |
| <a id="run_binary-args"></a>args |  Command line arguments of the binary.<br><br>Subject to `$(location)` and make variable expansions via [expand_location](./expand_make_vars#expand_locations) and [expand_make_vars](./expand_make_vars).   |  `[]` |
| <a id="run_binary-env"></a>env |  Environment variables of the action.<br><br>Subject to `$(location)` and make variable expansions via [expand_location](./expand_make_vars#expand_locations) and [expand_make_vars](./expand_make_vars).   |  `{}` |
| <a id="run_binary-outs"></a>outs |  Output files generated by the action.<br><br>These labels are available for `$(location)` expansion in `args` and `env`.<br><br>Output files cannot be nested within output directories in out_dirs.   |  `[]` |
| <a id="run_binary-out_dirs"></a>out_dirs |  Output directories generated by the action.<br><br>These labels are _not_ available for `$(location)` expansion in `args` and `env` since they are not pre-declared labels created via `attr.output_list()`. Output directories are declared instead by `ctx.actions.declare_directory`.<br><br>Output directories cannot be nested within other output directories in out_dirs.   |  `[]` |
| <a id="run_binary-mnemonic"></a>mnemonic |  A one-word description of the action, for example, CppCompile or GoLink.   |  `"RunBinary"` |
| <a id="run_binary-progress_message"></a>progress_message |  Progress message to show to the user during the build, for example, "Compiling foo.cc to create foo.o". The message may contain %{label}, %{input}, or %{output} patterns, which are substituted with label string, first input, or output's path, respectively. Prefer to use patterns instead of static strings, because the former are more efficient.   |  `None` |
| <a id="run_binary-execution_requirements"></a>execution_requirements |  Information for scheduling the action.<br><br>For example,<br><br><pre><code>execution_requirements = {&#10;    "no-cache": "1",&#10;},</code></pre><br><br>See https://docs.bazel.build/versions/main/be/common-definitions.html#common.tags for useful keys.   |  `None` |
| <a id="run_binary-use_default_shell_env"></a>use_default_shell_env |  Passed to the underlying ctx.actions.run.<br><br>May introduce non-determinism when True; use with care! See e.g. https://github.com/bazelbuild/bazel/issues/4912<br><br>Refer to https://bazel.build/rules/lib/builtins/actions#run for more details.   |  `False` |
| <a id="run_binary-stamp"></a>stamp |  Whether to include build status files as inputs to the tool. Possible values:<br><br>- `stamp = 0` (default): Never include build status files as inputs to the tool.     This gives good build result caching.     Most tools don't use the status files, so including them in `--stamp` builds makes those     builds have many needless cache misses.     (Note: this default is different from most rules with an integer-typed `stamp` attribute.) - `stamp = 1`: Always include build status files as inputs to the tool, even in     [--nostamp](https://docs.bazel.build/versions/main/user-manual.html#flag--stamp) builds.     This setting should be avoided, since it is non-deterministic.     It potentially causes remote cache misses for the target and     any downstream actions that depend on the result. - `stamp = -1`: Inclusion of build status files as inputs is controlled by the     [--[no]stamp](https://docs.bazel.build/versions/main/user-manual.html#flag--stamp) flag.     Stamped targets are not rebuilt unless their dependencies change.<br><br>When stamping is enabled, an additional two environment variables will be set for the action:     - `BAZEL_STABLE_STATUS_FILE`     - `BAZEL_VOLATILE_STATUS_FILE`<br><br>These files can be read and parsed by the action, for example to pass some values to a linker.   |  `0` |
| <a id="run_binary-kwargs"></a>kwargs |  Additional arguments   |  none |


