#!/usr/bin/env bash
# Copies release files from bazel-out to a common folder so the GitHub Actions
# configuration can easily find them all

# --- begin runfiles.bash initialization v3 ---
# Copy-pasted from the Bazel Bash runfiles library v3.
set -uo pipefail
set +e
f=bazel_tools/tools/bash/runfiles/runfiles.bash
source "${RUNFILES_DIR:-/dev/null}/$f" 2>/dev/null ||
  source "$(grep -sm1 "^$f " "${RUNFILES_MANIFEST_FILE:-/dev/null}" | cut -f2- -d' ')" 2>/dev/null ||
  source "$0.runfiles/$f" 2>/dev/null ||
  source "$(grep -sm1 "^$f " "$0.runfiles_manifest" | cut -f2- -d' ')" 2>/dev/null ||
  source "$(grep -sm1 "^$f " "$0.exe.runfiles_manifest" | cut -f2- -d' ')" 2>/dev/null ||
  {
    echo >&2 "ERROR: cannot find $f"
    exit 1
  }
f=
set -e
# --- end runfiles.bash initialization v3 ---

if [[ -z "${DEST:-}" ]]; then
  echo >&2 "ERROR: specify DEST environment variable"
  exit 1
fi

cd "$BUILD_WORKSPACE_DIRECTORY"
for arg in "$@"; do
  cp -pv "$(rlocation "$arg")" "$DEST"
done
