"Setup for docker testing"

def _impl_configure_docker(rctx):
    # See if docker_host is set
    has_docker = "DOCKER_HOST" in rctx.os.environ

    # See if standard docker sock exists
    if not has_docker:
        r = rctx.execute(["stat", "/var/run/docker.sock"])
        if r.return_code == 0:
            has_docker = True

    compatible_with = "[]" if has_docker else '["@platforms//:incompatible"]'

    rctx.file("defs.bzl", """
# Generated by configure_docker.bzl
TARGET_COMPATIBLE_WITH = %s
""" % compatible_with)
    rctx.file("BUILD.bazel", 'exports_files(["defs.bzl"])')
    pass

configure_docker = repository_rule(
    implementation = _impl_configure_docker,
)
