package org.yamcs.mdb;

/**
 * Groups all exceptions generated by the spreadsheet loader. Contextual
 * information is added to the exception messages.
 */
public class SpreadsheetLoadException extends DatabaseLoadException {

    private static final long serialVersionUID = 6952149910662130046L;

    /**
     * For known likely exceptions linkable to the current context
     */
    public SpreadsheetLoadException(SpreadsheetLoadContext ctx, String msg) {
        super(ctx+": "+msg);
    }
    
    /**
     * For unexpected exceptions linkable to the current context. (provides the
     * advantage that at least it can be seen where the spreadsheetloader
     * stopped executing)
     */
    public SpreadsheetLoadException(SpreadsheetLoadContext ctx, Throwable t) {
        super(ctx+": Could not load spreadsheet: "+t, t);
    }
}
