/* Generated By:JavaCC: Do not edit this line. StreamSqlParser.java */
package org.yamcs.yarch.streamsql;

import java.util.List;
import java.util.ArrayList;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.yamcs.utils.parser.Token;
import org.yamcs.utils.parser.SimpleCharStream;
import org.yamcs.utils.parser.ParseException;

import org.yamcs.yarch.*;
import org.yamcs.yarch.streamsql.funct.*;
import org.yamcs.yarch.TableWriter.InsertMode;


public class StreamSqlParser implements StreamSqlParserConstants {
    private Object[] args = new Object[0];
    int argCount = 0;

    private String getNonEscapedString(String s) {
            return s.substring(1,s.length()-1).replace("''","'"); //remove the quote (') from beginning and from end and then replace double quote with single quote
    }

    protected boolean seeTYPE() {
        return "TYPE".equalsIgnoreCase(getToken(1).image);
    }

   public void setArgs(Object[] args) {
        this.args = args;
    }

    ArgumentExpression nextArg() throws StreamSqlException {
        if(argCount>=args.length) {
            throw new StreamSqlException(StreamSqlException.ErrCode.WRONG_ARG_COUNT);
        }
       ArgumentExpression expr = new ArgumentExpression(argCount, args[argCount++]);
       expr.setArgs(args);
       return expr;
    }

    String nextArgAsString() throws StreamSqlException {
            if(argCount>=args.length) {
            throw new StreamSqlException(StreamSqlException.ErrCode.WRONG_ARG_COUNT);
        }
        Object o = args[argCount++];
        if(o instanceof String) {
            return (String) o;
        } else {
            throw new StreamSqlException(StreamSqlException.ErrCode.BAD_ARG_TYPE, "Expected String, got "+o.getClass());
        }
    }
    DataType getBasicDataType(String type) throws ParseException {
        if("TIMESTAMP".equalsIgnoreCase(type)) {return DataType.TIMESTAMP;}
        if("PARAMETER_VALUE".equalsIgnoreCase(type)) {return DataType.PARAMETER_VALUE;}
        if("BINARY".equalsIgnoreCase(type))  {return DataType.BINARY;}
        if("HRES_TIMESTAMP".equalsIgnoreCase(type)) {return DataType.HRES_TIMESTAMP;}
        if("UUID".equalsIgnoreCase(type)) {return DataType.UUID;}

        throw new ParseException("Unknown data type '"+type+"'");
    }

  final public DataType DataTypeDefinition() throws ParseException {
    Token className;
    DataType dataType;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_INT:
      jj_consume_token(K_INT);
               dataType = DataType.INT;
      break;
    case K_LONG:
      jj_consume_token(K_LONG);
                 dataType = DataType.LONG;
      break;
    case K_BOOLEAN:
      jj_consume_token(K_BOOLEAN);
                    dataType = DataType.BOOLEAN;
      break;
    case K_BYTE:
      jj_consume_token(K_BYTE);
                 dataType = DataType.BYTE;
      break;
    case K_SHRT:
      jj_consume_token(K_SHRT);
                  dataType = DataType.SHORT;
      break;
    case K_DOUBLE:
      jj_consume_token(K_DOUBLE);
                   dataType = DataType.DOUBLE;
      break;
    case K_STRING:
      jj_consume_token(K_STRING);
                    dataType = DataType.STRING;
      break;
    case K_ENUM:
      jj_consume_token(K_ENUM);
                  dataType = DataType.ENUM;
      break;
    case K_PROTOBUF:
      jj_consume_token(K_PROTOBUF);
      jj_consume_token(131);
      className = jj_consume_token(S_STRING);
      jj_consume_token(132);
                                                     dataType =  DataType.protobuf(getNonEscapedString(className.image));
      break;
    case S_IDENTIFIER:
      jj_consume_token(S_IDENTIFIER);
                        dataType = getBasicDataType(token.image);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 133:
      jj_consume_token(133);
            dataType = DataType.array(dataType);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
     {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public StreamSqlStatement OneStatement() throws ParseException, StreamSqlException {
    StreamSqlStatement statement;
    statement = StreamSqlStatement();
    jj_consume_token(0);
        {if (true) return statement;}
    throw new Error("Missing return statement in function");
  }

  final public StreamSqlStatement StreamSqlStatement() throws ParseException, StreamSqlException {
                                                                    StreamSqlStatement statement;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 0:
      jj_consume_token(0);
           {if (true) return null;}
      break;
    case K_ALTER:
    case K_CLOSE:
    case K_CREATE:
    case K_DELETE:
    case K_DESCRIBE:
    case K_DROP:
    case K_INSERT:
    case K_INSERT_APPEND:
    case K_LOAD:
    case K_SELECT:
    case K_SHOW:
    case K_UPDATE:
    case K_UPSERT:
    case K_UPSERT_APPEND:
      if (jj_2_1(2)) {
        statement = CreateTableStatement();
      } else if (jj_2_2(2)) {
        statement = CreateStreamStatement();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_DELETE:
          statement = DeleteStatement();
          break;
        case K_INSERT:
        case K_INSERT_APPEND:
        case K_LOAD:
        case K_UPSERT:
        case K_UPSERT_APPEND:
          statement = InsertStatement();
          break;
        case K_SELECT:
          statement = SelectTableStatement();
          break;
        case K_UPDATE:
          statement = UpdateTableStatement();
          break;
        case K_CLOSE:
          statement = CloseStreamStatement();
          break;
        case K_DROP:
          statement = DropTableStatement();
          break;
        case K_DESCRIBE:
          statement = DescribeStatement();
          break;
        default:
          jj_la1[2] = jj_gen;
          if (jj_2_3(2)) {
            statement = ShowStreamsStatement();
          } else if (jj_2_4(2)) {
            statement = ShowStreamStatement();
          } else if (jj_2_5(2)) {
            statement = ShowTablesStatement();
          } else if (jj_2_6(2)) {
            statement = ShowEnginesStatement();
          } else if (jj_2_7(2)) {
            statement = ShowDatabasesStatement();
          } else if (jj_2_8(2)) {
            statement = ShowSequencesStatement();
          } else if (jj_2_9(2)) {
            statement = AlterSequenceStatement();
          } else if (jj_2_10(2)) {
            statement = AlterTableStatement();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
        {if (true) return statement;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public CreateInputStreamStatement CreateInputStreamStatement() throws ParseException, StreamSqlException {
    TupleDefinition tupleDefinition;
    String streamName;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_INPUT);
    jj_consume_token(K_STREAM);
    streamName = ObjectName();
    tupleDefinition = TupleDefinition();
        {if (true) return new CreateInputStreamStatement(streamName,tupleDefinition);}
    throw new Error("Missing return statement in function");
  }

  final public CreateTableStatement CreateTableStatement() throws ParseException, StreamSqlException {
    TupleDefinition tupleDefinition=new TupleDefinition();
    ArrayList<String> primaryKey=new ArrayList<String>();
    ArrayList<String> partitions=new ArrayList<String>();
        ArrayList<String> index=new ArrayList<String>();
    String tableName, pk, partitionColumn, indexColumn ;
    boolean ifNotExists=false;
    boolean autoincrement = false;

    TableColumnDefinition tcd;

    CreateTableStatement cts;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_IF:
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
                                                     ifNotExists=true;
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    tableName = ObjectName();
    jj_consume_token(131);
    label_1:
    while (true) {
      tcd = TableColumnDefinition();
      jj_consume_token(134);
                                            tupleDefinition.addColumn(tcd);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S_IDENTIFIER:
      case S_DOUBLE_QUOTED_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(K_PRIMARY);
    jj_consume_token(K_KEY);
    jj_consume_token(131);
    pk = ObjectName();
                                              primaryKey.add(pk);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_2;
      }
      jj_consume_token(134);
      pk = ObjectName();
                                                                                        primaryKey.add(pk);
    }
    jj_consume_token(132);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 134:
      jj_consume_token(134);
      jj_consume_token(K_INDEX);
      jj_consume_token(131);
      indexColumn = ObjectName();
                                                 index.add(indexColumn);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 134:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_3;
        }
        jj_consume_token(134);
        indexColumn = ObjectName();
                                                                                                        index.add(indexColumn);
      }
      jj_consume_token(132);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(132);
      cts=new CreateTableStatement(ifNotExists, tableName, tupleDefinition, primaryKey, index);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ENGINE:
      case K_HISTOGRAM:
      case K_PARTITION:
      case K_TABLE_FORMAT:
      case K_TABLESPACE:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      TableOption(cts);
    }
        {if (true) return cts;}
    throw new Error("Missing return statement in function");
  }

  final public TableColumnDefinition TableColumnDefinition() throws ParseException, StreamSqlException {
   TableColumnDefinition tcd;
   String columnName;
   DataType columnType;
    columnName = ObjectName();
    columnType = DataTypeDefinition();
                                                            tcd = new TableColumnDefinition(columnName,columnType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTO_INCREMENT:
      jj_consume_token(K_AUTO_INCREMENT);
                        tcd.setAutoIncrement(true);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
   {if (true) return tcd;}
    throw new Error("Missing return statement in function");
  }

  final public void TableOption(CreateTableStatement cts) throws ParseException, StreamSqlException {
   String columnName, tablespace, engine;
   PartitioningSpec pspec;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_HISTOGRAM:
      jj_consume_token(K_HISTOGRAM);
      jj_consume_token(131);
      columnName = ObjectName();
                                              cts.addHistogramColumn(columnName);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 134:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_5;
        }
        jj_consume_token(134);
        columnName = ObjectName();
                                                                                                                cts.addHistogramColumn(columnName);
      }
      jj_consume_token(132);
      break;
    case K_ENGINE:
      jj_consume_token(K_ENGINE);
      engine = ObjectName();
                                    cts.setEngine(engine);
      break;
    case K_PARTITION:
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      pspec = PartitioningSpec();
                                                   cts.setPartitioning(pspec);
      break;
    case K_TABLESPACE:
      jj_consume_token(K_TABLESPACE);
      tablespace = ObjectName();
                                           cts.setTablespace(tablespace);
      break;
    case K_TABLE_FORMAT:
      jj_consume_token(K_TABLE_FORMAT);
      jj_consume_token(135);
      jj_consume_token(K_COMPRESSED);
                                      cts.setCompressed(true);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public PartitioningSpec PartitioningSpec() throws ParseException, StreamSqlException {
    PartitioningSpec pspec;
    String cname1, cname2;
    Token timePartSchema = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_TIME:
      jj_consume_token(K_TIME);
      jj_consume_token(131);
      cname1 = ObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 131:
        jj_consume_token(131);
        timePartSchema = jj_consume_token(S_STRING);
        jj_consume_token(132);
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      jj_consume_token(132);
                                                                                  pspec = PartitioningSpec.timeSpec(cname1);
      break;
    case K_VALUE:
      jj_consume_token(K_VALUE);
      jj_consume_token(131);
      cname1 = ObjectName();
      jj_consume_token(132);
                                               pspec = PartitioningSpec.valueSpec(cname1);
      break;
    case K_TIME_AND_VALUE:
      jj_consume_token(K_TIME_AND_VALUE);
      jj_consume_token(131);
      cname1 = ObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 131:
        jj_consume_token(131);
        timePartSchema = jj_consume_token(S_STRING);
        jj_consume_token(132);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      jj_consume_token(134);
      cname2 = ObjectName();
      jj_consume_token(132);
                                                                                                                         pspec = PartitioningSpec.timeAndValueSpec(cname1, cname2);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       if(timePartSchema!=null) {
          try {
                 pspec.setTimePartitioningSchema(getNonEscapedString(timePartSchema.image));
           } catch (IllegalArgumentException e) {
               {if (true) throw new ParseException(e.getMessage());}
           }
       }
       {if (true) return pspec;}
    throw new Error("Missing return statement in function");
  }

  final public CreateStreamStatement CreateStreamStatement() throws ParseException, StreamSqlException {
    String name;
    StreamExpression expression;
    TupleDefinition tupleDefinition;
    boolean follow = true;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_STREAM);
    name = ObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AS:
      jj_consume_token(K_AS);
      expression = StreamExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NOFOLLOW:
        jj_consume_token(K_NOFOLLOW);
                                                           follow=false;
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
                if(expression instanceof SelectExpression) {
                        ((SelectExpression) expression).setFollow(follow);
                }
            {if (true) return new CreateStreamStatement(name, expression);}
      break;
    case 131:
      tupleDefinition = TupleDefinition();
            {if (true) return new CreateStreamStatement(name,tupleDefinition);}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SelectTableStatement SelectTableStatement() throws ParseException, StreamSqlException {
    String name;
    SelectExpression expression;
    expression = SelectExpression();
        {if (true) return new SelectTableStatement(expression);}
    throw new Error("Missing return statement in function");
  }

  final public CloseStreamStatement CloseStreamStatement() throws ParseException, StreamSqlException {
    String name;
    jj_consume_token(K_CLOSE);
    jj_consume_token(K_STREAM);
    name = ObjectName();
        {if (true) return new CloseStreamStatement(name);}
    throw new Error("Missing return statement in function");
  }

  final public DropTableStatement DropTableStatement() throws ParseException, StreamSqlException {
    boolean ifExists=false;
    String name;
    jj_consume_token(K_DROP);
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_IF:
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
                                           ifExists=true;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    name = ObjectName();
        {if (true) return new DropTableStatement(ifExists, name);}
    throw new Error("Missing return statement in function");
  }

  final public ShowStreamsStatement ShowStreamsStatement() throws ParseException, StreamSqlException {
    jj_consume_token(K_SHOW);
    jj_consume_token(K_STREAMS);
        {if (true) return new ShowStreamsStatement();}
    throw new Error("Missing return statement in function");
  }

  final public ShowTablesStatement ShowTablesStatement() throws ParseException, StreamSqlException {
    jj_consume_token(K_SHOW);
    jj_consume_token(K_TABLES);
        {if (true) return new ShowTablesStatement();}
    throw new Error("Missing return statement in function");
  }

  final public ShowStreamStatement ShowStreamStatement() throws ParseException, StreamSqlException {
    String name;
    jj_consume_token(K_SHOW);
    jj_consume_token(K_STREAM);
    name = ObjectName();
        {if (true) return new ShowStreamStatement(name);}
    throw new Error("Missing return statement in function");
  }

  final public ShowEnginesStatement ShowEnginesStatement() throws ParseException, StreamSqlException {
    jj_consume_token(K_SHOW);
    jj_consume_token(K_ENGINES);
        {if (true) return new ShowEnginesStatement();}
    throw new Error("Missing return statement in function");
  }

  final public ShowDatabasesStatement ShowDatabasesStatement() throws ParseException, StreamSqlException {
    jj_consume_token(K_SHOW);
    jj_consume_token(K_DATABASES);
        {if (true) return new ShowDatabasesStatement();}
    throw new Error("Missing return statement in function");
  }

  final public ShowSequencesStatement ShowSequencesStatement() throws ParseException, StreamSqlException {
    jj_consume_token(K_SHOW);
    jj_consume_token(K_SEQUENCES);
        {if (true) return new ShowSequencesStatement();}
    throw new Error("Missing return statement in function");
  }

  final public DescribeStatement DescribeStatement() throws ParseException, StreamSqlException {
    String name;
    jj_consume_token(K_DESCRIBE);
    name = ObjectName();
        {if (true) return new DescribeStatement(name);}
    throw new Error("Missing return statement in function");
  }

  final public AlterSequenceStatement AlterSequenceStatement() throws ParseException, StreamSqlException {
    String name;
    BigDecimal n = new BigDecimal(0);
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SEQUENCE);
    name = ObjectName();
    jj_consume_token(K_RESTART);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_WITH:
      jj_consume_token(K_WITH);
      n = NumericConstant();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
        {if (true) return new AlterSequenceStatement(name, n.longValue());}
    throw new Error("Missing return statement in function");
  }

  final public AlterTableStatement AlterTableStatement() throws ParseException, StreamSqlException {
    String name, newName;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    name = ObjectName();
    jj_consume_token(K_RENAME);
    jj_consume_token(K_TO);
    newName = ObjectName();
        {if (true) return new AlterTableStatement(name, newName);}
    throw new Error("Missing return statement in function");
  }

  final public StreamExpression StreamExpression() throws ParseException, StreamSqlException {
    StreamExpression expression;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_SELECT:
      expression = SelectExpression();
      break;
    case K_MERGE:
      expression = MergeExpression();
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public void IntoClause() throws ParseException, StreamSqlException {
    jj_consume_token(K_INTO);
    ObjectName();
  }

  final public InsertStatement InsertStatement() throws ParseException, StreamSqlException {
    String name;
    StreamExpression expression;
    List<String> columns = new ArrayList();
    List<SelectItem> selectList;
    String cn;
    InsertMode insertMode;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_INSERT:
      jj_consume_token(K_INSERT);
                   insertMode = InsertMode.INSERT;
      break;
    case K_UPSERT:
      jj_consume_token(K_UPSERT);
                   insertMode = InsertMode.UPSERT;
      break;
    case K_INSERT_APPEND:
      jj_consume_token(K_INSERT_APPEND);
                          insertMode = InsertMode.INSERT_APPEND;
      break;
    case K_UPSERT_APPEND:
      jj_consume_token(K_UPSERT_APPEND);
                          insertMode = InsertMode.UPSERT_APPEND;
      break;
    case K_LOAD:
      jj_consume_token(K_LOAD);
                 insertMode = InsertMode.LOAD;
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_INTO);
    name = ObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_MERGE:
    case K_SELECT:
      expression = StreamExpression();
             {if (true) return new InsertStatement(name, expression, insertMode);}
      break;
    case 131:
      jj_consume_token(131);
      cn = ObjectName();
                              columns.add(cn);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 134:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_6;
        }
        jj_consume_token(134);
        cn = ObjectName();
                                                                     columns.add(cn);
      }
      jj_consume_token(132);
      jj_consume_token(K_VALUES);
      jj_consume_token(131);
      selectList = SelectList();
      jj_consume_token(132);
            {if (true) return new InsertStatement(name, new InsertValuesExpression(columns, selectList), InsertMode.INSERT);}
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public MergeExpression MergeExpression() throws ParseException, StreamSqlException {
    MergeExpression mergeExpr=new MergeExpression();
    TupleSourceExpression tsrc;
    String name;
    boolean ascending = true;
    BigDecimal offset = null;
    BigDecimal limit = null;
    jj_consume_token(K_MERGE);
    tsrc = TupleSourceExpression();
                                     mergeExpr.addTupleSourceExpression(tsrc);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_7;
      }
      jj_consume_token(134);
      tsrc = TupleSourceExpression();
                                      mergeExpr.addTupleSourceExpression(tsrc);
    }
    jj_consume_token(K_USING);
    name = ObjectName();
                               mergeExpr.setMergeColumn(name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ORDER:
      ascending = OrderClause();
                               mergeExpr.setAscending(ascending);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_LIMIT:
      jj_consume_token(K_LIMIT);
      if (jj_2_11(2)) {
        offset = NumericConstant();
        jj_consume_token(134);
      } else {
        ;
      }
      limit = NumericConstant();
                                  mergeExpr.setLimit(offset, limit);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
        {if (true) return mergeExpr;}
    throw new Error("Missing return statement in function");
  }

  final public DeleteStatement DeleteStatement() throws ParseException, StreamSqlException {
    String tableName;
    Expression expression=null;
    BigDecimal limit = new BigDecimal(-1);
    jj_consume_token(K_DELETE);
    jj_consume_token(K_FROM);
    tableName = ObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_WHERE:
      jj_consume_token(K_WHERE);
      expression = Expression();
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_LIMIT:
      jj_consume_token(K_LIMIT);
      limit = NumericConstant();
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
        {if (true) return new DeleteStatement(tableName, expression, limit.longValue());}
    throw new Error("Missing return statement in function");
  }

  final public UpdateTableStatement UpdateTableStatement() throws ParseException, StreamSqlException {
    String tableName;
    String colName;
    Expression whereExpr = null;
    Expression colValue;
    List<UpdateTableStatement.UpdateItem> updateList = new ArrayList<UpdateTableStatement.UpdateItem>();
    BigDecimal limit = new BigDecimal(-1);
    jj_consume_token(K_UPDATE);
    tableName = ObjectName();
    jj_consume_token(K_SET);
    colName = ObjectName();
    jj_consume_token(135);
    colValue = SimpleExpression();
          updateList.add(new UpdateTableStatement.UpdateItem(colName, colValue));
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_8;
      }
      jj_consume_token(134);
      colName = ObjectName();
      jj_consume_token(135);
      colValue = SimpleExpression();
          updateList.add(new UpdateTableStatement.UpdateItem(colName, colValue));
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_WHERE:
      jj_consume_token(K_WHERE);
      whereExpr = Expression();
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_LIMIT:
      jj_consume_token(K_LIMIT);
      limit = NumericConstant();
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
        {if (true) return new UpdateTableStatement(tableName, updateList, whereExpr, limit.longValue());}
    throw new Error("Missing return statement in function");
  }

// Expression and its children
  final public Expression Expression() throws ParseException, StreamSqlException {
    Expression expr;
    ArrayList<Expression> list = new ArrayList<Expression>();
    expr = AndExpression();
                               list.add(expr);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_OR:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_9;
      }
      jj_consume_token(K_OR);
      expr = AndExpression();
                                    list.add(expr);
    }
        if(list.size() == 1) expr= list.get(0);
        else expr = new OrExpression(list);

        expr.setArgs(args);
        {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression AndExpression() throws ParseException, StreamSqlException {
    Expression expr;
    ArrayList<Expression> list=new ArrayList<Expression>();
    if (jj_2_12(3)) {
      expr = UnaryLogicalExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 131:
        jj_consume_token(131);
        expr = Expression();
        jj_consume_token(132);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
            list.add(expr);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AND:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_10;
      }
      jj_consume_token(K_AND);
      if (jj_2_13(3)) {
        expr = UnaryLogicalExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 131:
          jj_consume_token(131);
          expr = Expression();
          jj_consume_token(132);
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
                list.add(expr);
    }
        if(list.size()==1) {if (true) return list.get(0);}
        else {if (true) return new AndExpression(list);}
    throw new Error("Missing return statement in function");
  }

  final public Expression UnaryLogicalExpression() throws ParseException, StreamSqlException {
    boolean notset=false;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
            notset = true;
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    expr = RelationalExpression();
        if(notset) {if (true) return new NotExpression(expr);}
        else {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression RelationalExpression() throws ParseException, StreamSqlException {
    Expression retExpr, expr;
    RelOp relOp;
    List<Expression> list;
    LikeClause likeClause;
    InClause inClause;
    IsNullClause isNullClause;
    expr = SimpleExpression();
                               retExpr=expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_BETWEEN:
    case K_IN:
    case K_IS:
    case K_LIKE:
    case K_NOT:
    case 135:
    case 141:
    case 149:
    case 150:
    case 151:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 135:
      case 141:
      case 149:
      case 150:
      case 151:
        relOp = RelOp();
        expr = SimpleExpression();
                                               retExpr=new RelationalExpression(retExpr,expr,relOp);
        break;
      default:
        jj_la1[37] = jj_gen;
        if (jj_2_14(2)) {
          inClause = InClause();
                                        retExpr=new InExpression(expr, inClause);
        } else if (jj_2_15(2)) {
          BetweenClause();
        } else if (jj_2_16(2)) {
          likeClause = LikeClause();
                                               retExpr = new LikeExpression(expr, likeClause);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_IS:
            isNullClause = IsNullClause();
                                      retExpr = new IsNullExpression(expr, isNullClause);
            break;
          default:
            jj_la1[38] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
        {if (true) return retExpr;}
    throw new Error("Missing return statement in function");
  }

  final public List<Expression> ExpressionList() throws ParseException, StreamSqlException {
    List<Expression> list=new ArrayList<Expression>();
    Expression expr;
    expr = Expression();
                      list.add(expr);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_11;
      }
      jj_consume_token(134);
      expr = Expression();
                                                               list.add(expr);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public InClause InClause() throws ParseException, StreamSqlException {
    List<Expression> list;
    InClause inClause = new InClause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
            inClause.setNegation(true);
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(K_IN);
    jj_consume_token(131);
    list = ExpressionList();
    jj_consume_token(132);
                                       inClause.setList(list);
    {if (true) return inClause;}
    throw new Error("Missing return statement in function");
  }

  final public void BetweenClause() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    SimpleExpression();
    jj_consume_token(K_AND);
    SimpleExpression();
  }

  final public LikeClause LikeClause() throws ParseException, StreamSqlException {
  LikeClause likeClause = new LikeClause();
  String pattern;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
            likeClause.setNegation(true);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(K_LIKE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_STRING:
      jj_consume_token(S_STRING);
                        likeClause.setPattern(getNonEscapedString(token.image));
      break;
    case S_QMARK:
      jj_consume_token(S_QMARK);
                 likeClause.setPattern(nextArgAsString());
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return likeClause;}
    throw new Error("Missing return statement in function");
  }

  final public IsNullClause IsNullClause() throws ParseException, StreamSqlException {
        IsNullClause isNullClause = new IsNullClause();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
                 isNullClause.setNegation(true);
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
    {if (true) return isNullClause;}
    throw new Error("Missing return statement in function");
  }

  final public Expression SimpleExpression() throws ParseException, StreamSqlException {
    Expression expr;
    BitwiseOp bitwiseOp;
    List<Expression> exprs = new ArrayList<Expression>();
    List<BitwiseOp> ops = new ArrayList<BitwiseOp>();
    expr = AdditiveExpression();
                                 exprs.add(expr);
    label_12:
    while (true) {
      if (jj_2_17(2)) {
        ;
      } else {
        break label_12;
      }
      bitwiseOp = BitwiseOp();
      expr = AdditiveExpression();
                                                                        exprs.add(expr); ops.add(bitwiseOp);
    }
        if(ops.isEmpty()) {
             {if (true) return exprs.get(0);}
        } else {
             {if (true) return new BitwiseExpression(exprs, ops);}
        }
    throw new Error("Missing return statement in function");
  }

  final public Expression AdditiveExpression() throws ParseException, StreamSqlException {
    Expression expr;
    AddOp addOp;
    List<Expression>exprs = new ArrayList<Expression>();
    List<AddOp> ops = new ArrayList<AddOp>();
    expr = MultiplicativeExpression();
                                       exprs.add(expr);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 137:
      case 138:
      case 146:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_13;
      }
      addOp = AddOp();
      expr = MultiplicativeExpression();
                                                       exprs.add(expr); ops.add(addOp);
    }
        if(ops.isEmpty()) {
             {if (true) return exprs.get(0);}
        } else {
             {if (true) return new AdditiveExpression(exprs,ops);}
        }
    throw new Error("Missing return statement in function");
  }

  final public Expression MultiplicativeExpression() throws ParseException, StreamSqlException {
    Expression expr;
    MultOp multOp;
    List<Expression>exprs=new ArrayList<Expression>();
    List<MultOp> ops=new ArrayList<MultOp>();
    expr = ExponentExpression();
                               exprs.add(expr);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_MOD:
      case 147:
      case 148:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_14;
      }
      multOp = MultOp();
      expr = MultiplicativeExpression();
                                                                    exprs.add(expr); ops.add(multOp);
    }
        if(ops.isEmpty()) {
             {if (true) return exprs.get(0);}
        } else {
             {if (true) return new MultiplicativeExpression(exprs,ops);}
        }
    throw new Error("Missing return statement in function");
  }

  final public Expression ExponentExpression() throws ParseException, StreamSqlException {
    Expression retExpr,expr;
    expr = UnaryExpression();
                            retExpr=expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 136:
      jj_consume_token(136);
      expr = UnaryExpression();
                                   retExpr=new ExponentExpression(retExpr,expr);
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
        {if (true) return retExpr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression UnaryExpression() throws ParseException, StreamSqlException {
    Expression expr;
    boolean negative=false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 137:
    case 138:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 137:
        jj_consume_token(137);
        break;
      case 138:
        jj_consume_token(138);
                negative=true;
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    expr = PrimaryExpression();
            if(negative) {
            if(expr instanceof ValueExpression) {
                {if (true) return ((ValueExpression)expr).getNegative();}
            } else {
                {if (true) return new NegativeExpression(expr);}
            }
        } else {
            {if (true) return expr;}
        }
    throw new Error("Missing return statement in function");
  }

  final public Expression PrimaryExpression() throws ParseException, StreamSqlException {
    String name;
    Expression expr;
    List<Expression> exprList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_INTEGER:
      jj_consume_token(S_INTEGER);
         String s = token.image;
         BigInteger bi ;
         if(s.startsWith("0x") || s.startsWith("0X")) {
             bi = new BigInteger(s.substring(2), 16);
         } else {
             bi = new BigInteger(s);
         }
         if (bi.bitLength() < 32) {if (true) return new ValueExpression((Integer)bi.intValue());}
             if (bi.bitLength() < 64) {if (true) return new ValueExpression((Long)bi.longValue());}
         {if (true) throw new ParseException("number too big for an int or a long: "+bi);}
      break;
    case S_FLOAT:
      jj_consume_token(S_FLOAT);
               {if (true) return new ValueExpression(Double.valueOf(token.image));}
      break;
    case S_STRING:
      jj_consume_token(S_STRING);
                {if (true) return new ValueExpression(getNonEscapedString(token.image));}
      break;
    case S_QMARK:
      jj_consume_token(S_QMARK);
               {if (true) return nextArg();}
      break;
    default:
      jj_la1[51] = jj_gen;
      if (jj_2_18(3)) {
        jj_consume_token(131);
        expr = SimpleExpression();
        jj_consume_token(132);
                                                    {if (true) return expr;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_ARRAY:
          jj_consume_token(K_ARRAY);
          jj_consume_token(139);
          exprList = ExpressionList();
          jj_consume_token(140);
                                                 {if (true) return new ArrayExpression(exprList);}
          break;
        default:
          jj_la1[52] = jj_gen;
          if (jj_2_19(2147483647)) {
            expr = FunctionCall();
                                                     {if (true) return expr;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S_IDENTIFIER:
            case S_DOUBLE_QUOTED_IDENTIFIER:
              name = ObjectName();
                       {if (true) return new ColumnExpression(name);}
              break;
            default:
              jj_la1[53] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/* ---------------- General Productions --------------------- */
  final public String ObjectName() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
      jj_consume_token(S_IDENTIFIER);
                           {if (true) return token.image;}
      break;
    case S_DOUBLE_QUOTED_IDENTIFIER:
      jj_consume_token(S_DOUBLE_QUOTED_IDENTIFIER);
                                  String s1 = token.image; {if (true) return s1.substring(1, s1.length() - 1);}
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public BitwiseOp BitwiseOp() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 141:
      jj_consume_token(141);
         {if (true) return BitwiseOp.AND;}
      break;
    case 142:
      jj_consume_token(142);
         {if (true) return BitwiseOp.OR;}
      break;
    case 143:
      jj_consume_token(143);
         {if (true) return BitwiseOp.XOR;}
      break;
    case 144:
      jj_consume_token(144);
          {if (true) return BitwiseOp.LSHIFT;}
      break;
    case 145:
      jj_consume_token(145);
          {if (true) return BitwiseOp.RSHIFT;}
      break;
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AddOp AddOp() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 137:
      jj_consume_token(137);
         {if (true) return AddOp.PLUS;}
      break;
    case 138:
      jj_consume_token(138);
         {if (true) return AddOp.MINUS;}
      break;
    case 146:
      jj_consume_token(146);
          {if (true) return AddOp.STRING_PLUS;}
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public MultOp MultOp() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 147:
      jj_consume_token(147);
         {if (true) return MultOp.MULT;}
      break;
    case 148:
      jj_consume_token(148);
         {if (true) return MultOp.DIV;}
      break;
    case K_MOD:
      jj_consume_token(K_MOD);
           {if (true) return MultOp.MOD;}
      break;
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public RelOp RelOp() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 135:
      jj_consume_token(135);
         {if (true) return RelOp.EQUAL;}
      break;
    case 149:
      jj_consume_token(149);
      jj_consume_token(135);
             {if (true) return RelOp.NOT_EQUAL;}
      break;
    default:
      jj_la1[58] = jj_gen;
      if (jj_2_20(2)) {
        jj_consume_token(150);
        jj_consume_token(135);
                          {if (true) return RelOp.GREATER_OR_EQUAL;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 150:
          jj_consume_token(150);
         {if (true) return RelOp.GREATER;}
          break;
        default:
          jj_la1[59] = jj_gen;
          if (jj_2_21(2)) {
            jj_consume_token(151);
            jj_consume_token(150);
                          {if (true) return RelOp.NOT_EQUAL;}
          } else if (jj_2_22(2)) {
            jj_consume_token(151);
            jj_consume_token(135);
                          {if (true) return RelOp.LESS_OR_EQUAL;}
          } else if (jj_2_23(2)) {
            jj_consume_token(141);
            jj_consume_token(141);
                          {if (true) return RelOp.OVERLAP;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case 151:
              jj_consume_token(151);
         {if (true) return RelOp.LESS;}
              break;
            default:
              jj_la1[60] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void Arguments() throws ParseException, StreamSqlException {
    Argument();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_15;
      }
      jj_consume_token(134);
      Argument();
    }
  }

  final public void Argument() throws ParseException, StreamSqlException {
    if (jj_2_24(2)) {
      jj_consume_token(S_IDENTIFIER);
      jj_consume_token(152);
    } else {
      ;
    }
    Expression();
  }

/* --------------- General Productions ends here --------------- */

/* ----------- SQL productions start here ----------------- */
  final public SelectExpression SelectExpression() throws ParseException, StreamSqlException {
    SelectExpression expression;
    boolean ascending;
    BigDecimal offset = null;
    BigDecimal limit = null;
    expression = Select();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ORDER:
      ascending = OrderClause();
                                expression.setAscending(ascending);
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_LIMIT:
      jj_consume_token(K_LIMIT);
      if (jj_2_25(2)) {
        offset = NumericConstant();
        jj_consume_token(134);
      } else {
        ;
      }
      limit = NumericConstant();
                                  expression.setLimit(offset, limit);
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
        {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public SelectExpression Select() throws ParseException, StreamSqlException {
    List<SelectItem> selectList;
    TupleSourceExpression tsrc;
    Expression whereClause=null;
    SelectExpression selectExpr=new SelectExpression();
    WindowSpecification windowSpec;
    jj_consume_token(K_SELECT);
    selectList = SelectList();
                                        selectExpr.setSelectList(selectList);
    jj_consume_token(K_FROM);
    tsrc = TupleSourceExpression();
                                           selectExpr.setFirstSource(tsrc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 139:
      jj_consume_token(139);
      windowSpec = WindowSpecification();
                                            selectExpr.setWindow(windowSpec);
      jj_consume_token(140);
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_WHERE:
      jj_consume_token(K_WHERE);
      whereClause = Expression();
                                         selectExpr.setWhereClause(whereClause);
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
        {if (true) return selectExpr;}
    throw new Error("Missing return statement in function");
  }

/* Checks for whatever follows  SELECT */
  final public List<SelectItem> SelectList() throws ParseException, StreamSqlException {
    List<SelectItem> selectList = new ArrayList<SelectItem>();
    SelectItem selectItem;
    selectItem = SelectItem();
                            selectList.add(selectItem);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_16;
      }
      jj_consume_token(134);
      selectItem = SelectItem();
                                    selectList.add(selectItem);
    }
    {if (true) return selectList;}
    throw new Error("Missing return statement in function");
  }

  final public SelectItem SelectItem() throws ParseException, StreamSqlException {
    String name;
    Expression expr;
    SelectItem selectItem;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 147:
      jj_consume_token(147);
            {if (true) return SelectItem.STAR;}
      break;
    case K_ARRAY:
    case S_INTEGER:
    case S_FLOAT:
    case S_STRING:
    case S_IDENTIFIER:
    case S_DOUBLE_QUOTED_IDENTIFIER:
    case S_QMARK:
    case 131:
    case 137:
    case 138:
      expr = SimpleExpression();
                                selectItem=new SelectItem(expr);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AS:
      case S_IDENTIFIER:
      case S_DOUBLE_QUOTED_IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_AS:
          jj_consume_token(K_AS);
          break;
        default:
          jj_la1[67] = jj_gen;
          ;
        }
        name = ObjectName();
            selectItem.setAlias(name);
        break;
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      {if (true) return selectItem;}
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public WindowSpecification WindowSpecification() throws ParseException, StreamSqlException {
    String name,field;
    WindowSpecification wspec;
    BigDecimal size, advance;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
    case S_DOUBLE_QUOTED_IDENTIFIER:
      name = ObjectName();
                       wspec=new WindowSpecification(name);
      break;
    case K_SIZE:
      jj_consume_token(K_SIZE);
      size = NumericConstant();
      jj_consume_token(K_ADVANCE);
      advance = NumericConstant();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_TIME:
        jj_consume_token(K_TIME);
              wspec = new WindowSpecification(size,advance,WindowSpecification.Type.TIME);
        break;
      case K_TUPLES:
        jj_consume_token(K_TUPLES);
                wspec = new WindowSpecification(size,advance,WindowSpecification.Type.TUPLES);
        break;
      case K_ON:
        jj_consume_token(K_ON);
        field = ObjectName();
                        wspec = new WindowSpecification(size,advance,WindowSpecification.Type.FIELD,field);
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
   {if (true) return wspec;}
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TupleSourceExpression TupleSourceExpression() throws ParseException, StreamSqlException {
    TupleSourceExpression tsrc;
    StreamExpression expr;
    String name, histoColumn;
    BigDecimal mergeTime;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
    case S_DOUBLE_QUOTED_IDENTIFIER:
      name = ObjectName();
                        tsrc = new TupleSourceExpression(name);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_HISTOGRAM:
        jj_consume_token(K_HISTOGRAM);
        jj_consume_token(131);
        histoColumn = ObjectName();
                                                         tsrc.setHistogramColumn(histoColumn);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 134:
          jj_consume_token(134);
          mergeTime = NumericConstant();
                                                 tsrc.setHistogramMergeTime(mergeTime);
          break;
        default:
          jj_la1[72] = jj_gen;
          ;
        }
        jj_consume_token(132);
        break;
      default:
        jj_la1[73] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      if (jj_2_26(3)) {
        jj_consume_token(131);
        expr = StreamExpression();
        jj_consume_token(132);
                                                       tsrc=new TupleSourceExpression(expr);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return tsrc;}
    throw new Error("Missing return statement in function");
  }

  final public TupleDefinition TupleDefinition() throws ParseException, StreamSqlException {
    String columnName;
    TupleDefinition tupleDefinition=new TupleDefinition();
    DataType columnType;
    jj_consume_token(131);
    columnName = ObjectName();
    columnType = DataTypeDefinition();
                                                                 tupleDefinition.addColumn(columnName,columnType);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 134:
        ;
        break;
      default:
        jj_la1[75] = jj_gen;
        break label_17;
      }
      jj_consume_token(134);
      columnName = ObjectName();
      columnType = DataTypeDefinition();
                                                                  tupleDefinition.addColumn(columnName,columnType);
    }
    jj_consume_token(132);
        {if (true) return tupleDefinition;}
    throw new Error("Missing return statement in function");
  }

  final public boolean OrderClause() throws ParseException, StreamSqlException {
   boolean ascending=true;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ASC:
    case K_DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ASC:
        jj_consume_token(K_ASC);
        break;
      case K_DESC:
        jj_consume_token(K_DESC);
                     ascending=false;
        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    {if (true) return ascending;}
    throw new Error("Missing return statement in function");
  }

  final public Expression FunctionCall() throws ParseException, StreamSqlException {
   String name;
   List<Expression> args=null;
   boolean star=false;
    name = ObjectName();
    jj_consume_token(131);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ARRAY:
    case K_NOT:
    case S_INTEGER:
    case S_FLOAT:
    case S_STRING:
    case S_IDENTIFIER:
    case S_DOUBLE_QUOTED_IDENTIFIER:
    case S_QMARK:
    case 131:
    case 137:
    case 138:
    case 147:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ARRAY:
      case K_NOT:
      case S_INTEGER:
      case S_FLOAT:
      case S_STRING:
      case S_IDENTIFIER:
      case S_DOUBLE_QUOTED_IDENTIFIER:
      case S_QMARK:
      case 131:
      case 137:
      case 138:
        args = ExpressionList();
        break;
      case 147:
        jj_consume_token(147);
                   star=true;
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    jj_consume_token(132);
      {if (true) return FunctionExpressionFactory.get(name, args, star);}
    throw new Error("Missing return statement in function");
  }

  final public BigDecimal NumericConstant() throws ParseException, StreamSqlException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_INTEGER:
      jj_consume_token(S_INTEGER);
      break;
    case S_FLOAT:
      jj_consume_token(S_FLOAT);
      break;
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                            {if (true) return new BigDecimal(token.image);}
    throw new Error("Missing return statement in function");
  }

  final public void ID(String id) throws ParseException {
    jj_consume_token(S_IDENTIFIER);
        if (!token.image.matches("(?i)" + id)) {
            {if (true) throw new ParseException("Encountered " + token.image
                + " at line " + token.beginLine + ", column " + token.beginColumn + "."
                + "\u005cnWas expecting: " + id);}
        }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(151)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_scan_token(141)) return true;
    if (jj_scan_token(141)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_scan_token(151)) return true;
    if (jj_scan_token(135)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_scan_token(151)) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(131)) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(150)) return true;
    if (jj_scan_token(135)) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(149)) return true;
    if (jj_scan_token(135)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(135)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(K_MOD)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(148)) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(146)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(138)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(137)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(145)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(144)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_66()) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(143)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(142)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(141)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_35()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(S_DOUBLE_QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    return false;
  }

  private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_36()) return true;
    if (jj_scan_token(131)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_36()) return true;
    if (jj_scan_token(131)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) jj_scanpos = xsp;
    if (jj_scan_token(132)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(K_ARRAY)) return true;
    if (jj_scan_token(139)) return true;
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(131)) return true;
    if (jj_3R_35()) return true;
    if (jj_scan_token(132)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(S_QMARK)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_SEQUENCES)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(S_STRING)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(S_FLOAT)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(131)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_DATABASES)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(S_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_ENGINES)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_STREAM)) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(138)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_scan_token(131)) return true;
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_TABLES)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_STREAMS)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(136)) return true;
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_61()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_71()) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_55()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_62()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_63()) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_49()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_56()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_28()) return true;
    if (jj_scan_token(134)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_STREAM)) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_33()) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(K_SELECT)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(K_MERGE)) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_28()) return true;
    if (jj_scan_token(134)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(S_STRING)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(S_QMARK)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) jj_scanpos = xsp;
    if (jj_scan_token(K_LIKE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(152)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public StreamSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[81];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x50000,0x0,0x50100000,0x50900101,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x20002000,0x20002000,0x800,0x800,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x4080011,0x0,0x2060002,0x2060002,0x1000,0x0,0x0,0x0,0x0,0x804,0x0,0x0,0x804,0x0,0x0,0x0,0x40000000,0x0,0x1000,0x0,0x8000000,0x2060000,0x0,0x8000000,0x0,0x0,0x1000000,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x200000,0x20a02000,0x0,0x20000000,0x20000000,0x20000000,0x0,0x20000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x84000800,0x0,0x200000,0x2200000,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x40000000,0x0,0xe00,0xe00,0x0,0x40000000,0x0,0x0,0x0,0xa,0x0,0x0,0xa,0x0,0x0,0x4030,0x0,0x0,0x0,0x40000,0x0,0xc00,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x8480000,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x40000000,0x48480000,0x90,0x40000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x48480000,0x48480000,0x480000,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x20,0x0,0x0,0x0,0x2,0x40,0x40,0x40,0x0,0x0,0x40,0x0,0x8,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x40,0x8,0x40,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0xe02080,0x0,0xe02080,0x40,0x0,0x0,0x0,0x4,0x0,0x40600,0x180000,0x100,0x600,0x600,0x4,0x0,0x2,0x2,0x3e000,0x40600,0x180000,0x200080,0x400000,0x800000,0x40,0x0,0x0,0x800,0x0,0x40,0x0,0x2,0x8060e,0x0,0x2,0x40,0x0,0x2,0x40,0x0,0x0,0x8060e,0x8060e,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[26];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public StreamSqlParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public StreamSqlParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new StreamSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public StreamSqlParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new StreamSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public StreamSqlParser(StreamSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(StreamSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 81; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        exists = true;
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.add(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[153];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 81; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 153; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 26; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
