package org.yamcs.tctm.ccsds.error;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.yamcs.tctm.ccsds.AosFrameDecoderTest.intToByteArray;

import org.junit.jupiter.api.Test;
import org.yamcs.tctm.ccsds.error.BchCltuGenerator.BchEncoder;

public class BchCltuGeneratorTest {

    @Test
    public void testBch() {
        byte[][] msg = {
                { 0x22, (byte) 0xF6, 0x00, (byte) 0xFF, 0x00, 0x42, 0x1A, 0x12 },
                { (byte) 0x8C, (byte) 0xC0, 0x0E, 0x01, 0x0D, 0x19, 0x06, 0x5A },
                { 0x30, 0x1B, 0x00, 0x09, 0x00, (byte) 0x82, 0x00, (byte) 0x54 },
                { 0x10, (byte) 0xE4, (byte) 0xC1, 0x55, 0x55, 0x55, 0x55, 0x3E }
        };

        for (byte[] p : msg) {
            assertEquals(p[7], BchEncoder.encode(p));
        }
    }

    @Test
    public void testCltu1() {
        BchCltuGenerator g = new BchCltuGenerator();
        byte[] cltu = g.makeCltu(TC_FRAME_01, false);
        assertArrayEquals(CLTU_01, cltu);
    }

    @Test
    public void testCltu2() {
        BchCltuGenerator g = new BchCltuGenerator();
        byte[] cltu = g.makeCltu(TC_FRAME_02, false);
        assertArrayEquals(CLTU_02, cltu);
    }

    // Examples copied from SpacePyLibrary
    // https://github.com/Stefan-Korner/SpacePyLibrary/blob/master/UnitTest/testData.py

    static byte[] TC_FRAME_01 = intToByteArray(new int[] {
            0x22, 0xF6, 0x00, 0xFF, 0x00, 0x42, 0x1A, 0x8C,
            0xC0, 0x0E, 0x01, 0x0D, 0x19, 0x06, 0x02, 0x00,
            0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x04, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x05, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x06, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x08, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x09, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0B, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x10, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x12, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x13, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x14, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x15, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x16, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x17, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x18, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x19, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x1A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x1B, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x1C, 0xFF, 0x00, 0x00, 0x00, 0xAD, 0x1A });

    static byte[] CLTU_01 = intToByteArray(new int[] {
            0xEB, 0x90, 0x22, 0xF6, 0x00, 0xFF, 0x00, 0x42,
            0x1A, 0x12, 0x8C, 0xC0, 0x0E, 0x01, 0x0D, 0x19,
            0x06, 0x5A, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x8A, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF,
            0x00, 0xCC, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x01,
            0xFF, 0x28, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
            0x02, 0x5A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x92, 0x03, 0xFF, 0x00, 0x00, 0x00, 0x00,
            0x0F, 0xD6, 0x00, 0x04, 0xFF, 0x00, 0x00, 0x00,
            0x00, 0xD4, 0x0F, 0x00, 0x05, 0xFF, 0x00, 0x00,
            0x00, 0xA8, 0x00, 0x0F, 0x00, 0x06, 0xFF, 0x00,
            0x00, 0xC8, 0x00, 0x00, 0x0F, 0x00, 0x07, 0xFF,
            0x00, 0xCA, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x08,
            0xFF, 0x66, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
            0x09, 0xA8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x92, 0x0A, 0xFF, 0x00, 0x00, 0x00, 0x00,
            0x0F, 0xF4, 0x00, 0x0B, 0xFF, 0x00, 0x00, 0x00,
            0x00, 0x5A, 0x0F, 0x00, 0x0C, 0xFF, 0x00, 0x00,
            0x00, 0xB0, 0x00, 0x0F, 0x00, 0x0D, 0xFF, 0x00,
            0x00, 0xD8, 0x00, 0x00, 0x0F, 0x00, 0x0E, 0xFF,
            0x00, 0x96, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x0F,
            0xFF, 0xDA, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
            0x10, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x92, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00,
            0x0F, 0x92, 0x00, 0x12, 0xFF, 0x00, 0x00, 0x00,
            0x00, 0x2A, 0x0F, 0x00, 0x13, 0xFF, 0x00, 0x00,
            0x00, 0x24, 0x00, 0x0F, 0x00, 0x14, 0xFF, 0x00,
            0x00, 0x4A, 0x00, 0x00, 0x0F, 0x00, 0x15, 0xFF,
            0x00, 0x72, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x16,
            0xFF, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
            0x17, 0x20, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x92, 0x18, 0xFF, 0x00, 0x00, 0x00, 0x00,
            0x0F, 0xB0, 0x00, 0x19, 0xFF, 0x00, 0x00, 0x00,
            0x00, 0x90, 0x0F, 0x00, 0x1A, 0xFF, 0x00, 0x00,
            0x00, 0x3C, 0x00, 0x0F, 0x00, 0x1B, 0xFF, 0x00,
            0x00, 0xF8, 0x00, 0x00, 0x0F, 0x00, 0x1C, 0xFF,
            0x00, 0x2E, 0x00, 0x00, 0xAD, 0x1A, 0x55, 0x55,
            0x55, 0xEC, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5,
            0xC5, 0x79 });

    static byte[] TC_FRAME_02 = intToByteArray(new int[] {
            0x22, 0xF6, 0x00, 0x23, 0x00, 0x82, 0x00, 0x0F,
            0x00, 0x1D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x1E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F,
            0xAC, 0x8F, 0x00, 0x68 });

    static byte[] CLTU_02 = intToByteArray(new int[] {
            0xEB, 0x90, 0x22, 0xF6, 0x00, 0x23, 0x00, 0x82,
            0x00, 0x24, 0x0F, 0x00, 0x1D, 0xFF, 0x00, 0x00,
            0x00, 0x34, 0x00, 0x0F, 0x00, 0x1E, 0xFF, 0x00,
            0x00, 0x10, 0x00, 0x00, 0x0F, 0x00, 0x1F, 0xFF,
            0x00, 0xD8, 0x00, 0x00, 0x00, 0x0F, 0xAC, 0x8F,
            0x00, 0x90, 0x68, 0x55, 0x55, 0x55, 0x55, 0x55,
            0x55, 0x06, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5,
            0xC5, 0x79 });
}
