import { AfterViewInit, ChangeDetectionStrategy, Component, OnDestroy, ViewChild } from '@angular/core';
import { MatLegacyPaginator } from '@angular/material/legacy-paginator';
import { MatLegacyTableDataSource } from '@angular/material/legacy-table';
import { MatSort } from '@angular/material/sort';
import { Title } from '@angular/platform-browser';
import { BehaviorSubject, Subscription } from 'rxjs';
import { ClientConnectionInfo, HttpTraffic } from '../../client';
import { Synchronizer } from '../../core/services/Synchronizer';
import { YamcsService } from '../../core/services/YamcsService';

@Component({
  templateUrl: './HttpTrafficPage.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HttpTrafficPage implements AfterViewInit, OnDestroy {

  @ViewChild(MatSort)
  sort: MatSort;

  @ViewChild(MatLegacyPaginator)
  paginator: MatLegacyPaginator;

  displayedColumns = [
    'id',
    'protocol',
    'remoteAddress',
    'readBytes',
    'writtenBytes',
    'readThroughput',
    'writeThroughput',
    'request',
    'authorization',
    'userAgent',
  ];

  tableTrackerFn = (index: number, conn: ClientConnectionInfo) => conn.id;

  traffic$ = new BehaviorSubject<HttpTraffic | null>(null);
  dataSource = new MatLegacyTableDataSource<ClientConnectionInfo>();

  private syncSubscription: Subscription;

  constructor(
    private yamcs: YamcsService,
    title: Title,
    synchronizer: Synchronizer,
  ) {
    title.setTitle('HTTP traffic');

    this.refresh();
    this.syncSubscription = synchronizer.syncSlow(() => this.refresh());
  }

  ngAfterViewInit() {
    this.dataSource.sort = this.sort;
    this.dataSource.paginator = this.paginator;
  }

  private refresh() {
    this.yamcs.yamcsClient.getHttpTraffic().then(traffic => {
      this.traffic$.next(traffic);
      this.dataSource.data = traffic.connections || [];
    });
  }

  ngOnDestroy() {
    this.syncSubscription?.unsubscribe();
  }
}
