import { ChangeDetectionStrategy, Component, ElementRef, Inject, ViewChild } from '@angular/core';
import { MatLegacyDialogRef, MAT_LEGACY_DIALOG_DATA } from '@angular/material/legacy-dialog';
import { Observable } from 'rxjs';
import { debounceTime } from 'rxjs/operators';
import { Upload } from './Upload';

@Component({
  selector: 'app-upload-progress-dialog',
  templateUrl: './UploadProgressDialog.html',
  styleUrls: ['./UploadProgressDialog.css'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class UploadProgressDialog {

  uploads$: Observable<Upload[]>;

  @ViewChild('tableWrapper', { static: true })
  tableWrapper: ElementRef;

  constructor(
    dialogRef: MatLegacyDialogRef<UploadProgressDialog>,
    @Inject(MAT_LEGACY_DIALOG_DATA) readonly data: any,
  ) {
    this.uploads$ = data.uploads$.pipe(
      debounceTime(500), // limit updates in the case of batch uploads
    );
  }
}
