package evm

var LatestFork = "cancun"

var forkReg = map[string]*InstructionSetDef{
	"frontier": {
		Names: []string{"frontier"},
		Added: []*Op{
			opm["STOP"],
			opm["ADD"],
			opm["MUL"],
			opm["SUB"],
			opm["DIV"],
			opm["SDIV"],
			opm["MOD"],
			opm["SMOD"],
			opm["ADDMOD"],
			opm["MULMOD"],
			opm["EXP"],
			opm["SIGNEXTEND"],
			opm["LT"],
			opm["GT"],
			opm["SLT"],
			opm["SGT"],
			opm["EQ"],
			opm["ISZERO"],
			opm["AND"],
			opm["XOR"],
			opm["OR"],
			opm["NOT"],
			opm["BYTE"],
			opm["KECCAK256"],
			opm["ADDRESS"],
			opm["BALANCE"],
			opm["ORIGIN"],
			opm["CALLER"],
			opm["CALLVALUE"],
			opm["CALLDATALOAD"],
			opm["CALLDATASIZE"],
			opm["CALLDATACOPY"],
			opm["CODESIZE"],
			opm["CODECOPY"],
			opm["GASPRICE"],
			opm["EXTCODESIZE"],
			opm["EXTCODECOPY"],
			opm["BLOCKHASH"],
			opm["COINBASE"],
			opm["TIMESTAMP"],
			opm["NUMBER"],
			opm["DIFFICULTY"],
			opm["GASLIMIT"],
			opm["POP"],
			opm["MLOAD"],
			opm["MSTORE"],
			opm["MSTORE8"],
			opm["SLOAD"],
			opm["SSTORE"],
			opm["JUMP"],
			opm["JUMPI"],
			opm["PC"],
			opm["MSIZE"],
			opm["GAS"],
			opm["JUMPDEST"],
			opm["PUSH1"],
			opm["PUSH2"],
			opm["PUSH3"],
			opm["PUSH4"],
			opm["PUSH5"],
			opm["PUSH6"],
			opm["PUSH7"],
			opm["PUSH8"],
			opm["PUSH9"],
			opm["PUSH10"],
			opm["PUSH11"],
			opm["PUSH12"],
			opm["PUSH13"],
			opm["PUSH14"],
			opm["PUSH15"],
			opm["PUSH16"],
			opm["PUSH17"],
			opm["PUSH18"],
			opm["PUSH19"],
			opm["PUSH20"],
			opm["PUSH21"],
			opm["PUSH22"],
			opm["PUSH23"],
			opm["PUSH24"],
			opm["PUSH25"],
			opm["PUSH26"],
			opm["PUSH27"],
			opm["PUSH28"],
			opm["PUSH29"],
			opm["PUSH30"],
			opm["PUSH31"],
			opm["PUSH32"],
			opm["DUP1"],
			opm["DUP2"],
			opm["DUP3"],
			opm["DUP4"],
			opm["DUP5"],
			opm["DUP6"],
			opm["DUP7"],
			opm["DUP8"],
			opm["DUP9"],
			opm["DUP10"],
			opm["DUP11"],
			opm["DUP12"],
			opm["DUP13"],
			opm["DUP14"],
			opm["DUP15"],
			opm["DUP16"],
			opm["SWAP1"],
			opm["SWAP2"],
			opm["SWAP3"],
			opm["SWAP4"],
			opm["SWAP5"],
			opm["SWAP6"],
			opm["SWAP7"],
			opm["SWAP8"],
			opm["SWAP9"],
			opm["SWAP10"],
			opm["SWAP11"],
			opm["SWAP12"],
			opm["SWAP13"],
			opm["SWAP14"],
			opm["SWAP15"],
			opm["SWAP16"],
			opm["LOG0"],
			opm["LOG1"],
			opm["LOG2"],
			opm["LOG3"],
			opm["LOG4"],
			opm["CREATE"],
			opm["CALL"],
			opm["CALLCODE"],
			opm["RETURN"],
			opm["SELFDESTRUCT"],
		},
	},

	"homestead": {
		Names:  []string{"homestead"},
		Parent: "frontier",
		Added: []*Op{
			opm["DELEGATECALL"],
		},
	},

	"tangerinewhistle": {
		Names:  []string{"tangerinewhistle", "eip150"},
		Parent: "homestead",
	},

	"spuriousdragon": {
		Names:  []string{"spuriousdragon", "eip158"},
		Parent: "tangerinewhistle",
	},

	"byzantium": {
		Names:  []string{"byzantium"},
		Parent: "spuriousdragon",
		Added: []*Op{
			opm["STATICCALL"],
			opm["RETURNDATASIZE"],
			opm["RETURNDATACOPY"],
			opm["REVERT"],
		},
	},

	"petersburg": {
		Names:  []string{"petersburg"},
		Parent: "byzantium",
	},

	"constantinople": {
		Names:  []string{"constantinople"},
		Parent: "petersburg",
		Added: []*Op{
			opm["SHL"],
			opm["SHR"],
			opm["SAR"],
			opm["EXTCODEHASH"],
			opm["CREATE2"],
		},
	},

	"istanbul": {
		Names:  []string{"istanbul"},
		Parent: "constantinople",
		Added: []*Op{
			opm["CHAINID"],
			opm["SELFBALANCE"],
		},
	},

	"berlin": {
		Names:  []string{"berlin"},
		Parent: "istanbul",
	},

	"london": {
		Names:  []string{"london"},
		Parent: "berlin",
		Added: []*Op{
			opm["BASEFEE"],
		},
	},

	"paris": {
		Names:  []string{"paris", "merge"},
		Parent: "istanbul",
		Added: []*Op{
			opm["RANDOM"],
		},
		Removed: []*Op{
			opm["DIFFICULTY"],
		},
	},

	"shanghai": {
		Names:  []string{"shanghai"},
		Parent: "paris",
		Added: []*Op{
			opm["PUSH0"],
		},
	},

	"cancun": {
		Names:  []string{"cancun"},
		Parent: "shanghai",
		Added: []*Op{
			opm["BLOBHASH"],
			opm["TSTORE"],
			opm["TLOAD"],
			opm["MCOPY"],
			opm["SENDALL"],
		},
		Removed: []*Op{
			opm["SELFDESTRUCT"],
		},
	},

	"prague": {
		Names:  []string{"prague"},
		Parent: "cancun",
	},
}
