package jwtware

const (
	// HS256 represents a public cryptography key generated by a 256 bit HMAC algorithm.
	HS256 = "HS256"

	// HS384 represents a public cryptography key generated by a 384 bit HMAC algorithm.
	HS384 = "HS384"

	// HS512 represents a public cryptography key generated by a 512 bit HMAC algorithm.
	HS512 = "HS512"

	// ES256 represents a public cryptography key generated by a 256 bit ECDSA algorithm.
	ES256 = "ES256"

	// ES384 represents a public cryptography key generated by a 384 bit ECDSA algorithm.
	ES384 = "ES384"

	// ES512 represents a public cryptography key generated by a 512 bit ECDSA algorithm.
	ES512 = "ES512"

	// P256 represents a cryptographic elliptical curve type.
	P256 = "P-256"

	// P384 represents a cryptographic elliptical curve type.
	P384 = "P-384"

	// P521 represents a cryptographic elliptical curve type.
	P521 = "P-521"

	// RS256 represents a public cryptography key generated by a 256 bit RSA algorithm.
	RS256 = "RS256"

	// RS384 represents a public cryptography key generated by a 384 bit RSA algorithm.
	RS384 = "RS384"

	// RS512 represents a public cryptography key generated by a 512 bit RSA algorithm.
	RS512 = "RS512"

	// PS256 represents a public cryptography key generated by a 256 bit RSA algorithm.
	PS256 = "PS256"

	// PS384 represents a public cryptography key generated by a 384 bit RSA algorithm.
	PS384 = "PS384"

	// PS512 represents a public cryptography key generated by a 512 bit RSA algorithm.
	PS512 = "PS512"
)
