package main

import (
	"github.com/flxxyz/ServerStatus/cmd"
	"github.com/flxxyz/ServerStatus/cmd/client"
	"github.com/flxxyz/ServerStatus/cmd/server"
	"github.com/flxxyz/ServerStatus/cmd/system"
	"github.com/flxxyz/ServerStatus/cmd/traffic"
	"github.com/flxxyz/ServerStatus/cmd/uuid"
)

func main() {
	c := cmd.Run()

	switch c.T {
	case "server":
		server.Run(c)
	case "client":
		client.Run(c)
	case "uuid":
		uuid.Run(c)
	case "system":
		system.Run(c)
	case "traffic":
		traffic.Run(c)
	}
}
