# How to Contribute

We'd love to accept your patches and contributions to this project. There are
just a few small guidelines you need to follow.

## Contributor License Agreement

Contributions to this project must be accompanied by a Contributor License
Agreement. You (or your employer) retain the copyright to your contribution;
this simply gives us permission to use and redistribute your contributions as
part of the project. Head over to <https://cla.developers.google.com/> to see
your current agreements on file or to sign a new one.

You generally only need to submit a CLA once, so if you've already submitted one
(even if it was for a different project), you probably don't need to do it
again.

## Code reviews

All submissions, including submissions by project members, require review. We
use GitHub pull requests for this purpose. Consult
[GitHub Help](https://help.github.com/articles/about-pull-requests/) for more
information on using pull requests.

## Community Guidelines

This project follows
[Google's Open Source Community Guidelines](https://opensource.google.com/conduct/).

## How to contribute

See the [contribution
guidelines](https://www.docsy.dev/docs/contribution-guidelines/)
in the Docsy user guide.

## Publishing a release

These notes are WIP for creating a release (v0.X.Y) from a local copy of the
repo.

1.  Change directory to your local docsy repo and ensure that you're on a branch
    and at the commit that you want to tag as the next release (usually
    `@HEAD`).
2.  Ensure that the [CHANGELOG](CHANGELOG.md) has a release summary entry for
    v0.X.Y. If not, create one with a brief summary of breaking changes. (Change
    details are autogenerated by GitHub in a later step.)
3. Update the Hugo module versions to v0.X.Y.
4. Update the NPM package version in [package.json](package.json) to v0.X.Y.
5.  Create the tags for v0.X.Y (we currently need two):

    ```console
    $ REL=v0.X.Y
    $ git tag $REL
    $ git tag dependencies/$REL
    ```

6.  Push the new tags to the main repo (which is named `upstream` in my setup)
    either one by one or all together provided you have no other new tags
    defined. The following illustrates the latter, and does a dry run first:

    ```console
    $ git push --dry-run --tags upstream
    To https://github.com/google/docsy.git
    * [new tag]         dependencies/v0.X.Y -> dependencies/v0.X.Y
    * [new tag]         v0.X.Y -> v0.X.Y
    ```

    If only the two new tags are listed, drop the dry-run flag to push the tags.

5.  Use the GitHub [Draft a new release][] feature, filling in the fields as
    follows:

    - From the release/tag dropdown: Select the new release tag that you just
      pushed, v0.X.Y.
    - Set the release title to the release number (without the "v").
    - Click "auto-generate release notes" to get the release details.
    - Replace the auto-generated "## What's Changed" heading by the following:

      ```markdown
      ## Release summary

      See, https://github.com/google/docsy/blob/main/CHANGELOG.md#0XY

      ## Commit details
      ```

    - Replace the `0XY` anchor target above with a target appropriate for this
      release.
    - Remove the "New contributors" autogenerated text since we don't publish
      that as part of our release notes.
    - Select **Create a discussion for this release**.
    - Click **Publish release**.

[draft a new release]: https://github.com/google/docsy/releases/new
