// Copyright 2016 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.devtools.build.android;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

/**
 * Represents the value associated with DataKey interface for resource and asset values.
 *
 * A DataValue is either an android resource or asset derived from a Path.
 */
public interface DataValue {

  /**
   * Provides the Path to the file from which the DataValue was derived.
   */
  Path source();

  /**
   * Serializes to a supplied stream and returns the number of bytes written.
   */
  int serializeTo(
      DataKey key, DataSourceTable sourceTable, OutputStream output) throws IOException;
}
