---
title: "Exceptions: The invalidArg Function (F#)"
description: "Exceptions: The invalidArg Function (F#)"
keywords: visual f#, f#, functional programming
author: dend
manager: danielfe
ms.date: 05/16/2016
ms.topic: language-reference
ms.prod: visual-studio-dev14
ms.technology: devlang-fsharp
ms.assetid: d375b704-6b27-493e-bd1d-ee217a53c4b5 
---

# Exceptions: The invalidArg Function

The `invalidArg` function generates an argument exception.


## Syntax

```fsharp
invalidArg parameter-name error-message-string
```

## Remarks
The parameter-name in the previous syntax is a string with the name of the parameter whose argument was invalid. The *error-message-string* is a literal string or a value of type `string`. It becomes the `Message` property of the exception object.

The exception generated by `invalidArg` is a `System.ArgumentException` exception. The following code illustrates the use of `invalidArg` to throw an exception.

[!code-fsharp[Main](../../../../samples/snippets/fsharp/lang-ref-2/snippet6101.fs)]

The output is the following, followed by a stack trace (not shown).

```
December
January
System.ArgumentException: Month parameter out of range.
```

## See Also
[Exception Handling](index.md)

[Exception Types](exception-types.md)

[Exceptions: The `try...with` Expression](the-try-with-expression.md)

[Exceptions: The `try...finally` Expression](the-try-finally-expression.md)

[Exceptions: the `raise` Function](the-raise-function.md)

[Exceptions: The `failwith` Function](the-failwith-function.md)
