---
layout: HubPage

title: .NET Core Documentation
description:
keywords:
author:
manager:
ms.date: 06/20/2016
ms.topic: hubpage
ms.prod:
ms.service:
ms.technology:
ms.suite:
ms.assetid:
---

<article id="main">
    <section id="hero-content" class="graph">
        <h1>.NET Documentation</h1>
        <h2>Welcome to .NET! This is the home of the technical documentation for .NET Core, C#, F# and Visual Basic, including basic concepts, getting started instructions, tutorials and samples. You can look for an answer to a challenging problem or learn .NET for the first time.</h2>
    </section>
    <aside class="alert section-border">
        <p>Download .NET Core today</p>
        <ol class="action-list">
            <li><a href="https://dot.net/core" class="button-bordered button-translucent">Get it!</a></li>
        </ol>
    </aside>
    <section id="featured" class="container">
        <h2 class="section-heading"><span class="icon icon-lightbulb-checked"></span> Featured Content</h2>
        <div class="features row">
            <ul class="column-half">
                <li><a href="docs/core/index.md">Get started with .NET Core</a></li>
            </ul>
            <ul class="column-half">
                <li><a href="https://docs.asp.net">Get started with ASP.NET Core</a></li>
            </ul>
        </div>
    </section>
    <div id="journeys">
        <section class="container">
            <ul class="journeys-list">
                <li class="journey-step">
                    <header class="journey-step-header row">
                        <div class="title column-third">
                            <span class="icon icon-tip"></span>
                            <p>Learn the Platform</p>
                        </div>
                        <p class="description column-two-thirds">
                            Get started with .NET Core and learn the fundamentals of the .NET platform.
                        </p>
                    </header>
                    <section class="journey-step-elements content">
                        <ul class="row">
                            <li class="column column-third">
                                <a href="docs/welcome.md">
                                    <h3>.NET Core Documentation</h3>
                                    <p>Learn .NET Core concepts and language syntax.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="api/index.md">
                                    <h3>API Reference</h3>
                                    <p>Browse the .NET API, organized by namespace.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="docs/core/index.md">
                                    <h3>Getting Started with .NET Core</h3>
                                    <p>Learn how to build .NET Core console apps at the command-line or in Visual Studio.</p>
                                </a>
                            </li>
                        </ul>
                    </section>
                </li>
                <li class="journey-step">
                    <header class="journey-step-header row">
                        <div class="title column-third">
                            <span class="icon icon-tip"></span>
                            <p>Web &amp; Cloud</p>
                        </div>
                        <p class="description column-two-thirds">
                            Learn how to create scalable web apps with ASP.NET Core, including deployment to Microsoft Azure.
                        </p>
                    </header>
                    <section class="journey-step-elements content">
                        <ul class="row">
                            <li class="column column-third">
                                <a href="https://docs.asp.net">
                                    <h3>ASP.NET Core</h3>
                                    <p>Learn how to build web sites and services using ASP.NET Core.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="https://docs.asp.net/en/latest/data">
                                    <h3>Accessing Data</h3>
                                    <p>Learn about Entity Framework for modeling your databases or how to access SQL Server and other databases using .NET.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="https://www.visualstudio.com/features/azure-tools-vs">
                                    <h3>Microsoft Azure</h3>
                                    <p>Get Started developing applications using Microsoft Azure.</p>
                                </a>
                            </li>
                        </ul>
                    </section>
                </li>
                <li class="journey-step">
                    <header class="journey-step-header row">
                        <div class="title column-third">
                            <span class="icon icon-tip"></span>
                            <p>Mobile</p>
                        </div>
                        <p class="description column-two-thirds">
                            Learn how .NET Core and Xamarin can enable you to develop for iOS and Android using C# or about building applications using the Universal Windows Platform (UWP) for Windows 10 devices.
                        </p>
                    </header>
                    <section class="journey-step-elements content">
                        <ul class="row">
                            <li class="column column-third">
                                <a href="https://developer.xamarin.com/guides/ios/getting_started/">
                                    <h3>Android and iOS apps</h3>
                                    <p>Learn how to build native iOS and Android applications with Xamarin.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="https://developer.microsoft.com/en-us/windows/getstarted">
                                    <h3>Universal Windows Platform</h3>
                                    <p>Learn how to build Windows 10 UWP apps, which can run on all Windows 10 devices.</p>
                                </a>
                            </li>
                        </ul>
                    </section>
                </li>
                <li class="journey-step">
                    <header class="journey-step-header row">
                        <div class="title column-third">
                            <span class="icon icon-tip"></span>
                            <p>Desktop</p>
                        </div>
                        <p class="description column-two-thirds">
                            Learn how you can build desktop applications for Windows and macOS.
                        </p>
                    </header>
                    <section class="journey-step-elements content">
                        <ul class="row">
                            <li class="column column-third">
                                <a href="https://msdn.microsoft.com/library/54xbah2z.aspx">
                                    <h3>Windows Desktop</h3>
                                    <p>Learn how to build Windows desktop applications with Windows Forms or Windows Presentation Framework (WPF).</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="https://developer.xamarin.com/guides/cross-platform/macios/">
                                    <h3>macOS Desktop</h3>
                                    <p>Learn how to build macOS desktop applications with Xamarin.</p>
                                </a>
                            </li>
                        </ul>
                    </section>
                </li>
                <li class="journey-step">
                    <header class="journey-step-header row">
                        <div class="title column-third">
                            <span class="icon icon-tip"></span>
                            <p>Gaming</p>
                        </div>
                        <p class="description column-two-thirds">
                            Learn how to build games using .NET
                        </p>
                    </header>
                    <section class="journey-step-elements content">
                        <ul class="row">
                            <li class="column column-third">
                                <a href="http://docs.cryengine.com/display/CEPROG/CE%23+Programming">
                                    <h3>CRYENGINE</h3>
                                    <p>Build games for desktop, console and mobile in C# with CRYENGINE.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="http://www.monogame.net/documentation/?page=main">
                                    <h3>MonoGame</h3>
                                    <p>Build games for desktop, console and mobile in C# with MonoGame.</p>
                                </a>
                            </li>
                            <li class="column column-third">
                                <a href="http://docs.unity3d.com/Manual/index.html">
                                    <h3>Unity</h3>
                                    <p>Build games for desktop, console and mobile in C# with Unity.</p>
                                </a>
                            </li>
                        </ul>
                    </section>
                </li>
            </ul>
        </section>
    </div>
</article>
