<?php
declare(strict_types = 1);

namespace Properties\Formal\ORM;

use Formal\ORM\Manager;
use Fixtures\Formal\ORM\User;
use Innmind\BlackBox\{
    Set,
    Property,
    Runner\Assert,
};

/**
 * @implements Property<Manager>
 */
final class Size implements Property
{
    private function __construct()
    {
    }

    public static function any(): Set
    {
        return Set::of(new self);
    }

    public function applicableTo(object $manager): bool
    {
        return true;
    }

    public function ensureHeldBy(Assert $assert, object $manager): object
    {
        $repository = $manager->repository(User::class);

        $assert
            ->expected($repository->all()->sequence()->size())
            ->same($repository->size());

        return $manager;
    }
}
