<?php
declare(strict_types = 1);

namespace Formal\ORM\Specification;

use Formal\ORM\Adapter\Repository\SubMatch;
use Innmind\Specification\{
    Comparator,
    Sign,
    Composable,
};

/**
 * @internal
 * @psalm-immutable
 */
final class CrossMatch implements Comparator
{
    use Composable;

    /**
     * @param non-empty-string $property
     */
    private function __construct(
        private string $property,
        private SubMatch $value,
    ) {
    }

    /**
     * @internal
     * @psalm-pure
     *
     * @param non-empty-string $property
     */
    public static function of(
        string $property,
        SubMatch $value,
    ): self {
        return new self($property, $value);
    }

    #[\Override]
    public function property(): string
    {
        return $this->property;
    }

    #[\Override]
    public function sign(): Sign
    {
        return Sign::in;
    }

    #[\Override]
    public function value(): mixed
    {
        return $this->value->unwrap();
    }
}
