# Overview 

Apollo is a meritocratic, consensus-based community project. Anyone with an interest in the project can join the community, contribute to the project design and participate in the decision-making process.

This document describes how that participation takes place and how to set about earning merit within the project community.

# Roles and Responsibilities

Apollo community is composed of and operated by the following roles:

- Users
- Contributors
- Committers
- Project Management Committee (PMC)

## Users

Users are community members who have a need for the project. They are the most important members of the community and without them the project would have no purpose. Anyone can be a user and there are no special requirements.

## Contributors

Contributors are community members who contribute in concrete ways to the project.

### How to become a Contributor

- merged at least 1 pull request

You are also encouraged to participate in the projects in the following ways:

- Actively answer technical questions raised by community users in GitHub issues.
- Help test the projects
- Help review the pull requests (PRs) submitted by others
- Help improve technical documents
- Submit valuable issues
- Report or fix known and unknown bugs
- Write articles about source code analysis and usage cases for a project.
- Give representations of Apollo topic in conferences.
- Take part in our discussions of features, enhancements, etc.

## Committers

Committers are contributors who have shown that they are committed to the continued development of the project through ongoing engagement with the community and recognized by PMCs for their outstanding contributions.

### How to become a Committer

A Committer must have accomplished one or more of the following items:

- Demonstrated a good sense of responsibility in PR reviews.
- Demonstrated deep understanding of Apollo components by contributing significantly as:
    - Finished 2 or more tasks of Medium difficulty
    - Fixed 1 or more tasks of Hard difficulty
- Nominated by one PMC member and gained more +1 than -1.

### Privileges and responsibilities

- Control overall code quality of projects
- Guide Contributors to contribute to the community continuously
- Participate in design discussions

## Project Management Committee

The PMC(Project Management Committee) functions as the core management team that oversees the Apollo community. The PMC has additional responsibilities over and above those of Committers. These responsibilities ensure the smooth running of the project.

### How to become a PMC member

- Membership of the PMC is by invitation from the existing PMC members. 
- A nomination will result in discussion and then a vote by the existing PMC members.
- PMC membership votes are subject to consensus approval of the current PMC members.

### Privileges and responsibilities

- Handle reported security issues (CVE, etc.)
- Nominate new committers and PMC members
- Vote on new committers and new PMC members
- Make major decisions for the future with respect to Apollo, such as project-level governance policies, management of sub-structures, security processes and so on
- Make decisions when community consensus cannot be reached

# Decision-making and voting

Proposals and ideas can be submitted for agreement via a GitHub issue, PR, or GitHub Discussion.

Major changes such as feature proposals and organization or process changes should be brought to the PMC. For the change to happen, the change must earn more +1 than -1.

# Conflict resolution

In general, we prefer that technical issues and other disputes upon which consensus can't be reached are amicably worked out between the persons involved. If a dispute cannot be decided independently, the PMC can be called in to resolve the issue by voting. The same PR can be used, or a separate PR can be opened for voting.

# Changes in Governance

Any change in this Governance document, or similar nature of changes to other governance related documents, shall go through the voting process as described in [Decision-making and voting](#decision-making-and-voting).

# Credits

The contents of this document are based on <http://oss-watch.ac.uk/resources/meritocraticgovernancemodel> by Ross Gardler and Gabriel Hanganu, and [TiDB Governance](https://github.com/pingcap/community/blob/master/GOVERNANCE.md).
