package org.jboss.forge.test.roaster.model;

import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class NonAsciiCharactersTest
{

   final String nonAsciiCharactersClass = "public class NonAsciiCharacters {" +

   "   public int punctuations_example_áéíóú = 0; " +

   "}";

   @Test
   public void testNonAsciiCharacters()
   {
      JavaClassSource javaClass = Roaster.parse(JavaClassSource.class, nonAsciiCharactersClass);
      assertTrue(!javaClass.hasSyntaxErrors());
      assertEquals("punctuations_example_áéíóú", javaClass.getFields().get(0).getName());
   }

}
