// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package image

import (
	"context"
	"sync"
	"time"
)

// Ensure, that StoreMock does implement Store.
// If this is not the case, regenerate this file with moq.
var _ Store = &StoreMock{}

// StoreMock is a mock implementation of Store.
//
//	func TestSomethingThatUsesStore(t *testing.T) {
//
//		// make and configure a mocked Store
//		mockedStore := &StoreMock{
//			CleanupFunc: func(ctx context.Context, ttl time.Duration) error {
//				panic("mock out the Cleanup method")
//			},
//			CommitFunc: func(id string) error {
//				panic("mock out the Commit method")
//			},
//			DeleteFunc: func(id string) error {
//				panic("mock out the Delete method")
//			},
//			InfoFunc: func() (StoreInfo, error) {
//				panic("mock out the Info method")
//			},
//			LoadFunc: func(id string) ([]byte, error) {
//				panic("mock out the Load method")
//			},
//			ResetCleanupTimerFunc: func(id string) error {
//				panic("mock out the ResetCleanupTimer method")
//			},
//			SaveFunc: func(id string, img []byte) error {
//				panic("mock out the Save method")
//			},
//		}
//
//		// use mockedStore in code that requires Store
//		// and then make assertions.
//
//	}
type StoreMock struct {
	// CleanupFunc mocks the Cleanup method.
	CleanupFunc func(ctx context.Context, ttl time.Duration) error

	// CommitFunc mocks the Commit method.
	CommitFunc func(id string) error

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(id string) error

	// InfoFunc mocks the Info method.
	InfoFunc func() (StoreInfo, error)

	// LoadFunc mocks the Load method.
	LoadFunc func(id string) ([]byte, error)

	// ResetCleanupTimerFunc mocks the ResetCleanupTimer method.
	ResetCleanupTimerFunc func(id string) error

	// SaveFunc mocks the Save method.
	SaveFunc func(id string, img []byte) error

	// calls tracks calls to the methods.
	calls struct {
		// Cleanup holds details about calls to the Cleanup method.
		Cleanup []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// TTL is the ttl argument value.
			TTL time.Duration
		}
		// Commit holds details about calls to the Commit method.
		Commit []struct {
			// ID is the id argument value.
			ID string
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// ID is the id argument value.
			ID string
		}
		// Info holds details about calls to the Info method.
		Info []struct {
		}
		// Load holds details about calls to the Load method.
		Load []struct {
			// ID is the id argument value.
			ID string
		}
		// ResetCleanupTimer holds details about calls to the ResetCleanupTimer method.
		ResetCleanupTimer []struct {
			// ID is the id argument value.
			ID string
		}
		// Save holds details about calls to the Save method.
		Save []struct {
			// ID is the id argument value.
			ID string
			// Img is the img argument value.
			Img []byte
		}
	}
	lockCleanup           sync.RWMutex
	lockCommit            sync.RWMutex
	lockDelete            sync.RWMutex
	lockInfo              sync.RWMutex
	lockLoad              sync.RWMutex
	lockResetCleanupTimer sync.RWMutex
	lockSave              sync.RWMutex
}

// Cleanup calls CleanupFunc.
func (mock *StoreMock) Cleanup(ctx context.Context, ttl time.Duration) error {
	if mock.CleanupFunc == nil {
		panic("StoreMock.CleanupFunc: method is nil but Store.Cleanup was just called")
	}
	callInfo := struct {
		Ctx context.Context
		TTL time.Duration
	}{
		Ctx: ctx,
		TTL: ttl,
	}
	mock.lockCleanup.Lock()
	mock.calls.Cleanup = append(mock.calls.Cleanup, callInfo)
	mock.lockCleanup.Unlock()
	return mock.CleanupFunc(ctx, ttl)
}

// CleanupCalls gets all the calls that were made to Cleanup.
// Check the length with:
//
//	len(mockedStore.CleanupCalls())
func (mock *StoreMock) CleanupCalls() []struct {
	Ctx context.Context
	TTL time.Duration
} {
	var calls []struct {
		Ctx context.Context
		TTL time.Duration
	}
	mock.lockCleanup.RLock()
	calls = mock.calls.Cleanup
	mock.lockCleanup.RUnlock()
	return calls
}

// Commit calls CommitFunc.
func (mock *StoreMock) Commit(id string) error {
	if mock.CommitFunc == nil {
		panic("StoreMock.CommitFunc: method is nil but Store.Commit was just called")
	}
	callInfo := struct {
		ID string
	}{
		ID: id,
	}
	mock.lockCommit.Lock()
	mock.calls.Commit = append(mock.calls.Commit, callInfo)
	mock.lockCommit.Unlock()
	return mock.CommitFunc(id)
}

// CommitCalls gets all the calls that were made to Commit.
// Check the length with:
//
//	len(mockedStore.CommitCalls())
func (mock *StoreMock) CommitCalls() []struct {
	ID string
} {
	var calls []struct {
		ID string
	}
	mock.lockCommit.RLock()
	calls = mock.calls.Commit
	mock.lockCommit.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *StoreMock) Delete(id string) error {
	if mock.DeleteFunc == nil {
		panic("StoreMock.DeleteFunc: method is nil but Store.Delete was just called")
	}
	callInfo := struct {
		ID string
	}{
		ID: id,
	}
	mock.lockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	mock.lockDelete.Unlock()
	return mock.DeleteFunc(id)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedStore.DeleteCalls())
func (mock *StoreMock) DeleteCalls() []struct {
	ID string
} {
	var calls []struct {
		ID string
	}
	mock.lockDelete.RLock()
	calls = mock.calls.Delete
	mock.lockDelete.RUnlock()
	return calls
}

// Info calls InfoFunc.
func (mock *StoreMock) Info() (StoreInfo, error) {
	if mock.InfoFunc == nil {
		panic("StoreMock.InfoFunc: method is nil but Store.Info was just called")
	}
	callInfo := struct {
	}{}
	mock.lockInfo.Lock()
	mock.calls.Info = append(mock.calls.Info, callInfo)
	mock.lockInfo.Unlock()
	return mock.InfoFunc()
}

// InfoCalls gets all the calls that were made to Info.
// Check the length with:
//
//	len(mockedStore.InfoCalls())
func (mock *StoreMock) InfoCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockInfo.RLock()
	calls = mock.calls.Info
	mock.lockInfo.RUnlock()
	return calls
}

// Load calls LoadFunc.
func (mock *StoreMock) Load(id string) ([]byte, error) {
	if mock.LoadFunc == nil {
		panic("StoreMock.LoadFunc: method is nil but Store.Load was just called")
	}
	callInfo := struct {
		ID string
	}{
		ID: id,
	}
	mock.lockLoad.Lock()
	mock.calls.Load = append(mock.calls.Load, callInfo)
	mock.lockLoad.Unlock()
	return mock.LoadFunc(id)
}

// LoadCalls gets all the calls that were made to Load.
// Check the length with:
//
//	len(mockedStore.LoadCalls())
func (mock *StoreMock) LoadCalls() []struct {
	ID string
} {
	var calls []struct {
		ID string
	}
	mock.lockLoad.RLock()
	calls = mock.calls.Load
	mock.lockLoad.RUnlock()
	return calls
}

// ResetCleanupTimer calls ResetCleanupTimerFunc.
func (mock *StoreMock) ResetCleanupTimer(id string) error {
	if mock.ResetCleanupTimerFunc == nil {
		panic("StoreMock.ResetCleanupTimerFunc: method is nil but Store.ResetCleanupTimer was just called")
	}
	callInfo := struct {
		ID string
	}{
		ID: id,
	}
	mock.lockResetCleanupTimer.Lock()
	mock.calls.ResetCleanupTimer = append(mock.calls.ResetCleanupTimer, callInfo)
	mock.lockResetCleanupTimer.Unlock()
	return mock.ResetCleanupTimerFunc(id)
}

// ResetCleanupTimerCalls gets all the calls that were made to ResetCleanupTimer.
// Check the length with:
//
//	len(mockedStore.ResetCleanupTimerCalls())
func (mock *StoreMock) ResetCleanupTimerCalls() []struct {
	ID string
} {
	var calls []struct {
		ID string
	}
	mock.lockResetCleanupTimer.RLock()
	calls = mock.calls.ResetCleanupTimer
	mock.lockResetCleanupTimer.RUnlock()
	return calls
}

// Save calls SaveFunc.
func (mock *StoreMock) Save(id string, img []byte) error {
	if mock.SaveFunc == nil {
		panic("StoreMock.SaveFunc: method is nil but Store.Save was just called")
	}
	callInfo := struct {
		ID  string
		Img []byte
	}{
		ID:  id,
		Img: img,
	}
	mock.lockSave.Lock()
	mock.calls.Save = append(mock.calls.Save, callInfo)
	mock.lockSave.Unlock()
	return mock.SaveFunc(id, img)
}

// SaveCalls gets all the calls that were made to Save.
// Check the length with:
//
//	len(mockedStore.SaveCalls())
func (mock *StoreMock) SaveCalls() []struct {
	ID  string
	Img []byte
} {
	var calls []struct {
		ID  string
		Img []byte
	}
	mock.lockSave.RLock()
	calls = mock.calls.Save
	mock.lockSave.RUnlock()
	return calls
}
