import { AnyRouter, DataTransformer } from '@trpc/server';
import { TRPCResult } from '@trpc/server/rpc';
import { TRPCClientError } from '../TRPCClientError';

export type OperationContext = Record<string, unknown>;
export type Operation<TInput = unknown> = {
  id: number;
  type: 'query' | 'mutation' | 'subscription';
  input: TInput;
  path: string;
  context: OperationContext;
};

export type OperationResponse<TRouter extends AnyRouter, TOutput = unknown> =
  | TRPCResult<TOutput>
  | TRPCClientError<TRouter>;

export type PrevCallback<TRouter extends AnyRouter, TOutput = unknown> = (
  result: OperationResponse<TRouter, TOutput>,
) => void;
export type OperationLink<
  TRouter extends AnyRouter,
  TInput = unknown,
  TOutput = unknown,
> = (opts: {
  op: Operation;
  prev: PrevCallback<TRouter, TOutput>;
  next: (
    op: Operation<TInput>,
    callback: PrevCallback<TRouter, TOutput>,
  ) => void;
  onDestroy: (callback: () => void) => void;
}) => void;

export type TRPCLink<TRouter extends AnyRouter> = (
  opts: LinkRuntimeOptions,
) => OperationLink<TRouter>;

export interface HttpLinkOptions {
  url: string;
}

export type HttpHeaders = Record<string, string | string[] | undefined>;
export type LinkRuntimeOptions = Readonly<{
  transformer: DataTransformer;
  headers: () => HttpHeaders;
  fetch: typeof fetch;
  AbortController?: typeof AbortController;
}>;

export type CancelFn = () => void;

export type PromiseAndCancel<TValue> = {
  promise: Promise<TValue>;
  cancel: CancelFn;
};
