#!/bin/bash

PACKAGE_JS="package.js"

LESS_FILES=`find . -name "*.less" | sed "s|^\./||"`

# remove everything after the token
sed -i '' '/AUTOGENERATED/,$d' $PACKAGE_JS
echo "  // AUTOGENERATED" >> $PACKAGE_JS

# add all js and less files
echo "  api.addFiles([" >> $PACKAGE_JS
for FILE in $LESS_FILES
do
  echo "    \"$FILE\"," >> $PACKAGE_JS
done
echo "  ], \"client\", {isImport: true});" >> $PACKAGE_JS

# end the use statement
echo "});" >> $PACKAGE_JS
