<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Installation Language Lines
    |--------------------------------------------------------------------------
    */

    // commons
    'title' => 'Setup Configuration File',
    'desc' => 'Installation',
    'btn_check' => 'Try Again',
    'btn_next' => 'Next Step',
    'btn_submit' => 'Submit',
    // intro
    'intro_title' => 'Welcome to Fresns',
    'intro_desc' => 'Before getting started, we need some information on the database. You will need to know the following items before proceeding.',
    'intro_database_name' => 'Database name',
    'intro_database_username' => 'Database username',
    'intro_database_password' => 'Database password',
    'intro_database_host' => 'Database host',
    'intro_database_table_prefix' => 'Table prefix (if you want to run more than one Fresns in a single database)',
    'intro_database_desc' => 'In all likelihood, these items were supplied to you by your web host. If you don’t have this information, then you will need to contact them before you can continue. If you’re all ready…',
    'intro_next_btn' => "Let's go!",
    // server
    'server_title' => 'Server Requirements',
    'server_check_php_version' => 'PHP 8.2+',
    'server_check_composer_version' => 'Composer 2.5+',
    'server_check_https' => 'HTTPS is recommended for sites',
    'server_check_folder_ownership' => 'Folder Ownership',
    'server_check_php_extensions' => 'PHP Extensions',
    'server_check_php_functions' => 'PHP Functions',
    'server_check_error' => 'Server environment detection failure.',
    'server_check_self' => 'Self Check',
    'server_status_success' => 'ok',
    'server_status_failure' => 'Error',
    'server_status_warning' => 'Warning',
    'server_status_not_writable' => 'Not Writable',
    'server_status_not_installed' => 'Not Installed',
    'server_status_not_enabled' => 'Not Enabled',
    // database
    'database_title' => 'Database Information',
    'database_desc' => 'Below you should enter your database connection details. If you’re not sure about these, contact your host.',
    'database_driver' => 'Database',
    'database_name' => 'Database Name',
    'database_name_sqlite' => 'Database Path',
    'database_name_desc' => 'The name of the database you want to use with Fresns.',
    'database_username' => 'Username',
    'database_username_desc' => 'Your database username.',
    'database_password' => 'Password',
    'database_password_desc' => 'Your database password.',
    'database_host' => 'Database Host',
    'database_host_desc' => 'You should be able to get this info from your web host, if localhost doesn’t work.',
    'database_port' => 'Database Port',
    'database_port_mysql_desc' => 'Default Port 3306',
    'database_port_pgsql_desc' => 'Default Port 5432',
    'database_port_sqlsrv_desc' => 'Default Port 1433',
    'database_timezone' => 'Database Timezone',
    'database_timezone_desc' => 'Proper configuration ensures that the data time is accurate so that Fresns can process the time correctly.',
    'database_table_prefix' => 'Table Prefix',
    'database_table_prefix_desc' => 'If you want to run multiple Fresns installations in a single database, change this.',
    'database_config_invalid' => 'Database Config Invalid',
    'database_import_log' => 'Data Import Log',
    // install
    'install_failure' => 'Installation failed, please check the log for the reason',
    // register
    'register_welcome' => 'Welcome to Fresns installation process! Just fill in the information below and you’ll be on your way to using the most extendable and cross-platform social network service software in the world.',
    'register_title' => 'Information needed',
    'register_desc' => 'Please provide the following information. Don’t worry, you can always change these settings later.',
    'register_account_email' => 'Admin Email',
    'register_account_password' => 'Password',
    'register_account_password_confirm' => 'Confirm Password',
    // done
    'done_title' => 'Success!',
    'done_desc' => 'Fresns has been installed. Thank you, and enjoy!',
    'done_account' => 'Account',
    'done_password' => 'Password',
    'done_password_desc' => 'Your chosen password.',
    'done_btn' => 'Log In',
];
