<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Panel de control Fresns',
    'fresns_core' => 'Core Fresns',
    // Login page
    'language' => 'Idioma',
    'login' => 'Acceso',
    'account' => 'Cuenta',
    'password' => 'Clave',
    'enter' => 'Ingresar',
    'operation' => 'Funcionamiento del panel',
    'site_home' => 'Inicio del sitio web',
    'switch_language' => 'Idioma del interruptor',
    'logout' => 'Cerrar sesión',
    // Header menus
    'menu_dashboard' => 'Tablero',
    'menu_systems' => 'Sistemas',
    'menu_operations' => 'Operaciones',
    'menu_extends' => 'Expansión',
    'menu_clients' => 'Clientela',
    'menu_app_center' => 'Centro de aplicaciones',
    'menu_marketplace' => 'Mercado',
    // Sidebar menus
    'sidebar_home' => 'Casa',
    'sidebar_admins' => 'Administradores',
    'sidebar_events' => 'Eventi',
    'sidebar_events_tab_subscribe' => 'Iscriviti',
    'sidebar_events_tab_crontab' => 'Crontab',
    'sidebar_caches' => 'Cachés',
    'sidebar_caches_tab_config' => 'Caché de configuración',
    'sidebar_caches_tab_data' => 'Caché de datos',
    'sidebar_upgrades' => 'Actualizaciones',
    'sidebar_settings' => 'Ajustes',
    'sidebar_languages' => 'Idiomas',
    'sidebar_storage' => 'Almacenamiento',
    'sidebar_storage_tab_image' => 'Imagen',
    'sidebar_storage_tab_video' => 'Video',
    'sidebar_storage_tab_audio' => 'Audio',
    'sidebar_storage_tab_document' => 'Documento',
    'sidebar_storage_tab_substitution' => 'Sustitución',
    'sidebar_general' => 'General',
    'sidebar_policy' => 'Política',
    'sidebar_policy_tab_options' => 'Opciones',
    'sidebar_policy_tab_contents' => 'Contenido',
    'sidebar_send' => 'Enviar',
    'sidebar_send_tab_services' => 'Enviar servicios',
    'sidebar_send_tab_templates' => 'Verificar plantillas de código',
    'sidebar_account' => 'Cuenta',
    'sidebar_wallet' => 'Billetera',
    'sidebar_wallet_tab_options' => 'Opciones',
    'sidebar_wallet_tab_recharge_services' => 'Servicios de recarga',
    'sidebar_wallet_tab_withdraw_services' => 'Retirar los servicios',
    'sidebar_user' => 'Usuario',
    'sidebar_content' => 'Contenido',
    'sidebar_interaction' => 'Interacción',
    'sidebar_publish' => 'Publicar',
    'sidebar_publish_tab_post' => 'Correo',
    'sidebar_publish_tab_comment' => 'Comentario',
    'sidebar_roles' => 'Roles',
    'sidebar_stickers' => 'Pegatinas',
    'sidebar_groups' => 'Grupo',
    'sidebar_groups_tab_active' => 'Activo',
    'sidebar_groups_tab_deactivate' => 'Inactivo',
    'sidebar_groups_tab_recommend' => 'Ver solo recomendar',
    'sidebar_extend_editor' => 'Editor',
    'sidebar_extend_content_type' => 'Tipo de contenido',
    'sidebar_extend_content_handler' => 'Manipulador de contenidos',
    'sidebar_extend_manage' => 'Administrar',
    'sidebar_extend_group' => 'Grupo',
    'sidebar_extend_group_filter' => 'Filtrar',
    'sidebar_extend_user_feature' => 'Característica del usuario',
    'sidebar_extend_user_profile' => 'Perfil del usuario',
    'sidebar_extend_channel' => 'Canal',
    'sidebar_extend_command_words' => 'Palabras de comando',
    'sidebar_channels' => 'Canales',
    'sidebar_paths' => 'Ruta',
    'sidebar_language_packs' => 'Paquetes de idiomas',
    'sidebar_code_messages' => 'Mensajes de código',
    'sidebar_client_basic' => 'Base',
    'sidebar_client_status' => 'Estado',
    'sidebar_plugins' => 'Plugins',
    'sidebar_plugins_tab_all' => 'Todos',
    'sidebar_plugins_tab_active' => 'Activo',
    'sidebar_plugins_tab_inactive' => 'Inactivo',
    'sidebar_themes' => 'Temas',
    'sidebar_apps' => 'Aplicaciones',
    'sidebar_keys' => 'Claves de la aplicación',
    // Sidebar intro
    'sidebar_admins_intro' => 'Los usuarios que tienen derecho a iniciar sesión en el panel de control',
    'sidebar_events_intro' => 'Ver las tareas cronometradas y los eventos de suscripción en el sistema',
    'sidebar_caches_intro' => 'Al borrar toda la caché, puede aumentar la carga del servidor, por lo que le rogamos que intente evitar las horas punta de acceso.',
    'sidebar_upgrades_intro' => 'Finalmente',
    'sidebar_settings_intro' => 'Por favor, borre la caché cuando la configuración esté completa, o espere 10 minutos para que la nueva caché tenga efecto.',
    'sidebar_languages_intro' => 'Multi-idioma necesita configurar las opciones de idioma aquí antes de poder ingresar contenido multilingüe en el elemento de configuración correspondiente',
    'sidebar_storage_intro' => 'Cuatro archivos de recursos se pueden almacenar por separado, o almacenarse al mismo tiempo, simplemente complete la información de configuración de almacenamiento',
    'sidebar_general_intro' => 'Salvaguardar los elementos de configuración del sistema en ejecución',
    'sidebar_policy_intro' => 'De acuerdo con las regulaciones legales de datos relevantes sobre el país del mercado objetivo',
    'sidebar_send_intro' => 'Mensajería y otros mensajes, como correo SMS y notificaciones del sistema',
    'sidebar_account_intro' => 'Configuración de la función del Centro de cuentas',
    'sidebar_wallet_intro' => 'La billetera es una característica monetaria real, si necesita una función integral virtual, instale el complemento apropiado',
    'sidebar_wallet_tab_recharge_services_intro' => 'La configuración del proveedor de servicios de recarga se representará en la lista de funciones de "billetera" para las órdenes de pago o recargará la billetera',
    'sidebar_wallet_tab_withdraw_services_intro' => 'La configuración del proveedor de servicios de dispensación estará presente en la lista de funciones de "billetera", que se utiliza para el saldo de la billetera en efectivo en la cuenta especificada',
    'sidebar_user_intro' => 'Configuración de la función básica del usuario',
    'sidebar_content_intro' => 'Configuración de la función y el nombre del contenido social',
    'sidebar_interaction_intro' => 'La percepción del usuario sobre el servicio de un producto (sentido de la experiencia) no depende de la lógica técnica, sino del nombre de los puntos de función.',
    'sidebar_publish_intro' => 'Esta configuración es válida para todos los miembros, y la prioridad prioritaria es mayor que los permisos de roles del usuario',
    'sidebar_roles_intro' => 'El rol puede establecer configuraciones específicas para la identidad y permisos del usuario',
    'sidebar_stickers_intro' => 'Configuración personalizada Emotive, en el caso de no configurar, los usuarios también pueden ingresar a Emoji Expressions a través del teclado de Emoker',
    'sidebar_groups_intro' => 'El grupo de uso puede realizar varios escenarios de operación, como proyectos BBS, círculos comunitarios, clasificación de contenido',
    'sidebar_extend_editor_intro' => 'En el "Editor" del proceso de liberación, por ejemplo, la extensión "Vote" permite al "Editor" para admitir la función de votación que acompaña a la publicación',
    'sidebar_extend_content_type_intro' => 'La publicación se presentará en la página de la lista "POST", que se utiliza para emitir el mensaje "Tipo" especificado y definir la fuente de datos',
    'sidebar_extend_content_handler_intro' => 'La función es la misma que la función de origen de datos "Extensión de tipo de contenido", si la solicitud se distribuye al procesamiento del complemento, y la lógica de datos está determinada por el complemento',
    'sidebar_extend_manage_intro' => 'En la lista de características "más" de la publicación, el comentario, la página de inicio del usuario, como la extensión "queja", permite a los usuarios quejarse los objetivos correspondientes',
    'sidebar_extend_group_intro' => 'La presentación se presenta en la página de inicio "Grupo", como "complemento de extensión de enlace puro", puede mostrar un hipervínculo en la página de inicio "GRUPO"',
    'sidebar_extend_user_feature_intro' => 'La página "Mi" se presentará en el "Centro de usuario", como la extensión "billetera", le permite al usuario una función más billetera',
    'sidebar_extend_user_profile_intro' => 'En la lista de funciones de administración "Información del usuario", como "Modificar el complemento de nombre de usuario" permite que la información de modificación sea compatible con la modificación del nombre de usuario',
    'sidebar_extend_channel_intro' => 'Aparece en el menú principal o en una lista de páginas de canales; por ejemplo, la extensión Compras permite al usuario acceder al canal Centro comercial.',
    'sidebar_extend_command_words_intro' => 'Las palabras de comando configuradas en esta lista están disponibles para las solicitudes API.',
    'sidebar_channels_intro' => 'Configuración unificada de la información del canal individual del cliente.',
    'sidebar_paths_intro' => 'Las estructuras de rutas personalizadas pueden mejorar la estética, la usabilidad y la compatibilidad con el futuro de sus enlaces.',
    'sidebar_language_packs_intro' => 'Configure los contenidos de varios idiomas de cada texto para clientes multi-idioma',
    'sidebar_code_messages_intro' => 'Descripción multilingüe de los códigos de estado configurados para el programa principal y los complementos.',
    'sidebar_client_basic_intro' => 'Elementos de configuración general de la base de clientes.',
    'sidebar_client_status_intro' => 'Tras la desactivación, todas las páginas y acciones del cliente saltarán a la página de instrucciones de desactivación.',
    'sidebar_plugins_intro' => 'Características flexibles, las extensiones poderosas lo ayudan a jugar libremente',
    'sidebar_themes_intro' => 'Seleccione diferentes temas para lograr un estilo e interacción más personalizado',
    'sidebar_apps_intro' => 'API estándar, potentes extensiones, cree una variedad de escenarios operativos y modelos de aplicación a su gusto.',
    'sidebar_keys_intro' => 'Las credenciales clave son importantes, no las revelan fácilmente a otras personas',
    // Page button
    'button_support' => 'Apoyo',
    'button_update' => 'Actualizar',
    'button_search' => 'Búsqueda',
    'button_add' => 'Agregar',
    'button_edit' => 'Editar',
    'button_modify' => 'Modificar',
    'button_delete' => 'Borrar',
    'button_cancel' => 'Cancelar',
    'button_close' => 'Cerrar',
    'button_dismiss' => 'Descartar',
    'button_activate' => 'Activar',
    'button_deactivate' => 'Desactivar',
    'button_install' => 'Instalar',
    'button_uninstall' => 'Desinstalar',
    'button_setting' => 'Ajuste',
    'button_config' => 'Configurar',
    'button_reset' => 'Reiniciar',
    'button_confirm' => 'Confirmar',
    'button_try_again' => 'Inténtalo de nuevo',
    'button_save' => 'Salvar',
    'button_download' => 'Descargar',
    'button_upgrade' => 'Actualizar',
    'button_automatic_upgrade' => 'Actualización automática',
    'button_manual_upgrade' => 'Actualización manual',
    'button_confirm_delete' => 'Confirmar eliminación',
    'button_confirm_install' => 'Confirmar la instalación',
    'button_confirm_upgrade' => 'Confirmar la actualización',
    'button_confirm_download' => 'Confirmar descarga',
    'button_confirm_uninstall' => 'Confirmar desinstalar',
    'button_view' => 'Vista',
    'button_image_upload' => 'Subir',
    'button_image_input' => 'Aporte',
    'button_check_upgrade' => 'Comprobar la actualización',
    'button_check_status' => 'Comprobar estado',
    'button_batch_import' => 'Importar',
    'button_batch_export' => 'Exportar',
    'button_config_email_template' => 'Plantilla de correo electrónico de configuración',
    'button_config_sms_template' => 'Plantilla de configuración SMS',
    'button_config_sticker' => 'Pegatina de configuración',
    'button_config_permission' => 'Permiso de configuración',
    'button_config_language_pack' => 'Paquete de configuración',
    'button_add_admin' => 'Agregar admin',
    'button_add_language' => 'Añadir lang',
    'button_add_account_connect' => 'Añadir cuenta connect',
    'button_add_service_provider' => 'Añadir servicio',
    'button_add_sticker_group' => 'Agregar grupo de etiqueta',
    'button_add_sticker' => 'Añadir etiqueta',
    'button_add_role' => 'Añadir rol',
    'button_add_group' => 'Añadir grupo',
    'button_group_move' => 'Moverse',
    'button_add_key' => 'Agregar clave',
    'button_reset_key' => 'Tecla Reset',
    'button_reset_secret' => 'Reinicio secreto',
    'button_clear_cache' => 'borrar el caché',
    'button_clear_all_cache' => 'Borrar toda la caché',
    // Page table
    'table_order' => 'Ordenar',
    'table_recommend_order' => 'Recomendar Ordenar',
    'table_position' => 'Posición',
    'table_number' => 'Número',
    'table_lang_tag' => 'Etiqueta lang',
    'table_lang_name' => 'Nombre de lang',
    'table_title' => 'Título',
    'table_content' => 'Contenido',
    'table_platform' => 'Plataforma',
    'table_service' => 'Servicio',
    'table_app_id' => 'ID de aplicación',
    'table_app_key' => 'Clave de la aplicación',
    'table_app_secret' => 'App secreta',
    'table_plugin' => 'Enchufar',
    'table_command_word' => 'Palabra de mando',
    'table_name' => 'Nombre',
    'table_description' => 'Descripción',
    'table_icon' => 'Icono',
    'table_banner' => 'Bandera',
    'table_type' => 'Escribe',
    'table_use' => 'Utilizar',
    'table_support' => 'Apoyo',
    'table_data_source' => 'Fuente de datos',
    'table_scene' => 'Escena',
    'table_number_of_uses' => 'Número de usos',
    'table_scope' => 'Alcance',
    'table_scope_global' => 'Global',
    'table_scope_global_desc' => 'Se puede restringir a roles especificados',
    'table_scope_group_admins' => 'Administradores de grupo',
    'table_scope_group_admins_desc' => 'Cuando está habilitado, solo los administradores del grupo mostrarán el complemento',
    'table_authorized_roles' => 'Roles autorizados',
    'table_authorized_roles_desc' => 'Deje en blanco para indicar que todos los roles de usuario tienen derecho a usar',
    'table_whitelist_rules' => 'Rol de lista blanca',
    'table_parameter' => 'Parámetro',
    'table_status' => 'Estado',
    'table_options' => 'Opciones',
    // Config option
    'option_default' => 'Por defecto',
    'option_all' => 'Todo',
    'option_public' => 'Público',
    'option_private' => 'Privado',
    'option_visible' => 'Visible',
    'option_hidden' => 'Oculto',
    'option_open' => 'Abierto',
    'option_close' => 'Cerrar',
    'option_yes' => 'sí',
    'option_no' => 'No',
    'option_activate' => 'Activar',
    'option_deactivate' => 'Desactivar',
    'option_local' => 'Local',
    'option_remote' => 'Remoto',
    'option_required' => 'Requerido',
    'option_not_required' => 'No requerido',
    'option_not_set' => 'No se ha configurado',
    'option_no_use' => 'Sin uso',
    'option_unselect' => 'Deseleccionar',
    'option_optional' => 'Opcional',
    'option_email' => 'Correo electrónico',
    'option_sms' => 'SMS',
    'option_data_close' => 'No público',
    'option_data_private' => 'Solo yo',
    'option_data_public' => 'Público',
    'option_type_tree' => 'Árbol',
    'option_type_list' => 'Lista',
    'option_uninstall_plugin_data' => 'Eliminación simultánea de los datos del plugin',
    'option_uninstall_theme_data' => 'Eliminación simultánea de los datos del tema',
    // Commons
    'portal' => 'Portal',
    'user' => 'Usuario',
    'group' => 'Grupo',
    'hashtag' => 'Hashtag',
    'geotag' => 'Geotag',
    'post' => 'Correo',
    'comment' => 'Comentario',
    'file' => 'Archivo',
    'extend' => 'Ampliar contenido',
    'user_detail' => 'Inicio del usuario',
    'group_detail' => 'Detalle del grupo',
    'hashtag_detail' => 'Detalle del Hashtag',
    'geotag_detail' => 'Geotag Detalle',
    'post_detail' => 'Detalle de la publicación',
    'comment_detail' => 'Detalle del comentario',
    'like' => 'Me gusta',
    'dislike' => 'No me gusta',
    'follow' => 'Seguir',
    'block' => 'Bloquear',
    'author' => 'Autor',
    'new_version' => 'Nuevo',
    'default_language' => 'Idioma predeterminado',
    'default_list' => 'Lista por defecto',
    'recommend' => 'Recomendar',
    'unit_day' => 'Día',
    'unit_length' => 'Longitud',
    'unit_second' => 'Segundo',
    'unit_minute' => 'Minuto',
    'unit_within_minute' => 'Dentro de un minuto',
    'unit_character' => 'Personaje',
    'unit_number' => 'Número',
    'unit_number_of_times' => 'Número de veces',
    'unit_kilometer' => 'Kilómetro',
    'unit_mile' => 'Milla',
    'config_default' => 'Configuración por defecto',
    'config_name' => 'Nombre Config',
    'config_edit' => 'Editar Config',
    'config_interaction' => 'Configuración de interacción',
    'config_conversation' => 'Configuración de conversación',
    'config_hashtag' => 'Configuración de hashtag',
    'config_list' => 'Configuración de lista',
    'config_preview' => 'Config. vista previa',
    'config_manage' => 'Configuración de gestión',
    'delete_desc' => 'Seguro de borrar?',
    // Dashboard-Home
    'welcome' => 'Bienvenido a Fresns',
    'current_version' => 'La versión actual utilizada es',
    'overview' => 'Datos del sitio',
    'overview_accounts' => 'Cuentas',
    'overview_users' => 'Usuarios',
    'overview_groups' => 'Grupos',
    'overview_hashtags' => 'Hashtags',
    'overview_geotags' => 'Geotags',
    'overview_posts' => 'Entradas',
    'overview_comments' => 'Comentarios',
    'extensions' => 'Cantidad de solicitud',
    'support' => 'Manual de ayuda',
    'support_website' => 'Sitio web oficial de FRESNS',
    'support_teams' => 'Equipo de código abierto',
    'support_sponsor' => 'Patrocinador',
    'support_join' => 'Únete a nosotros',
    'support_community' => 'Comunidad de apoyo',
    'support_marketplace' => 'Mercado de aplicaciones',
    'system_info' => 'Mensaje del sistema',
    'system_info_server' => 'Sistema de servidor',
    'system_info_web' => 'Entorno de ejecución web',
    'system_info_php_version' => 'PHP versión',
    'system_info_php_cli_info' => 'PHP Cli info',
    'system_info_php_upload_max_filesize' => 'Subir el tamaño máximo del archivo',
    'system_info_composer_info' => 'Composer info',
    'system_info_composer_version' => 'Composer versión',
    'system_info_env_timezone' => '.env Zona horaria',
    'system_info_env_timezone_name' => '.env Identificador de zona horaria',
    'system_info_env_timezone_utc' => '.env Zona horaria UTC del identificador de zona horaria',
    'system_info_env_timezone_list' => 'Identificador de zona horaria correspondiente',
    'system_info_database_driver' => 'Controlador de base de datos',
    'system_info_database_version' => 'Versión de base de datos',
    'system_info_database_timezone' => 'Zona horaria de la base de datos',
    'system_info_database_engine' => 'Motor de valores de datos',
    'system_info_database_collation' => 'Reglas de clasificación de la base de datos',
    'system_info_database_size' => 'Tamaño actual de la base de datos',
    'tips' => 'Instrucciones de uso',
    'news' => 'FRESNS ACTIVIDADES Y NOTICIAS',
    // Dashboard-Events
    'event_subscribe_subject' => 'Tema',
    'event_crontab_time' => 'Ciclo de ejecución',
    'event_crontab_time_desc' => 'Formato de la tabla cron de programación de tareas de Laravel',
    // Dashboard-Caches
    'cache' => 'Caché',
    'cache_fresns_system' => 'Configuración del sistema',
    'cache_fresns_config' => 'Configuración del sitio',
    'cache_fresns_extend' => 'Ampliar configuración',
    'cache_fresns_view' => 'Ver',
    'cache_fresns_route' => 'Ruta',
    'cache_fresns_event' => 'Evento',
    'cache_fresns_schedule' => 'Programar',
    'cache_fresns_temporary' => 'Datos temporales',
    // Dashboard-Admins
    'admin_add_title' => 'Nuevo administrador del sistema',
    'admin_add_form_account' => 'cuenta',
    'admin_add_form_account_placeholder' => 'Correo electrónico o número de móvil',
    'admin_add_form_account_desc' => 'El número de teléfono móvil debe ser un número completo con el código de área internacional',
    'admin_add_form_account_btn' => 'Búsqueda y aumento',
    // Dashboard-Settings
    'setting_developer_options' => 'Opciones de desarrollo',
    'setting_developer_options_desc' => 'No desactive las opciones si no se trata de un entorno de desarrollo.',
    'setting_build_type' => 'Tipo de versión',
    'setting_build_type_desc' => 'La versión beta es menos estable, así que elige con cuidado.',
    'setting_build_select_tip' => 'Seleccione el tipo de versión de actualización',
    'setting_build_option_stable' => 'Stable Build',
    'setting_build_option_beta' => 'Beta Build',
    'setting_system_url' => 'URL del sistema',
    'setting_system_url_desc' => 'Direcciones de acceso por defecto para la API principal y los plugins',
    'setting_panel_path' => 'Entrada segura',
    'setting_panel_path_desc' => 'Después de la configuración, solo puede iniciar sesión en el panel de control especificando la entrada de seguridad',
    'setting_panel_url' => 'Entrada completa dirección',
    'setting_panel_url_desc' => 'Entrada de inicio de sesión del panel de control URL completa',
    'setting_panel_url_copy' => 'Copiar',
    // System-Languages
    'language_multilingual' => 'multi lenguaje',
    'language_table_default' => 'idioma predeterminado',
    'language_table_langCode' => 'Código de lenguaje',
    'language_table_areaCode' => 'Códigos de área',
    'language_table_langName' => 'Nombre del lenguaje',
    'language_table_areaName' => 'Nombre de la región',
    'language_table_lengthUnit' => 'Unidad de longitud',
    'language_table_writingDirection' => 'Dirección de escritura',
    'language_table_area' => 'Área de idioma',
    'language_table_dateFormat' => 'Formato de fecha',
    'language_table_dateFormat_desc' => 'YYYY dijo AÑO, MM dijo el mes, DD significa el cielo',
    'language_table_timeFormat' => 'Tiempo humano',
    'language_table_timeFormat_desc' => 'Nombre de la variable de tiempo {n}',
    'language_select_langCode' => 'Seleccione el código de idioma',
    'language_select_continent' => 'Continente',
    'language_select_areaCode' => 'Seleccione Código Regional',
    // System-General
    'site_url' => 'Sitio URL',
    'site_url_desc' => 'URL de acceso al sitio principal',
    'site_name' => 'Nombre del sitio',
    'site_name_desc' => 'El nombre de su sitio Fresns',
    'site_intro' => 'INTRODUCCIÓN DEL SITIO',
    'site_intro_desc' => 'Introducción a su sitio Fresns',
    'site_logo' => 'Signo del sitio',
    'site_logo_desc' => 'La información en "Configuración de almacenamiento" debe configurarse para cargar la imagen',
    'site_copyright' => 'informacion registrada',
    'site_email' => 'Buzón de administrador',
    'site_email_desc' => 'Al ejecutar un error, muestre al usuario que facilite los comentarios de los usuarios',
    'site_mode' => 'Modo de operación',
    'site_mode_public' => 'Modo de publicación',
    'site_mode_private' => 'Modo privado',
    'site_mode_private_desc' => 'Configuración de modo privado',
    'site_mode_private_join_status' => '¿Está abierto al exterior?',
    'site_mode_private_join_service' => 'Únete al complemento de soporte del canal',
    'site_mode_private_content_policy' => 'Estado privado vencido',
    'site_mode_private_content_policy_1' => 'El contenido del sitio no es visible',
    'site_mode_private_content_policy_2' => 'Contenido antes de la expiración, el nuevo contenido es invisible',
    // System-Policy
    'policy_terms' => 'Términos de servicio',
    'policy_privacy' => 'política de privacidad',
    'policy_cookie' => 'Política de cookie',
    'policy_delete_account' => 'Instrucciones de cierre de sesión',
    'policy_delete_options' => 'Función de cierre de sesión',
    'policy_delete_options_desc' => 'El usuario puede revocar la sesión de cierre de sesión (cuenta de recuperación) dentro del día del búfer, y el proceso de cancelación se ejecutará sin deshacer',
    'policy_delete_option_1' => 'No habilitar la función de cierre de sesión',
    'policy_delete_option_2' => 'Inicio de sesión lógico',
    'policy_delete_option_2_desc' => 'Cierre de sesión lógico: solo se notifica en la base de datos en la base de datos, no es cierto eliminar los datos',
    'policy_delete_option_3' => 'Cancelación física',
    'policy_delete_option_3_desc' => 'Cierre de sesión físico: los datos de eliminación física, los datos de usuario y el contenido publicado se eliminarán realmente',
    'policy_delete_crontab' => 'Ciclo de cierre de sesión',
    // System-Send
    'send_email_config' => 'Configuración del buzón',
    'send_sms_config' => 'Configuración de SMS',
    'send_sms_default_code' => 'Código de área internacional predeterminada',
    'send_sms_supported_codes' => 'Soporta más código de área',
    'send_sms_desc' => 'Una línea El representante en blanco solo apoya a un solo país. Confirme que el proveedor de servicios es compatible con la función Internacional SMS antes de la configuración',
    'send_app_notifications' => 'Servicio de notificaciones push',
    'send_app_ios_config' => 'Configuración de iOS',
    'send_app_ios_notifications_desc' => 'Función de notificación emergente del sistema iOS',
    'send_app_android_config' => 'Configuración de Android',
    'send_app_android_notifications_desc' => 'Función de notificación emergente del sistema Android',
    'send_app_desktop_config' => 'Configuración del escritorio',
    'send_app_desktop_notifications_desc' => 'Funciones de notificación del escritorio, como las notificaciones del navegador.',
    'send_code_template_1' => 'Código de verificación general',
    'send_code_template_2' => 'Registre una nueva cuenta',
    'send_code_template_3' => 'Modificar la información de la cuenta',
    'send_code_template_4' => 'Reemplace la nueva encuadernación',
    'send_code_template_5' => 'Restablecer la contraseña de inicio de sesión',
    'send_code_template_6' => 'Restablecer la contraseña de pago',
    'send_code_template_7' => 'Inicie sesión con un código de verificación',
    'send_code_template_8' => 'Eliminar la cuenta con el código de verificación',
    'send_code_template_table_email_desc' => 'APOYO FORMATO HTML',
    'send_code_template_table_sms_sign' => 'Nombre de la firma de SMS',
    'send_code_template_table_sms_code' => 'Parámetros de la plantilla',
    'send_code_template_table_sms_code_desc' => 'Puede configurar la identificación de la plantilla. Para obtener más información, consulte la descripción del complemento asociado',
    'send_code_template_table_sms_param' => 'Nombre de la variable de código de verificación',
    // System-Account
    'account_center_config' => 'Config del Centro de Cuentas',
    'account_child_safety' => 'Seguridad infantil',
    'account_age_verification' => 'Verificación de edad',
    'account_age_min_required' => 'Edad mínima requerida',
    'account_register_config' => 'Registro Config',
    'account_login_config' => 'Config de inicio de sesión',
    'account_password_config' => 'Config de contraseña',
    'account_center_service' => 'Centro de cuentas',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => 'Servicio de inicio de sesión',
    'account_register_status' => 'Si el registro abierto',
    'account_register_type' => 'Soporte de cuenta de registro',
    'account_register_type_email' => 'Correo electrónico',
    'account_register_type_phone' => 'Número de teléfono',
    'account_login_service' => 'Servicio de registro',
    'account_login_support' => 'Soporte de inicio de sesión',
    'account_login_type_email' => 'Correo electrónico',
    'account_login_type_phone' => 'Número de teléfono',
    'account_code_login' => 'Código de verificación Inicio de sesión',
    'account_login_or_register' => 'Registro automático si no hay ninguna cuenta disponible cuando se inicia la sesión con el código de verificación',
    'account_password_length' => 'Requisitos de longitud',
    'account_password_length_desc' => 'Requisitos de longitud: la longitud mínima, 0 o no llena no está limitada',
    'account_password_strength' => 'Requisitos de fuerza',
    'account_password_strength_desc' => 'Requisitos de fuerza: el tipo de carácter seleccionado debe estar presente en la contraseña, y no está limitado',
    'account_password_strength_digital' => 'número',
    'account_password_strength_lowerLetters' => 'Letras minusculas',
    'account_password_strength_upperLetters' => 'letra mayúscula',
    'account_password_strength_symbols' => 'Símbolo (división)',
    'account_connect_services' => 'Soporte de interconexión de terceros',
    'account_connect_services_desc' => 'Seleccione la plataforma de interconexión y los complementos asociados para realizar un registro rápido o inicio de sesión',
    'account_kyc_service' => 'Soporte de certificación de nombre real',
    'account_kyc_service_desc' => 'Después de instalar el complemento del servicio de autenticación, el usuario puede autenticar el nombre real',
    'account_users_service' => 'Gestión multiusuario',
    // System-Wallet
    'wallet_functions' => 'Función de la billetera',
    'wallet_functions_desc' => 'Si habilitar el paquete de dinero francés',
    'wallet_currency_code' => 'Código de moneda',
    'wallet_currency_name' => 'Nombre monetario',
    'wallet_currency_unit' => 'Unidad monetaria',
    'wallet_currency_precision' => 'Precisión de la moneda',
    'wallet_withdraw_status' => 'Dinero en efectivo',
    'wallet_withdraw_config' => 'Configuración de efectivo',
    'wallet_withdraw_config_desc' => 'Necesidades de configuración relacionadas adicionales para ser compatibles, consulte al desarrollador de plugin',
    'wallet_withdraw_review' => 'Dinero en efectivo',
    'wallet_withdraw_review_prove' => 'Traying para verificar la información del nombre real',
    'wallet_withdraw_periodicity' => 'Intervalo de efectivo',
    'wallet_withdraw_rates' => 'Tarifa de retiro de efectivo',
    'wallet_withdraw_min' => 'Importe mínimo de una sola extradición',
    'wallet_withdraw_max' => 'Importe máximo de un solo retiro',
    'wallet_withdraw_sum_limit' => 'Casquillo de retiro diario',
    // System-Storage
    'storage_service_config' => 'Configuración de almacenamiento',
    'storage_service_config_desc' => 'Los proveedores de servicios de almacenamiento pueden instalar más opciones en la App Store',
    'storage_function_config' => 'Configuración de la función',
    'storage_function_image_config' => 'Configuración de la función de procesamiento de imágenes',
    'storage_function_image_config_desc' => 'Los nombres de estilo o parámetros avanzados se pueden configurar. La compresión de la imagen de prueba, el zoom, la marca de agua, etc., "Identificador de intervalo" común es los caracteres de medio ancho "!", "-", "_". Apoye los parámetros avanzados, y consulte la documentación del desarrollador del proveedor de servicios de almacenamiento',
    'storage_function_video_config' => 'Configuración de la función de procesamiento de video',
    'storage_function_video_config_desc' => 'Puede configurar la identificación de la plantilla. Para obtener más información, consulte la descripción del complemento asociado',
    'storage_function_audio_config' => 'Configuración de la función de procesamiento de audio',
    'storage_function_audio_config_desc' => 'Puede configurar la identificación de la plantilla. Para obtener más información, consulte la descripción del complemento asociado',
    'storage_function_document_config' => 'Configuración de vista previa en línea',
    'storage_function_substitution_config' => 'Mapa de reemplazo de estado no válido',
    'storage_function_substitution_config_desc' => 'Cuando el estado del archivo de recursos es "inválido", se utiliza el mapa de indicación ilegítimo',
    'storage_function_substitution_image' => 'Imagen de la imagen no válida',
    'storage_function_substitution_video' => 'Pista de video no válida',
    'storage_function_substitution_audio' => 'Consejo de audio no válido',
    'storage_function_substitution_document' => 'Documento Mapa de solicitud no válido',
    'storage_service_provider' => 'Proveedor de servicios de almacenamiento',
    'storage_filesystem_disk' => 'Disco del sistema de archivos',
    'storage_file_access_domain' => 'Dominio de acceso',
    'storage_extension_names' => 'Extensión admitida',
    'storage_max_size' => 'Tamaño máximo soportado',
    'storage_max_duration' => 'Tiempo máximo admitido',
    'storage_temporary_url_status' => 'URL temporal',
    'storage_temporary_url_status_desc' => 'Si el plugin no admite la función de URL temporal, no lo abra; de lo contrario, no se podrá acceder al recurso.',
    'storage_temporary_url_key' => 'Clave de URL temporal',
    'storage_temporary_url_expiration' => 'Expiración de la URL temporal',
    'storage_image_handle_position' => 'Posición de la manija de la imagen',
    'storage_image_thumb_config' => 'Mapa de configuración',
    'storage_image_thumb_avatar' => 'Avatar',
    'storage_image_thumb_ratio' => 'Miniatura isométrica',
    'storage_image_thumb_square' => 'Miniatura cuadrada',
    'storage_image_thumb_big' => 'Mapa original comprimido',
    'storage_video_transcode_parameter' => 'Parámetros de transcodificación de video',
    'storage_video_watermark' => 'Video de parámetros de marca de agua',
    'storage_video_screenshot' => 'Parámetros de captura de pantalla de video',
    'storage_video_gift' => 'Parámetros del diagrama de rotación de video',
    'storage_video_poster_parameter' => 'Parámetro Cartel',
    'storage_video_transcode_handle_position' => 'Posición de procesamiento de parámetros de transcodificación de vídeo',
    'storage_video_poster_handle_position' => 'Posición de procesamiento de parámetros de póster',
    'storage_audio_transcode_parameter' => 'Parámetros de transcodificación de audio',
    'storage_audio_transcode_handle_position' => 'Posición de procesamiento de parámetros de transcodificación de audio',
    'storage_document_preview_service' => 'Servicio de vista previa de documentos',
    'storage_document_preview_extension_names' => 'Extensión de vista previa de soporte',
    // Operating-User
    'user_name' => 'Nombre personalizado de identidad',
    'user_name_desc' => 'Por ejemplo, "Usuario", "Miembro", "Comisionado" y otro nombrado',
    'user_uid_name' => 'ID Nombre personalizado',
    'user_uid_name_desc' => 'Por ejemplo, "UID", "ID", "Número de miembro" y otro nombrado',
    'user_username_name' => 'Nombre de usuario Nombre personalizado',
    'user_username_name_desc' => 'Por ejemplo, "Nombre de usuario", "Nombre de miembro", "Cuenta" y otros nombrados',
    'user_nickname_name' => 'Nombre personalizado de apodo',
    'user_nickname_name_desc' => 'Por ejemplo, "Apodo", "Nombre de la flor", "Código" y otro nombrado',
    'user_role_name' => 'Nombre personalizado del rol',
    'user_role_name_desc' => 'Por ejemplo, "rol", "grupo de usuarios", "grupo de usuarios" y otro nombrado',
    'user_bio_name' => 'Nombre personalizado de la biografía',
    'user_bio_name_desc' => 'Ejemplo: Bio o Introducción',
    'user_default_role' => 'Papel de usuario predeterminado',
    'user_default_role_desc' => 'Rol de usuario predeterminado después del registro',
    'user_default_avatar' => 'Avatar de usuario predeterminado',
    'user_default_avatar_desc' => 'El diagrama de avatar predeterminado cuando el usuario no establece el Avatar',
    'user_default_anonymous_avatar' => 'Avatar de usuario anónimo',
    'user_default_anonymous_avatar_desc' => 'Contenido publicado Anónimo Diagrama de Avatar',
    'user_default_deactivate_avatar' => 'Avatar de usuario',
    'user_default_deactivate_avatar_desc' => 'Imagen de Avatar después del cierre de sesión del usuario o desactivación',
    'user_identifier' => 'Identificador de usuario',
    'user_identifier_desc' => 'Qué marca predomina en la interacción con el usuario',
    'user_uid_digit' => 'UID del usuario Dígito inicial',
    'user_uid_digit_desc' => 'Número de dígitos generados aleatoriamente durante el registro',
    'user_profile_desc' => 'Lista de contenidos por defecto al visitar la página de inicio de un usuario',
    'user_ban_names' => 'Prohibir nombres',
    'user_ban_names_desc' => 'Un nombre por línea. El uso de estos nombres de usuario y apodos está prohibido.',
    'user_edit_username_length' => 'Longitud del nombre de usuario',
    'user_edit_username_length_min' => 'Longitud mínima',
    'user_edit_username_length_max' => 'La longitud máxima',
    'user_edit_username_length_desc' => 'Nombre de usuario Longitud mínima y longitud máxima',
    'user_edit_username_periodicity' => 'Nombre de intervalo de modificación de nombre de usuario',
    'user_edit_nickname_length' => 'Longitud del apodo',
    'user_edit_nickname_periodicity' => 'Número de intervalo de modificación de apodo de usuario',
    'user_edit_nickname_unique' => 'Apodo Único',
    'user_edit_bio_length' => 'Bio Longitud',
    'user_edit_bio_support' => 'Soporte de la biografía',
    'user_bio_support_mention' => 'Mencionar al usuario',
    'user_bio_support_link' => 'Enlace',
    'user_bio_support_hashtag' => 'Hashtag',
    'user_extcredits_config' => 'Extcredits Configuración',
    'user_extcredits_name' => 'Extcredits Nombre',
    'user_extcredits_unit' => 'Nombre de la unidad',
    'user_extcredits_state_not_enabled' => 'No habilitado',
    'user_extcredits_state_private' => 'Privado',
    'user_extcredits_state_public' => 'Público',
    'user_conversation_status' => 'Sesión de carta privada',
    'user_conversation_status_desc' => 'Cerrar es válido para todos los miembros, y está sujeto a los derechos de roles del usuario después de abrir',
    'user_conversation_files' => 'Función de accesorios de sesión',
    'user_conversation_files_desc' => 'Si no todos lo comprueban, el representante solo admite la conversación de texto puro',
    // Operating-User-Profile
    'profile_posts' => 'Sus publicaciones',
    'profile_comments' => 'Sus comentarios',
    'profile_likers' => 'Usuarios a quienes les gustaron',
    'profile_dislikers' => 'Usuarios a quienes no les gustaron',
    'profile_followers' => 'Usuarios que les siguieron',
    'profile_blockers' => 'Usuarios que les bloquearon',
    'profile_followers_you_follow' => 'Seguidores que conoces',
    'profile_likes_users' => 'Les gustan los usuarios',
    'profile_likes_groups' => 'Les gustan los grupos',
    'profile_likes_hashtags' => 'Les gustan los hashtags',
    'profile_likes_geotags' => 'Les gustan los geotags',
    'profile_likes_posts' => 'Les gustan las publicaciones',
    'profile_likes_comments' => 'Les gustan los comentarios',
    'profile_dislikes_users' => 'No les gustan los usuarios',
    'profile_dislikes_groups' => 'No les gustan los grupos',
    'profile_dislikes_hashtags' => 'No les gustan los hashtags',
    'profile_dislikes_geotags' => 'No les gustan los geotags',
    'profile_dislikes_posts' => 'No les gustan las publicaciones',
    'profile_dislikes_comments' => 'No les gustan los comentarios',
    'profile_following_users' => 'Siguen a los usuarios',
    'profile_following_groups' => 'Siguen a los grupos',
    'profile_following_hashtags' => 'Siguen a los hashtags',
    'profile_following_geotags' => 'Siguen a los geotags',
    'profile_following_posts' => 'Siguen a las publicaciones',
    'profile_following_comments' => 'Siguen a los comentarios',
    'profile_blocking_users' => 'Bloquean a los usuarios',
    'profile_blocking_groups' => 'Bloquean a los grupos',
    'profile_blocking_hashtags' => 'Bloquean a los hashtags',
    'profile_blocking_geotags' => 'Bloquean a los geotags',
    'profile_blocking_posts' => 'Bloquean a las publicaciones',
    'profile_blocking_comments' => 'Bloquean a los comentarios',
    // Operating-Content
    'content_group_name' => 'Nombre personalizado del grupo',
    'content_group_name_desc' => 'Por ejemplo, "Edición", "Círculo", "Clasificación" y otros nombrados',
    'content_hashtag_name' => 'Tema Nombre personalizado',
    'content_hashtag_name_desc' => 'Por ejemplo, "super como", "Etiqueta", "Temas", etc',
    'content_post_name' => 'Publicar nombre de contenido',
    'content_post_name_desc' => 'Por ejemplo, "Publicar", "Dinámica", "Hablar", etc',
    'content_comment_name' => 'Comentar el nombre de contenido',
    'content_comment_name_desc' => 'Por ejemplo, "Comentarios", "Respuesta", "Interacción" y otros nombrados',
    'content_publish_post_name' => 'Publicar un nombre de comportamiento poste',
    'content_publish_post_name_desc' => 'Por ejemplo, "publicado", "sumisión", "Comentarios" y otros nombrados',
    'content_publish_comment_name' => 'Publicar un comentario Nombre de comportamiento',
    'content_publish_comment_name_desc' => 'Por ejemplo, "Responder", "Responder", "Seguir Post" y otras nombradas',
    'content_mention_status' => 'Mención Estado',
    'content_mention_number' => 'Número de menciones',
    'content_mention_number_desc' => 'El número de menciones de usuario por contenido, 0 significa que no hay limitación.',
    'content_hashtag_status' => 'Estado de los hashtags',
    'content_hashtag_format' => 'Formato de hashtag',
    'content_hashtag_format_1' => 'Solo #',
    'content_hashtag_format_2' => 'Doble #',
    'content_hashtag_format_desc' => '<a href="#">#tema</a> y <a href="#">#tema#</a>',
    'content_hashtag_length' => 'Lunghezza degli hashtag',
    'content_hashtag_number' => 'Número de Hashtag',
    'content_hashtag_number_desc' => 'El número de hashtags admitidos por pieza de contenido, 0 significa que no hay limitación.',
    'content_hashtag_regexp' => 'Espressione regolare degli hashtag',
    'content_nearby_length' => 'Campo di ricerca predefinito per la ricerca nelle vicinanze',
    'content_nearby_length_desc' => 'Ambito di ricerca quando si visualizzano i contenuti nelle vicinanze',
    'content_post_brief_length' => 'Extracto posterior',
    'content_post_brief_length_desc' => 'El poste excede este valor establecido adoptará un resumen, el número de palabras de resumen de contenido de gran tamaño',
    'content_comment_brief_length' => 'Resumen de comentarios',
    'content_comment_brief_length_desc' => 'Comentario Antes del valor establecido adoptará un resumen, supervise el resumen de contenido de la longitud',
    'content_comment_visibility_rule' => 'Normas de visibilidad de los comentarios',
    'content_comment_visibility_rule_desc' => 'Los comentarios estarán ocultos si el post ha sido publicado durante más de unos días, 0 significa que no está habilitado',
    'content_preview_post_like_users' => 'Vista previa de los usuarios a los que les ha gustado una entrada',
    'content_preview_post_like_users_desc' => 'Vista previa de los usuarios a los que les ha gustado el post, el número representa el número de vistas previas.',
    'content_preview_post_comments' => 'Vista previa de los comentarios',
    'content_preview_post_comments_desc' => 'Vista previa de los comentarios en la página de la lista de entradas, el número representa el número de comentarios previsualizados.',
    'content_preview_post_comment_require' => 'Condiciones de previsualización de comentarios',
    'content_preview_post_comment_require_desc' => 'Contar el número de comentarios antes de la salida de la vista previa',
    'content_preview_comment_like_users' => 'Comentario como usuario vista previa',
    'content_preview_comment_replies' => 'Vista previa de las respuestas a los comentarios',
    'content_post_edit_config' => 'Permisos de edición de entradas',
    'content_post_delete_config' => 'Permisos de eliminación de entradas',
    'content_comment_edit_config' => 'Permisos de edición de comentarios',
    'content_comment_delete_config' => 'Permisos de eliminación de comentarios',
    'content_edit_desc' => '¿Puedo editar después de publicar?',
    'content_delete_desc' => '¿Puedo borrar después de publicar?',
    // Operating-Interaction
    'interaction_function_status' => 'Estado de la función',
    'interaction_operation_name' => 'Nombre de la operación',
    'interaction_user_title' => 'Título de usuario',
    'interaction_public_record' => 'Registro público',
    'interaction_public_count' => 'Recuento público',
    'interaction_column_name' => 'Nombre de columna',
    // Operating-Sticker
    'sticker_group' => 'Grupo de expresión',
    'sticker_table_group_name' => 'Nombre del grupo de emociones',
    'sticker_table_group_image' => 'Icono de grupo de emociones',
    'sticker_table_group_code' => 'Logotipo del grupo de emociones',
    'sticker_table_quantity' => 'Número de expresiones',
    'sticker_manage' => 'Gestión de expresión',
    'sticker_table_image' => 'Carta de expresión',
    'sticker_table_code' => 'Emoticonos',
    // Operating-Editor
    'editor_group' => 'grupo',
    'editor_title' => 'título',
    'editor_sticker' => 'expresión',
    'editor_image' => 'imagen',
    'editor_video' => 'video',
    'editor_audio' => 'Audio',
    'editor_document' => 'Documentación',
    'editor_mention' => 'Anexo',
    'editor_hashtag' => 'tema',
    'editor_extend' => 'extensiones',
    'editor_location' => 'posición',
    'editor_anonymous' => 'anónimo',
    'editor_upload_image_type' => 'Formulario de carga de imágenes',
    'editor_upload_video_type' => 'Formulario de carga de vídeo',
    'editor_upload_audio_type' => 'Formulario de carga de audio',
    'editor_upload_document_type' => 'Formulario de carga de documentos',
    'editor_upload_image_number' => 'Número máximo de imágenes cargadas',
    'editor_upload_video_number' => 'Número máximo de vídeos cargados',
    'editor_upload_audio_number' => 'Número máximo de subidas de audio',
    'editor_upload_document_number' => 'Número máximo de documentos cargados',
    // Operating-Publish
    'publish_editor_config' => 'Selección de editor',
    'publish_editor_function_status' => 'Función del editor',
    'publish_editor_function_options' => 'Configuración de la función del editor',
    'publish_post_verify_config' => 'Publicar una solicitud de publicación',
    'publish_comment_verify_config' => 'Publicar una solicitud de comentario',
    'publish_post_rules_config' => 'Publicar una regla posterior especial',
    'publish_comment_rules_config' => 'Publicar una revisión regla especial',
    'publish_editor_desc' => 'Editor publicado',
    'publish_verify_desc' => 'Las cuentas deben completarse con la información seleccionada para su publicación',
    'publish_rules_desc' => 'Todos los empleados son válidos, la prioridad es mayor que las reglas de roles',
    'publish_rule_type' => 'Tipo de Regla',
    'publish_rule_datetime' => 'Rango de fechas',
    'publish_rule_time' => 'límite de tiempo',
    'publish_rule_timezone' => 'Zona horaria estándar',
    'publish_rule_rule' => 'Requisitos de la regla',
    'publish_rule_tip' => 'Regla',
    'publish_edit_time_limit' => '¿Cuánto tiempo puedes editar?',
    'publish_edit_sticky_limit' => 'Después de Sticky',
    'publish_edit_digest_limit' => 'Después de Digest',
    'publish_editor_group_required' => 'Si se requiere el grupo',
    'publish_editor_group_required_desc' => 'Al publicar publicaciones, ¿tienes que elegir?',
    'publish_editor_title_input_box' => 'Pantalla del cuadro de entrada del título',
    'publish_editor_title_input_box_desc' => 'La pantalla débil requiere que el usuario seleccione manualmente el cuadro de entrada del título',
    'publish_editor_title_required' => 'Si el título debe ser lleno',
    'publish_editor_title_required_desc' => 'Al publicar poste, el título debe estar lleno',
    'publish_editor_title_length' => 'Límite de palabra de título',
    'publish_editor_title_length_desc' => 'El número de títulos no debe exceder el número de configuraciones, el límite superior máximo de 255 caracteres',
    'publish_editor_post_content_length' => 'Límite de publicación de palabra',
    'publish_editor_post_content_length_desc' => 'El número de publicaciones no excederá el número de configuraciones, mínimo límite superior 140 caracteres',
    'publish_editor_comment_content_length' => 'Límite de palabra de comentarios',
    'publish_editor_comment_content_length_desc' => 'El número de comentarios no debe exceder el número de configuraciones, mínimo límite superior 140 caracteres',
    // Operating-Permission
    'permission_option_email' => 'Correo electrónico obligatorio',
    'permission_option_phone' => 'Teléfono Obligatorio',
    'permission_option_kyc' => 'Se requiere KYC',
    'permission_option_rule_datetime' => 'Efectivo dentro del intervalo de fechas especificado',
    'permission_option_rule_time' => 'Especifique un ciclo de tiempo dentro del período de tiempo especificado',
    'permission_option_review_publish' => 'Se puede publicar, pero es necesario revisar',
    'permission_option_close_publish' => 'Prohibir la publicación',
    'permission_option_can_be_edited' => 'Editable',
    'permission_option_cannot_be_edited' => 'No se puede editar',
    'permission_option_can_be_deleted' => 'Se puede borrar',
    'permission_option_cannot_be_deleted' => 'No se puede borrar',
    'permission_option_direct_release' => 'Pase directamente',
    'permission_option_required_review' => 'Necesito revisar',
    'permission_option_title_optional_display' => 'Exhibición débil',
    'permission_option_title_direct_display' => 'Exhibición fuerte',
    // Operating-Roles
    'role_table_display' => 'Mostrar logo',
    'role_table_nickname_color' => 'Color de apodo',
    'role_option_display_icon' => 'Icono de pantalla',
    'role_option_display_text' => 'Texto',
    'role_option_close_nickname_color' => 'No use colores',
    'role_current' => 'Rol actual',
    'role_target' => 'Rol de destino',
    'role_target_desc' => 'Una vez que se elimina la función, el usuario se fusiona con el nombre de la función de destino seleccionado bajo la función',
    'role_perm_basic_config' => 'Ajustes básicos',
    'role_perm_post_config' => 'Publicar un ajuste de publicación',
    'role_perm_comment_config' => 'Publicar un comentario',
    'role_perm_upload_config' => 'Configuración de carga',
    'role_perm_interaction_config' => 'Configuración interactiva',
    'role_perm_customize_config' => 'Configuración personalizada',
    'role_perm_content_view' => 'Permiso de navegación',
    'role_perm_conversation' => 'Permiso de sesión',
    'role_perm_content_link_handle' => 'Gestión de enlaces para los contenidos publicados',
    'role_perm_content_link_handle_1' => 'No resolver y enmascarar el nombre de dominio',
    'role_perm_content_link_handle_2' => 'No se resuelve pero se muestra como texto',
    'role_perm_content_link_handle_3' => 'Análisis sintáctico normal',
    'role_perm_post_publish' => 'Publicar un permiso de publicación',
    'role_perm_post_verify' => 'Publicar una solicitud de publicación',
    'role_perm_post_review' => 'Publicar una regla de publicación',
    'role_perm_post_rules' => 'Publicar una regla posterior especial',
    'role_perm_post_time_interval' => 'Contabilizar el intervalo de tiempo',
    'role_perm_post_daily_count' => 'Publicar límite diario',
    'role_perm_post_draft_count' => 'Límite de número de borradores de correo',
    'role_perm_comment_publish' => 'Publicar privilegios de comentarios',
    'role_perm_comment_verify' => 'Publicar una solicitud de comentario',
    'role_perm_comment_review' => 'Publicar una regla de comentarios',
    'role_perm_comment_rules' => 'Publicar una revisión regla especial',
    'role_perm_comment_time_interval' => 'Intervalo de tiempo de los comentarios',
    'role_perm_comment_daily_count' => 'Límite diario de comentarios',
    'role_perm_comment_draft_count' => 'Comentario Borrador Límite de Número',
    'role_perm_upload_image' => 'cargar imagen',
    'role_perm_upload_video' => 'Subir video',
    'role_perm_upload_audio' => 'Subir audio',
    'role_perm_upload_document' => 'Cargar documento',
    'role_perm_upload_file_desc' => 'Comprobación del representante tiene el derecho de cargar, el cuadro de entrada deja en blanco utiliza la "Configuración de almacenamiento" como el parámetro predeterminado',
    'role_perm_follow_user_max_count' => 'Seguir el recuento máximo de usuarios',
    'role_perm_block_user_max_count' => 'Bloquear el número máximo de usuarios',
    'role_perm_download_file_count' => 'Descarga el límite superior dentro de las 24 horas',
    'role_perm_table_name' => 'Nombre de la autoridad',
    'role_perm_table_value' => 'Valor de permiso',
    // Operating-Groups
    'group_table_parent_group' => 'Grupo de padres',
    'group_table_subgroup' => 'Subgrupo',
    'group_table_privacy' => 'Privacidad',
    'group_table_visibility' => 'Visibilidad',
    'group_table_follow_method' => 'Método Follow',
    'group_table_recommend' => '¿Se recomienda?',
    'group_table_admins' => 'Administrador del grupo',
    'group_table_can_publish' => 'Puede publicar',
    'group_table_post_permissions' => 'Permisos de publicación',
    'group_table_comment_permissions' => 'Permisos de comentario',
    'group_table_publish_perm_role' => 'Papel con el derecho a publicar',
    'group_table_publish_perm_review' => '¿Necesitas una auditoría?',
    'group_table_publish_perm_review_desc' => 'Los administradores de grupos no están restringidos',
    'group_public_desc' => 'Abierto (cualquiera puede ver el post dentro del grupo)',
    'group_private_desc' => 'No público (solo los miembros pueden ver las publicaciones dentro del grupo)',
    'group_visible_desc' => 'Se puede encontrar (cualquiera puede encontrar este grupo)',
    'group_hidden_desc' => 'No encuentre (solo los miembros pueden encontrar este grupo)',
    'group_publish_option_all' => 'Todo el mundo',
    'group_publish_option_members' => 'Solo pagando solo al grupo de usuarios',
    'group_publish_option_roles' => 'Solo usuarios de roles especificados',
    'group_publish_option_admins' => 'Sólo administradores de grupos',
    'group_can_publish_desc' => 'Los permisos de publicación de cierre pueden utilizarse como categorización de grupos',
    'group_current' => 'Grupo actual',
    'group_target' => 'Grupo objetivo',
    'group_target_desc' => 'Después de la fusión, se eliminará el grupo anterior, y los contenidos del grupo anterior se migrarán al nombre del equipo de destino seleccionado',
    // Extends
    'extend_editor_menus' => 'Menús',
    'extend_editor_toolbar' => 'Barra de herramientas',
    'extend_editor_number_of_uses_desc' => 'Ejemplos de complementos de "votación", el número es 2, que representa una sola publicación, se pueden incluir 2 votos',
    'extend_content_service' => 'Servicio de contenidos',
    'extend_content_list' => 'Lista de contenidos',
    'extend_content_detail' => 'Detalles del contenido',
    'extend_content_search' => 'Búsqueda de contenido',
    'extend_content_list_desc' => 'Esta configuración tiene mayor prioridad que la configuración del tipo de contenido, y cuando se configura, se sustituye la fuente de datos especificada por el tipo de contenido.',
    'extend_content_ip' => 'Servicio IP',
    'extend_content_map' => 'Servicio de mapas',
    'extend_content_notifications_service' => 'Notificar al Servicio',
    'extend_content_review' => 'Servicio de revisión',
    'extend_content_list_by_all' => 'Todas las entradas o comentarios',
    'extend_content_list_by_timelines' => 'Cronología de entradas o comentarios',
    'extend_content_list_by_nearby' => 'Entradas o comentarios cercanos',
    'extend_content_by_detail' => 'Detalle de la entrada o el comentario',
    'extend_content_search_users' => 'Buscar usuarios',
    'extend_content_search_groups' => 'Buscar grupos',
    'extend_content_search_hashtags' => 'Buscar Hashtags',
    'extend_content_search_geotags' => 'Buscar geoetiquetas',
    'extend_content_search_posts' => 'Buscar mensajes',
    'extend_content_search_comments' => 'Buscar comentarios',
    // Client-Channels
    'channel_default_homepage' => 'Página de inicio predeterminada',
    'channel_table_channel' => 'Canal',
    'channel_table_page' => 'Página',
    'channel_table_page_home' => 'Inicio',
    'channel_table_page_list' => 'Lista',
    'channel_table_page_detail' => 'Detalle',
    'channel_table_page_interaction' => 'Interacción',
    'channel_table_path' => 'Ruta',
    'channel_table_seo' => 'Información SEO',
    'channel_table_seo_title' => 'Título de SEO',
    'channel_table_seo_description' => 'SEO Descripción',
    'channel_table_seo_keywords' => 'SEO Palabra clave',
    'channel_table_query_state' => 'Paso del lado del cliente',
    'channel_table_query_state_desc' => 'Aceptar o no los pases del lado del cliente, cuando se desactiva sólo se admiten los valores de los parámetros por defecto',
    'channel_table_query_config' => 'Parámetros predeterminados',
    'channel_table_query_config_desc' => 'Consulte los parámetros de consulta de la API de esta interfaz',
    'channel_query_state_1' => 'No se aceptan parámetros del cliente',
    'channel_query_state_2' => 'Aceptar sólo los parámetros de paginación del cliente',
    'channel_query_state_3' => 'Aceptar todos los parámetros',
    // Client-Columns
    'channel_timeline' => 'Cronología',
    'channel_timeline_all_posts' => 'Todas las publicaciones seguidas',
    'channel_timeline_user_posts' => 'Sigo publicaciones de usuarios',
    'channel_timeline_group_posts' => 'Sigo publicaciones de grupos',
    'channel_timeline_hashtag_posts' => 'Sigo publicaciones con hashtags',
    'channel_timeline_geotag_posts' => 'Sigo publicaciones con geotags',
    'channel_timeline_all_comments' => 'Todos los comentarios seguidos',
    'channel_timeline_user_comments' => 'Sigo comentarios de usuarios',
    'channel_timeline_group_comments' => 'Sigo comentarios de grupos',
    'channel_timeline_hashtag_comments' => 'Sigo los comentarios de hashtags',
    'channel_timeline_geotag_comments' => 'Sigo los comentarios de geotags',
    'channel_nearby' => 'Cerca de',
    'channel_nearby_posts' => 'Publicado por Nearby',
    'channel_nearby_comments' => 'Comentarios de Cerca',
    'channel_me' => 'Centro Personal',
    'channel_me_extcredits' => 'Extcredits',
    'channel_me_wallet' => 'Cartera',
    'channel_me_drafts' => 'Borradores',
    'channel_me_users' => 'Usuarios',
    'channel_me_settings' => 'Configuración',
    'channel_messages' => 'Mensajes',
    'channel_conversations' => 'Conversaciones',
    'channel_notifications' => 'Notificaciones',
    'channel_notifications_all' => 'Notificar-Alle',
    'channel_notifications_systems' => 'Notificar-Systems',
    'channel_notifications_recommends' => 'Notificar-Recomendar',
    'channel_notifications_likes' => 'Notificar-gustos',
    'channel_notifications_dislikes' => 'Notificar-No me gusta',
    'channel_notifications_follows' => 'Notificar-Sigue',
    'channel_notifications_blocks' => 'Notificar-Bloqueos',
    'channel_notifications_mentions' => 'Notificar-Menciones',
    'channel_notifications_comments' => 'Notificar-Comentarios',
    'channel_notifications_quotes' => 'Notificar-Cita',
    'channel_search' => 'búsqueda',
    // Client-Keys
    'key_table_read_only' => 'Sólo lectura',
    'key_select_platform' => 'Seleccione la plataforma de aplicaciones clave',
    'key_option_main_api' => 'API principal',
    'key_option_manage_api' => 'API de gestión',
    'key_option_plugin_api' => 'API de plugin',
    'key_option_plugin_api_select' => 'Seleccione el complemento para usar',
    'key_option_plugin_api_select_desc' => 'Esta clave solo puede solicitar la API del complemento asociado',
    // Client-Basic
    'website_stat_code' => 'Código estadístico del sitio',
    'website_stat_code_desc' => 'No se admite el uso de código estadístico que contenga document.write.',
    'website_stat_position' => 'Ubicación del código estadístico',
    'website_stat_position_desc' => 'Dónde se carga el código de estadísticas en el HTML.',
    'china_mode' => 'Modo China',
    'china_mode_desc' => 'Información requerida cuando el servidor del sitio está desplegado en China.',
    'china_mode_config' => 'Configuración del servidor de China continental (campo no obligatorio)',
    'china_icp_filing' => 'Presentación del proveedor de contenidos de Internet',
    'china_icp_license' => 'Licencia de proveedor de contenidos de Internet',
    'china_mps_filing' => 'Presentación de la Oficina de Seguridad Pública',
    'china_broadcasting_license' => 'Licencia de radiodifusión',
    // Client-Status
    'client_status_desc' => 'El cliente solicita la configuración del estado cada 10 minutos',
    // App-Center-Themes
    'website_engine_config' => 'Configuración del motor',
    'website_engine_api_config' => 'Configuración API',
    'website_engine_status' => 'Estado del motor',
    'website_engine_api_type' => 'Tipo de API del motor',
    'website_engine_key_id' => 'Seleccione la clave de la aplicación',
    'website_engine_view_desktop' => 'Ordenador',
    'website_engine_view_mobile' => 'Móvil',
    // App-Center-Install
    'install_website_engine' => 'Instalar el motor del sitio web',
    'install_plugin' => 'Instalar Plugin',
    'install_application' => 'Instalar aplicación',
    'install_mode' => 'Modo de instalación',
    'install_mode_fskey' => 'Introducir la clave de Fresns',
    'install_mode_upload' => 'Subir el paquete Zip',
    'install_mode_directory' => 'Ruta del directorio de entrada',
    'download_application' => 'Descargar aplicación',
];
