<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresnsコントロールパネル',
    'fresns_core' => 'Fresnsメインプログラム',
    // Login page
    'language' => '言語',
    'login' => 'ログイン',
    'account' => 'アカウント',
    'password' => 'パスワード',
    'enter' => '入力',
    'operation' => 'パネル操作',
    'site_home' => 'ウェブサイトホーム',
    'switch_language' => 'スイッチの言語',
    'logout' => 'ログアウト',
    // Header menus
    'menu_dashboard' => 'ダッシュボード',
    'menu_systems' => 'システム',
    'menu_operations' => '操作',
    'menu_extends' => '伸びる',
    'menu_clients' => 'クライアント',
    'menu_app_center' => 'アプリセンター',
    'menu_marketplace' => '市場',
    // Sidebar menus
    'sidebar_home' => '家',
    'sidebar_admins' => 'アドミン',
    'sidebar_events' => 'イベント情報',
    'sidebar_events_tab_subscribe' => 'サブスクライブ',
    'sidebar_events_tab_crontab' => 'クロンダブ',
    'sidebar_caches' => 'キャッシュ',
    'sidebar_caches_tab_config' => 'コンフィグキャッシュ',
    'sidebar_caches_tab_data' => 'データキャッシュ',
    'sidebar_upgrades' => 'アップグレード',
    'sidebar_settings' => '設定',
    'sidebar_languages' => '言語',
    'sidebar_storage' => '保管所',
    'sidebar_storage_tab_image' => '画像',
    'sidebar_storage_tab_video' => 'ビデオ',
    'sidebar_storage_tab_audio' => 'オーディオ',
    'sidebar_storage_tab_document' => '書類',
    'sidebar_storage_tab_substitution' => '代替品',
    'sidebar_general' => '全般的',
    'sidebar_policy' => 'ポリシー',
    'sidebar_policy_tab_options' => 'オプション',
    'sidebar_policy_tab_contents' => 'コンテンツ',
    'sidebar_send' => '送信',
    'sidebar_send_tab_services' => 'サービスを送る',
    'sidebar_send_tab_templates' => 'コードテンプレートを確認します',
    'sidebar_account' => 'アカウント',
    'sidebar_wallet' => '財布',
    'sidebar_wallet_tab_options' => 'オプション',
    'sidebar_wallet_tab_recharge_services' => '充電サービス',
    'sidebar_wallet_tab_withdraw_services' => 'サービスを撤回します',
    'sidebar_user' => 'ユーザー',
    'sidebar_content' => 'コンテンツ',
    'sidebar_interaction' => 'インタラクション',
    'sidebar_publish' => '公開',
    'sidebar_publish_tab_post' => '役職',
    'sidebar_publish_tab_comment' => 'コメント',
    'sidebar_roles' => '役割',
    'sidebar_stickers' => 'ステッカー',
    'sidebar_groups' => '団体',
    'sidebar_groups_tab_active' => 'アクティブ',
    'sidebar_groups_tab_deactivate' => '非活性',
    'sidebar_groups_tab_recommend' => '推奨のみを表示します',
    'sidebar_extend_editor' => '編集者',
    'sidebar_extend_content_type' => 'コンテンツタイプ',
    'sidebar_extend_content_handler' => 'コンテンツハンドラ',
    'sidebar_extend_manage' => '管理',
    'sidebar_extend_group' => 'グループ',
    'sidebar_extend_group_filter' => 'フィルター',
    'sidebar_extend_user_feature' => 'ユーザーの機能',
    'sidebar_extend_user_profile' => 'ユーザープロファイル',
    'sidebar_extend_channel' => 'チャンネル',
    'sidebar_extend_command_words' => 'コマンドワード',
    'sidebar_channels' => 'チャンネル',
    'sidebar_paths' => 'パス',
    'sidebar_language_packs' => '言語パック',
    'sidebar_code_messages' => 'コードメッセージ',
    'sidebar_client_basic' => 'ベース',
    'sidebar_client_status' => 'ステータス',
    'sidebar_plugins' => 'プラグイン',
    'sidebar_plugins_tab_all' => '全て',
    'sidebar_plugins_tab_active' => 'アクティブ',
    'sidebar_plugins_tab_inactive' => '非活性',
    'sidebar_themes' => 'テーマ',
    'sidebar_apps' => 'アプリケーション',
    'sidebar_keys' => 'アプリキー',
    // Sidebar intro
    'sidebar_admins_intro' => 'コントロールパネルにログインする権利を持つユーザー',
    'sidebar_events_intro' => 'システム上の時間指定タスクと購読イベントの表示',
    'sidebar_caches_intro' => 'キャッシュを全てクリアする場合、サーバーの負荷が増える可能性がありますので、アクセスの集中する時間帯を避けてご利用ください。',
    'sidebar_upgrades_intro' => 'ついに',
    'sidebar_settings_intro' => '設定完了後、キャッシュをクリアするか、新しいキャッシュが有効になるまで10分ほどお待ちください。',
    'sidebar_languages_intro' => '多言語は、対応する設定項目に多言語コンテンツを入力する前に、ここで言語オプションを構成する必要があります。',
    'sidebar_storage_intro' => '4つのリソースファイルを別々に保存することも、同じで保存することも、ストレージ構成情報を記入するだけです。',
    'sidebar_general_intro' => '実行中のシステムの設定項目を保護します。',
    'sidebar_policy_intro' => 'ターゲット市場の国に関する関連データ法規制によると。',
    'sidebar_send_intro' => 'メールSMSやシステム通知などのメッセージングおよびその他のメッセージ。',
    'sidebar_account_intro' => 'アカウントセンター機能設定',
    'sidebar_wallet_intro' => 'Walletは実際の金融機能です。仮想積分機能が必要な場合は、適切なプラグインをインストールしてください。',
    'sidebar_wallet_tab_recharge_services_intro' => '充電サービスプロバイダの設定は、支払い注文の「財布」機能リストにレンダリングされたり、財布を再充電します。',
    'sidebar_wallet_tab_withdraw_services_intro' => 'ディスペンスサービスプロバイダの設定は、指定されたアカウントでの現金に対する財布の残高に使用されている「Wallet」機能リストに掲載されます。',
    'sidebar_user_intro' => 'ユーザー基本機能設定',
    'sidebar_content_intro' => 'ソーシャルコンテンツ名と機能設定',
    'sidebar_interaction_intro' => '製品のサービスに対するユーザーの知覚（体験の感覚）は、技術的な論理ではなく、機能ポイントの命名に依存します。',
    'sidebar_publish_intro' => 'この設定はすべてのメンバーに対して有効であり、優先順位の優先順位はユーザーロール権限よりも大きい。',
    'sidebar_roles_intro' => '役割は、ユーザーIDとアクセス許可の特定の設定を設定できます。',
    'sidebar_stickers_intro' => 'カスタム構成の感情的な、構成されていない場合は、Emojedキーボードを介してEmoji式を入力することもできます。',
    'sidebar_groups_intro' => '使用グループは、BBSプロジェクト、コミュニティサークル、コンテンツ分類などのさまざまな操作シナリオを実現できます。',
    'sidebar_extend_editor_intro' => 'リリースプロセスの「エディタ」には、例えば、「投票」の拡張子が「編集者」が投稿に付随する投票機能をサポートすることを可能にする。',
    'sidebar_extend_content_type_intro' => 'POSTは「POST」リストページに表示されます。これは、指定された「Type」というメッセージを出力し、データのソースを定義します。',
    'sidebar_extend_content_handler_intro' => 'この関数は、「コンテンツタイプ拡張機能」データソース関数と同じであり、要求がプラグイン処理に配布され、データロジックはプラグインによって決定されます。',
    'sidebar_extend_manage_intro' => 'POST、コメント、ユーザーホームページの「その他」機能リストでは、ユーザーが対応するターゲットを不平を言うことができます。',
    'sidebar_extend_group_intro' => 'プレゼンテーションは「純粋なリンク拡張プラグイン」など、「グループ」のホームページなどの「グループ」のホームページに表示されます。「Group」のホームページでハイパーリンクを表示できます。',
    'sidebar_extend_user_feature_intro' => '「マイ」ページは、「Wallet」拡張子などの「ユーザーセンター」に表示され、ユーザーはより多くの財布機能を可能にします。',
    'sidebar_extend_user_profile_intro' => '「ユーザ名プラグインの変更」などの「ユーザ情報」管理機能のリストには、修正情報がユーザ名の変更をサポートすることができる。',
    'sidebar_extend_channel_intro' => 'メインメニューやチャンネルページのリストに表示されます。例えば、ショッピングの拡張機能を使用すると、ユーザーはモールチャンネルにアクセスできます。',
    'sidebar_extend_command_words_intro' => 'このリストで設定されたコマンド・ワードは、APIリクエストで使用できます。',
    'sidebar_channels_intro' => 'クライアントの各チャンネル情報を統一的に設定。',
    'sidebar_paths_intro' => 'カスタムパス構造は、リンクの美しさ、使いやすさ、前方互換性を向上させることができます。',
    'sidebar_language_packs_intro' => '多言語クライアントの各テキストの多言語内容を設定します。',
    'sidebar_code_messages_intro' => 'メインプログラムおよびプラグインに設定されたステータスコードを多言語で説明します。',
    'sidebar_client_basic_intro' => 'クライアントベースの一般的な設定項目。',
    'sidebar_client_status_intro' => '非アクティブ化後、すべてのクライアントページとアクションは非アクティブ化の指示ページにジャンプします。',
    'sidebar_plugins_intro' => '柔軟な機能、強力な拡張機能はあなたが自由に遊ぶのを助けます。',
    'sidebar_themes_intro' => 'より個人化されたスタイルとやり取りを達成するために、さまざまなトピックを選択してください。',
    'sidebar_apps_intro' => '標準API、強力な拡張機能で、様々な運用シナリオやアプリケーションモデルを自由に作成できます。',
    'sidebar_keys_intro' => '主な資格情報が重要ですが、他の人に簡単に開示しないでください。',
    // Page button
    'button_support' => 'サポート',
    'button_update' => '更新',
    'button_search' => '検索',
    'button_add' => '追加',
    'button_edit' => '編集',
    'button_modify' => '修正する',
    'button_delete' => '消去',
    'button_cancel' => 'キャンセル',
    'button_close' => '閉じる',
    'button_dismiss' => '解散',
    'button_activate' => '活性化',
    'button_deactivate' => '無効にする',
    'button_install' => 'インストール',
    'button_uninstall' => 'アンインストール',
    'button_setting' => '設定',
    'button_config' => 'コンフィグ',
    'button_reset' => 'リセットする',
    'button_confirm' => '確認',
    'button_try_again' => 'もう一度お試しください',
    'button_save' => 'セーブ',
    'button_download' => 'ダウンロード',
    'button_upgrade' => 'アップグレード',
    'button_automatic_upgrade' => '自動アップグレード',
    'button_manual_upgrade' => 'マニュアルアップグレード',
    'button_confirm_delete' => '削除を確認してください',
    'button_confirm_install' => 'インストールを確認する',
    'button_confirm_upgrade' => 'アップグレードを確認します',
    'button_confirm_download' => 'ダウンロードの確認',
    'button_confirm_uninstall' => 'アンインストールを確認してください',
    'button_view' => '意見',
    'button_image_upload' => 'アップロード',
    'button_image_input' => '入力',
    'button_check_upgrade' => 'アップグレードを確認してください',
    'button_check_status' => 'ステータス確認',
    'button_batch_import' => '輸入',
    'button_batch_export' => '輸出',
    'button_config_email_template' => '電子メールテンプレートを設定します',
    'button_config_sms_template' => '設定SMSテンプレート',
    'button_config_sticker' => '設定ステッカー',
    'button_config_permission' => '設定権限',
    'button_config_language_pack' => 'Config Pack',
    'button_add_admin' => 'addinを追加してください',
    'button_add_language' => 'Langを追加します',
    'button_add_account_connect' => 'アカウント接続を追加します',
    'button_add_service_provider' => 'サービスを追加します',
    'button_add_sticker_group' => 'ステッカーグループを追加します',
    'button_add_sticker' => 'ステッカーを追加してください',
    'button_add_role' => '役割を追加します',
    'button_add_group' => 'グループを追加します',
    'button_group_move' => '動く',
    'button_add_key' => 'キーを追加してください',
    'button_reset_key' => 'キーをリセット',
    'button_reset_secret' => '秘密のリセット',
    'button_clear_cache' => 'クリアキャッシュ',
    'button_clear_all_cache' => 'すべてのキャッシュを消去',
    // Page table
    'table_order' => 'ソート順',
    'table_recommend_order' => 'おすすめソート順',
    'table_position' => 'ポジション',
    'table_number' => '番号',
    'table_lang_tag' => 'Lang Tag',
    'table_lang_name' => 'Lang Name',
    'table_title' => 'タイトル',
    'table_content' => 'コンテンツ',
    'table_platform' => 'プラットホーム',
    'table_service' => 'サービス',
    'table_app_id' => 'アプリID',
    'table_app_key' => 'アプリキー',
    'table_app_secret' => 'アプリの秘密',
    'table_plugin' => 'プラグイン',
    'table_command_word' => 'コマンドワード',
    'table_name' => '名前',
    'table_description' => '説明',
    'table_icon' => 'アイコン',
    'table_banner' => 'バナー',
    'table_type' => 'タイプ',
    'table_use' => '使用する',
    'table_support' => 'サポート',
    'table_data_source' => '情報源',
    'table_scene' => 'シーン',
    'table_number_of_uses' => '利用数',
    'table_scope' => '範囲',
    'table_scope_global' => 'グローバル',
    'table_scope_global_desc' => '指定された役割に制限することができます',
    'table_scope_group_admins' => 'グループ管理者',
    'table_scope_group_admins_desc' => '有効にすると、グループ管理者だけがプラグインを表示します',
    'table_authorized_roles' => '許可された役割',
    'table_authorized_roles_desc' => 'すべてのユーザーロールが使用する権利があることを示すために、空白のままにします。',
    'table_whitelist_rules' => 'ホワイトリストの役割',
    'table_parameter' => 'パラメータ',
    'table_status' => 'スターテス',
    'table_options' => 'オプション',
    // Config option
    'option_default' => 'ディフォルト',
    'option_all' => 'すべて',
    'option_public' => 'パブリック',
    'option_private' => '非公開',
    'option_visible' => '見える',
    'option_hidden' => '隠れた',
    'option_open' => '開ける',
    'option_close' => '選ぶ',
    'option_yes' => 'はい',
    'option_no' => '番号',
    'option_activate' => '活性化',
    'option_deactivate' => '無効にする',
    'option_local' => 'ローカル',
    'option_remote' => 'リモート',
    'option_required' => '必須',
    'option_not_required' => '必須ではありません',
    'option_not_set' => '未設定',
    'option_no_use' => '使用しない',
    'option_unselect' => '選択解除',
    'option_optional' => '任意の',
    'option_email' => 'Eメール',
    'option_sms' => 'SMS',
    'option_data_close' => '非公開',
    'option_data_private' => '自分のみ',
    'option_data_public' => '公開',
    'option_type_tree' => '木',
    'option_type_list' => 'リスト',
    'option_uninstall_plugin_data' => 'プラグインデータの同時削除',
    'option_uninstall_theme_data' => 'テーマデータの同時削除',
    // Commons
    'portal' => 'ポータル',
    'user' => 'ユーザー',
    'group' => 'グループ',
    'hashtag' => 'ハッシュタグ',
    'geotag' => 'ジオタグ',
    'post' => '役職',
    'comment' => 'コメント',
    'file' => 'ファイル',
    'extend' => 'コンテンツの拡張',
    'user_detail' => 'ユーザーホーム',
    'group_detail' => 'グループ詳細',
    'hashtag_detail' => 'ハッシュタグの詳細',
    'geotag_detail' => 'ジオタグ詳細',
    'post_detail' => '投稿の詳細',
    'comment_detail' => 'コメント詳細',
    'like' => '好き',
    'dislike' => '嫌い',
    'follow' => 'フォローする',
    'block' => 'ブロック',
    'author' => '著者',
    'new_version' => '新しい',
    'default_language' => 'デフォルト言語',
    'default_list' => 'デフォルトリスト',
    'recommend' => 'おすすめ順',
    'unit_day' => '日',
    'unit_length' => '長さ',
    'unit_second' => '2番',
    'unit_minute' => '分',
    'unit_within_minute' => '分以内に',
    'unit_character' => 'キャラクター',
    'unit_number' => '回数',
    'unit_number_of_times' => '回数',
    'unit_kilometer' => 'キロメートル',
    'unit_mile' => 'マイル',
    'config_default' => 'デフォルト設定',
    'config_name' => 'コンフィグ名',
    'config_edit' => '編集コンフィグ',
    'config_interaction' => 'インタラクション設定',
    'config_conversation' => '会話コンフィグ',
    'config_hashtag' => 'ハッシュタグコンフィグ',
    'config_list' => 'リスト設定',
    'config_preview' => 'プレビュー設定',
    'config_manage' => '管理コンフィグ',
    'delete_desc' => '必ず削除してください？',
    // Dashboard-Home
    'welcome' => 'Fresnsへようこそ',
    'current_version' => '現在のバージョンが使用されています',
    'overview' => 'サイトデータ',
    'overview_accounts' => 'アカウント',
    'overview_users' => 'ユーザー',
    'overview_groups' => 'グループ',
    'overview_hashtags' => 'ハッシュタグ',
    'overview_geotags' => 'ジオタグ',
    'overview_posts' => '投稿',
    'overview_comments' => 'コメント',
    'extensions' => 'アプリケーション量',
    'support' => '助けて',
    'support_website' => 'Fresns公式サイト',
    'support_teams' => 'オープンソースチーム',
    'support_sponsor' => 'スポンサー',
    'support_join' => '参加しませんか',
    'support_community' => 'コミュニティをサポートします',
    'support_marketplace' => 'アプリケーションマーケット',
    'system_info' => 'システムメッセージ',
    'system_info_server' => 'サーバーシステム',
    'system_info_web' => 'Webランニング環境',
    'system_info_php_version' => 'PHP バージョン',
    'system_info_php_cli_info' => 'PHP Cli インフォメーション',
    'system_info_php_upload_max_filesize' => '最大ファイルサイズをアップロードする',
    'system_info_composer_info' => 'Composer インフォメーション',
    'system_info_composer_version' => 'Composer バージョン',
    'system_info_env_timezone' => '.env タイムゾーン',
    'system_info_env_timezone_name' => '.env タイムゾーン識別子',
    'system_info_env_timezone_utc' => '.env タイムゾーン識別子のUTCタイムゾーン',
    'system_info_env_timezone_list' => 'タイムゾーン識別子と一致するもの',
    'system_info_database_driver' => 'データベースドライバ',
    'system_info_database_version' => 'データベースバージョン',
    'system_info_database_timezone' => 'データベースタイムゾーン',
    'system_info_database_engine' => 'データ在庫エンジン',
    'system_info_database_collation' => 'データベースの並べ替えルール',
    'system_info_database_size' => '現在のデータベースサイズ',
    'tips' => '使用説明書',
    'news' => 'Fresnsイベント＆ニュース',
    // Dashboard-Events
    'event_subscribe_subject' => 'テーマ',
    'event_crontab_time' => '実行サイクル',
    'event_crontab_time_desc' => 'Laravelタスクスケジューリングcronテーブル形式',
    // Dashboard-Caches
    'cache' => 'キャッシュ',
    'cache_fresns_system' => 'システム構成',
    'cache_fresns_config' => 'サイト構成',
    'cache_fresns_extend' => '拡張設定',
    'cache_fresns_view' => '表示',
    'cache_fresns_route' => 'ルート',
    'cache_fresns_event' => 'イベント',
    'cache_fresns_schedule' => 'スケジュール',
    'cache_fresns_temporary' => '一時データ',
    // Dashboard-Admins
    'admin_add_title' => '新しいシステム管理者',
    'admin_add_form_account' => 'アカウント',
    'admin_add_form_account_placeholder' => '電子メールまたは携帯電話番号',
    'admin_add_form_account_desc' => '携帯電話番号は、国際市外局番を使用した全番号でなければなりません。',
    'admin_add_form_account_btn' => '検索と増加',
    // Dashboard-Settings
    'setting_developer_options' => 'デベロッパーオプション',
    'setting_developer_options_desc' => '開発環境でない場合は、オプションを解除しないでください。',
    'setting_build_type' => 'バージョンの種類',
    'setting_build_type_desc' => 'ベータ版は安定性が低いので、慎重に選んでください。',
    'setting_build_select_tip' => 'アップグレードバージョンの種類を選択',
    'setting_build_option_stable' => '安定版 (Stable Build)',
    'setting_build_option_beta' => 'ベータ版 (Beta Build)',
    'setting_system_url' => 'システムURL',
    'setting_system_url_desc' => 'メインAPIとプラグインのデフォルトアクセスアドレス',
    'setting_panel_path' => '安全なエントリー',
    'setting_panel_path_desc' => '設定後、セキュリティエントリを指定してコントロールパネルにのみログインできます。',
    'setting_panel_url' => '入り口完成住所',
    'setting_panel_url_desc' => 'コントロールパネルログインエントリの完了URL',
    'setting_panel_url_copy' => 'コピー',
    // System-Languages
    'language_multilingual' => '多言語',
    'language_table_default' => '既定の言語',
    'language_table_langCode' => '言語コード',
    'language_table_areaCode' => 'エリアコード',
    'language_table_langName' => '言語名',
    'language_table_areaName' => '地域の名前',
    'language_table_lengthUnit' => '長さ単位',
    'language_table_writingDirection' => '執筆方向に',
    'language_table_area' => '言語エリア',
    'language_table_dateFormat' => '日付形式',
    'language_table_dateFormat_desc' => 'Yyyyは今年、MMは月に言った、DDは天国を意味します。',
    'language_table_timeFormat' => '人間の時間',
    'language_table_timeFormat_desc' => '時間変数名{n}',
    'language_select_langCode' => '言語コードを選択してください',
    'language_select_continent' => '大陸',
    'language_select_areaCode' => '地域コードを選択してください',
    // System-General
    'site_url' => 'サイトのURL',
    'site_url_desc' => 'メインサイトのアクセスURL',
    'site_name' => 'サイト名',
    'site_name_desc' => 'Fresnsのサイト名です。',
    'site_intro' => 'サイトの紹介',
    'site_intro_desc' => 'Fresnsサイトの紹介です。',
    'site_logo' => 'サイトサイン',
    'site_logo_desc' => '「ストレージ設定」の情報は、画像をアップロードするように設定する必要があります。',
    'site_copyright' => '著作権情報',
    'site_email' => '管理者メールボックス',
    'site_email_desc' => 'エラーを実行するときは、ユーザーのフィードバックを容易にするためにユーザーを表示します。',
    'site_mode' => '動作モード',
    'site_mode_public' => '出版モード',
    'site_mode_private' => 'プライベートモード',
    'site_mode_private_desc' => 'プライベートモードの設定',
    'site_mode_private_join_status' => '外側に開いていますか？',
    'site_mode_private_join_service' => 'チャネルサポートプラグインに参加してください',
    'site_mode_private_content_policy' => '民間期限切れの状態',
    'site_mode_private_content_policy_1' => 'サイトの内容が表示されていません',
    'site_mode_private_content_policy_2' => '満了前のコンテンツ、新しいコンテンツは見えない',
    // System-Policy
    'policy_terms' => '利用規約',
    'policy_privacy' => 'プライバシーポリシー',
    'policy_cookie' => 'クッキーポリシー',
    'policy_delete_account' => 'ログアウトの指示',
    'policy_delete_options' => 'ログアウト機能',
    'policy_delete_options_desc' => 'ユーザーはバッファーの日内のログアウト（回復アカウント）を取り消すことができ、解除されずにキャンセル処理が実行されます。',
    'policy_delete_option_1' => 'ログアウト機能を有効にしないでください',
    'policy_delete_option_2' => '論理ログイン',
    'policy_delete_option_2_desc' => 'ロジックログアウト：データベースにのみ通知されているデータベースに通知されているため、データを削除するには当てはまりません。',
    'policy_delete_option_3' => '身体キャンセル',
    'policy_delete_option_3_desc' => '物理ログアウト：物理削除データ、ユーザーデータ、および公開コンテンツは本当に削除されます。',
    'policy_delete_crontab' => 'ログアウトサイクル',
    // System-Send
    'send_email_config' => 'メールボックスの設定',
    'send_sms_config' => 'SMS構成',
    'send_sms_default_code' => 'デフォルトの国際市域コード',
    'send_sms_supported_codes' => 'より多くの市外局番をサポート',
    'send_sms_desc' => '1回線につき1つの市外局番。空白の代表者は単一の国だけをサポートします。構成の前にサービスプロバイダのサポート国際SMS機能を確認してください。',
    'send_app_notifications' => 'プッシュ通知サービス',
    'send_app_ios_config' => 'iOS構成',
    'send_app_ios_notifications_desc' => 'iOSシステムポップアップ通知機能',
    'send_app_android_config' => 'Androidの設定',
    'send_app_android_notifications_desc' => 'Androidシステムポップアップ通知機能',
    'send_app_desktop_config' => 'デスクトップの構成',
    'send_app_desktop_notifications_desc' => 'ブラウザ通知などのデスクトップ通知機能。',
    'send_code_template_1' => '一般確認コード',
    'send_code_template_2' => '新しい口座を登録します',
    'send_code_template_3' => 'アカウント情報を変更します',
    'send_code_template_4' => '新しいバインディングを置き換えます',
    'send_code_template_5' => 'ログインパスワードをリセットします',
    'send_code_template_6' => '支払いパスワードをリセットします',
    'send_code_template_7' => '確認コードでログインします',
    'send_code_template_8' => 'ベリファイコードによるアカウント削除',
    'send_code_template_table_email_desc' => 'HTMLフォーマットをサポートします',
    'send_code_template_table_sms_sign' => 'SMS署名の名前',
    'send_code_template_table_sms_code' => 'テンプレートパラメータ',
    'send_code_template_table_sms_code_desc' => 'テンプレートIDを設定できます。詳細は、関連するプラグインの説明を参照してください。',
    'send_code_template_table_sms_param' => '検証コード変数名',
    // System-Account
    'account_center_config' => 'アカウントセンター設定',
    'account_child_safety' => '子供の安全',
    'account_age_verification' => '年齢確認',
    'account_age_min_required' => '最低必要年齢',
    'account_register_config' => '登録設定',
    'account_login_config' => 'ログイン設定',
    'account_password_config' => 'パスワード設定',
    'account_center_service' => 'アカウントセンター',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => '登録サービス',
    'account_register_status' => 'オープン登録かどうか',
    'account_register_type' => 'アカウントのサポートを登録します',
    'account_register_type_email' => '電子メール',
    'account_register_type_phone' => '電話番号',
    'account_login_service' => 'ログインサービス',
    'account_login_support' => 'ログインサポート',
    'account_login_type_email' => '電子メール',
    'account_login_type_phone' => '電話番号',
    'account_code_login' => 'ベリファイコードログイン',
    'account_login_or_register' => '認証コードログイン時に利用可能なアカウントがない場合の自動登録',
    'account_password_length' => '長さ要件',
    'account_password_length_desc' => '長さ要件：最小長、0または充填されていない。',
    'account_password_strength' => '強さの要件',
    'account_password_strength_desc' => '強度要件：選択した文字タイプはパスワードに存在する必要があり、限定されません。',
    'account_password_strength_digital' => '番号',
    'account_password_strength_lowerLetters' => '小文字',
    'account_password_strength_upperLetters' => '大文字',
    'account_password_strength_symbols' => 'シンボル（部門）',
    'account_connect_services' => 'サードパーティの相互接続サポート',
    'account_connect_services_desc' => 'インターコネリングプラットフォームとアソシエイトプラグインを選択して、迅速な登録またはログインを行います。',
    'account_kyc_service' => '本名認証支援',
    'account_kyc_service_desc' => '認証サービスプラグインをインストールした後、ユーザーはReal-Nameを認証できます。',
    'account_users_service' => 'マルチユーザー管理',
    // System-Wallet
    'wallet_functions' => '財布',
    'wallet_functions_desc' => 'フランスのお金のパッケージを有効にするかどうか',
    'wallet_currency_code' => '通貨コード',
    'wallet_currency_name' => '金額',
    'wallet_currency_unit' => '通貨単位',
    'wallet_currency_precision' => '通貨の正確さ',
    'wallet_withdraw_status' => '現金',
    'wallet_withdraw_config' => '現金構成',
    'wallet_withdraw_config_desc' => '追加の関連設定をサポートする必要がある場合は、プラグイン開発者を参照してください。',
    'wallet_withdraw_review' => '現金',
    'wallet_withdraw_review_prove' => '実名情報を確認する',
    'wallet_withdraw_periodicity' => '現金間隔',
    'wallet_withdraw_rates' => '現金払い戻し料',
    'wallet_withdraw_min' => '単一の引き渡し最小量',
    'wallet_withdraw_max' => '単一撤退最大量',
    'wallet_withdraw_sum_limit' => '毎日の撤退キャップ',
    // System-Storage
    'storage_service_config' => 'ストレージ構成',
    'storage_service_config_desc' => 'ストレージサービスプロバイダは、App Storeにさらに選択をインストールできます。',
    'storage_function_config' => '機能構成',
    'storage_function_image_config' => '画像処理機能の設定',
    'storage_function_image_config_desc' => 'スタイル名または高度なパラメータを設定できます。テスト画像圧縮、ズーム、透かし入れなど、一般的な「間隔識別子」は半角文字「！」、「 - 」、「_」です。高度なパラメータをサポートし、ストレージサービスプロバイダの開発者のマニュアルを参照してください。',
    'storage_function_video_config' => 'ビデオ処理機能の設定',
    'storage_function_video_config_desc' => 'テンプレートIDを設定できます。詳細は、関連するプラグインの説明を参照してください。',
    'storage_function_audio_config' => 'オーディオ処理機能の設定',
    'storage_function_audio_config_desc' => 'テンプレートIDを設定できます。詳細は、関連するプラグインの説明を参照してください。',
    'storage_function_document_config' => 'オンラインプレビュー構成',
    'storage_function_substitution_config' => '無効な状態交換マップ',
    'storage_function_substitution_config_desc' => 'リソースファイルのステータスが「無効」の場合、不正な表示マップが使用されます。',
    'storage_function_substitution_image' => '画像無効なヒント',
    'storage_function_substitution_video' => 'ビデオ無効なヒント',
    'storage_function_substitution_audio' => '音声無効なヒント',
    'storage_function_substitution_document' => 'ドキュメント無効なプロンプトマップ',
    'storage_service_provider' => 'ストレージサービスプロバイダー',
    'storage_filesystem_disk' => 'ファイルシステムディスク',
    'storage_file_access_domain' => 'アクセスドメイン',
    'storage_extension_names' => 'サポートされている拡張子',
    'storage_max_size' => 'サポートされている最大サイズ',
    'storage_max_duration' => 'サポートされている最大時間',
    'storage_temporary_url_status' => '一時URL',
    'storage_temporary_url_status_desc' => 'プラグインが一時URL機能に対応していない場合は、開かないでください。',
    'storage_temporary_url_key' => '一時URLキー',
    'storage_temporary_url_expiration' => '一時URLの有効期限',
    'storage_image_handle_position' => '画像ハンドル位置',
    'storage_image_thumb_config' => '構成マップ',
    'storage_image_thumb_avatar' => 'アバター',
    'storage_image_thumb_ratio' => '等尺性サムネイル',
    'storage_image_thumb_square' => '正方形のサムネイル',
    'storage_image_thumb_big' => 'オリジナルの圧縮マップ',
    'storage_video_transcode_parameter' => 'ビデオトランスコーディングパラメータ',
    'storage_video_watermark' => 'ビデオ透かしパラメータ',
    'storage_video_screenshot' => 'ビデオスクリーンショットパラメータ',
    'storage_video_gift' => 'ビデオ回転図のパラメータ',
    'storage_video_poster_parameter' => 'ポスターパラメータ',
    'storage_video_transcode_handle_position' => 'ビデオトランスコードパラメータ処理位置',
    'storage_video_poster_handle_position' => 'ポスターパラメータ処理位置',
    'storage_audio_transcode_parameter' => 'オーディオトランスコーディングパラメータ',
    'storage_audio_transcode_handle_position' => 'オーディオトランスコードパラメータ処理位置',
    'storage_document_preview_service' => 'ドキュメント・プレビュー・サービス',
    'storage_document_preview_extension_names' => 'プレビューの拡張機能をサポートします',
    // Operating-User
    'user_name' => 'アイデンティティカスタムネーム',
    'user_name_desc' => 'たとえば、「ユーザー」、「メンバー」、「コミッショナー」、その他の名前付き',
    'user_uid_name' => 'IDカスタム名',
    'user_uid_name_desc' => 'たとえば、「uid」、「ID」、「メンバー番号」、その他の名前付き',
    'user_username_name' => 'ユーザー名カスタム名',
    'user_username_name_desc' => 'たとえば、「ユーザー名」、「メンバー名」、「アカウント」、その他の名前などです。',
    'user_nickname_name' => 'ニックネームカスタム名',
    'user_nickname_name_desc' => 'たとえば、「ニックネーム」、「フラワー名」、「コード」、その他の名前付き',
    'user_role_name' => '役割のカ​​スタム名',
    'user_role_name_desc' => 'たとえば、「役割」、「ユーザーグループ」、「ユーザーグループ」、その他の名前を付けました。',
    'user_bio_name' => 'バイオカスタム名',
    'user_bio_name_desc' => '例 バイオまたはイントロダクション',
    'user_default_role' => 'デフォルトのユーザーロール',
    'user_default_role_desc' => '登録後のデフォルトのユーザーロール',
    'user_default_avatar' => 'デフォルトユーザーアバター',
    'user_default_avatar_desc' => 'ユーザーがアバターを設定しない場合のデフォルトのアバター・ダイアグラム',
    'user_default_anonymous_avatar' => '匿名ユーザーアバター',
    'user_default_anonymous_avatar_desc' => 'コンテンツ発行匿名アバターダイアグラム',
    'user_default_deactivate_avatar' => 'ユーザーアバター',
    'user_default_deactivate_avatar_desc' => 'ユーザーログアウトまたは無効化後のアバター画像',
    'user_identifier' => 'ユーザー識別子',
    'user_identifier_desc' => 'ユーザーとのインタラクションでどのマークが優勢か',
    'user_uid_digit' => 'User UID 開始桁',
    'user_uid_digit_desc' => '登録時にランダムに生成される桁数',
    'user_profile_desc' => 'ユーザーのホームページにアクセスした際のデフォルトのコンテンツリスト',
    'user_ban_names' => '名前禁止',
    'user_ban_names_desc' => '1行に1つの名前。これらのユーザー名やニックネームの使用は禁止されています。',
    'user_edit_username_length' => 'ユーザー名の長さ',
    'user_edit_username_length_min' => '最小長さ',
    'user_edit_username_length_max' => '最大長さ',
    'user_edit_username_length_desc' => 'ユーザー名最小長さと最大長',
    'user_edit_username_periodicity' => 'ユーザー名変更間隔番号',
    'user_edit_nickname_length' => 'ニックネームの長さ',
    'user_edit_nickname_periodicity' => 'ユーザーのニックネームの修正間隔番号',
    'user_edit_nickname_unique' => 'ニックネーム ユニーク',
    'user_edit_bio_length' => 'バイオの長さ',
    'user_edit_bio_support' => 'バイオサポート',
    'user_bio_support_mention' => 'ユーザーへの言及',
    'user_bio_support_link' => 'リンク',
    'user_bio_support_hashtag' => 'ハッシュタグ',
    'user_extcredits_config' => 'Extcreditsコンフィギュレーション',
    'user_extcredits_name' => 'Extcredits名称',
    'user_extcredits_unit' => 'ユニット名',
    'user_extcredits_state_not_enabled' => '有効でない',
    'user_extcredits_state_private' => 'プライベート',
    'user_extcredits_state_public' => 'パブリック',
    'user_conversation_status' => 'プライベートレターセッション',
    'user_conversation_status_desc' => 'CLOSEはすべてのメンバーに対して有効であり、オープニング後のユーザーロール権利の対象となります。',
    'user_conversation_files' => 'セッションアクセサリー機能',
    'user_conversation_files_desc' => 'すべてがチェックされていない場合、代表者は純粋なテキストの会話のみをサポートします',
    // Operating-User-Profile
    'profile_posts' => '彼らの投稿',
    'profile_comments' => '彼らのコメント',
    'profile_likers' => '彼らを好きなユーザー',
    'profile_dislikers' => '彼らを嫌うユーザー',
    'profile_followers' => '彼らをフォローしたユーザー',
    'profile_blockers' => '彼らをブロックしたユーザー',
    'profile_followers_you_follow' => 'あなたが知っているフォロワー',
    'profile_likes_users' => '彼らはユーザーが好き',
    'profile_likes_groups' => '彼らはグループが好き',
    'profile_likes_hashtags' => '彼らはハッシュタグが好き',
    'profile_likes_geotags' => '彼らはジオタグが好き',
    'profile_likes_posts' => '彼らは投稿が好き',
    'profile_likes_comments' => '彼らはコメントが好き',
    'profile_dislikes_users' => '彼らはユーザーが嫌い',
    'profile_dislikes_groups' => '彼らはグループが嫌い',
    'profile_dislikes_hashtags' => '彼らはハッシュタグが嫌い',
    'profile_dislikes_geotags' => '彼らはジオタグが嫌い',
    'profile_dislikes_posts' => '彼らは投稿が嫌い',
    'profile_dislikes_comments' => '彼らはコメントが嫌い',
    'profile_following_users' => '彼らはユーザーをフォローする',
    'profile_following_groups' => '彼らはグループをフォローする',
    'profile_following_hashtags' => '彼らはハッシュタグをフォローする',
    'profile_following_geotags' => '彼らはジオタグをフォローする',
    'profile_following_posts' => '彼らは投稿をフォローする',
    'profile_following_comments' => '彼らはコメントをフォローする',
    'profile_blocking_users' => '彼らはユーザーをブロックする',
    'profile_blocking_groups' => '彼らはグループをブロックする',
    'profile_blocking_hashtags' => '彼らはハッシュタグをブロックする',
    'profile_blocking_geotags' => '彼らはジオタグをブロックする',
    'profile_blocking_posts' => '彼らは投稿をブロックする',
    'profile_blocking_comments' => '彼らはコメントをブロックする',
    // Operating-Content
    'content_group_name' => 'グループカスタムネーム',
    'content_group_name_desc' => 'たとえば、「編集」、「丸」、「分類」、その他の名前付き',
    'content_hashtag_name' => 'トピックカスタム名',
    'content_hashtag_name_desc' => 'たとえば、「スーパーのような」、「タグ」、「トピック」などです。',
    'content_post_name' => 'コンテンツ名を投稿',
    'content_post_name_desc' => 'たとえば、「投稿」、「ダイナミクス」、「トーク」などです。',
    'content_comment_name' => 'コメントコンテンツ名',
    'content_comment_name_desc' => 'たとえば、「コメント」、「返信」、「対話」、その他の名前付き',
    'content_publish_post_name' => '投稿行行動の名前を投稿してください',
    'content_publish_post_name_desc' => 'たとえば、「発行」、「提出」、「フィードバック」、その他の名前付き',
    'content_publish_comment_name' => 'コメントの行動の名前を投稿してください',
    'content_publish_comment_name_desc' => 'たとえば、「返信」、「返信」、「フォロー」およびその他の名前付き',
    'content_mention_status' => 'コメント状況',
    'content_mention_number' => 'メンション数',
    'content_mention_number_desc' => '1コンテンツあたりのユーザー言及数、0は制限なしを意味する。',
    'content_hashtag_status' => 'ハッシュタグの状態',
    'content_hashtag_format' => 'ハッシュタグのフォーマット',
    'content_hashtag_format_1' => '単一＃号機',
    'content_hashtag_format_2' => 'ダブル＃号機',
    'content_hashtag_format_desc' => '<a href="#">＃トピック</a>と<a href="#">＃トピック＃</a>',
    'content_hashtag_length' => 'ハッシュタグの長さ',
    'content_hashtag_number' => 'ハッシュタグ数',
    'content_hashtag_number_desc' => 'コンテンツごとにサポートされるハッシュタグの数。',
    'content_hashtag_regexp' => 'ハッシュタグの正規表現',
    'content_nearby_length' => '周辺検索のデフォルト範囲',
    'content_nearby_length_desc' => '周辺コンテンツ閲覧時の検索範囲',
    'content_post_brief_length' => 'ポスト要約',
    'content_post_brief_length_desc' => 'POSTがこの設定値を超えると、特大のコンテンツの概要の単語の概要を採用します。',
    'content_comment_brief_length' => 'コメントの概要',
    'content_comment_brief_length_desc' => '設定値が概要、監督の内容の概要を採用する前にコメントする',
    'content_comment_visibility_rule' => 'コメントの可視化ルール',
    'content_comment_visibility_rule_desc' => '投稿が数日以上経過するとコメントが非表示になります、0は有効でないことを意味します',
    'content_preview_post_like_users' => 'ある投稿に「いいね！」をつけたユーザーのプレビュー',
    'content_preview_post_like_users_desc' => '投稿に「いいね！」を押したユーザーのプレビュー、数値はプレビューの数を表す。',
    'content_preview_post_comments' => 'コメント投稿プレビュー',
    'content_preview_post_comments_desc' => '投稿一覧ページでのコメントのプレビュー、数値はプレビューされたコメントの数を表す。',
    'content_preview_post_comment_require' => 'コメント投稿のプレビュー条件',
    'content_preview_post_comment_require_desc' => 'プレビューを出力する前にコメント数をカウントする',
    'content_preview_comment_like_users' => 'いいね！」コメントのプレビュー',
    'content_preview_comment_replies' => 'コメント返信プレビュー',
    'content_post_edit_config' => '投稿の編集権限',
    'content_post_delete_config' => '投稿削除権限',
    'content_comment_edit_config' => 'コメント編集権限',
    'content_comment_delete_config' => 'コメント削除権限',
    'content_edit_desc' => '公開後に編集できますか？',
    'content_delete_desc' => '公開後に削除できますか？',
    // Operating-Interaction
    'interaction_function_status' => '機能ステータス',
    'interaction_operation_name' => '運営名',
    'interaction_user_title' => 'ユーザータイトル',
    'interaction_public_record' => '公開記録',
    'interaction_public_count' => '公開回数',
    'interaction_column_name' => 'カラム名',
    // Operating-Sticker
    'sticker_group' => '式グループ',
    'sticker_table_group_name' => '感情グループの名前',
    'sticker_table_group_image' => '感情グループのアイコン',
    'sticker_table_group_code' => '感情グループのロゴ',
    'sticker_table_quantity' => '式の数',
    'sticker_manage' => '式管理',
    'sticker_table_image' => '表情チャート',
    'sticker_table_code' => '絵文字',
    // Operating-Editor
    'editor_group' => 'グループ',
    'editor_title' => 'タイトル',
    'editor_sticker' => '表現',
    'editor_image' => '写真',
    'editor_video' => 'ビデオ',
    'editor_audio' => 'オーディオ',
    'editor_document' => 'ドキュメンテーション',
    'editor_mention' => 'aite',
    'editor_hashtag' => 'トピック',
    'editor_extend' => 'エクステンション',
    'editor_location' => '位置',
    'editor_anonymous' => '匿名',
    'editor_upload_image_type' => '画像アップロードフォーム',
    'editor_upload_video_type' => '動画アップロードフォーム',
    'editor_upload_audio_type' => '音声アップロードフォーム',
    'editor_upload_document_type' => 'ドキュメントアップロード',
    'editor_upload_image_number' => '画像の最大アップロード枚数',
    'editor_upload_video_number' => 'アップロードできる動画の最大数',
    'editor_upload_audio_number' => 'アップロード可能な音声の最大数',
    'editor_upload_document_number' => 'アップロードできるドキュメントの最大数',
    // Operating-Publish
    'publish_editor_config' => 'エディタの選択',
    'publish_editor_function_status' => 'エディタ機能',
    'publish_editor_function_options' => 'エディタ機能の設定',
    'publish_post_verify_config' => '投稿リクエストを投稿してください',
    'publish_comment_verify_config' => 'コメントを投稿してください',
    'publish_post_rules_config' => 'ポストスペシャルルールを投稿してください',
    'publish_comment_rules_config' => 'レビュー特別ルールを公開しています',
    'publish_editor_desc' => 'エディタが発行されました',
    'publish_verify_desc' => '公表するアカウントは、選択した情報を記入する必要があります。',
    'publish_rules_desc' => 'すべての従業員が有効で、優先順位はロールルールよりも大きい',
    'publish_rule_type' => 'ルールタイプ',
    'publish_rule_datetime' => '日付範囲',
    'publish_rule_time' => '制限時間',
    'publish_rule_timezone' => 'タイムゾーンスタンダード',
    'publish_rule_rule' => 'ルール要件',
    'publish_rule_tip' => 'ルールプロンプト',
    'publish_edit_time_limit' => 'どのくらい編集できますか？',
    'publish_edit_sticky_limit' => 'スティッキー後',
    'publish_edit_digest_limit' => 'ダイジェスト後',
    'publish_editor_group_required' => 'グループが必要かどうか',
    'publish_editor_group_required_desc' => '投稿を投稿するときは、選択する必要がありますか',
    'publish_editor_title_input_box' => 'タイトル入力ボックス表示',
    'publish_editor_title_input_box_desc' => '弱い表示には、ユーザーが手動でタイトル入力ボックスを選択する必要があります。',
    'publish_editor_title_required' => 'タイトルを埋めるかどうか',
    'publish_editor_title_required_desc' => '投稿を投稿するときは、タイトルを埋める必要があります',
    'publish_editor_title_length' => 'タイトル単語の制限',
    'publish_editor_title_length_desc' => 'タイトル数は設定数を超えてはいけません、最大上限255文字',
    'publish_editor_post_content_length' => '単語の制限を投稿',
    'publish_editor_post_content_length_desc' => 'ポスト数は設定数、最小上限140文字を超えない',
    'publish_editor_comment_content_length' => 'コメント単語の制限',
    'publish_editor_comment_content_length_desc' => 'コメント数は設定数、最小上限140文字を超えてはいけません',
    // Operating-Permission
    'permission_option_email' => 'Eメール必須',
    'permission_option_phone' => '電話番号必須',
    'permission_option_kyc' => 'KYC 必須',
    'permission_option_rule_datetime' => '指定された日付範囲内で効果的です',
    'permission_option_rule_time' => '指定された期間内に時間の周期を指定します',
    'permission_option_review_publish' => '公開することができますが、レビューする必要があります',
    'permission_option_close_publish' => '公開を禁止します',
    'permission_option_can_be_edited' => '編集可能',
    'permission_option_cannot_be_edited' => '編集不可',
    'permission_option_can_be_deleted' => '削除可能',
    'permission_option_cannot_be_deleted' => '削除不可',
    'permission_option_direct_release' => '直接透過する',
    'permission_option_required_review' => 'レビューする必要があります',
    'permission_option_title_optional_display' => '弱い表示',
    'permission_option_title_direct_display' => '強いディスプレイ',
    // Operating-Roles
    'role_table_display' => 'ロゴを表示します',
    'role_table_nickname_color' => 'ニックネームの色',
    'role_option_display_icon' => '表示アイコンを表示します',
    'role_option_display_text' => '文章',
    'role_option_close_nickname_color' => '色を使わないでください',
    'role_current' => '現在の役割',
    'role_target' => 'ターゲットロール',
    'role_target_desc' => 'ロールが削除された後、ユーザーはロールの下で選択されたターゲットロール名にマージします。',
    'role_perm_basic_config' => '基本設定',
    'role_perm_post_config' => '投稿を投稿する',
    'role_perm_comment_config' => 'コメントを投稿してください',
    'role_perm_upload_config' => 'アップロード設定',
    'role_perm_interaction_config' => 'インタラクティブ設定',
    'role_perm_customize_config' => 'カスタム設定',
    'role_perm_content_view' => '許可を閲覧する',
    'role_perm_conversation' => 'セッション権限',
    'role_perm_content_link_handle' => '公開コンテンツのリンク処理',
    'role_perm_content_link_handle_1' => 'ドメイン名の解決とマスクを行わない',
    'role_perm_content_link_handle_2' => '解決せず、テキストとして表示される',
    'role_perm_content_link_handle_3' => '通常の構文解析',
    'role_perm_post_publish' => '投稿許可を投稿してください',
    'role_perm_post_verify' => '投稿リクエストを投稿してください',
    'role_perm_post_review' => '投稿ルールを投稿してください',
    'role_perm_post_rules' => 'ポストスペシャルルールを投稿してください',
    'role_perm_post_time_interval' => '投稿時間間隔',
    'role_perm_post_daily_count' => 'ポストデイリーリミット',
    'role_perm_post_draft_count' => 'ポストドラフト数制限',
    'role_perm_comment_publish' => 'コメント特権を公開します',
    'role_perm_comment_verify' => 'コメントを投稿してください',
    'role_perm_comment_review' => 'コメントルールを投稿してください',
    'role_perm_comment_rules' => 'レビュー特別ルールを公開しています',
    'role_perm_comment_time_interval' => 'コメント投稿時間間隔',
    'role_perm_comment_daily_count' => 'コメント 1日の上限',
    'role_perm_comment_draft_count' => 'コメント投稿数制限',
    'role_perm_upload_image' => '画像をアップロードしてください',
    'role_perm_upload_video' => 'ビデオをアップロードします',
    'role_perm_upload_audio' => 'オーディオをアップロードする',
    'role_perm_upload_document' => 'ドキュメントをアップロードします',
    'role_perm_upload_file_desc' => '担当者の確認アップロード権限は、入力ボックスの離脱空白の「ストレージ構成」をデフォルトのパラメータとして使用します。',
    'role_perm_follow_user_max_count' => 'ユーザーマックスカウントをフォローする',
    'role_perm_block_user_max_count' => 'ブロックするユーザーの最大数',
    'role_perm_download_file_count' => '24時間以内に上限をダウンロードしてください',
    'role_perm_table_name' => '権限の名前',
    'role_perm_table_value' => '許可値',
    // Operating-Groups
    'group_table_parent_group' => '親グループ',
    'group_table_subgroup' => 'サブグループ',
    'group_table_privacy' => 'プライバシー',
    'group_table_visibility' => '視認性',
    'group_table_follow_method' => 'フォロー・メソッド',
    'group_table_recommend' => 'それはお勧めですか？',
    'group_table_admins' => 'グループ管理者',
    'group_table_can_publish' => '公開する',
    'group_table_post_permissions' => '投稿許可',
    'group_table_comment_permissions' => 'コメント許可',
    'group_table_publish_perm_role' => '公開する権利を持つ役割',
    'group_table_publish_perm_review' => '監査が必要ですか。',
    'group_table_publish_perm_review_desc' => 'グループ管理者は制限されていません',
    'group_public_desc' => 'Open（誰でもグループ内の投稿を見ることができます）',
    'group_private_desc' => '非公開（メンバーのみがグループ内の投稿を見ることができる）',
    'group_visible_desc' => 'それは見つけることができます（だれでもこのグループを見つけることができます）',
    'group_hidden_desc' => '見つけられない（メンバーだけがこのグループを見つけることができます）',
    'group_publish_option_all' => '全員',
    'group_publish_option_members' => 'ユーザーのグループだけを支払うだけです',
    'group_publish_option_roles' => '指定された役割ユーザーのみ',
    'group_publish_option_admins' => 'グループ管理者のみ',
    'group_can_publish_desc' => 'クローズパブリッシングパーミッションは、グループ分類として使用できます。',
    'group_current' => '現在のグループ',
    'group_target' => 'ターゲットグループ',
    'group_target_desc' => '合併後、古いグループは削除され、古いグループの内容は選択したターゲットチーム名に移行されます。',
    // Extends
    'extend_editor_menus' => 'メニュー',
    'extend_editor_toolbar' => 'ツールバー',
    'extend_editor_number_of_uses_desc' => '「投票」プラグインの例、数字は2ですが、単一の投稿を表し、2票を含めることができます',
    'extend_content_service' => 'コンテンツサービス',
    'extend_content_list' => 'コンテンツ一覧',
    'extend_content_detail' => 'コンテンツ詳細',
    'extend_content_search' => 'コンテンツ検索',
    'extend_content_list_desc' => 'この設定はコンテンツタイプの設定よりも優先度が高く、設定するとコンテンツタイプで指定されたデータソースに置き換わります。',
    'extend_content_ip' => 'IPサービス',
    'extend_content_map' => '地図サービス',
    'extend_content_notifications_service' => '通知サービス',
    'extend_content_review' => 'レビューサービス',
    'extend_content_list_by_all' => 'すべての投稿またはコメント',
    'extend_content_list_by_timelines' => 'タイムライン投稿またはコメント',
    'extend_content_list_by_nearby' => '近くの投稿またはコメント',
    'extend_content_by_detail' => '投稿またはコメントの詳細',
    'extend_content_search_users' => 'ユーザーを検索する',
    'extend_content_search_groups' => 'グループ検索',
    'extend_content_search_hashtags' => 'ハッシュタグを検索',
    'extend_content_search_geotags' => 'ジオタグ検索',
    'extend_content_search_posts' => '投稿を検索する',
    'extend_content_search_comments' => 'コメント検索',
    // Client-Channels
    'channel_default_homepage' => 'デフォルト・ホームページ',
    'channel_table_channel' => 'チャンネル',
    'channel_table_page' => 'ページ',
    'channel_table_page_home' => 'ホーム',
    'channel_table_page_list' => 'リスト',
    'channel_table_page_detail' => '詳細',
    'channel_table_page_interaction' => '相互作用',
    'channel_table_path' => 'パス',
    'channel_table_seo' => 'SEO情報',
    'channel_table_seo_title' => 'SEOのタイトル',
    'channel_table_seo_description' => 'SEOの説明',
    'channel_table_seo_keywords' => 'SEOのキーワード',
    'channel_table_query_state' => 'クライアント側の受け渡し',
    'channel_table_query_state_desc' => 'クライアントサイドパスを受け入れるかどうか、オフにした場合はデフォルトのパラメータ値のみがサポートされます。',
    'channel_table_query_config' => 'デフォルトのパラメータ',
    'channel_table_query_config_desc' => 'このインターフェースのAPI Queryパラメータを参照する。',
    'channel_query_state_1' => 'クライアントパラメータを受け付けない',
    'channel_query_state_2' => 'クライアントページングパラメータのみ受け付ける',
    'channel_query_state_3' => 'すべてのパラメータを受け付ける',
    // Client-Columns
    'channel_timeline' => 'タイムライン',
    'channel_timeline_all_posts' => 'すべてのフォローされた投稿',
    'channel_timeline_user_posts' => 'ユーザーの投稿をフォローする',
    'channel_timeline_group_posts' => 'グループの投稿をフォローしている',
    'channel_timeline_hashtag_posts' => 'ハッシュタグの投稿をフォローする',
    'channel_timeline_geotag_posts' => 'ジオタグ投稿をフォローする',
    'channel_timeline_all_comments' => 'フォローしているコメント',
    'channel_timeline_user_comments' => 'ユーザーのコメントをフォローする',
    'channel_timeline_group_comments' => 'グループのコメントをフォローする',
    'channel_timeline_hashtag_comments' => 'ハッシュタグのコメントをフォローする',
    'channel_timeline_geotag_comments' => 'ジオタグコメントをフォローする',
    'channel_nearby' => '近くの投稿',
    'channel_nearby_posts' => 'Nearbyさんの投稿',
    'channel_nearby_comments' => 'によるコメント Nearby',
    'channel_me' => 'パーソナルセンター',
    'channel_me_extcredits' => 'エクスクレジット',
    'channel_me_wallet' => '財布',
    'channel_me_drafts' => '下書き',
    'channel_me_users' => 'ユーザー',
    'channel_me_settings' => '設定',
    'channel_messages' => 'メッセージ',
    'channel_conversations' => '会話',
    'channel_notifications' => '通知',
    'channel_notifications_all' => '通知する-すべて',
    'channel_notifications_systems' => '通知する-システム',
    'channel_notifications_recommends' => '通知する-おすすめ',
    'channel_notifications_likes' => '通知する-好きなもの',
    'channel_notifications_dislikes' => '通知する-嫌いなもの',
    'channel_notifications_follows' => '通知する-フォローする',
    'channel_notifications_blocks' => '通知する-ブロック',
    'channel_notifications_mentions' => '通知する-メンション',
    'channel_notifications_comments' => '通知する-コメント',
    'channel_notifications_quotes' => '通知する-引用',
    'channel_search' => '探す',
    // Client-Keys
    'key_table_read_only' => 'リードオンリー',
    'key_select_platform' => 'キーアプリケーションプラットフォームを選択します',
    'key_option_main_api' => 'メインアピリ',
    'key_option_manage_api' => '管理API',
    'key_option_plugin_api' => 'プラグインAPI',
    'key_option_plugin_api_select' => '使用するプラグインを選択してください',
    'key_option_plugin_api_select_desc' => 'このキーは、関連するプラグインのAPIのみを要求できます。',
    // Client-Basic
    'website_stat_code' => 'サイト統計コード',
    'website_stat_code_desc' => 'document.writeを含む統計コードの使用はサポートされていません。',
    'website_stat_position' => '統計コードの場所',
    'website_stat_position_desc' => '統計コードがHTMLに読み込まれる場所。',
    'china_mode' => '中国モード',
    'china_mode_desc' => 'サイトサーバーが中国に展開されている場合に必要な情報。',
    'china_mode_config' => '中国本土サーバーの設定（非必須項目）',
    'china_icp_filing' => 'インターネットコンテンツプロバイダー申請',
    'china_icp_license' => 'インターネットコンテンツプロバイダー許可証',
    'china_mps_filing' => '公安局への申請',
    'china_broadcasting_license' => '放送局免許',
    // Client-Status
    'client_status_desc' => 'クライアントは10分ごとにステータス設定を要求',
    // App-Center-Themes
    'website_engine_config' => 'エンジン構成',
    'website_engine_api_config' => 'APIコンフィグ',
    'website_engine_status' => 'エンジンステータス',
    'website_engine_api_type' => 'エンジンAPIタイプ',
    'website_engine_key_id' => 'アプリケーションキーの選択',
    'website_engine_view_desktop' => 'デスクトップ',
    'website_engine_view_mobile' => 'モバイル',
    // App-Center-Install
    'install_website_engine' => 'ウェブサイト・エンジンのインストール',
    'install_plugin' => 'プラグインのインストール',
    'install_application' => 'インストールアプリ',
    'install_mode' => 'インストールモード',
    'install_mode_fskey' => 'Fresnsキーの入力',
    'install_mode_upload' => 'Zipパッケージのアップロード',
    'install_mode_directory' => '入力ディレクトリパス',
    'download_application' => 'アプリをダウンロード',
];
