<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresns 제어판',
    'fresns_core' => 'Fresns Core',
    // Login page
    'language' => '언어',
    'login' => '로그인',
    'account' => '계정',
    'password' => '비밀번호',
    'enter' => '입력하다',
    'operation' => '패널 작동',
    'site_home' => '웹사이트 홈',
    'switch_language' => '언어 전환',
    'logout' => '로그 아웃',
    // Header menus
    'menu_dashboard' => '계기반',
    'menu_systems' => '시스템',
    'menu_operations' => '조작',
    'menu_extends' => '확장',
    'menu_clients' => '클라이언트',
    'menu_app_center' => '앱 센터',
    'menu_marketplace' => '시장',
    // Sidebar menus
    'sidebar_home' => '집',
    'sidebar_admins' => 'admins',
    'sidebar_events' => '이벤트',
    'sidebar_events_tab_subscribe' => '구독하다',
    'sidebar_events_tab_crontab' => '크론탭',
    'sidebar_caches' => '캐시',
    'sidebar_caches_tab_config' => '구성 캐시',
    'sidebar_caches_tab_data' => '데이터 캐시',
    'sidebar_upgrades' => '업그레이드',
    'sidebar_settings' => '설정',
    'sidebar_languages' => '언어',
    'sidebar_storage' => '저장',
    'sidebar_storage_tab_image' => '영상',
    'sidebar_storage_tab_video' => '동영상',
    'sidebar_storage_tab_audio' => '오디오',
    'sidebar_storage_tab_document' => '문서',
    'sidebar_storage_tab_substitution' => '치환',
    'sidebar_general' => '일반적인',
    'sidebar_policy' => '수단',
    'sidebar_policy_tab_options' => '옵션',
    'sidebar_policy_tab_contents' => '내용물',
    'sidebar_send' => '보내다',
    'sidebar_send_tab_services' => '서비스를 보내십시오',
    'sidebar_send_tab_templates' => '코드 템플릿 확인',
    'sidebar_account' => '계정',
    'sidebar_wallet' => '지갑',
    'sidebar_wallet_tab_options' => '옵션',
    'sidebar_wallet_tab_recharge_services' => '재충전 서비스',
    'sidebar_wallet_tab_withdraw_services' => '서비스 철회',
    'sidebar_user' => '사용자',
    'sidebar_content' => '콘텐츠',
    'sidebar_interaction' => '상호 작용',
    'sidebar_publish' => '게시',
    'sidebar_publish_tab_post' => '게시하다',
    'sidebar_publish_tab_comment' => '논평',
    'sidebar_roles' => '역할',
    'sidebar_stickers' => '스티커',
    'sidebar_groups' => '여러 떼',
    'sidebar_groups_tab_active' => '활동적인',
    'sidebar_groups_tab_deactivate' => '비활성으로',
    'sidebar_groups_tab_recommend' => '권장 사항 만 표시하십시오',
    'sidebar_extend_editor' => '편집자',
    'sidebar_extend_content_type' => '컨텐츠 타입',
    'sidebar_extend_content_handler' => '콘텐츠 핸들러',
    'sidebar_extend_manage' => '관리하다',
    'sidebar_extend_group' => '그룹',
    'sidebar_extend_group_filter' => '필터',
    'sidebar_extend_user_feature' => '사용자 특징',
    'sidebar_extend_user_profile' => '유저 프로필',
    'sidebar_extend_channel' => '채널',
    'sidebar_extend_command_words' => '명령어',
    'sidebar_channels' => '채널',
    'sidebar_paths' => '길',
    'sidebar_language_packs' => '언어 팩',
    'sidebar_code_messages' => '코드 메시지',
    'sidebar_client_basic' => '기본',
    'sidebar_client_status' => '상태',
    'sidebar_plugins' => '플러그인',
    'sidebar_plugins_tab_all' => '모두',
    'sidebar_plugins_tab_active' => '활동적인',
    'sidebar_plugins_tab_inactive' => '비활성으로',
    'sidebar_themes' => '테마',
    'sidebar_apps' => '애플리케이션',
    'sidebar_keys' => '앱 키',
    // Sidebar intro
    'sidebar_admins_intro' => '제어판에 로그인 할 권리가있는 사용자',
    'sidebar_events_intro' => '시스템에서 예약된 작업을 보고 이벤트를 구독합니다.',
    'sidebar_caches_intro' => '모든 캐시가 지워지면 서버 부하가 증가할 수 있으므로 피크 액세스 시간을 피하십시오.',
    'sidebar_upgrades_intro' => '마침내',
    'sidebar_settings_intro' => '구성이 완료된 후 캐시를 지우거나 새 캐시가 적용될 때까지 10분 동안 기다리십시오.',
    'sidebar_storage_intro' => '4 개의 리소스 파일을 별도로 저장하거나 동일하게 저장할 수 있으며 스토리지 구성 정보를 채 웁니다',
    'sidebar_languages_intro' => '다중 언어는 해당 구성 항목에 다국어 컨텐츠를 입력하기 전에 언어 옵션을 구성해야합니다',
    'sidebar_general_intro' => '시스템 설정 항목을 안전하게 보호하십시오',
    'sidebar_policy_intro' => '대상 시장 국가의 관련 데이터 법률 규정에 따르면',
    'sidebar_send_intro' => '메일 SMS 및 시스템 알림과 같은 메시징 및 기타 메시지',
    'sidebar_account_intro' => '계정 센터 기능 설정',
    'sidebar_wallet_intro' => '지갑은 실제 통화 기능이며, 가상 적분 기능이 필요한 경우 적절한 플러그인을 설치하십시오',
    'sidebar_wallet_tab_recharge_services_intro' => '재충전 서비스 공급자 구성은 지불 주문을 위해 "Wallet"기능 목록에 렌더링되거나 지갑을 충전합니다',
    'sidebar_wallet_tab_withdraw_services_intro' => 'Dispense Service Provider 구성은 지정된 계정에서 현금으로 지갑 밸런스에 사용되는 "Wallet"기능 목록에 있습니다',
    'sidebar_user_intro' => '사용자 기본 기능 설정',
    'sidebar_content_intro' => '소셜 콘텐츠 이름 및 기능 구성',
    'sidebar_interaction_intro' => '제품 서비스에 대한 사용자의 인식(경험의 감각)은 기술적 논리가 아닌 기능 포인트의 명명에 달려있습니다.',
    'sidebar_publish_intro' => '이 구성은 모든 구성원에게 유효하며 우선 순위 우선 순위가 사용자 역할 권한보다 큽니다',
    'sidebar_roles_intro' => '역할은 사용자 ID 및 사용 권한에 대한 특정 설정을 설정할 수 있습니다',
    'sidebar_stickers_intro' => '사용자 정의 구성 eMotive, 구성하지 않는 경우 사용자는 또한 전자 메커 키보드를 통해 이모티콘 표현식을 입력 할 수도 있습니다',
    'sidebar_groups_intro' => '사용 그룹은 BBS 프로젝트, 커뮤니티 서클, 콘텐츠 분류와 같은 다양한 작동 시나리오를 실현할 수 있습니다',
    'sidebar_extend_editor_intro' => '릴리스 프로세스의 "편집기"에서 "투표"확장은 "편집기"가 게시물과 함께 제공되는 투표 기능을 지원하도록 허용합니다',
    'sidebar_extend_content_type_intro' => '게시물은 지정된 메시지를 출력하고 데이터 소스를 정의하는 데 사용되는 "포스트"목록 페이지에 표시됩니다',
    'sidebar_extend_content_handler_intro' => '이 함수는 요청이 플러그인 처리에 분산되어 있는지 여부에 관계없이 함수가 "콘텐츠 유형 확장자"데이터 소스 기능과 동일하며, 데이터 로직은 플러그인에 의해 결정됩니다',
    'sidebar_extend_manage_intro' => '게시물, 주석, "불만 사항"확장과 같은 사용자 홈페이지의 "더 많은"기능 목록은 사용자가 해당 대상을 불평 할 수 있습니다',
    'sidebar_extend_group_intro' => '"Pure Link Extension Plugin"과 같은 "그룹"홈 페이지에는 프레젠테이션이 "그룹"홈 페이지에 하이퍼 링크를 표시 할 수 있습니다',
    'sidebar_extend_user_feature_intro' => '"My"페이지는 "Wallet"확장과 같은 "사용자 센터"에 표시되며 사용자가 더 많은 지갑 기능을 할 수 있습니다',
    'sidebar_extend_user_profile_intro' => '"사용자 이름 플러그인 수정"과 같은 "사용자 정보"관리 기능 목록에서 수정 정보가 사용자 이름의 수정을 지원할 수 있습니다',
    'sidebar_extend_channel_intro' => '메인 메뉴 또는 채널 페이지 목록에 표시됩니다. 쇼핑 확장을 통해 사용자는 쇼핑몰 채널에 액세스할 수 있습니다.',
    'sidebar_extend_command_words_intro' => '이 목록에 구성된 명령어는 API 요청에 사용할 수 있습니다.',
    'sidebar_channels_intro' => '클라이언트의 개별 채널 정보를 통합적으로 구성할 수 있습니다.',
    'sidebar_paths_intro' => '사용자 정의 경로 구조는 링크의 미학, 유용성 및 향후 호환성을 향상시킬 수 있습니다.',
    'sidebar_language_packs_intro' => '다국어 클라이언트의 각 텍스트의 다중 언어 내용을 구성하십시오',
    'sidebar_code_messages_intro' => '메인 프로그램 및 플러그인에 대한 상태 코드의 다국어 설명을 구성합니다.',
    'sidebar_client_basic_intro' => '클라이언트 기반에 대한 일반 구성 항목입니다.',
    'sidebar_client_status_intro' => '비활성화하면 모든 클라이언트 페이지와 작업은 비활성화 지침 페이지로 이동합니다.',
    'sidebar_plugins_intro' => '유연한 기능, 강력한 확장 기능은 자유롭게 재생할 수 있습니다',
    'sidebar_themes_intro' => '다른 주제를 선택하여보다 개인화 된 스타일과 상호 작용을 달성하십시오',
    'sidebar_apps_intro' => '강력한 확장 기능인 표준 API는 다양한 운영 시나리오와 애플리케이션 모드를 마음대로 생성합니다.',
    'sidebar_keys_intro' => '주요 자격 증명은 중요하고 다른 사람들에게 쉽게 공개하지는 않습니다',
    // Page button
    'button_support' => '지원하다',
    'button_update' => '업데이트',
    'button_search' => '검색',
    'button_add' => '추가하다',
    'button_edit' => '편집',
    'button_modify' => '수정',
    'button_delete' => '삭제',
    'button_cancel' => '취소',
    'button_close' => '닫기',
    'button_dismiss' => '해고하다',
    'button_activate' => '활성화',
    'button_deactivate' => '비활성화하십시오',
    'button_install' => '설치',
    'button_uninstall' => '제거',
    'button_setting' => '환경',
    'button_config' => '구성',
    'button_reset' => '초기화',
    'button_confirm' => '확인하다',
    'button_try_again' => '다시 시도하기',
    'button_save' => '구하다',
    'button_download' => '다운로드',
    'button_upgrade' => '업그레이드',
    'button_automatic_upgrade' => '자동 업그레이드',
    'button_manual_upgrade' => '수동 업그레이드',
    'button_confirm_delete' => '삭제 확인',
    'button_confirm_install' => '설치 확인',
    'button_confirm_upgrade' => '업그레이드 확인',
    'button_confirm_download' => '다운로드 확인',
    'button_confirm_uninstall' => '제거를 확인하십시오',
    'button_view' => '보다',
    'button_image_upload' => '업로드',
    'button_image_input' => '입력',
    'button_check_upgrade' => '업그레이드 확인',
    'button_check_status' => '상태 확인',
    'button_batch_import' => '수입',
    'button_batch_export' => '내 보내다',
    'button_config_email_template' => '구성 이메일 템플릿',
    'button_config_sms_template' => 'Config SMS 템플릿',
    'button_config_sticker' => '구성 스티커',
    'button_config_permission' => '구성 허가',
    'button_config_language_pack' => '구성 팩',
    'button_add_admin' => '관리자 추가',
    'button_add_language' => 'Lang을 추가하십시오',
    'button_add_account_connect' => '계정 연결 추가',
    'button_add_service_provider' => '서비스를 추가하십시오',
    'button_add_sticker_group' => '스티커 그룹을 추가하십시오',
    'button_add_sticker' => '스티커 추가',
    'button_add_role' => '역할 추가',
    'button_add_group' => '그룹 추가',
    'button_group_move' => '이동하다',
    'button_add_key' => '키를 추가하십시오',
    'button_reset_key' => '키 재설정',
    'button_reset_secret' => '비밀 재설정',
    'button_clear_cache' => '캐시 지우기',
    'button_clear_all_cache' => '모든 캐시 지우기',
    // Page table
    'table_order' => '정렬 순서',
    'table_recommend_order' => '정렬 순서 추천',
    'table_position' => '위치',
    'table_number' => '숫자',
    'table_lang_tag' => 'Lang 태그',
    'table_lang_name' => 'Lang Name',
    'table_title' => '제목',
    'table_content' => '콘텐츠',
    'table_platform' => '플랫폼',
    'table_service' => '서비스',
    'table_app_id' => '앱 ID',
    'table_app_key' => '앱 키',
    'table_app_secret' => '앱 비밀',
    'table_plugin' => '플러그인',
    'table_command_word' => '명령어',
    'table_name' => '이름',
    'table_description' => '설명',
    'table_icon' => '상',
    'table_banner' => '배너',
    'table_type' => '유형',
    'table_use' => '사용',
    'table_support' => '지원하다',
    'table_data_source' => '데이터 원본',
    'table_scene' => '장면',
    'table_number_of_uses' => '용도의 수',
    'table_scope' => '범위',
    'table_scope_global' => '글로벌',
    'table_scope_global_desc' => '지정된 역할로 제한 될 수 있습니다',
    'table_scope_group_admins' => '그룹 관리자',
    'table_scope_group_admins_desc' => '활성화되면 그룹 관리자 만 플러그인을 표시합니다',
    'table_authorized_roles' => '승인 된 역할',
    'table_authorized_roles_desc' => '모든 사용자 역할이 사용할 자격이 있음을 나타 내기 위해 공백을 남겨 두십시오',
    'table_whitelist_rules' => '흰색 목록 역할',
    'table_parameter' => '매개 변수',
    'table_status' => '상태',
    'table_options' => '옵션',
    // Config option
    'option_default' => '기본',
    'option_all' => '모두',
    'option_public' => '공개',
    'option_private' => '비공개',
    'option_visible' => '보이는',
    'option_hidden' => '숨겨진',
    'option_open' => '열려있는',
    'option_close' => '닫기',
    'option_yes' => '네',
    'option_no' => '아니요',
    'option_activate' => '활성화',
    'option_deactivate' => '비활성화하십시오',
    'option_local' => '현지의',
    'option_remote' => '원격',
    'option_required' => '필수의',
    'option_not_required' => '필요하지 않습니다',
    'option_not_set' => '설정되지 않음',
    'option_no_use' => '소용없음',
    'option_unselect' => '선택 취소',
    'option_optional' => '선택 과목',
    'option_email' => '이메일',
    'option_sms' => 'SMS',
    'option_data_close' => '비공개',
    'option_data_private' => '나만 보기',
    'option_data_public' => '공개',
    'option_type_tree' => '나무',
    'option_type_list' => '목록',
    'option_uninstall_plugin_data' => '플러그인 데이터의 동시 삭제',
    'option_uninstall_theme_data' => '테마 데이터를 동시에 삭제합니다',
    // Commons
    'portal' => '문',
    'user' => '사용자',
    'group' => '그룹',
    'hashtag' => '해시 태그',
    'geotag' => '지오태그',
    'post' => '게시하다',
    'comment' => '논평',
    'file' => '파일',
    'extend' => '콘텐츠 확장',
    'user_detail' => '사용자 홈',
    'group_detail' => '그룹 세부 정보',
    'hashtag_detail' => '해시태그 세부정보',
    'geotag_detail' => '지오태그 세부 정보',
    'post_detail' => '게시물 세부정보',
    'comment_detail' => '댓글 세부정보',
    'like' => '좋아요',
    'dislike' => '싫어요',
    'follow' => '팔로우',
    'block' => '차단',
    'author' => '작가',
    'new_version' => '새로운',
    'default_language' => '기본 언어',
    'default_list' => '기본 목록',
    'recommend' => '추천',
    'unit_day' => '일',
    'unit_length' => '길이',
    'unit_second' => '초',
    'unit_minute' => '분',
    'unit_within_minute' => '분 내에',
    'unit_character' => '성격',
    'unit_number' => '숫자',
    'unit_number_of_times' => '횟수',
    'unit_kilometer' => '킬로미터',
    'unit_mile' => '마일',
    'config_default' => '기본 구성',
    'config_name' => '이름 구성',
    'config_edit' => '구성 편집',
    'config_interaction' => '상호 작용 구성',
    'config_conversation' => '대화 구성',
    'config_hashtag' => '해시태그 구성',
    'config_list' => '목록 구성',
    'config_preview' => '구성 미리보기',
    'config_manage' => '구성 관리',
    'delete_desc' => '확실히 삭제할 수 있습니까?',
    // Dashboard-Home
    'welcome' => 'Fresns에 오신 것을 환영합니다',
    'current_version' => '사용 된 현재 버전은입니다',
    'overview' => '사이트 데이터',
    'overview_accounts' => '계정',
    'overview_users' => '사용자',
    'overview_groups' => '그룹',
    'overview_hashtags' => '해시태그',
    'overview_geotags' => '위치정보 태그',
    'overview_posts' => '글',
    'overview_comments' => '댓글',
    'extensions' => '적용 수량',
    'support' => '도움말 매뉴얼',
    'support_website' => 'Fresns 공식 웹 사이트',
    'support_teams' => '오픈 소스 팀',
    'support_sponsor' => '스폰서',
    'support_join' => '우리와 함께하십시오',
    'support_community' => '커뮤니티 지원',
    'support_marketplace' => '신청 시장',
    'system_info' => '시스템 메시지',
    'system_info_server' => '서버 시스템',
    'system_info_web' => '웹 실행 환경',
    'system_info_php_version' => 'PHP 버전',
    'system_info_php_cli_info' => 'PHP Cli 정보',
    'system_info_php_upload_max_filesize' => '최대 파일 크기 업로드',
    'system_info_composer_info' => 'Composer 정보',
    'system_info_composer_version' => 'Composer 버전',
    'system_info_env_timezone' => '.env 시간대',
    'system_info_env_timezone_name' => '.env 시간대 식별자',
    'system_info_env_timezone_utc' => '.env 시간대 식별자의 UTC 시간대',
    'system_info_env_timezone_list' => '일치하는 시간대 식별자',
    'system_info_database_driver' => '데이터베이스 드라이버',
    'system_info_database_version' => '데이터베이스 버전',
    'system_info_database_timezone' => '데이터베이스 시간대',
    'system_info_database_engine' => '데이터 주식 엔진',
    'system_info_database_collation' => '데이터베이스 정렬 규칙',
    'system_info_database_size' => '현재 데이터베이스 크기',
    'tips' => '사용 지침',
    'news' => 'Fresns 활동 및 뉴스',
    // Dashboard-Events
    'event_subscribe_subject' => '주제',
    'event_crontab_time' => '실행 주기',
    'event_crontab_time_desc' => 'Laravel 작업 스케줄링 크론 테이블 형식',
    // Dashboard-Caches
    'cache' => '은닉처',
    'cache_fresns_system' => '시스템 구성',
    'cache_fresns_config' => '사이트 구성',
    'cache_fresns_extend' => '확장 구성',
    'cache_fresns_view' => '보다',
    'cache_fresns_route' => '노선',
    'cache_fresns_event' => '이벤트',
    'cache_fresns_schedule' => '일정',
    'cache_fresns_temporary' => '임시 데이터',
    // Dashboard-Admins
    'admin_add_title' => '새로운 시스템 관리자',
    'admin_add_form_account' => '계정',
    'admin_add_form_account_placeholder' => '이메일 또는 휴대 전화 번호',
    'admin_add_form_account_desc' => '휴대 전화 번호는 국제 지역 코드가 완비되어야합니다',
    'admin_add_form_account_btn' => '검색 및 증가',
    // Dashboard-Settings
    'setting_developer_options' => '개발자 옵션',
    'setting_developer_options_desc' => '개발 환경이 아닌 경우 옵션을 비활성화하지 마십시오.',
    'setting_build_type' => '버전 유형',
    'setting_build_type_desc' => '베타 버전은 안정성이 좋지 않으므로 신중하게 선택하십시오.',
    'setting_build_select_tip' => '업그레이드 버전 유형 선택',
    'setting_build_option_stable' => '안정적인 버전 (Stable Build)',
    'setting_build_option_beta' => '베타 (Beta Build)',
    'setting_system_url' => '시스템 URL',
    'setting_system_url_desc' => '메인 프로그램 API 및 플러그인 기본 접근 주소',
    'setting_panel_path' => '안전한 입장',
    'setting_panel_path_desc' => '설정 후 보안 항목을 지정하여 제어판에만 로그인 할 수 있습니다',
    'setting_panel_url' => '입구 완료 주소',
    'setting_panel_url_desc' => '제어판 로그인 항목 완료 URL',
    'setting_panel_url_copy' => '복사',
    // System-Languages
    'language_multilingual' => '다국어',
    'language_table_default' => '기본 언어',
    'language_table_langCode' => '언어 코드',
    'language_table_areaCode' => '지역 번호',
    'language_table_langName' => '언어 이름',
    'language_table_areaName' => '지역 이름',
    'language_table_lengthUnit' => '길이 단위',
    'language_table_writingDirection' => '쓰기 방향',
    'language_table_area' => '언어 영역',
    'language_table_dateFormat' => '날짜 형식',
    'language_table_dateFormat_desc' => 'Yyyy는 한 해에 말했다, DD는 천국을 의미한다고 말했다',
    'language_table_timeFormat' => '인간 시간',
    'language_table_timeFormat_desc' => '시간 변수 이름 {n}',
    'language_select_langCode' => '언어 코드를 선택하십시오',
    'language_select_continent' => '대륙',
    'language_select_areaCode' => '지역 코드를 선택하십시오',
    // System-General
    'site_url' => '사이트 URL',
    'site_url_desc' => '메인 사이트 접속 URL',
    'site_name' => '사이트 이름',
    'site_name_desc' => 'Fresns 사이트의 이름',
    'site_intro' => '사이트 소개',
    'site_intro_desc' => 'Fresns 사이트 소개',
    'site_logo' => '사이트 서명',
    'site_logo_desc' => '"저장소 설정"의 정보는 이미지를 업로드하도록 구성되어야합니다',
    'site_copyright' => '저작권 정보',
    'site_email' => '관리자 사서함',
    'site_email_desc' => '오류를 실행할 때 사용자가 사용자 피드백을 촉진하도록 사용자에게 표시하십시오',
    'site_mode' => '작동 모드',
    'site_mode_public' => '출판 모드',
    'site_mode_private' => '개인 모드',
    'site_mode_private_desc' => '개인 모드 구성',
    'site_mode_private_join_status' => '그것은 외부에 열리고 있습니까?',
    'site_mode_private_join_service' => '채널 지원 플러그인에 가입하십시오',
    'site_mode_private_content_policy' => '개인 만료 된 상태',
    'site_mode_private_content_policy_1' => '사이트 콘텐츠가 표시되지 않습니다',
    'site_mode_private_content_policy_2' => '만료되기 전에 콘텐츠, 새 콘텐츠가 보이지 않습니다',
    // System-Policy
    'policy_terms' => '서비스 약관',
    'policy_privacy' => '개인 정보 정책',
    'policy_cookie' => '쿠키 정책',
    'policy_delete_account' => '로그 아웃 지침',
    'policy_delete_options' => '로그 아웃 기능',
    'policy_delete_options_desc' => '사용자는 버퍼 데이 내에서 로그 아웃 (복구 계정)을 취소 할 수 있으며 취소 프로세스가 실행 취소없이 실행됩니다',
    'policy_delete_option_1' => '로그 아웃 기능을 사용하지 마십시오',
    'policy_delete_option_2' => '논리적 로그인',
    'policy_delete_option_2_desc' => '논리 로그 아웃 : 데이터베이스에서만 데이터베이스에서만 알림이 있으므로 데이터를 삭제하는 것은 해당되지 않습니다',
    'policy_delete_option_3' => '물리적 취소',
    'policy_delete_option_3_desc' => '실제 로그 아웃 : 실제 삭제 데이터, 사용자 데이터 및 게시 된 콘텐츠가 진정으로 삭제됩니다',
    'policy_delete_crontab' => '로그 아웃주기',
    // System-Send
    'send_email_config' => '사서함 구성',
    'send_sms_config' => 'SMS 구성',
    'send_sms_default_code' => '기본 국제 지역 코드',
    'send_sms_supported_codes' => '더 많은 지역 코드를 지원하십시오',
    'send_sms_desc' => '한 줄, 공백 대표는 단일 국가 만 지원합니다. 구성 이전에 서비스 제공 업체가 국제 SMS 기능을 지원하는지 확인하십시오',
    'send_app_notifications' => '푸시 알림 서비스',
    'send_app_ios_config' => 'iOS 구성',
    'send_app_ios_notifications_desc' => 'iOS 시스템 팝업 알림 기능',
    'send_app_android_config' => '안드로이드 구성',
    'send_app_android_notifications_desc' => 'Android 시스템 팝업 알림 기능',
    'send_app_desktop_config' => '데스크톱 구성',
    'send_app_desktop_notifications_desc' => '브라우저 알림과 같은 데스크톱 알림 기능입니다.',
    'send_code_template_1' => '일반 검증 코드',
    'send_code_template_2' => '새 계정을 등록하십시오',
    'send_code_template_3' => '계정 정보를 수정하십시오',
    'send_code_template_4' => '새로운 바인딩을 바꿉니다',
    'send_code_template_5' => '로그인 암호 재설정',
    'send_code_template_6' => '지불 암호 재설정',
    'send_code_template_7' => '확인 코드로 로그인하십시오',
    'send_code_template_8' => '인증 코드를 사용하여 계정 삭제',
    'send_code_template_table_email_desc' => 'HTML 형식 지원',
    'send_code_template_table_sms_sign' => 'SMS 서명 이름',
    'send_code_template_table_sms_code' => '템플릿 매개 변수',
    'send_code_template_table_sms_code_desc' => '템플릿 ID를 구성 할 수 있습니다. 자세한 내용은 관련 플러그인의 설명을 참조하십시오',
    'send_code_template_table_sms_param' => '확인 코드 변수 이름',
    // System-User
    'account_center_config' => '계정 센터 구성',
    'account_child_safety' => '어린이 안전',
    'account_age_verification' => '연령 확인',
    'account_age_min_required' => '최소 연령 필수',
    'account_register_config' => '등록 구성',
    'account_login_config' => '로그인 구성',
    'account_password_config' => '비밀번호 구성',
    'account_center_service' => '계정 센터',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => '등록 서비스',
    'account_register_status' => '오픈 등록 여부',
    'account_register_type' => '계정 지원 등록',
    'account_register_type_email' => '이메일',
    'account_register_type_phone' => '전화 번호',
    'account_login_service' => '로그인 서비스',
    'account_login_support' => '로그인 지원',
    'account_login_type_email' => '이메일',
    'account_login_type_phone' => '전화 번호',
    'account_code_login' => '코드 인증 로그인',
    'account_login_or_register' => '인증코드 로그인 시 계정이 없으면 자동으로 등록됩니다.',
    'account_password_length' => '길이 요구 사항',
    'account_password_length_desc' => '길이 요구 사항 : 최소 길이, 0 또는 채워지지 않음은 제한되지 않습니다',
    'account_password_strength' => '힘 요구 사항',
    'account_password_strength_desc' => '강도 요구 사항 : 선택한 문자 유형이 암호에 있어야하며 제한되지 않습니다',
    'account_password_strength_digital' => '숫자',
    'account_password_strength_lowerLetters' => '소문자',
    'account_password_strength_upperLetters' => '대문자',
    'account_password_strength_symbols' => '기호 (부서)',
    'account_connect_services' => '제 3 자 상호 연결 지원',
    'account_connect_services_desc' => '상호 연결 플랫폼을 선택하고 플러그인을 연결하여 빠른 등록 또는 로그인하십시오',
    'account_kyc_service' => '실명 인증 지원',
    'account_kyc_service_desc' => '인증 서비스 플러그인을 설치 한 후 사용자는 실제 이름을 인증 할 수 있습니다',
    'account_users_service' => '다중 사용자 관리',
    // System-Wallet
    'wallet_functions' => '지갑 기능',
    'wallet_functions_desc' => '프랑스 돈 패키지를 사용할 수 있는지 여부',
    'wallet_currency_code' => '통화 코드',
    'wallet_currency_name' => '화폐 이름',
    'wallet_currency_unit' => '통화 단위',
    'wallet_currency_precision' => '통화 정확도',
    'wallet_withdraw_status' => '현금',
    'wallet_withdraw_config' => '현금 구성',
    'wallet_withdraw_config_desc' => '추가 관련 구성을 지원해야하며 플러그인 개발자에게 문의하십시오',
    'wallet_withdraw_review' => '현금',
    'wallet_withdraw_review_prove' => '실제 이름 정보를 확인합니다',
    'wallet_withdraw_periodicity' => '현금 간격',
    'wallet_withdraw_rates' => '현금 인출 수수료',
    'wallet_withdraw_min' => '단일 인도 최소 금액',
    'wallet_withdraw_max' => '단일 인출 최대 금액',
    'wallet_withdraw_sum_limit' => '일일 철수 캡',
    // System-Storage
    'storage_service_config' => '스토리지 구성',
    'storage_service_config_desc' => '스토리지 서비스 제공 업체는 앱 스토어에 더 많은 선택권을 설치할 수 있습니다',
    'storage_function_config' => '기능 구성',
    'storage_function_image_config' => '이미지 처리 기능 구성',
    'storage_function_image_config_desc' => '스타일 이름 또는 고급 매개 변수를 구성 할 수 있습니다. 테스트 이미지 압축, 줌, 워터 마킹 등, 공통 "간격 식별자"는 반 폭 문자 "!", "-", "_"입니다. 고급 매개 변수를 지원하고 스토리지 서비스 공급자의 개발자 설명서를 참조하십시오',
    'storage_function_video_config' => '비디오 프로세싱 기능 구성',
    'storage_function_video_config_desc' => '템플릿 ID를 구성 할 수 있습니다. 자세한 내용은 관련 플러그인의 설명을 참조하십시오',
    'storage_function_audio_config' => '오디오 처리 기능 구성',
    'storage_function_audio_config_desc' => '템플릿 ID를 구성 할 수 있습니다. 자세한 내용은 관련 플러그인의 설명을 참조하십시오',
    'storage_function_document_config' => '온라인 미리보기 구성',
    'storage_function_substitution_config' => '유효하지 않은 상태 교체지도',
    'storage_function_substitution_config_desc' => '리소스 파일의 상태가 "유효하지 않은"일 때, 불법 표시 맵이 사용됩니다',
    'storage_function_substitution_image' => '그림이 잘못되었습니다',
    'storage_function_substitution_video' => '비디오가 잘못되었습니다',
    'storage_function_substitution_audio' => '오디오 잘못된 힌트',
    'storage_function_substitution_document' => '잘못된 프롬프트 맵을 문서화합니다',
    'storage_service_provider' => '스토리지 서비스 제공 업체',
    'storage_filesystem_disk' => '파일 시스템 디스크',
    'storage_file_access_domain' => '액세스 도메인',
    'storage_extension_names' => '지원되는 확장자',
    'storage_max_size' => '지원 최대 크기',
    'storage_max_duration' => '지원되는 최대 시간',
    'storage_temporary_url_status' => '임시 URL',
    'storage_temporary_url_status_desc' => '플러그인이 임시 URL 기능을 지원하지 않는 경우 열지 마십시오. 그렇지 않으면 리소스에 액세스할 수 없습니다.',
    'storage_temporary_url_key' => '임시 URL 키',
    'storage_temporary_url_expiration' => '임시 URL 만료',
    'storage_image_handle_position' => '이미지 핸들 위치',
    'storage_image_thumb_config' => '구성지도',
    'storage_image_thumb_avatar' => '화신',
    'storage_image_thumb_ratio' => '아이소 메트릭 썸네일',
    'storage_image_thumb_square' => '사각형 축소판 그림',
    'storage_image_thumb_big' => '원래 압축지도',
    'storage_video_transcode_parameter' => '비디오 트랜스 코딩 매개 변수',
    'storage_video_watermark' => '비디오 워터 마크 매개 변수',
    'storage_video_screenshot' => '비디오 스크린 샷 매개 변수',
    'storage_video_gift' => '비디오 회전 다이어그램 매개 변수',
    'storage_video_poster_parameter' => '포스터 모수',
    'storage_video_transcode_handle_position' => '동영상 트랜스코드 매개변수 처리 위치',
    'storage_video_poster_handle_position' => '포스터 매개변수 처리 위치',
    'storage_audio_transcode_parameter' => '오디오 트랜스 코딩 매개 변수',
    'storage_audio_transcode_handle_position' => '오디오 트랜스코드 매개변수 처리 위치',
    'storage_document_preview_service' => '문서 미리보기 서비스',
    'storage_document_preview_extension_names' => '지원 미리보기 확장자',
    // Operating-User
    'user_name' => '신원 사용자 정의 이름',
    'user_name_desc' => '예를 들어 "사용자", "회원", "위원"및 기타 명명 된',
    'user_uid_name' => 'ID 사용자 정의 이름',
    'user_uid_name_desc' => '예를 들어 "UID", "ID", "멤버 번호"및 기타 이름',
    'user_username_name' => '사용자 이름 사용자 정의 이름',
    'user_username_name_desc' => '예를 들어, "사용자 이름", "회원 이름", "계정"및 기타 이름',
    'user_nickname_name' => '닉네임 사용자 정의 이름',
    'user_nickname_name_desc' => '예를 들어, "닉네임", "꽃 이름", "코드"및 기타 이름',
    'user_role_name' => '역할 사용자 정의 이름',
    'user_role_name_desc' => '예를 들어 "역할", "사용자 그룹", "사용자 그룹"및 기타 이름',
    'user_bio_name' => '약력 사용자 정의 이름',
    'user_bio_name_desc' => '예: 약력 또는 소개',
    'user_default_role' => '기본 사용자 역할',
    'user_default_role_desc' => '등록 후 기본 사용자 역할',
    'user_default_avatar' => '기본 사용자 아바타',
    'user_default_avatar_desc' => '사용자가 아바타를 설정하지 않은 기본 아바타 다이어그램',
    'user_default_anonymous_avatar' => '익명 사용자 아바타',
    'user_default_anonymous_avatar_desc' => '콘텐츠 게시 익명 아바타 다이어그램',
    'user_default_deactivate_avatar' => '사용자 아바타',
    'user_default_deactivate_avatar_desc' => '사용자 로그 아웃 또는 비활성화 후 아바타 이미지',
    'user_identifier' => '사용자 식별자',
    'user_identifier_desc' => '사용자 상호 작용에서 어떤 로고가 지배적입니까?',
    'user_uid_digit' => '사용자 UID 시작 숫자',
    'user_uid_digit_desc' => '등록 시 무작위로 생성되는 자릿수',
    'user_profile_desc' => '사용자의 홈페이지 방문 시 기본 콘텐츠 목록',
    'user_ban_names' => '이름 금지',
    'user_ban_names_desc' => '한 줄에 하나의 이름만 입력할 수 있습니다. 이러한 사용자 아이디와 닉네임의 사용은 금지됩니다.',
    'user_edit_username_length' => '사용자 이름 길이',
    'user_edit_username_length_min' => '최소 길이',
    'user_edit_username_length_max' => '최대 길이',
    'user_edit_username_length_desc' => '사용자 이름 최소 길이 및 최대 길이',
    'user_edit_username_periodicity' => '사용자 이름 수정 간격 번호',
    'user_edit_nickname_length' => '닉네임 길이',
    'user_edit_nickname_periodicity' => '사용자 별명 수정 간격 번호',
    'user_edit_nickname_unique' => '고유한 닉네임',
    'user_edit_bio_length' => '약력',
    'user_edit_bio_support' => '바이오 지원',
    'user_bio_support_mention' => '사용자 멘션',
    'user_bio_support_link' => '링크',
    'user_bio_support_hashtag' => '해시태그',
    'user_extcredits_config' => 'Extcredits 구성',
    'user_extcredits_name' => 'Extcredits 이름',
    'user_extcredits_unit' => '단위 이름',
    'user_extcredits_state_not_enabled' => '사용할 수 없음',
    'user_extcredits_state_private' => '사적인',
    'user_extcredits_state_public' => '공공의',
    'user_conversation_status' => '개인 편지 세션',
    'user_conversation_status_desc' => '닫기는 모든 회원에게 유효하며 개방 후 사용자 역할 권한의 적용을받습니다',
    'user_conversation_files' => '세션 액세서리 기능',
    'user_conversation_files_desc' => '모두가 확인하지 않으면 대리인은 순수한 텍스트의 대화 만 지원합니다',
    // Operating-User-Profile
    'profile_posts' => '그들의 게시물',
    'profile_comments' => '그들의 댓글',
    'profile_likers' => '그들을 좋아한 사용자',
    'profile_dislikers' => '그들을 싫어한 사용자',
    'profile_followers' => '그들을 팔로우한 사용자',
    'profile_blockers' => '그들을 차단한 사용자',
    'profile_followers_you_follow' => '당신이 아는 팔로워',
    'profile_likes_users' => '그들은 사용자를 좋아함',
    'profile_likes_groups' => '그들은 그룹을 좋아함',
    'profile_likes_hashtags' => '그들은 해시태그를 좋아함',
    'profile_likes_geotags' => '그들은 지오태그를 좋아함',
    'profile_likes_posts' => '그들은 게시물을 좋아함',
    'profile_likes_comments' => '그들은 댓글을 좋아함',
    'profile_dislikes_users' => '그들은 사용자를 싫어함',
    'profile_dislikes_groups' => '그들은 그룹을 싫어함',
    'profile_dislikes_hashtags' => '그들은 해시태그를 싫어함',
    'profile_dislikes_geotags' => '그들은 지오태그를 싫어함',
    'profile_dislikes_posts' => '그들은 게시물을 싫어함',
    'profile_dislikes_comments' => '그들은 댓글을 싫어함',
    'profile_following_users' => '그들은 사용자를 팔로우함',
    'profile_following_groups' => '그들은 그룹을 팔로우함',
    'profile_following_hashtags' => '그들은 해시태그를 팔로우함',
    'profile_following_geotags' => '그들은 지오태그를 팔로우함',
    'profile_following_posts' => '그들은 게시물을 팔로우함',
    'profile_following_comments' => '그들은 댓글을 팔로우함',
    'profile_blocking_users' => '그들은 사용자를 차단함',
    'profile_blocking_groups' => '그들은 그룹을 차단함',
    'profile_blocking_hashtags' => '그들은 해시태그를 차단함',
    'profile_blocking_geotags' => '그들은 지오태그를 차단함',
    'profile_blocking_posts' => '그들은 게시물을 차단함',
    'profile_blocking_comments' => '그들은 댓글을 차단함',
    // Operating-Content
    'content_group_name' => '그룹 맞춤 이름',
    'content_group_name_desc' => '예를 들어, "에디션", "원", "분류"및 기타 이름',
    'content_hashtag_name' => '주제 사용자 정의 이름',
    'content_hashtag_name_desc' => '예를 들어, "슈퍼 유사", "태그", "주제"등',
    'content_post_name' => '콘텐츠 이름 게시물',
    'content_post_name_desc' => '예를 들어, "POST", "Dynamics", "그것lk"등',
    'content_comment_name' => '주석 콘텐츠 이름',
    'content_comment_name_desc' => '예를 들어, "댓글", "답장", "상호 작용"및 기타 명명 된',
    'content_publish_post_name' => '게시물 동작 이름을 게시하십시오',
    'content_publish_post_name_desc' => '예를 들어 "게시", "제출", "피드백"및 기타 이름 지정된',
    'content_publish_comment_name' => '코멘트 동작 이름 게시 이름',
    'content_publish_comment_name_desc' => '예를 들어, "답장", "답장", "POST"및 기타 이름 지정된 이름 지정',
    'content_mention_status' => '언급 상태',
    'content_mention_number' => '멘션 수',
    'content_mention_number_desc' => '콘텐츠당 사용자 멘션 수. 0은 제한이 없음을 의미합니다.',
    'content_hashtag_status' => '해시태그 상태',
    'content_hashtag_format' => '해시태그 형식',
    'content_hashtag_format_1' => '단일 #',
    'content_hashtag_format_2' => '더블 #',
    'content_hashtag_format_desc' => '<a href="#">#주제</a> 및 <a href="#">#주제#</a>',
    'content_hashtag_length' => '해시태그 길이',
    'content_hashtag_number' => '해시태그 개수',
    'content_hashtag_number_desc' => '콘텐츠당 지원되는 해시태그 수. 0은 제한이 없음을 의미합니다.',
    'content_hashtag_regexp' => '해시태그 정규 표현식',
    'content_nearby_length' => '주변 검색 기본 범위',
    'content_nearby_length_desc' => '주변 콘텐츠를 볼 때 검색 범위',
    'content_post_brief_length' => '게시물 추상',
    'content_post_brief_length_desc' => '게시물 이이 세트 값을 초과하여 요약, 대형 콘텐츠 요약 단어 수를 채택합니다',
    'content_comment_brief_length' => '코멘트 요약',
    'content_comment_brief_length_desc' => '설정 값이 요약을 채택하기 전에 의견, 길이 내용 요약을 감독합니다',
    'content_comment_visibility_rule' => '댓글 가시성 규칙',
    'content_comment_visibility_rule_desc' => '게시 시간이 일 수보다 길면 댓글이 숨겨지고 0은 활성화되지 않음을 의미합니다.',
    'content_preview_post_like_users' => '사용자 미리보기처럼 게시',
    'content_preview_post_like_users_desc' => '게시물에 좋아요를 누른 사용자를 미리보기하고 숫자는 미리보기 수를 나타냅니다.',
    'content_preview_post_comments' => '댓글 미리보기 게시',
    'content_preview_post_comments_desc' => '게시물 목록 페이지의 미리보기 댓글이며 숫자는 미리보기 수를 나타냅니다.',
    'content_preview_post_comment_require' => '댓글 게시 미리보기 기준',
    'content_preview_post_comment_require_desc' => '카운트 수에 도달하면 미리보기가 출력됩니다.',
    'content_preview_comment_like_users' => '사용자 미리 보기처럼 댓글 달기',
    'content_preview_comment_replies' => '댓글 답글 미리보기',
    'content_post_edit_config' => '글 편집 권한',
    'content_post_delete_config' => '글 삭제 권한',
    'content_comment_edit_config' => '댓글 편집 권한',
    'content_comment_delete_config' => '댓글 삭제 권한',
    'content_edit_desc' => '게시 후 수정할 수 있나요?',
    'content_delete_desc' => '게시 후 삭제할 수 있나요?',
    // Operating-Interaction
    'interaction_function_status' => '기능 상태',
    'interaction_operation_name' => '작업 이름',
    'interaction_user_title' => '사용자 제목',
    'interaction_public_record' => '공개 기록',
    'interaction_public_count' => '공개 횟수',
    'interaction_column_name' => '열 이름',
    // Operating-Sticker
    'sticker_group' => '식 그룹',
    'sticker_table_group_name' => '감정 그룹 이름',
    'sticker_table_group_image' => '감정 그룹 아이콘',
    'sticker_table_group_code' => '감정 그룹 로고',
    'sticker_table_quantity' => '표현의 수',
    'sticker_manage' => '표현 관리',
    'sticker_table_image' => '표현식 차트',
    'sticker_table_code' => '이모티콘',
    // Operating-Editor
    'editor_group' => '그룹',
    'editor_title' => '제목',
    'editor_sticker' => '표현',
    'editor_image' => '그림',
    'editor_video' => '동영상',
    'editor_audio' => '오디오',
    'editor_document' => '선적 서류 비치',
    'editor_mention' => '아타씨',
    'editor_hashtag' => '주제',
    'editor_extend' => '확장자',
    'editor_location' => '위치',
    'editor_anonymous' => '익명의',
    'editor_upload_image_type' => '이미지 업로드 양식',
    'editor_upload_video_type' => '동영상 업로드 양식',
    'editor_upload_audio_type' => '오디오 업로드 양식',
    'editor_upload_document_type' => '문서 업로드 양식',
    'editor_upload_image_number' => '최대 업로드 이미지 수',
    'editor_upload_video_number' => '최대 업로드 동영상 수',
    'editor_upload_audio_number' => '최대 업로드 오디오 수',
    'editor_upload_document_number' => '최대 업로드 문서 수',
    // Operating-Publish
    'publish_editor_config' => '편집자 선택',
    'publish_editor_function_status' => '편집기 기능',
    'publish_editor_function_options' => '편집기 기능 구성',
    'publish_post_verify_config' => '게시물 요청을 게시하십시오',
    'publish_comment_verify_config' => '코멘트 요청을 게시하십시오',
    'publish_post_rules_config' => '게시물 특별 규칙을 게시하십시오',
    'publish_comment_rules_config' => '리뷰 스페셜 규칙을 게시하십시오',
    'publish_editor_desc' => '편집자가 게시되었습니다',
    'publish_verify_desc' => '계정을 게시하려면 선택한 정보로 계정을 완성해야 합니다.',
    'publish_rules_desc' => '모든 직원은 유효하고 우선 순위가 역할 규칙보다 큽니다',
    'publish_rule_type' => '규칙 유형',
    'publish_rule_datetime' => '날짜 범위',
    'publish_rule_time' => '시간 제한',
    'publish_rule_timezone' => '시간대 표준',
    'publish_rule_rule' => '규칙 요구 사항',
    'publish_rule_tip' => '규칙 프롬프트',
    'publish_edit_time_limit' => '얼마나 오래 편집 할 수 있습니까?',
    'publish_edit_sticky_limit' => '애프터 스티키',
    'publish_edit_digest_limit' => '애프터 다이제스트',
    'publish_editor_group_required' => '그룹이 필요한지 여부',
    'publish_editor_group_required_desc' => '게시물을 게시 할 때 선택해야합니까?',
    'publish_editor_title_input_box' => '제목 입력 상자 디스플레이',
    'publish_editor_title_input_box_desc' => '약한 디스플레이가 사용자가 제목 입력 상자를 수동으로 선택해야합니다',
    'publish_editor_title_required' => '제목이 채워야하는지 여부',
    'publish_editor_title_required_desc' => '게시물을 게시 할 때 제목을 채워야합니다',
    'publish_editor_title_length' => '제목 단어 제한',
    'publish_editor_title_length_desc' => '타이틀 수는 설정 수를 초과해서는 안됩니다. 최대 상한 255 자',
    'publish_editor_post_content_length' => '워드 제한을 게시하십시오',
    'publish_editor_post_content_length_desc' => '게시물 수는 설정 수, 최소 상한 140자를 초과하지 않습니다',
    'publish_editor_comment_content_length' => '댓글 워드 제한',
    'publish_editor_comment_content_length_desc' => '주석의 수는 설정 수, 최소 상한 140자를 초과해서는 안됩니다',
    // Operating-Permission
    'permission_option_email' => '이메일 필수',
    'permission_option_phone' => '전화 필수',
    'permission_option_kyc' => 'KYC 필수',
    'permission_option_rule_datetime' => '지정된 날짜 범위 내에서 효과적입니다',
    'permission_option_rule_time' => '지정된 기간 내에 시간주기를 지정하십시오',
    'permission_option_review_publish' => '게시 할 수 있지만 검토해야합니다',
    'permission_option_close_publish' => '게시 금지',
    'permission_option_can_be_edited' => '편집 가능',
    'permission_option_cannot_be_edited' => '편집할 수 없음',
    'permission_option_can_be_deleted' => '삭제 가능',
    'permission_option_cannot_be_deleted' => '삭제할 수 없음',
    'permission_option_direct_release' => '직접 패스',
    'permission_option_required_review' => '검토해야합니다',
    'permission_option_title_optional_display' => '약한 디스플레이',
    'permission_option_title_direct_display' => '강한 디스플레이',
    // Operating-Roles
    'role_table_display' => '로고를 표시합니다',
    'role_table_nickname_color' => '닉네임 색상',
    'role_option_display_icon' => '디스플레이 아이콘',
    'role_option_display_text' => '텍스트',
    'role_option_close_nickname_color' => '색상을 사용하지 마십시오',
    'role_current' => '현재 역할',
    'role_target' => '목표 역할',
    'role_target_desc' => '역할이 삭제 된 후에 사용자는 역할 아래 선택된 대상 역할 이름에 병합됩니다',
    'role_perm_basic_config' => '기본 설정',
    'role_perm_post_config' => '게시물 설정을 게시하십시오',
    'role_perm_comment_config' => '코멘트 설정을 게시하십시오',
    'role_perm_upload_config' => '업로드 설정',
    'role_perm_interaction_config' => '대화형 설정',
    'role_perm_customize_config' => '사용자 설정',
    'role_perm_content_view' => '찾아보기 허가',
    'role_perm_conversation' => '세션 허가',
    'role_perm_content_link_handle' => '게시된 콘텐츠에 대한 링크 처리',
    'role_perm_content_link_handle_1' => '도메인 이름을 구문 분석 및 마스킹하지 않음',
    'role_perm_content_link_handle_2' => '구문 분석되지 않았지만 텍스트로 표시됨',
    'role_perm_content_link_handle_3' => '일반 구문 분석',
    'role_perm_post_publish' => '게시물 허가를 게시하십시오',
    'role_perm_post_verify' => '게시물 요청을 게시하십시오',
    'role_perm_post_review' => '게시물 규칙을 게시하십시오',
    'role_perm_post_rules' => '게시물 특별 규칙을 게시하십시오',
    'role_perm_post_time_interval' => '게시 시간 간격',
    'role_perm_post_daily_count' => '일일 한도 이후',
    'role_perm_post_draft_count' => '초안 게시 한도',
    'role_perm_comment_publish' => '코멘트 특권을 게시하십시오',
    'role_perm_comment_verify' => '코멘트 요청을 게시하십시오',
    'role_perm_comment_review' => '의견을 게시하십시오',
    'role_perm_comment_rules' => '리뷰 스페셜 규칙을 게시하십시오',
    'role_perm_comment_time_interval' => '게시물 메시지 간격',
    'role_perm_comment_daily_count' => '댓글 일일 한도',
    'role_perm_comment_draft_count' => '댓글 초안 한도',
    'role_perm_upload_image' => '이미지 업로드',
    'role_perm_upload_video' => '비디오 업로드',
    'role_perm_upload_audio' => '오디오 업로드',
    'role_perm_upload_document' => '문서 업로드',
    'role_perm_upload_file_desc' => '대리인을 확인하면 업로드 할 권리가 있으므로 입력 상자가 비어 있으면 "저장소 구성"을 기본 매개 변수로 사용합니다',
    'role_perm_follow_user_max_count' => '팔로우 사용자 최대 수',
    'role_perm_block_user_max_count' => '차단 사용자 최대 수',
    'role_perm_download_file_count' => '24 시간 이내에 상한을 다운로드하십시오',
    'role_perm_table_name' => '권위명',
    'role_perm_table_value' => '권한 값',
    // Operating-Groups
    'group_table_parent_group' => '상위 그룹',
    'group_table_subgroup' => '하위 그룹',
    'group_table_privacy' => '개인정보 보호',
    'group_table_visibility' => '가시성',
    'group_table_follow_method' => '팔로우 방법',
    'group_table_recommend' => '추천하고 있습니까?',
    'group_table_admins' => '그룹 관리자',
    'group_table_can_publish' => '게시 가능',
    'group_table_post_permissions' => '글 권한',
    'group_table_comment_permissions' => '댓글 권한',
    'group_table_publish_perm_role' => '게시 할 권리가있는 역할',
    'group_table_publish_perm_review' => '감사가 필요합니까?',
    'group_table_publish_perm_review_desc' => '그룹 관리자는 제한되지 않습니다',
    'group_public_desc' => '열기 (그룹 내의 게시물을 볼 수 있습니다)',
    'group_private_desc' => '비공개 (회원 만 그룹 내의 게시물 만 볼 수 있음)',
    'group_visible_desc' => '그것은 발견 될 수 있습니다 (누구나이 그룹을 찾을 수 있습니다)',
    'group_hidden_desc' => '찾지 못함 (회원만이 그룹을 찾을 수 있음)',
    'group_publish_option_all' => '모든 사람',
    'group_publish_option_members' => '사용자 그룹 만 지불합니다',
    'group_publish_option_roles' => '지정된 역할 사용자 전용',
    'group_publish_option_admins' => '팀 관리자만',
    'group_can_publish_desc' => '게시 권한을 닫으면 그룹 분류로 사용할 수 있습니다.',
    'group_current' => '현재 그룹',
    'group_target' => '대상 그룹',
    'group_target_desc' => '합병 후 이전 그룹이 삭제되고 이전 그룹의 내용이 선택한 대상 팀 이름으로 마이그레이션됩니다',
    // Extends
    'extend_editor_menus' => '메뉴',
    'extend_editor_toolbar' => '도구 모음',
    'extend_editor_number_of_uses_desc' => '"투표"플러그인의 예로는 단일 게시물을 나타내는 2 개의 숫자가 2로 표시됩니다',
    'extend_content_service' => '콘텐츠 서비스',
    'extend_content_list' => '콘텐츠 목록',
    'extend_content_detail' => '콘텐츠 세부 정보',
    'extend_content_search' => '콘텐츠 검색',
    'extend_content_list_desc' => '이 구성은 컨텐츠 유형 구성보다 우선 순위가 높으며 구성되면 컨텐츠 유형으로 지정된 데이터 소스가 대체됩니다.',
    'extend_content_ip' => 'IP 서비스',
    'extend_content_map' => '지도 서비스',
    'extend_content_notifications_service' => '알림 서비스',
    'extend_content_review' => '리뷰 서비스',
    'extend_content_list_by_all' => '모든 게시물 또는 댓글',
    'extend_content_list_by_timelines' => '타임라인 게시물 또는 댓글',
    'extend_content_list_by_nearby' => '주변 게시물 또는 댓글',
    'extend_content_by_detail' => '게시물 또는 댓글 세부정보',
    'extend_content_search_users' => '사용자 검색',
    'extend_content_search_groups' => '그룹 검색',
    'extend_content_search_hashtags' => '해시태그 검색',
    'extend_content_search_geotags' => '위치정보 태그 검색',
    'extend_content_search_posts' => '게시물 검색',
    'extend_content_search_comments' => '댓글 검색',
    // Client-Channels
    'channel_default_homepage' => '기본 홈페이지',
    'channel_table_channel' => '채널',
    'channel_table_page' => '페이지',
    'channel_table_page_home' => '홈',
    'channel_table_page_list' => '목록',
    'channel_table_page_detail' => '세부 정보',
    'channel_table_page_interaction' => '상호작용',
    'channel_table_path' => '경로',
    'channel_table_seo' => 'SEO 정보',
    'channel_table_seo_title' => 'SEO 제목',
    'channel_table_seo_description' => 'SEO 설명',
    'channel_table_seo_keywords' => 'SEO 키워드',
    'channel_table_query_state' => '클라이언트 전달 매개변수',
    'channel_table_query_state_desc' => '클라이언트 측 매개변수 허용 여부는 종료 후 기본 매개변수 값만 지원됩니다.',
    'channel_table_query_config' => '기본 매개 변수',
    'channel_table_query_config_desc' => '이 인터페이스의 API 쿼리 매개변수를 참조하십시오.',
    'channel_query_state_1' => '클라이언트 매개변수가 허용되지 않습니다.',
    'channel_query_state_2' => '클라이언트 페이징 매개변수만 허용',
    'channel_query_state_3' => '모든 매개변수 수락',
    // Client-Columns
    'channel_timeline' => '타임라인',
    'channel_timeline_all_posts' => '팔로우한 모든 게시물',
    'channel_timeline_user_posts' => '내가 팔로우하는 사용자 게시물',
    'channel_timeline_group_posts' => '그룹 게시물을 팔로우함',
    'channel_timeline_hashtag_posts' => '해시태그 게시물을 팔로우합니다',
    'channel_timeline_geotag_posts' => '지오태그 게시물을 팔로우합니다',
    'channel_timeline_all_comments' => '내가 팔로우하는 모든 댓글',
    'channel_timeline_user_comments' => '사용자 댓글을 팔로우합니다',
    'channel_timeline_group_comments' => '그룹 댓글을 팔로우합니다',
    'channel_timeline_hashtag_comments' => '해시태그 댓글을 팔로우합니다',
    'channel_timeline_geotag_comments' => '지오태그 댓글을 팔로우합니다',
    'channel_nearby' => 'Nearby',
    'channel_nearby_posts' => 'Nearby의 게시물',
    'channel_nearby_comments' => 'Nearby의 댓글',
    'channel_me' => '개인 센터',
    'channel_me_extcredits' => '익스크레딧',
    'channel_me_wallet' => '월렛',
    'channel_me_drafts' => '초안',
    'channel_me_users' => '사용자',
    'channel_me_settings' => '설정',
    'channel_messages' => '메시지',
    'channel_conversations' => '대화',
    'channel_notifications' => '알림',
    'channel_notifications_all' => '알림-모두',
    'channel_notifications_systems' => '알림-시스템',
    'channel_notifications_recommends' => '알림-추천',
    'channel_notifications_likes' => '알림-좋아요',
    'channel_notifications_dislikes' => '알림-싫어요',
    'channel_notifications_follows' => '알림-팔로우',
    'channel_notifications_blocks' => '알림-블록',
    'channel_notifications_mentions' => '알림-언급',
    'channel_notifications_comments' => '알림-코멘트',
    'channel_notifications_quotes' => '알림-인용하다',
    'channel_search' => '검색',
    // Client-Keys
    'key_table_read_only' => '읽기 전용',
    'key_select_platform' => '키 응용 프로그램 플랫폼을 선택하십시오',
    'key_option_main_api' => '메인 API',
    'key_option_manage_api' => '관리 API',
    'key_option_plugin_api' => '플러그인 API',
    'key_option_plugin_api_select' => '사용할 플러그인을 선택하십시오',
    'key_option_plugin_api_select_desc' => '이 키는 연관된 플러그인의 API 만 요청할 수 있습니다',
    // Client-Basic
    'website_stat_code' => '사이트 통계 코드',
    'website_stat_code_desc' => 'document.write가 포함된 통계 코드의 사용은 지원되지 않습니다.',
    'website_stat_position' => '통계 코드 위치',
    'website_stat_position_desc' => '통계 코드가 HTML에 로드되는 위치입니다.',
    'china_mode' => '차이나 모드',
    'china_mode_desc' => '사이트 서버를 중국에 배포할 때 필요한 정보입니다.',
    'china_mode_config' => '중국 본토 서버 구성(필수 필드 없음)',
    'china_icp_filing' => '인터넷 콘텐츠 제공자 제출',
    'china_icp_license' => '인터넷 콘텐츠 제공자 라이선스',
    'china_mps_filing' => '공안국 제출',
    'china_broadcasting_license' => '방송 라이센스',
    // Client-Status
    'client_status_desc' => '10분마다 클라이언트 요청 상태 구성',
    // App-Center-Themes
    'website_engine_config' => '엔진 구성',
    'website_engine_api_config' => 'API 구성',
    'website_engine_status' => '웹 엔진 상태',
    'website_engine_api_type' => '엔진 API 유형',
    'website_engine_key_id' => '애플리케이션 키 선택',
    'website_engine_view_desktop' => '컴퓨터',
    'website_engine_view_mobile' => '모바일',
    // App-Center-Install
    'install_website_engine' => '웹사이트 엔진 설치',
    'install_plugin' => '플러그인 설치',
    'install_application' => '앱 설치',
    'install_mode' => '설치 모드',
    'install_mode_fskey' => '입력 Fresns 키',
    'install_mode_upload' => 'Zip 패키지 업로드',
    'install_mode_directory' => '입력 디렉토리 경로',
    'download_application' => '앱 다운로드',
];
