<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresns 控制面板',
    'fresns_core' => 'Fresns 主程序',
    // Login page
    'language' => '语言',
    'login' => '登录',
    'account' => '账号',
    'password' => '密码',
    'enter' => '进入',
    'operation' => '面板操作',
    'site_home' => '站点首页',
    'switch_language' => '切换语言',
    'logout' => '退出登录',
    // Header menus
    'menu_dashboard' => '仪表盘',
    'menu_systems' => '系统',
    'menu_operations' => '运营',
    'menu_extends' => '扩展',
    'menu_clients' => '客户端',
    'menu_app_center' => '应用中心',
    'menu_marketplace' => '应用市场',
    // Sidebar menus
    'sidebar_home' => '首页',
    'sidebar_admins' => '管理员',
    'sidebar_events' => '事件',
    'sidebar_events_tab_subscribe' => '订阅事件',
    'sidebar_events_tab_crontab' => '定时任务',
    'sidebar_caches' => '缓存',
    'sidebar_caches_tab_config' => '配置信息',
    'sidebar_caches_tab_data' => '数据内容',
    'sidebar_upgrades' => '更新',
    'sidebar_settings' => '设置',
    'sidebar_languages' => '语言设置',
    'sidebar_storage' => '存储设置',
    'sidebar_storage_tab_image' => '图片',
    'sidebar_storage_tab_video' => '视频',
    'sidebar_storage_tab_audio' => '音频',
    'sidebar_storage_tab_document' => '文档',
    'sidebar_storage_tab_substitution' => '替补图设置',
    'sidebar_general' => '站点设置',
    'sidebar_policy' => '政策设置',
    'sidebar_policy_tab_options' => '政策功能',
    'sidebar_policy_tab_contents' => '政策内容',
    'sidebar_send' => '发信设置',
    'sidebar_send_tab_services' => '发信服务商',
    'sidebar_send_tab_templates' => '验证码模板',
    'sidebar_account' => '账户设置',
    'sidebar_wallet' => '钱包设置',
    'sidebar_wallet_tab_options' => '功能设置',
    'sidebar_wallet_tab_recharge_services' => '充值服务商',
    'sidebar_wallet_tab_withdraw_services' => '提现服务商',
    'sidebar_user' => '用户配置',
    'sidebar_content' => '内容配置',
    'sidebar_interaction' => '互动配置',
    'sidebar_publish' => '发表配置',
    'sidebar_publish_tab_post' => '发表帖子',
    'sidebar_publish_tab_comment' => '发表评论',
    'sidebar_roles' => '用户角色',
    'sidebar_stickers' => '表情贴纸',
    'sidebar_groups' => '内容小组',
    'sidebar_groups_tab_active' => '启用的小组',
    'sidebar_groups_tab_deactivate' => '停用的小组',
    'sidebar_groups_tab_recommend' => '仅查看推荐',
    'sidebar_extend_editor' => '编辑器扩展',
    'sidebar_extend_content_type' => '内容类型扩展',
    'sidebar_extend_content_handler' => '内容处理扩展',
    'sidebar_extend_manage' => '管理扩展',
    'sidebar_extend_group' => '小组扩展',
    'sidebar_extend_group_filter' => '小组筛选',
    'sidebar_extend_user_feature' => '用户功能扩展',
    'sidebar_extend_user_profile' => '用户资料扩展',
    'sidebar_extend_channel' => '频道扩展',
    'sidebar_extend_command_words' => '接口命令字扩展',
    'sidebar_channels' => '频道配置',
    'sidebar_paths' => '路径配置',
    'sidebar_language_packs' => '语言包配置',
    'sidebar_code_messages' => '状态码配置',
    'sidebar_client_basic' => '客户端基础',
    'sidebar_client_status' => '客户端状态',
    'sidebar_plugins' => '扩展插件',
    'sidebar_plugins_tab_all' => '全部',
    'sidebar_plugins_tab_active' => '已启用',
    'sidebar_plugins_tab_inactive' => '未启用',
    'sidebar_themes' => '主题模板',
    'sidebar_apps' => '独立应用',
    'sidebar_keys' => '应用密钥',
    // Sidebar intro
    'sidebar_admins_intro' => '有权登录控制面板的用户',
    'sidebar_events_intro' => '查看系统中定时任务和订阅事件',
    'sidebar_caches_intro' => '清空全部缓存的时候，可能让服务器负载升高，请尽量避开访问高峰时间',
    'sidebar_upgrades_intro' => '最后检查于',
    'sidebar_settings_intro' => '配置完成后请清空缓存，或者等待 10 分钟后新缓存生效。',
    'sidebar_languages_intro' => '多语言需要先在这里配置语言选项，然后才能在对应配置项时录入多语言内容。',
    'sidebar_storage_intro' => '四种资源文件可分开存储，也可存储在同一处，只需将存储配置信息填写一致即可。',
    'sidebar_general_intro' => '保障系统正常运行的设置项。',
    'sidebar_policy_intro' => '根据目标市场所在国的相关数据法律条例配置功能。',
    'sidebar_send_intro' => '邮件短信和系统通知等消息发送设置。',
    'sidebar_account_intro' => '账户中心功能设置。',
    'sidebar_wallet_intro' => '钱包为真实货币功能，如需虚拟积分功能请安装相应的插件。',
    'sidebar_wallet_tab_recharge_services_intro' => '充值服务商配置将呈现在「钱包」功能列表中，用于支付订单或者充值钱包。',
    'sidebar_wallet_tab_withdraw_services_intro' => '提现服务商配置将呈现在「钱包」功能列表中，用于钱包余额提现到指定账户中。',
    'sidebar_user_intro' => '用户基础功能设置。',
    'sidebar_content_intro' => '社交内容名称和功能配置。',
    'sidebar_interaction_intro' => '用户感知一款产品的服务（体验感），并不取决于技术逻辑，而是来源于功能点命名。',
    'sidebar_publish_intro' => '此处配置对全员有效，权限优先级大于用户角色权限。',
    'sidebar_roles_intro' => '角色可以对用户身份和权限进行特定的设置。',
    'sidebar_stickers_intro' => '自定义配置表情图，在不配置的情况下，用户也可以通过表情键盘输入 Emoji 表情。',
    'sidebar_groups_intro' => '使用小组可以实现 BBS 版区、社群圈子、内容分类等各种运营场景。',
    'sidebar_extend_editor_intro' => '将呈现在发布流程的「编辑器」中，例如「投票」扩展可以让「编辑器」支持为帖子附带投票功能。',
    'sidebar_extend_content_type_intro' => '将呈现在「帖子」列表页面中，用于输出指定「类型」的帖子，以及定义数据结果来源。',
    'sidebar_extend_content_handler_intro' => '功能与「内容类型扩展」数据来源功能一样，是否将请求分发给插件处理，由插件决定数据逻辑。',
    'sidebar_extend_manage_intro' => '将呈现在帖子、评论、用户主页的「更多」功能列表中，例如「投诉」扩展可以让用户对相应目标进行投诉。',
    'sidebar_extend_group_intro' => '将呈现在「小组」主页中，例如「纯链接扩展插件」可以在「小组」主页显示一个超链接。',
    'sidebar_extend_user_feature_intro' => '将呈现在「用户中心」的“我的”页面中，例如「钱包」扩展可以让用户中心多一个钱包功能。',
    'sidebar_extend_user_profile_intro' => '将呈现在「用户资料」管理功能列表中，例如「修改用户名插件」可以让修改资料功能支持修改用户名。',
    'sidebar_extend_channel_intro' => '将呈现在「主菜单」或者「频道」页面列表中，例如「购物」扩展可以让用户进入商城频道。',
    'sidebar_extend_command_words_intro' => '配置在该列表的命令字，可供 API 请求使用。',
    'sidebar_channels_intro' => '统一配置客户端各个频道信息。',
    'sidebar_paths_intro' => '自定义路径结构可以为链接提高美感、可用性和前向兼容性。',
    'sidebar_language_packs_intro' => '为多语言客户端配置各项文本的多语言内容。',
    'sidebar_code_messages_intro' => '为主程序和插件配置状态码的多语言描述。',
    'sidebar_client_basic_intro' => '客户端基础的通用配置项。',
    'sidebar_client_status_intro' => '停用后，客户端所有页面和操作将跳转到停用说明页面。',
    'sidebar_plugins_intro' => '灵活的功能，强大的扩展，助您自由发挥心中所想。',
    'sidebar_themes_intro' => '选配不同的主题，实现更个性化的风格和交互。',
    'sidebar_apps_intro' => '标准的 API，强大的扩展，随心打造多样的运营场景和应用模式。',
    'sidebar_keys_intro' => '密钥凭证很重要，请勿轻易透露给其他人。',
    // Page button
    'button_support' => '帮助说明',
    'button_update' => '更新',
    'button_search' => '搜索',
    'button_add' => '新增',
    'button_edit' => '编辑',
    'button_modify' => '修改',
    'button_delete' => '删除',
    'button_cancel' => '取消',
    'button_close' => '关闭',
    'button_dismiss' => '驳回',
    'button_activate' => '启用',
    'button_deactivate' => '停用',
    'button_install' => '安装',
    'button_uninstall' => '卸载',
    'button_setting' => '设置',
    'button_config' => '配置',
    'button_reset' => '重置',
    'button_confirm' => '确认',
    'button_try_again' => '再试一次',
    'button_save' => '提交保存',
    'button_download' => '下载',
    'button_upgrade' => '升级',
    'button_automatic_upgrade' => '自动升级',
    'button_manual_upgrade' => '手动升级',
    'button_confirm_delete' => '确认删除',
    'button_confirm_install' => '确认安装',
    'button_confirm_upgrade' => '确认升级',
    'button_confirm_download' => '确认下载',
    'button_confirm_uninstall' => '确认卸载',
    'button_view' => '查看',
    'button_image_upload' => '上传图片',
    'button_image_input' => '输入地址',
    'button_check_upgrade' => '检查更新',
    'button_check_status' => '检查状态',
    'button_batch_import' => '批量导入',
    'button_batch_export' => '批量导出',
    'button_config_email_template' => '配置邮件模板',
    'button_config_sms_template' => '配置短信模板',
    'button_config_sticker' => '配置表情图',
    'button_config_permission' => '配置权限',
    'button_config_language_pack' => '配置语言包',
    'button_add_admin' => '新增管理员',
    'button_add_language' => '新增语言',
    'button_add_account_connect' => '新增账号互联',
    'button_add_service_provider' => '新增服务商',
    'button_add_sticker_group' => '新增表情组',
    'button_add_sticker' => '新增表情图',
    'button_add_role' => '新增角色',
    'button_add_group' => '新增小组',
    'button_group_move' => '合并',
    'button_add_key' => '新增密钥',
    'button_reset_key' => '重置 Key',
    'button_reset_secret' => '重置 Secret',
    'button_clear_cache' => '清理缓存',
    'button_clear_all_cache' => '清空全部缓存',
    // Page table
    'table_order' => '显示顺序',
    'table_recommend_order' => '推荐顺序',
    'table_position' => '显示位置',
    'table_number' => '编号',
    'table_lang_tag' => '语言标签',
    'table_lang_name' => '语言名称',
    'table_title' => '标题',
    'table_content' => '内容',
    'table_platform' => '平台',
    'table_service' => '服务商',
    'table_app_id' => 'App ID',
    'table_app_key' => 'App Key',
    'table_app_secret' => 'App Secret',
    'table_plugin' => '插件',
    'table_command_word' => '命令字',
    'table_name' => '名称',
    'table_description' => '描述',
    'table_icon' => '图标',
    'table_banner' => '条幅',
    'table_type' => '类型',
    'table_use' => '用途说明',
    'table_support' => '支持方式',
    'table_data_source' => '数据来源',
    'table_scene' => '使用场景',
    'table_number_of_uses' => '使用数量',
    'table_scope' => '使用范围',
    'table_scope_global' => '全局',
    'table_scope_global_desc' => '可限制指定角色才能使用',
    'table_scope_group_admins' => '小组管理员专用',
    'table_scope_group_admins_desc' => '启用后，仅小组管理员会展示该插件',
    'table_authorized_roles' => '角色使用权',
    'table_authorized_roles_desc' => '留空代表所有用户角色均有权使用',
    'table_whitelist_rules' => '白名单角色',
    'table_parameter' => '自定义参数',
    'table_status' => '启用状态',
    'table_options' => '操作',
    // Config option
    'option_default' => '默认',
    'option_all' => '全部',
    'option_public' => '公开',
    'option_private' => '私有',
    'option_visible' => '显示',
    'option_hidden' => '隐藏',
    'option_open' => '开启',
    'option_close' => '关闭',
    'option_yes' => '是',
    'option_no' => '否',
    'option_activate' => '启用',
    'option_deactivate' => '停用',
    'option_local' => '本地',
    'option_remote' => '远程',
    'option_required' => '需要',
    'option_not_required' => '不需要',
    'option_not_set' => '未设置',
    'option_no_use' => '不使用',
    'option_unselect' => '不选择',
    'option_optional' => '可选',
    'option_email' => '邮件',
    'option_sms' => '短信',
    'option_data_close' => '不公开',
    'option_data_private' => '仅对自己公开',
    'option_data_public' => '对所有人公开',
    'option_type_tree' => '树结构',
    'option_type_list' => '列表',
    'option_uninstall_plugin_data' => '同步删除该插件的数据',
    'option_uninstall_theme_data' => '同步删除该主题的数据',
    // Commons
    'portal' => '门户',
    'user' => '用户',
    'group' => '小组',
    'hashtag' => '话题',
    'geotag' => '地理',
    'post' => '帖子',
    'comment' => '评论',
    'file' => '文件',
    'extend' => '扩展内容',
    'user_detail' => '用户主页',
    'group_detail' => '小组详情',
    'hashtag_detail' => '话题详情',
    'geotag_detail' => '地理详情',
    'post_detail' => '帖子详情',
    'comment_detail' => '评论详情',
    'like' => '赞',
    'dislike' => '踩',
    'follow' => '关注',
    'block' => '屏蔽',
    'author' => '开发者',
    'new_version' => '有新版',
    'default_language' => '默认语言',
    'default_list' => '默认列表',
    'recommend' => '推荐',
    'unit_day' => '天',
    'unit_length' => '位数',
    'unit_second' => '秒',
    'unit_minute' => '分钟',
    'unit_within_minute' => '分钟以内',
    'unit_character' => '字符',
    'unit_number' => '个数',
    'unit_number_of_times' => '次数',
    'unit_kilometer' => '公里',
    'unit_mile' => '英里',
    'config_default' => '默认配置',
    'config_name' => '名称配置',
    'config_edit' => '修改配置',
    'config_interaction' => '互动配置',
    'config_conversation' => '对话配置',
    'config_hashtag' => '话题配置',
    'config_list' => '列表配置',
    'config_preview' => '预览配置',
    'config_manage' => '管理配置',
    'delete_desc' => '确定删除吗？',
    // Dashboard-Home
    'welcome' => '欢迎使用 Fresns',
    'current_version' => '当前使用的版本是',
    'overview' => '站点数据',
    'overview_accounts' => '账号总数',
    'overview_users' => '用户总数',
    'overview_groups' => '小组总数',
    'overview_hashtags' => '话题总数',
    'overview_geotags' => '地理总数',
    'overview_posts' => '帖子总数',
    'overview_comments' => '评论总数',
    'extensions' => '应用数量',
    'support' => '帮助手册',
    'support_website' => 'Fresns 官网',
    'support_teams' => '开源团队',
    'support_sponsor' => '赞助我们',
    'support_join' => '加入我们',
    'support_community' => '支持社区',
    'support_marketplace' => '应用市场',
    'system_info' => '系统信息',
    'system_info_server' => '服务器系统',
    'system_info_web' => 'Web 运行环境',
    'system_info_php_version' => 'PHP 版本',
    'system_info_php_cli_info' => 'PHP Cli 信息',
    'system_info_php_upload_max_filesize' => '上传最大文件大小',
    'system_info_composer_info' => 'Composer 信息',
    'system_info_composer_version' => 'Composer 版本',
    'system_info_env_timezone' => '.env 时区',
    'system_info_env_timezone_name' => '.env 时区地名',
    'system_info_env_timezone_utc' => '.env 时区地名所属 UTC 时区',
    'system_info_env_timezone_list' => '匹配的时区地名',
    'system_info_database_driver' => '数据库驱动',
    'system_info_database_version' => '数据库版本',
    'system_info_database_timezone' => '数据库时区',
    'system_info_database_engine' => '数据库存储引擎',
    'system_info_database_collation' => '数据库排序规则',
    'system_info_database_size' => '当前数据库尺寸',
    'tips' => '使用说明',
    'news' => 'Fresns 活动和新闻',
    // Dashboard-Events
    'event_subscribe_subject' => '主题',
    'event_crontab_time' => '执行周期',
    'event_crontab_time_desc' => 'Laravel 定时任务表达式',
    // Dashboard-Caches
    'cache' => '缓存',
    'cache_fresns_system' => '系统信息',
    'cache_fresns_config' => '站点配置',
    'cache_fresns_extend' => '扩展配置',
    'cache_fresns_view' => '视图',
    'cache_fresns_route' => '路由',
    'cache_fresns_event' => '事件',
    'cache_fresns_schedule' => '任务调度',
    'cache_fresns_temporary' => '临时数据',
    // Dashboard-Admins
    'admin_add_title' => '新增系统管理员',
    'admin_add_form_account' => '账号',
    'admin_add_form_account_placeholder' => '邮箱或者手机号',
    'admin_add_form_account_desc' => '手机号必须为带国际区号的完整号码',
    'admin_add_form_account_btn' => '搜索并增加',
    // Dashboard-Settings
    'setting_developer_options' => '开发者选项',
    'setting_developer_options_desc' => '不是开发环境下，请勿停用选项。',
    'setting_build_type' => '版本类型',
    'setting_build_type_desc' => '测试版稳定性欠佳，请谨慎选择。',
    'setting_build_select_tip' => '选择升级版本类型',
    'setting_build_option_stable' => '稳定版 Stable Build',
    'setting_build_option_beta' => '测试版 Beta Build',
    'setting_system_url' => '系统网址',
    'setting_system_url_desc' => '主程序 API 和插件默认访问地址',
    'setting_panel_path' => '安全入口',
    'setting_panel_path_desc' => '设置后只能通过指定安全入口登录控制面板',
    'setting_panel_url' => '入口完整地址',
    'setting_panel_url_desc' => '控制面板登录入口完整网址',
    'setting_panel_url_copy' => '复制',
    // System-Languages
    'language_multilingual' => '多语言',
    'language_table_default' => '默认语言',
    'language_table_langCode' => '语言代码',
    'language_table_areaCode' => '地区代码',
    'language_table_langName' => '语言名称',
    'language_table_areaName' => '地区名称',
    'language_table_lengthUnit' => '长度单位',
    'language_table_writingDirection' => '书写方向',
    'language_table_area' => '语言地区',
    'language_table_dateFormat' => '日期格式',
    'language_table_dateFormat_desc' => 'yyyy 表示年，mm 表示月，dd 表示天。',
    'language_table_timeFormat' => '人性化时间',
    'language_table_timeFormat_desc' => '时间变量名 {n}',
    'language_select_langCode' => '选择语言代码',
    'language_select_continent' => '选择洲',
    'language_select_areaCode' => '选择地区代码',
    // System-General
    'site_url' => '站点网址',
    'site_url_desc' => '主站点访问地址',
    'site_name' => '站点名称',
    'site_name_desc' => '你的 Fresns 站点的名称。',
    'site_intro' => '站点介绍',
    'site_intro_desc' => '你的 Fresns 站点的介绍。',
    'site_logo' => '站点标志',
    'site_logo_desc' => '必须配置了“存储设置”中的信息才能上传图片。',
    'site_copyright' => '版权信息',
    'site_email' => '管理员邮箱',
    'site_email_desc' => '当运行出错时，展示给用户，便于用户反馈问题。',
    'site_mode' => '运行模式',
    'site_mode_public' => '公开模式',
    'site_mode_private' => '私有模式',
    'site_mode_private_desc' => '私有模式配置',
    'site_mode_private_join_status' => '是否对外开放加入',
    'site_mode_private_join_service' => '加入通道支持插件',
    'site_mode_private_content_policy' => '私有到期后的状态',
    'site_mode_private_content_policy_1' => '站点内容全部不可见',
    'site_mode_private_content_policy_2' => '到期前内容可见，新内容不可见',
    // System-Policy
    'policy_terms' => '服务条款',
    'policy_privacy' => '隐私权政策',
    'policy_cookie' => 'Cookie 政策',
    'policy_delete_account' => '注销说明',
    'policy_delete_options' => '注销功能',
    'policy_delete_options_desc' => '用户在缓冲期天数内可以撤销注销（恢复账号），到期未撤销将执行注销流程。',
    'policy_delete_option_1' => '不启用注销功能',
    'policy_delete_option_2' => '逻辑注销',
    'policy_delete_option_2_desc' => '逻辑注销：仅在数据库中标注账号为注销，并不真实删除数据。',
    'policy_delete_option_3' => '物理注销',
    'policy_delete_option_3_desc' => '物理注销：物理删除数据，用户资料和发表的内容将会被真实删除。',
    'policy_delete_crontab' => '注销缓冲期',
    // System-Send
    'send_email_config' => '邮箱配置',
    'send_sms_config' => '短信配置',
    'send_sms_default_code' => '默认国际区号',
    'send_sms_supported_codes' => '支持更多区号',
    'send_sms_desc' => '一行一个，区号不带加号。留空代表只支持单一国家。配置前请确认服务商支持国际短信功能。',
    'send_app_notifications' => '推送通知服务',
    'send_app_ios_config' => 'iOS 配置',
    'send_app_ios_notifications_desc' => 'iOS 系统弹窗通知功能。',
    'send_app_android_config' => 'Android 配置',
    'send_app_android_notifications_desc' => 'Android 系统弹窗通知功能。',
    'send_app_desktop_config' => '桌面配置',
    'send_app_desktop_notifications_desc' => '桌面通知功能，例如浏览器通知。',
    'send_code_template_1' => '通用验证码',
    'send_code_template_2' => '注册新账号',
    'send_code_template_3' => '修改账号资料',
    'send_code_template_4' => '更换新绑定',
    'send_code_template_5' => '重置登录密码',
    'send_code_template_6' => '重置支付密码',
    'send_code_template_7' => '使用验证码登录',
    'send_code_template_8' => '使用验证码注销账号',
    'send_code_template_table_email_desc' => '支持 HTML 格式',
    'send_code_template_table_sms_sign' => '短信签名名称',
    'send_code_template_table_sms_code' => '模板参数',
    'send_code_template_table_sms_code_desc' => '可以配置模板 ID，详情请查阅关联插件的说明。',
    'send_code_template_table_sms_param' => '验证码变量名',
    // System-Account
    'account_center_config' => '账户中心设置',
    'account_child_safety' => '儿童保护',
    'account_age_verification' => '年龄验证',
    'account_age_min_required' => '最小年龄',
    'account_register_config' => '注册设置',
    'account_login_config' => '登录设置',
    'account_password_config' => '密码设置',
    'account_center_service' => '账户中心',
    'account_center_captcha' => '验证码方案',
    'account_register_service' => '注册服务',
    'account_register_status' => '是否开放注册',
    'account_register_type' => '注册账号支持',
    'account_register_type_email' => '邮箱注册',
    'account_register_type_phone' => '手机号注册',
    'account_login_service' => '登录服务',
    'account_login_support' => '登录支持',
    'account_login_type_email' => '邮箱登录',
    'account_login_type_phone' => '手机号登录',
    'account_code_login' => '验证码登录支持',
    'account_login_or_register' => '验证码登录时，无账号则自动注册',
    'account_password_length' => '长度要求',
    'account_password_length_desc' => '长度要求：密码最小长度，0 或不填为不限制。',
    'account_password_strength' => '强度要求',
    'account_password_strength_desc' => '强度要求：密码中必须存在所选字符类型，不选则为无限制。',
    'account_password_strength_digital' => '数字',
    'account_password_strength_lowerLetters' => '小写字母',
    'account_password_strength_upperLetters' => '大写字母',
    'account_password_strength_symbols' => '符号(除空格)',
    'account_connect_services' => '第三方互联支持',
    'account_connect_services_desc' => '选择互联平台并关联插件，可实现快捷注册或登录。',
    'account_kyc_service' => '实名认证支持',
    'account_kyc_service_desc' => '安装认证服务插件后，用户可以实名制认证。',
    'account_users_service' => '多用户管理',
    // System-Wallet
    'wallet_functions' => '钱包功能',
    'wallet_functions_desc' => '是否启用法币钱包功能',
    'wallet_currency_code' => '货币代码',
    'wallet_currency_name' => '货币名称',
    'wallet_currency_unit' => '货币单位',
    'wallet_currency_precision' => '货币精度',
    'wallet_withdraw_status' => '提现功能',
    'wallet_withdraw_config' => '提现配置',
    'wallet_withdraw_config_desc' => '提现相关配置需插件支持，详细请咨询插件开发者。',
    'wallet_withdraw_review' => '提现是否审核',
    'wallet_withdraw_review_prove' => '提现是否验证实名信息',
    'wallet_withdraw_periodicity' => '提现间隔时间',
    'wallet_withdraw_rates' => '提现手续费率',
    'wallet_withdraw_min' => '单次提现最小金额',
    'wallet_withdraw_max' => '单次提现最大金额',
    'wallet_withdraw_sum_limit' => '每日提现总金额上限',
    // System-Storage
    'storage_service_config' => '存储配置',
    'storage_service_config_desc' => '存储服务商可在应用商店安装更多选择',
    'storage_function_config' => '功能配置',
    'storage_function_image_config' => '图片处理功能配置',
    'storage_function_image_config_desc' => '可以配置样式名或高级参数。可实时处理图片压缩、缩放、打水印等各种功能，常见的“间隔标识符”为半角字符 “!”、“-”、“_” 三种。支持高级参数，写法见存储服务商的开发者文档。',
    'storage_function_video_config' => '视频处理功能配置',
    'storage_function_video_config_desc' => '可以配置模板 ID，详情请查阅关联插件的说明。',
    'storage_function_audio_config' => '音频处理功能配置',
    'storage_function_audio_config_desc' => '可以配置模板 ID，详情请查阅关联插件的说明。',
    'storage_function_document_config' => '在线预览配置',
    'storage_function_substitution_config' => '无效状态补位图',
    'storage_function_substitution_config_desc' => '当资源文件的状态为“无效”时输出的补位提示用图。',
    'storage_function_substitution_image' => '图片无效提示图',
    'storage_function_substitution_video' => '视频无效提示图',
    'storage_function_substitution_audio' => '音频无效提示图',
    'storage_function_substitution_document' => '文档无效提示图',
    'storage_service_provider' => '存储服务商',
    'storage_filesystem_disk' => '文件系统磁盘',
    'storage_file_access_domain' => '访问域名',
    'storage_extension_names' => '支持的扩展名',
    'storage_max_size' => '支持的最大尺寸',
    'storage_max_duration' => '支持的最大时长',
    'storage_temporary_url_status' => '临时链接功能',
    'storage_temporary_url_status_desc' => '如果插件不支持临时链接功能，请勿开启，否则将导致文件无法访问。',
    'storage_temporary_url_key' => '临时链接 Key',
    'storage_temporary_url_expiration' => '临时链接有效期',
    'storage_image_handle_position' => '图片处理位置',
    'storage_image_thumb_config' => '配置图',
    'storage_image_thumb_avatar' => '头像图',
    'storage_image_thumb_ratio' => '等比例缩略图',
    'storage_image_thumb_square' => '正方形缩略图',
    'storage_image_thumb_big' => '原图压缩图',
    'storage_video_transcode_parameter' => '视频转码参数',
    'storage_video_watermark' => '视频水印参数',
    'storage_video_screenshot' => '视频截图参数',
    'storage_video_gift' => '视频转动图参数',
    'storage_video_poster_parameter' => '视频封面图参数',
    'storage_video_transcode_handle_position' => '视频转码参数处理位置',
    'storage_video_poster_handle_position' => '视频封面图参数处理位置',
    'storage_audio_transcode_parameter' => '音频转码参数',
    'storage_audio_transcode_handle_position' => '音频转码参数处理位置',
    'storage_document_preview_service' => '文档预览服务',
    'storage_document_preview_extension_names' => '支持预览的扩展名',
    // Operating-User
    'user_name' => '身份自定义名称',
    'user_name_desc' => '例如“用户”、“会员”、“站友”等命名',
    'user_uid_name' => 'ID 自定义名称',
    'user_uid_name_desc' => '例如“uid”、“id”、“会员号”等命名',
    'user_username_name' => '用户名自定义名称',
    'user_username_name_desc' => '例如“用户名”、“会员名”、“账号”等命名',
    'user_nickname_name' => '昵称自定义名称',
    'user_nickname_name_desc' => '例如“昵称”、“花名”、“代号”等命名',
    'user_role_name' => '角色自定义名称',
    'user_role_name_desc' => '例如“角色”、“用户组”、“用户群”等命名',
    'user_bio_name' => '简介自定义名称',
    'user_bio_name_desc' => '例如“Bio”、“简介”、“个性签名”等命名',
    'user_default_role' => '默认用户角色',
    'user_default_role_desc' => '注册后默认用户角色',
    'user_default_avatar' => '默认用户头像',
    'user_default_avatar_desc' => '用户未设置头像时的默认头像图',
    'user_default_anonymous_avatar' => '匿名用户头像',
    'user_default_anonymous_avatar_desc' => '内容发表匿名者的头像图',
    'user_default_deactivate_avatar' => '已停用用户头像',
    'user_default_deactivate_avatar_desc' => '用户注销或停用后的头像图',
    'user_identifier' => '用户标识类型',
    'user_identifier_desc' => '用户互动中以哪个标识为主',
    'user_uid_digit' => '用户 UID 起始位数',
    'user_uid_digit_desc' => '注册时随机生成的数字位数',
    'user_profile_desc' => '访问用户主页时，默认内容列表',
    'user_ban_names' => '用户禁用名',
    'user_ban_names_desc' => '一行一个。禁止用户名和昵称使用。',
    'user_edit_username_length' => '用户名长度',
    'user_edit_username_length_min' => '最小长度',
    'user_edit_username_length_max' => '最大长度',
    'user_edit_username_length_desc' => '用户名最小长度和最大长度',
    'user_edit_username_periodicity' => '用户名修改间隔天数',
    'user_edit_nickname_length' => '用户昵称长度',
    'user_edit_nickname_periodicity' => '用户昵称修改间隔天数',
    'user_edit_nickname_unique' => '用户昵称唯一值',
    'user_edit_bio_length' => '用户简介长度',
    'user_edit_bio_support' => '用户简介支持',
    'user_bio_support_mention' => '艾特用户',
    'user_bio_support_link' => '超链接',
    'user_bio_support_hashtag' => '话题',
    'user_extcredits_config' => '扩展分值配置',
    'user_extcredits_name' => '分值名称',
    'user_extcredits_unit' => '分值单位',
    'user_extcredits_state_not_enabled' => '不启用',
    'user_extcredits_state_private' => '私有',
    'user_extcredits_state_public' => '公开',
    'user_conversation_status' => '私信对话功能',
    'user_conversation_status_desc' => '关闭对全员有效，开启后以用户角色权限为准',
    'user_conversation_files' => '对话附件功能',
    'user_conversation_files_desc' => '如果全部不勾选则代表只支持纯文字的对话',
    // Operating-User-Profile
    'profile_posts' => '他发表的帖子',
    'profile_comments' => '他发表的评论',
    'profile_likers' => '点赞了他的用户',
    'profile_dislikers' => '点踩了他的用户',
    'profile_followers' => '关注了他的用户',
    'profile_blockers' => '屏蔽了他的用户',
    'profile_followers_you_follow' => '你认识的关注者',
    'profile_likes_users' => '他点赞的用户',
    'profile_likes_groups' => '他点赞的小组',
    'profile_likes_hashtags' => '他点赞的话题',
    'profile_likes_geotags' => '他点赞的地理',
    'profile_likes_posts' => '他点赞的帖子',
    'profile_likes_comments' => '他点赞的评论',
    'profile_dislikes_users' => '他点踩的用户',
    'profile_dislikes_groups' => '他点踩的小组',
    'profile_dislikes_hashtags' => '他点踩的话题',
    'profile_dislikes_geotags' => '他点踩的地理',
    'profile_dislikes_posts' => '他点踩的帖子',
    'profile_dislikes_comments' => '他点踩的评论',
    'profile_following_users' => '他关注的用户',
    'profile_following_groups' => '他关注的小组',
    'profile_following_hashtags' => '他关注的话题',
    'profile_following_geotags' => '他关注的地理',
    'profile_following_posts' => '他关注的帖子',
    'profile_following_comments' => '他关注的评论',
    'profile_blocking_users' => '他屏蔽的用户',
    'profile_blocking_groups' => '他屏蔽的小组',
    'profile_blocking_hashtags' => '他屏蔽的话题',
    'profile_blocking_geotags' => '他屏蔽的地理',
    'profile_blocking_posts' => '他屏蔽的帖子',
    'profile_blocking_comments' => '他屏蔽的评论',
    // Operating-Content
    'content_group_name' => '小组自定义名称',
    'content_group_name_desc' => '例如“版区”、“圈子”、“分类”等命名',
    'content_hashtag_name' => '话题自定义名称',
    'content_hashtag_name_desc' => '例如“超话”、“标签”、“话题”等命名',
    'content_post_name' => '帖子内容名称',
    'content_post_name_desc' => '例如“帖子”、“动态”、“说说”等命名',
    'content_comment_name' => '评论内容名称',
    'content_comment_name_desc' => '例如“评论”、“回复”、“互动”等命名',
    'content_publish_post_name' => '发表帖子行为名称',
    'content_publish_post_name_desc' => '例如“发表”、“投稿”、“反馈”等命名',
    'content_publish_comment_name' => '发表评论行为名称',
    'content_publish_comment_name_desc' => '例如“回复”、“回帖”、“跟帖”等命名',
    'content_mention_status' => '艾特功能',
    'content_mention_number' => '艾特个数',
    'content_mention_number_desc' => '每篇内容支持艾特用户的数量，0 表示不限制',
    'content_hashtag_status' => '话题功能',
    'content_hashtag_format' => '话题格式',
    'content_hashtag_format_1' => '单 # 号',
    'content_hashtag_format_2' => '双 # 号',
    'content_hashtag_format_desc' => '<a href="#">#话题</a> 和 <a href="#">#话题#</a> 的区别',
    'content_hashtag_length' => '话题长度',
    'content_hashtag_number' => '话题个数',
    'content_hashtag_number_desc' => '每篇内容支持话题的数量，0 表示不限制',
    'content_hashtag_regexp' => '话题正则表达式',
    'content_nearby_length' => '附近搜索默认范围',
    'content_nearby_length_desc' => '查看附近内容时的搜索范围',
    'content_post_brief_length' => '帖子摘要字数',
    'content_post_brief_length_desc' => '帖子超过该设定值将采用摘要，超长内容摘要字数',
    'content_comment_brief_length' => '评论摘要字数',
    'content_comment_brief_length_desc' => '评论超过该设定值将采用摘要，超长内容摘要字数',
    'content_comment_visibility_rule' => '评论可见度规则',
    'content_comment_visibility_rule_desc' => '帖子发表时间大于天数，评论将隐藏，0 代表不启用',
    'content_preview_post_like_users' => '帖子点赞用户预览',
    'content_preview_post_like_users_desc' => '预览点赞了帖子的用户，数字代表预览数量。',
    'content_preview_post_comments' => '帖子评论预览',
    'content_preview_post_comments_desc' => '帖子列表页预览评论，数字代表预览数量。',
    'content_preview_post_comment_require' => '帖子评论预览条件',
    'content_preview_post_comment_require_desc' => 'Count 数量达到多少才输出预览',
    'content_preview_comment_like_users' => '评论点赞用户预览',
    'content_preview_comment_replies' => '评论回复预览数量',
    'content_post_edit_config' => '帖子编辑权限',
    'content_post_delete_config' => '帖子删除权限',
    'content_comment_edit_config' => '评论编辑权限',
    'content_comment_delete_config' => '评论删除权限',
    'content_edit_desc' => '发表后是否可以编辑',
    'content_delete_desc' => '发表后是否可以删除',
    // Operating-Interaction
    'interaction_function_status' => '功能状态',
    'interaction_operation_name' => '行为名称',
    'interaction_user_title' => '用户头衔',
    'interaction_public_record' => '公开记录',
    'interaction_public_count' => '公开计数',
    'interaction_column_name' => '栏目名称',
    // Operating-Sticker
    'sticker_group' => '表情组',
    'sticker_table_group_name' => '表情组名称',
    'sticker_table_group_image' => '表情组图标',
    'sticker_table_group_code' => '表情组标识',
    'sticker_table_quantity' => '表情数量',
    'sticker_manage' => '表情管理',
    'sticker_table_image' => '表情图',
    'sticker_table_code' => '表情符号',
    // Operating-Editor
    'editor_group' => '小组',
    'editor_title' => '标题',
    'editor_sticker' => '表情',
    'editor_image' => '图片',
    'editor_video' => '视频',
    'editor_audio' => '音频',
    'editor_document' => '文档',
    'editor_mention' => '艾特',
    'editor_hashtag' => '话题',
    'editor_extend' => '扩展功能',
    'editor_location' => '定位',
    'editor_anonymous' => '匿名',
    'editor_upload_image_type' => '图片上传方式',
    'editor_upload_video_type' => '视频上传方式',
    'editor_upload_audio_type' => '音频上传方式',
    'editor_upload_document_type' => '文档上传方式',
    'editor_upload_image_number' => '上传图片上限个数',
    'editor_upload_video_number' => '上传视频上限个数',
    'editor_upload_audio_number' => '上传音频上限个数',
    'editor_upload_document_number' => '上传文档上限个数',
    // Operating-Publish
    'publish_editor_config' => '编辑器选择',
    'publish_editor_function_status' => '编辑器功能开启',
    'publish_editor_function_options' => '编辑器功能配置',
    'publish_post_verify_config' => '发表帖子要求',
    'publish_comment_verify_config' => '发表评论要求',
    'publish_post_rules_config' => '发表帖子特殊规则',
    'publish_comment_rules_config' => '发表评论特殊规则',
    'publish_editor_desc' => '发表内容的编辑器',
    'publish_verify_desc' => '账户必须完善所选资料才可以发表',
    'publish_rules_desc' => '全员有效，优先级大于角色规则要求',
    'publish_rule_type' => '规则类型',
    'publish_rule_datetime' => '日期范围',
    'publish_rule_time' => '时间范围',
    'publish_rule_timezone' => '时区标准',
    'publish_rule_rule' => '规则要求',
    'publish_rule_tip' => '规则提示',
    'publish_edit_time_limit' => '多长时间可编辑',
    'publish_edit_sticky_limit' => '置顶后',
    'publish_edit_digest_limit' => '加精后',
    'publish_editor_group_required' => '小组是否必选',
    'publish_editor_group_required_desc' => '发表帖子的时候，小组是否必须选择',
    'publish_editor_title_input_box' => '标题输入框显示',
    'publish_editor_title_input_box_desc' => '弱显示需用户手动选择后才会显示标题输入框',
    'publish_editor_title_required' => '标题是否必填',
    'publish_editor_title_required_desc' => '发表帖子的时候，标题是否必填',
    'publish_editor_title_length' => '标题字数限制',
    'publish_editor_title_length_desc' => '标题字数不得超过设置数，最大上限 255 个字符',
    'publish_editor_post_content_length' => '帖子字数限制',
    'publish_editor_post_content_length_desc' => '帖子字数不得超过设置数，最小上限 140 个字符',
    'publish_editor_comment_content_length' => '评论字数限制',
    'publish_editor_comment_content_length_desc' => '评论字数不得超过设置数，最小上限 140 个字符',
    // Operating-Permission
    'permission_option_email' => '已绑定邮箱',
    'permission_option_phone' => '已绑定手机号',
    'permission_option_kyc' => '已实名认证',
    'permission_option_rule_datetime' => '指定日期范围内生效',
    'permission_option_rule_time' => '指定时间段范围内每天循环生效',
    'permission_option_review_publish' => '可以发表，但是需要审核',
    'permission_option_close_publish' => '禁止发表',
    'permission_option_can_be_edited' => '可以编辑',
    'permission_option_cannot_be_edited' => '不可编辑',
    'permission_option_can_be_deleted' => '可以删除',
    'permission_option_cannot_be_deleted' => '不可删除',
    'permission_option_direct_release' => '直接通过',
    'permission_option_required_review' => '需要审核',
    'permission_option_title_optional_display' => '弱显示',
    'permission_option_title_direct_display' => '强显示',
    // Operating-Roles
    'role_table_display' => '显示标识',
    'role_table_nickname_color' => '昵称颜色',
    'role_option_display_icon' => '显示图标',
    'role_option_display_text' => '显示文字',
    'role_option_close_nickname_color' => '不使用颜色',
    'role_current' => '当前角色',
    'role_target' => '目标角色',
    'role_target_desc' => '角色删除后，该角色下用户合并到所选目标角色名下',
    'role_perm_basic_config' => '基础设置',
    'role_perm_post_config' => '发表帖子设置',
    'role_perm_comment_config' => '发表评论设置',
    'role_perm_upload_config' => '上传设置',
    'role_perm_interaction_config' => '互动设置',
    'role_perm_customize_config' => '自定义设置',
    'role_perm_content_view' => '浏览权限',
    'role_perm_conversation' => '对话权限',
    'role_perm_content_link_handle' => '发表内容的链接处理',
    'role_perm_content_link_handle_1' => '不解析并掩码域名',
    'role_perm_content_link_handle_2' => '不解析但以文本方式显示',
    'role_perm_content_link_handle_3' => '正常解析',
    'role_perm_post_publish' => '发表帖子权限',
    'role_perm_post_verify' => '发表帖子要求',
    'role_perm_post_review' => '发表帖子规则',
    'role_perm_post_rules' => '发表帖子特殊规则',
    'role_perm_post_time_interval' => '发表帖子时间间隔',
    'role_perm_post_daily_count' => '发表帖子每日上限',
    'role_perm_post_draft_count' => '帖子草稿数量限制',
    'role_perm_comment_publish' => '发表评论权限',
    'role_perm_comment_verify' => '发表评论要求',
    'role_perm_comment_review' => '发表评论规则',
    'role_perm_comment_rules' => '发表评论特殊规则',
    'role_perm_comment_time_interval' => '发表评论时间间隔',
    'role_perm_comment_daily_count' => '发表评论每日上限',
    'role_perm_comment_draft_count' => '评论草稿数量限制',
    'role_perm_upload_image' => '上传图片',
    'role_perm_upload_video' => '上传视频',
    'role_perm_upload_audio' => '上传音频',
    'role_perm_upload_document' => '上传文档',
    'role_perm_upload_file_desc' => '勾选代表有权上传，输入框留空则使用“存储配置”的设置值作为默认参数。',
    'role_perm_follow_user_max_count' => '关注用户上限数量',
    'role_perm_block_user_max_count' => '屏蔽用户上限数量',
    'role_perm_download_file_count' => '24 小时内下载上限',
    'role_perm_table_name' => '权限名',
    'role_perm_table_value' => '权限值',
    // Operating-Groups
    'group_table_parent_group' => '父级小组',
    'group_table_subgroup' => '子级小组',
    'group_table_privacy' => '小组模式',
    'group_table_visibility' => '可见度',
    'group_table_follow_method' => '关注方式',
    'group_table_recommend' => '是否推荐',
    'group_table_admins' => '小组管理员',
    'group_table_can_publish' => '发布权限',
    'group_table_post_permissions' => '帖子权限',
    'group_table_comment_permissions' => '评论权限',
    'group_table_publish_perm_role' => '有权发表的角色',
    'group_table_publish_perm_review' => '是否需要审核',
    'group_table_publish_perm_review_desc' => '小组管理员不受限制',
    'group_public_desc' => '公开（任何人都能查看小组内帖子）',
    'group_private_desc' => '非公开（只有成员才能查看小组内帖子）',
    'group_visible_desc' => '可发现（任何人都能找到这个小组）',
    'group_hidden_desc' => '不可发现（只有成员能找到这个小组）',
    'group_publish_option_all' => '所有人',
    'group_publish_option_members' => '仅小组的成员',
    'group_publish_option_roles' => '仅指定角色的用户',
    'group_publish_option_admins' => '仅限小组管理员',
    'group_can_publish_desc' => '关闭发布权限，可以作为小组分类使用',
    'group_current' => '当前小组',
    'group_target' => '目标小组',
    'group_target_desc' => '合并后旧小组将被删除，旧小组名下内容将迁移到所选目标小组名下。',
    // Extends
    'extend_editor_menus' => '显示在扩展菜单',
    'extend_editor_toolbar' => '显示在工具栏',
    'extend_editor_number_of_uses_desc' => '以“投票”插件举例，数量为 2 则代表单个帖子可以附带 2 个投票',
    'extend_content_service' => '内容服务',
    'extend_content_list' => '内容列表',
    'extend_content_detail' => '内容详情',
    'extend_content_search' => '内容搜索',
    'extend_content_list_desc' => '该配置的优先级大于内容类型配置，当配置后，内容类型指定的数据来源将被取代。',
    'extend_content_ip' => 'IP 服务',
    'extend_content_map' => '地图服务',
    'extend_content_notifications_service' => '通知服务',
    'extend_content_review' => '审核服务',
    'extend_content_list_by_all' => '全部帖子或评论',
    'extend_content_list_by_timelines' => '时间线的帖子或评论',
    'extend_content_list_by_nearby' => '附近范围的帖子或评论',
    'extend_content_by_detail' => '帖子或评论详情',
    'extend_content_search_users' => '搜索用户',
    'extend_content_search_groups' => '搜索小组',
    'extend_content_search_hashtags' => '搜索话题',
    'extend_content_search_geotags' => '搜索地理',
    'extend_content_search_posts' => '搜索帖子',
    'extend_content_search_comments' => '搜索评论',
    // Client-Channels
    'channel_default_homepage' => '默认首页',
    'channel_table_channel' => '频道',
    'channel_table_page' => '页面',
    'channel_table_page_home' => '主页',
    'channel_table_page_list' => '列表页',
    'channel_table_page_detail' => '详情页',
    'channel_table_page_interaction' => '互动页',
    'channel_table_path' => '路径',
    'channel_table_seo' => 'SEO 信息',
    'channel_table_seo_title' => 'SEO 标题',
    'channel_table_seo_description' => 'SEO 描述',
    'channel_table_seo_keywords' => 'SEO 关键词',
    'channel_table_query_state' => '客户端传参',
    'channel_table_query_state_desc' => '是否接受客户端传参，关闭后将仅支持默认参数值',
    'channel_table_query_config' => '默认参数',
    'channel_table_query_config_desc' => '参考本接口的 API Query 参数',
    'channel_query_state_1' => '不接受客户端传参',
    'channel_query_state_2' => '仅接受客户端分页参数',
    'channel_query_state_3' => '接受全部参数',
    // Client-Columns
    'channel_timeline' => '时间线',
    'channel_timeline_all_posts' => '全部关注的帖子',
    'channel_timeline_user_posts' => '关注用户的帖子',
    'channel_timeline_group_posts' => '关注小组的帖子',
    'channel_timeline_hashtag_posts' => '关注话题的帖子',
    'channel_timeline_geotag_posts' => '关注地理的帖子',
    'channel_timeline_all_comments' => '全部关注的评论',
    'channel_timeline_user_comments' => '关注用户的评论',
    'channel_timeline_group_comments' => '关注小组的评论',
    'channel_timeline_hashtag_comments' => '关注话题的评论',
    'channel_timeline_geotag_comments' => '关注地理的评论',
    'channel_nearby' => '附近',
    'channel_nearby_posts' => '附近的帖子',
    'channel_nearby_comments' => '附近的评论',
    'channel_me' => '个人中心',
    'channel_me_extcredits' => '扩展分值',
    'channel_me_wallet' => '钱包',
    'channel_me_drafts' => '草稿箱',
    'channel_me_users' => '名下用户',
    'channel_me_settings' => '设置',
    'channel_messages' => '消息',
    'channel_conversations' => '对话',
    'channel_notifications' => '通知',
    'channel_notifications_all' => '通知-全部',
    'channel_notifications_systems' => '通知-系统',
    'channel_notifications_recommends' => '通知-推荐',
    'channel_notifications_likes' => '通知-点赞',
    'channel_notifications_dislikes' => '通知-点踩',
    'channel_notifications_follows' => '通知-关注',
    'channel_notifications_blocks' => '通知-屏蔽',
    'channel_notifications_mentions' => '通知-提及',
    'channel_notifications_comments' => '通知-评论',
    'channel_notifications_quotes' => '通知-引用',
    'channel_search' => '搜索',
    // Client-Keys
    'key_table_read_only' => '只读',
    'key_select_platform' => '选择密钥应用平台',
    'key_option_main_api' => '主程 API',
    'key_option_manage_api' => '管理 API',
    'key_option_plugin_api' => '插件 API',
    'key_option_plugin_api_select' => '选择密钥用于哪个插件',
    'key_option_plugin_api_select_desc' => '该密钥仅能请求关联插件的 API',
    // Client-Website
    'website_stat_code' => '网站统计代码',
    'website_stat_code_desc' => '第三方统计代码，不支持使用含有 document.write 的统计代码。',
    'website_stat_position' => '统计代码位置',
    'website_stat_position_desc' => '统计代码载入到 HTML 的哪个位置。',
    'china_mode' => '中国大陆模式',
    'china_mode_desc' => '站点服务器部署在中国大陆境内时需要填写的信息。',
    'china_mode_config' => '中国大陆服务器配置（非必填项）',
    'china_icp_filing' => 'ICP 备案号',
    'china_icp_license' => 'ICP 许可证号',
    'china_mps_filing' => '公安备案号',
    'china_broadcasting_license' => '广播电视节目制作经营许可证',
    // Client-Status
    'client_status_desc' => '客户端每 10 分钟请求一次状态配置',
    // App-Center-Themes
    'website_engine_config' => '网站引擎配置',
    'website_engine_api_config' => 'API 配置',
    'website_engine_status' => '引擎状态',
    'website_engine_api_type' => '引擎 API 类型',
    'website_engine_key_id' => '关联应用密钥',
    'website_engine_view_desktop' => '电脑端',
    'website_engine_view_mobile' => '移动端',
    // App-Center-Install
    'install_website_engine' => '安装网站引擎',
    'install_plugin' => '安装插件',
    'install_application' => '安装应用',
    'install_mode' => '安装方式',
    'install_mode_fskey' => '输入标识名',
    'install_mode_upload' => '上传安装包',
    'install_mode_directory' => '输入目录路径',
    'download_application' => '下载应用',
];
