<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresns 控制面板',
    'fresns_core' => 'Fresns 主程式',
    // Login page
    'language' => '語言',
    'login' => '登入',
    'account' => '帳號',
    'password' => '密碼',
    'enter' => '進入',
    'operation' => '面板操作',
    'site_home' => '網站首頁',
    'switch_language' => '切換語言',
    'logout' => '登出',
    // Header menus
    'menu_dashboard' => '儀錶盤',
    'menu_systems' => '系統',
    'menu_operations' => '運營',
    'menu_extends' => '擴充',
    'menu_clients' => '使用者端',
    'menu_app_center' => '應用中心',
    'menu_marketplace' => '應用市場',
    // Sidebar menus
    'sidebar_home' => '首頁',
    'sidebar_admins' => '管理員',
    'sidebar_events' => '事件',
    'sidebar_events_tab_subscribe' => '訂閱事件',
    'sidebar_events_tab_crontab' => '定時任務',
    'sidebar_caches' => '緩存',
    'sidebar_caches_tab_config' => '配置緩存',
    'sidebar_caches_tab_data' => '資料緩存',
    'sidebar_upgrades' => '更新',
    'sidebar_settings' => '設定',
    'sidebar_languages' => '語言設定',
    'sidebar_storage' => '存儲設定',
    'sidebar_storage_tab_image' => '圖片',
    'sidebar_storage_tab_video' => '視頻',
    'sidebar_storage_tab_audio' => '音頻',
    'sidebar_storage_tab_document' => '文檔',
    'sidebar_storage_tab_substitution' => '替補圖設定',
    'sidebar_general' => '站點設定',
    'sidebar_policy' => '政策設定',
    'sidebar_policy_tab_options' => '政策功能',
    'sidebar_policy_tab_contents' => '政策內容',
    'sidebar_send' => '發信設定',
    'sidebar_send_tab_services' => '發信服務商',
    'sidebar_send_tab_templates' => '驗證碼模板',
    'sidebar_account' => '使用者設定',
    'sidebar_wallet' => '錢包設定',
    'sidebar_wallet_tab_options' => '功能設定',
    'sidebar_wallet_tab_recharge_services' => '充值服務商',
    'sidebar_wallet_tab_withdraw_services' => '提現服務商',
    'sidebar_user' => '使用者配置',
    'sidebar_content' => '内容配置',
    'sidebar_interaction' => '互動配置',
    'sidebar_publish' => '發表配置',
    'sidebar_publish_tab_post' => '發表貼文',
    'sidebar_publish_tab_comment' => '發表留言',
    'sidebar_roles' => '使用者角色',
    'sidebar_stickers' => '表情貼紙',
    'sidebar_groups' => '內容社團',
    'sidebar_groups_tab_active' => '啟用的社團',
    'sidebar_groups_tab_deactivate' => '停用的社團',
    'sidebar_groups_tab_recommend' => '僅查看推薦',
    'sidebar_extend_editor' => '編輯器擴充',
    'sidebar_extend_content_type' => '內容類型擴充',
    'sidebar_extend_content_handler' => '內容處理擴充',
    'sidebar_extend_manage' => '管理擴充',
    'sidebar_extend_group' => '社團擴充',
    'sidebar_extend_group_filter' => '社團篩選',
    'sidebar_extend_user_feature' => '使用者功能擴充',
    'sidebar_extend_user_profile' => '使用者資料擴充',
    'sidebar_extend_channel' => '頻道擴充',
    'sidebar_extend_command_words' => '介面命令字擴充',
    'sidebar_channels' => '頻道配置',
    'sidebar_paths' => '路徑配置',
    'sidebar_language_packs' => '語言包配置',
    'sidebar_code_messages' => '狀態碼配置',
    'sidebar_client_basic' => '使用者端基礎',
    'sidebar_client_status' => '使用者端狀態',
    'sidebar_plugins' => '擴充外掛',
    'sidebar_plugins_tab_all' => '全部',
    'sidebar_plugins_tab_active' => '已啟用',
    'sidebar_plugins_tab_inactive' => '未啟用',
    'sidebar_themes' => '主題模板',
    'sidebar_apps' => '獨立應用',
    'sidebar_keys' => '應用密鑰',
    // Sidebar intro
    'sidebar_admins_intro' => '有權登入控制面板的使用者',
    'sidebar_events_intro' => '查看系統中定時任務和訂閱事件',
    'sidebar_caches_intro' => '清空全部緩存的時候，可能讓伺服器負載升高，請盡量避開訪問高峰時間',
    'sidebar_upgrades_intro' => '最後檢查於',
    'sidebar_settings_intro' => '配置完成後請清空緩存，或者等待 10 分鐘後新緩存生效。',
    'sidebar_languages_intro' => '多語言需要先在這裡配置語言選項，然後才能在對應配置項時錄入多語言內容。',
    'sidebar_storage_intro' => '四種資源文件可分開存儲，也可存儲在同一處，只需將存儲配置信息填寫一致即可。',
    'sidebar_general_intro' => '保障系統正常運行的設定項。',
    'sidebar_policy_intro' => '根據目標市場所在國的相關數據法律條例配置功能。',
    'sidebar_send_intro' => '郵件短信和系統通知等消息發送設定。',
    'sidebar_account_intro' => '帳戶中心功能設定。',
    'sidebar_wallet_intro' => '錢包為真實貨幣功能，如需虛擬積分功能請安裝相應的外掛。',
    'sidebar_wallet_tab_recharge_services_intro' => '充值服務商配置將呈現在「錢包」功能列表中，用於支付訂單或者充值錢包。',
    'sidebar_wallet_tab_withdraw_services_intro' => '提現服務商配置將呈現在「錢包」功能列表中，用於錢包餘額提現到指定賬戶中。',
    'sidebar_user_intro' => '使用者基础功能设置。',
    'sidebar_content_intro' => '社交內容名稱和功能配置。',
    'sidebar_interaction_intro' => '使用者感知一款產品的服務（體驗感），並不取決於技術邏輯，而是來自功能點命名。',
    'sidebar_publish_intro' => '此處配置對全員有效，權限優先級大於使用者角色權限。',
    'sidebar_roles_intro' => '角色可以對使用者身份和權限進行特定的設定。',
    'sidebar_stickers_intro' => '自定義配置表情圖，在不配置的情況下，使用者也可以透過表情鍵盤輸入 Emoji 表情。',
    'sidebar_groups_intro' => '使用社團可以實現 BBS 版區、社群圈子、內容分類等各種運營場景。',
    'sidebar_extend_editor_intro' => '將呈現在發布流程的「編輯器」中，例如「投票」擴充可以讓「編輯器」支援為貼文附帶投票功能。',
    'sidebar_extend_content_type_intro' => '將呈現在「貼文」列表頁面中，用於輸出指定「類型」的貼文，以及定義數據結果來源。',
    'sidebar_extend_content_handler_intro' => '功能與「內容類型擴充」數據來源功能一樣，是否將請求分發給外掛處理，由外掛決定數據邏輯。',
    'sidebar_extend_manage_intro' => '將呈現在貼文、留言、使用者主頁的「更多」功能列表中，例如「投訴」擴充可以讓使用者對相應目標進行投訴。',
    'sidebar_extend_group_intro' => '將呈現在「社團」主頁中，例如「純鏈接擴充外掛」可以在「社團」主頁顯示一個超鏈接。',
    'sidebar_extend_user_feature_intro' => '將呈現在「使用者中心」的“我的”頁面中，例如「錢包」擴充可以讓使用者中心多一個錢包功能。',
    'sidebar_extend_user_profile_intro' => '將呈現在「使用者資料」管理功能列表中，例如「修改使用者名外掛」可以讓修改資料功能支援修改使用者名。',
    'sidebar_extend_channel_intro' => '將呈現在「主菜單」或者「頻道」頁面列表中，例如「購物」擴充可以讓使用者進入商城頻道。',
    'sidebar_extend_command_words_intro' => '配置在該清單的命令字，可供 API 請求使用。',
    'sidebar_channels_intro' => '統一配置客戶端各個頻道資訊。',
    'sidebar_paths_intro' => '自定義路徑結構可以為鏈接提高美感、可用性和前向兼容性。',
    'sidebar_language_packs_intro' => '為多語言使用者端配置各項文本的多語言內容。',
    'sidebar_code_messages_intro' => '為主程序和外掛配置狀態碼的多語言描述。',
    'sidebar_client_basic_intro' => '使用者端基礎的通用設定項。',
    'sidebar_client_status_intro' => '停用後，使用者端所有頁面和操作將跳轉到停用說明頁面。',
    'sidebar_plugins_intro' => '靈活的功能，強大的擴充，助您自由發揮心中所想。',
    'sidebar_themes_intro' => '選配不同的主題，實現更個人化的風格與互動。',
    'sidebar_apps_intro' => '標準的 API，強大的擴充，隨心打造多樣的運營場景和應用模式。',
    'sidebar_keys_intro' => '密鑰憑證很重要，請勿輕易透露給其他人。',
    // Page button
    'button_support' => '幫助說明',
    'button_update' => '更新',
    'button_search' => '搜尋',
    'button_add' => '新增',
    'button_edit' => '編輯',
    'button_modify' => '修改',
    'button_delete' => '刪除',
    'button_cancel' => '取消',
    'button_close' => '關閉',
    'button_dismiss' => '駁回',
    'button_activate' => '啟用',
    'button_deactivate' => '停用',
    'button_install' => '安裝',
    'button_uninstall' => '卸載',
    'button_setting' => '設定',
    'button_config' => '配置',
    'button_reset' => '重設',
    'button_confirm' => '確認',
    'button_try_again' => '再試一次',
    'button_save' => '儲存',
    'button_download' => '下載',
    'button_upgrade' => '升級',
    'button_automatic_upgrade' => '自動升級',
    'button_manual_upgrade' => '手動升級',
    'button_confirm_delete' => '確認刪除',
    'button_confirm_install' => '確認安裝',
    'button_confirm_upgrade' => '確認升級',
    'button_confirm_download' => '確認下載',
    'button_confirm_uninstall' => '確認卸載',
    'button_view' => '查看',
    'button_image_upload' => '上傳圖片',
    'button_image_input' => '輸入地址',
    'button_check_upgrade' => '檢查更新',
    'button_check_status' => '檢查狀態',
    'button_batch_import' => '批量匯入',
    'button_batch_export' => '批量匯出',
    'button_config_email_template' => '配置郵件模板',
    'button_config_sms_template' => '配置短信模板',
    'button_config_sticker' => '配置表情圖',
    'button_config_permission' => '配置權限',
    'button_config_language_pack' => '配置語言包',
    'button_add_admin' => '新增管理員',
    'button_add_language' => '新增語言',
    'button_add_account_connect' => '新增帳號互聯',
    'button_add_service_provider' => '新增服務商',
    'button_add_sticker_group' => '新增表情組',
    'button_add_sticker' => '新增表情圖',
    'button_add_role' => '新增角色',
    'button_add_group' => '新增社團',
    'button_group_move' => '合併',
    'button_add_key' => '新增密鑰',
    'button_reset_key' => '重設 Key',
    'button_reset_secret' => '重設 Secret',
    'button_clear_cache' => '清除緩存',
    'button_clear_all_cache' => '清除所有緩存',
    // Page table
    'table_order' => '顯示順序',
    'table_recommend_order' => '推薦順序',
    'table_position' => '顯示位置',
    'table_number' => '編號',
    'table_lang_tag' => '語言標籤',
    'table_lang_name' => '語言名稱',
    'table_title' => '標題',
    'table_content' => '內容',
    'table_platform' => '平台',
    'table_service' => '服務商',
    'table_app_id' => 'App ID',
    'table_app_key' => 'App Key',
    'table_app_secret' => 'App Secret',
    'table_plugin' => '外掛',
    'table_command_word' => '命令字',
    'table_name' => '名稱',
    'table_description' => '描述',
    'table_icon' => '圖標',
    'table_banner' => '條幅',
    'table_type' => '類型',
    'table_use' => '用途說明',
    'table_support' => '支援方式',
    'table_data_source' => '數據來源',
    'table_scene' => '使用場景',
    'table_number_of_uses' => '使用數量',
    'table_scope' => '使用範圍',
    'table_scope_global' => '全域',
    'table_scope_global_desc' => '可限制指定角色才能使用',
    'table_scope_group_admins' => '社團管理員專用',
    'table_scope_group_admins_desc' => '啟用後，僅社團管理員會展示該外掛',
    'table_authorized_roles' => '角色使用權',
    'table_authorized_roles_desc' => '留空代表所有使用者角色均有權使用',
    'table_whitelist_rules' => '白名單角色',
    'table_parameter' => '自定義參數',
    'table_status' => '啟用狀態',
    'table_options' => '操作',
    // Config option
    'option_default' => '預設',
    'option_all' => '全部',
    'option_public' => '公開',
    'option_private' => '私人',
    'option_visible' => '顯示',
    'option_hidden' => '隱藏',
    'option_open' => '開啟',
    'option_close' => '關閉',
    'option_yes' => '是',
    'option_no' => '否',
    'option_activate' => '啟用',
    'option_deactivate' => '停用',
    'option_local' => '本地',
    'option_remote' => '遠程',
    'option_required' => '需要',
    'option_not_required' => '不需要',
    'option_not_set' => '未設定',
    'option_no_use' => '不使用',
    'option_unselect' => '不選擇',
    'option_optional' => '可選',
    'option_email' => '郵件',
    'option_sms' => '短信',
    'option_data_close' => '不公開',
    'option_data_private' => '僅對自己公開',
    'option_data_public' => '對所有人公開',
    'option_type_tree' => '樹結構',
    'option_type_list' => '列表',
    'option_uninstall_plugin_data' => '同步刪除該外掛的數據',
    'option_uninstall_theme_data' => '同步刪除該主題的數據',
    // Commons
    'portal' => '門戶',
    'user' => '使用者',
    'group' => '社團',
    'hashtag' => '話題',
    'geotag' => '地理',
    'post' => '貼文',
    'comment' => '留言',
    'file' => '文件',
    'extend' => '擴充內容',
    'user_detail' => '使用者主頁',
    'group_detail' => '社團詳情',
    'hashtag_detail' => '話題詳情',
    'geotag_detail' => '地理詳情',
    'post_detail' => '貼文詳情',
    'comment_detail' => '留言詳情',
    'like' => '喜歡',
    'dislike' => '不喜歡',
    'follow' => '跟隨',
    'block' => '封鎖',
    'author' => '開發者',
    'new_version' => '有新版',
    'default_language' => '預設語言',
    'default_list' => '預設列表',
    'recommend' => '推薦',
    'unit_day' => '天',
    'unit_length' => '位數',
    'unit_second' => '秒',
    'unit_minute' => '分鐘',
    'unit_within_minute' => '分鐘以內',
    'unit_character' => '字符',
    'unit_number' => '個數',
    'unit_number_of_times' => '次數',
    'unit_kilometer' => '公里',
    'unit_mile' => '英里',
    'config_default' => '預設配置',
    'config_name' => '名稱配置',
    'config_edit' => '修改配置',
    'config_interaction' => '互動配置',
    'config_conversation' => '對話配置',
    'config_hashtag' => '話題配置',
    'config_list' => '清單配置',
    'config_preview' => '預覽配置',
    'config_manage' => '管理配置',
    'delete_desc' => '確定刪除嗎？',
    // Dashboard-Home
    'welcome' => '歡迎使用 Fresns',
    'current_version' => '當前使用的版本是',
    'overview' => '站點數據',
    'overview_accounts' => '帳號總數',
    'overview_users' => '使用者總數',
    'overview_groups' => '社團總數',
    'overview_hashtags' => '話題總數',
    'overview_geotags' => '地理總數',
    'overview_posts' => '貼文總數',
    'overview_comments' => '留言總數',
    'extensions' => '應用數量',
    'support' => '幫助手冊',
    'support_website' => 'Fresns 官網',
    'support_teams' => '開源團隊',
    'support_sponsor' => '贊助我們',
    'support_join' => '加入我們',
    'support_community' => '支援社區',
    'support_marketplace' => '應用市場',
    'system_info' => '系統信息',
    'system_info_server' => '伺服器系統',
    'system_info_web' => 'Web 運行環境',
    'system_info_php_version' => 'PHP 版本',
    'system_info_php_cli_info' => 'PHP Cli 信息',
    'system_info_php_upload_max_filesize' => '上傳最大文件大小',
    'system_info_composer_info' => 'Composer 信息',
    'system_info_composer_version' => 'Composer 版本',
    'system_info_env_timezone' => '.env 時區',
    'system_info_env_timezone_name' => '.env 時區地名',
    'system_info_env_timezone_utc' => '.env 時區地名所屬 UTC 時區',
    'system_info_env_timezone_list' => '匹配的時區地名',
    'system_info_database_driver' => '資料庫驅動',
    'system_info_database_version' => '資料庫版本',
    'system_info_database_timezone' => '資料庫時區',
    'system_info_database_engine' => '資料庫存儲引擎',
    'system_info_database_collation' => '資料庫排序規則',
    'system_info_database_size' => '當前資料庫尺寸',
    'tips' => '使用說明',
    'news' => 'Fresns 活動和新聞',
    // Dashboard-Events
    'event_subscribe_subject' => '主題',
    'event_crontab_time' => '執行週期',
    'event_crontab_time_desc' => 'Laravel 定時任務表達式',
    // Dashboard-Caches
    'cache' => '緩存',
    'cache_fresns_system' => '系統配置',
    'cache_fresns_config' => '站點配置',
    'cache_fresns_extend' => '擴充配置',
    'cache_fresns_view' => '視圖',
    'cache_fresns_route' => '路由',
    'cache_fresns_event' => '事件',
    'cache_fresns_schedule' => '任務調度',
    'cache_fresns_temporary' => '暫存資料',
    // Dashboard-Admins
    'admin_add_title' => '新增系統管理員',
    'admin_add_form_account' => '帳號',
    'admin_add_form_account_placeholder' => '郵箱或者手機號',
    'admin_add_form_account_desc' => '手機號必須為帶國際區號的完整號碼',
    'admin_add_form_account_btn' => '搜尋並增加',
    // Dashboard-Settings
    'setting_developer_options' => '開發者選項',
    'setting_developer_options_desc' => '不是開發環境下，請勿停用選項。',
    'setting_build_type' => '版本類型',
    'setting_build_type_desc' => '測試版穩定性欠佳，請謹慎選擇。',
    'setting_build_select_tip' => '選擇升級版本類型',
    'setting_build_option_stable' => '穩定版 Stable Build',
    'setting_build_option_beta' => '測試版 Beta Build',
    'setting_system_url' => '系統網址',
    'setting_system_url_desc' => '主程式 API 和外掛預設訪問地址',
    'setting_panel_path' => '安全入口',
    'setting_panel_path_desc' => '設定後只能透過指定安全入口登入控制面板',
    'setting_panel_url' => '入口完整地址',
    'setting_panel_url_desc' => '控制面板登入入口完整網址',
    'setting_panel_url_copy' => '複製',
    // System-Languages
    'language_multilingual' => '多語言',
    'language_table_default' => '預設語言',
    'language_table_langCode' => '語言代碼',
    'language_table_areaCode' => '地區代碼',
    'language_table_langName' => '語言名稱',
    'language_table_areaName' => '地區名稱',
    'language_table_lengthUnit' => '長度單位',
    'language_table_writingDirection' => '書寫方向',
    'language_table_area' => '語言地區',
    'language_table_dateFormat' => '日期格式',
    'language_table_dateFormat_desc' => 'yyyy 表示年，mm 表示月，dd 表示天。',
    'language_table_timeFormat' => '人性化時間',
    'language_table_timeFormat_desc' => '時間變量名 {n}',
    'language_select_langCode' => '選擇語言代碼',
    'language_select_continent' => '選擇洲',
    'language_select_areaCode' => '選擇地區代碼',
    // System-General
    'site_url' => '站點網址',
    'site_url_desc' => '主站點訪問網址',
    'site_name' => '站點名稱',
    'site_name_desc' => '你的 Fresns 站點的名稱。',
    'site_intro' => '站點介紹',
    'site_intro_desc' => '你的 Fresns 站點的介紹。',
    'site_logo' => '站點標誌',
    'site_logo_desc' => '必須配置了“存儲設定”中的信息才能上傳圖片。',
    'site_copyright' => '版權信息',
    'site_email' => '管理員郵箱',
    'site_email_desc' => '當運行出錯時，展示給使用者，便於使用者反饋問題。',
    'site_mode' => '運行模式',
    'site_mode_public' => '公開模式',
    'site_mode_private' => '私有模式',
    'site_mode_private_desc' => '私有模式配置',
    'site_mode_private_join_status' => '是否對外開放加入',
    'site_mode_private_join_service' => '加入通道支援外掛',
    'site_mode_private_content_policy' => '私有到期後的狀態',
    'site_mode_private_content_policy_1' => '站點內容全部不可見',
    'site_mode_private_content_policy_2' => '到期前內容可見，新內容不可見',
    // System-Policy
    'policy_terms' => '服務條款',
    'policy_privacy' => '隱私權政策',
    'policy_cookie' => 'Cookie 政策',
    'policy_delete_account' => '註銷說明',
    'policy_delete_options' => '註銷功能',
    'policy_delete_options_desc' => '使用者在緩衝期天數內可以撤銷註銷（恢復帳號），到期未撤銷將執行註銷流程。',
    'policy_delete_option_1' => '不啟用註銷功能',
    'policy_delete_option_2' => '邏輯註銷',
    'policy_delete_option_2_desc' => '邏輯註銷：僅在資料庫中標註帳號為註銷，並不真實刪除數據。',
    'policy_delete_option_3' => '物理註銷',
    'policy_delete_option_3_desc' => '物理註銷：物理刪除數據，使用者資料和發表的內容將會被真實刪除。',
    'policy_delete_crontab' => '註銷緩衝期',
    // System-Send
    'send_email_config' => '郵箱配置',
    'send_sms_config' => '短信配置',
    'send_sms_default_code' => '預設國際區號',
    'send_sms_supported_codes' => '支援更多區號',
    'send_sms_desc' => '一行一個，區號不帶 + 號。留空代表只支援單一國家。配置前請確認服務商支援國際短信功能。',
    'send_app_notifications' => '推送通知服務',
    'send_app_ios_config' => 'iOS 配置',
    'send_app_ios_notifications_desc' => 'iOS 系統彈窗通知功能。',
    'send_app_android_config' => 'Android 配置',
    'send_app_android_notifications_desc' => 'Android 系統彈窗通知功能。',
    'send_app_desktop_config' => '桌面配置',
    'send_app_desktop_notifications_desc' => '桌面通知功能，例如瀏覽器通知。',
    'send_code_template_1' => '通用驗證碼',
    'send_code_template_2' => '註冊新帳號',
    'send_code_template_3' => '修改帳號資料',
    'send_code_template_4' => '更換新綁定',
    'send_code_template_5' => '重設登入密碼',
    'send_code_template_6' => '重設支付密碼',
    'send_code_template_7' => '使用驗證碼登入',
    'send_code_template_8' => '使用驗證碼註銷賬號',
    'send_code_template_table_email_desc' => '支援 HTML 格式',
    'send_code_template_table_sms_sign' => '短信簽名名稱',
    'send_code_template_table_sms_code' => '模板參數',
    'send_code_template_table_sms_code_desc' => '可以配置模板 ID，詳情請查閱關聯外掛的說明。',
    'send_code_template_table_sms_param' => '驗證碼變量名',
    // System-Account
    'account_center_config' => '帳戶中心設定',
    'account_child_safety' => '兒童保護',
    'account_age_verification' => '年齡驗證',
    'account_age_min_required' => '最小年齡',
    'account_register_config' => '註冊設定',
    'account_login_config' => '登入設定',
    'account_password_config' => '密碼設定',
    'account_center_service' => '帳戶中心',
    'account_center_captcha' => '驗證碼方案',
    'account_register_service' => '註冊服務',
    'account_register_status' => '是否開放註冊',
    'account_register_type' => '註冊帳號支援',
    'account_register_type_email' => '郵箱註冊',
    'account_register_type_phone' => '手機號註冊',
    'account_login_service' => '登入服務',
    'account_login_support' => '登入支援',
    'account_login_type_email' => '郵箱登入',
    'account_login_type_phone' => '手機號登入',
    'account_code_login' => '驗證碼登入支援',
    'account_login_or_register' => '驗證碼登入時，無賬號則自動註冊',
    'account_password_length' => '長度要求',
    'account_password_length_desc' => '長度要求：密碼最小長度，0 或不填為不限制。',
    'account_password_strength' => '強度要求',
    'account_password_strength_desc' => '強度要求：密碼中必須存在所選字符類型，不選則為無限制。',
    'account_password_strength_digital' => '數字',
    'account_password_strength_lowerLetters' => '小寫字母',
    'account_password_strength_upperLetters' => '大寫字母',
    'account_password_strength_symbols' => '符號(除空格)',
    'account_connect_services' => '第三方互聯支援',
    'account_connect_services_desc' => '選擇互聯平台並關聯外掛，可實現快捷註冊或登入。',
    'account_kyc_service' => '實名認證支援',
    'account_kyc_service_desc' => '安裝認證服務外掛後，使用者可以實名制認證。',
    'account_users_service' => '多個身分管理',
    // System-Wallet
    'wallet_functions' => '錢包功能',
    'wallet_functions_desc' => '是否啟用法幣錢包功能',
    'wallet_currency_code' => '貨幣代碼',
    'wallet_currency_name' => '貨幣名稱',
    'wallet_currency_unit' => '貨幣單位',
    'wallet_currency_precision' => '貨幣精度',
    'wallet_withdraw_status' => '提現功能',
    'wallet_withdraw_config' => '提現配置',
    'wallet_withdraw_config_desc' => '提現相關配置需外掛支援，詳細請諮詢外掛開發者。',
    'wallet_withdraw_review' => '提現是否審核',
    'wallet_withdraw_review_prove' => '提現是否驗證實名信息',
    'wallet_withdraw_periodicity' => '提現間隔時間',
    'wallet_withdraw_rates' => '提現手續費率',
    'wallet_withdraw_min' => '單次提現最小金額',
    'wallet_withdraw_max' => '單次提現最大金額',
    'wallet_withdraw_sum_limit' => '每日提現總金額上限',
    // System-Storage
    'storage_service_config' => '存儲配置',
    'storage_service_config_desc' => '存儲服務商可在應用商店安裝更多選擇',
    'storage_function_config' => '功能配置',
    'storage_function_image_config' => '圖片處理功能配置',
    'storage_function_image_config_desc' => '可以配置樣式名或高級參數。可實時處理圖片壓縮、縮放、打水印等各種功能，常見的“間隔標識符”為半角字符 “!”、“-”、“_” 三種。支援高級參數，寫法見存儲服務商的開發者文檔。',
    'storage_function_video_config' => '視頻處理功能配置',
    'storage_function_video_config_desc' => '可以配置模板 ID，詳情請查閱關聯外掛的說明。',
    'storage_function_audio_config' => '音頻處理功能配置',
    'storage_function_audio_config_desc' => '可以配置模板 ID，詳情請查閱關聯外掛的說明。',
    'storage_function_document_config' => '在線預覽配置',
    'storage_function_substitution_config' => '無效狀態補位圖',
    'storage_function_substitution_config_desc' => '當資源文件的狀態為“無效”時輸出的補位提示用圖。',
    'storage_function_substitution_image' => '圖片無效提示圖',
    'storage_function_substitution_video' => '視頻無效提示圖',
    'storage_function_substitution_audio' => '音頻無效提示圖',
    'storage_function_substitution_document' => '文檔無效提示圖',
    'storage_service_provider' => '存儲服務商',
    'storage_filesystem_disk' => '文件系統磁盤',
    'storage_file_access_domain' => '訪問網域',
    'storage_extension_names' => '支援的副檔名',
    'storage_max_size' => '支援的最大尺寸',
    'storage_max_duration' => '支援的最大時長',
    'storage_temporary_url_status' => '臨時 URL 功能',
    'storage_temporary_url_status_desc' => '如果外掛程式不支援臨時URL功能，請勿開啟，否則將導致資源無法存取。',
    'storage_temporary_url_key' => '臨時 URL Key',
    'storage_temporary_url_expiration' => '臨時 URL 有效期限',
    'storage_image_handle_position' => '圖片處理位置',
    'storage_image_thumb_config' => '配置圖',
    'storage_image_thumb_avatar' => '頭像圖',
    'storage_image_thumb_ratio' => '等比例縮略圖',
    'storage_image_thumb_square' => '正方形縮略圖',
    'storage_image_thumb_big' => '原圖壓縮圖',
    'storage_video_transcode_parameter' => '視頻轉碼參數',
    'storage_video_watermark' => '視頻水印參數',
    'storage_video_screenshot' => '視頻截圖參數',
    'storage_video_gift' => '視頻轉動圖參數',
    'storage_video_poster_parameter' => '視頻封面圖參數',
    'storage_video_transcode_handle_position' => '視頻轉碼參數處理位置',
    'storage_video_poster_handle_position' => '視頻封面圖參數處理位置',
    'storage_audio_transcode_parameter' => '音頻轉碼參數',
    'storage_audio_transcode_handle_position' => '音頻轉碼參數處理位置',
    'storage_document_preview_service' => '文件預覽服務',
    'storage_document_preview_extension_names' => '支援預覽的副檔名',
    // Operating-User
    'user_name' => '身份自定義名稱',
    'user_name_desc' => '例如“使用者”、“會員”、“站友”等命名',
    'user_uid_name' => 'ID 自定義名稱',
    'user_uid_name_desc' => '例如“uid”、“id”、“會員號”等命名',
    'user_username_name' => '使用者名自定義名稱',
    'user_username_name_desc' => '例如“使用者名”、“會員名”、“帳號”等命名',
    'user_nickname_name' => '暱稱自定義名稱',
    'user_nickname_name_desc' => '例如“暱稱”、“花名”、“代號”等命名',
    'user_role_name' => '角色自定義名稱',
    'user_role_name_desc' => '例如“角色”、“使用者組”、“使用者群”等命名',
    'user_bio_name' => '簡介自定義名稱',
    'user_bio_name_desc' => '例如“Bio”、“簡介”、“個性簽名”等命名',
    'user_default_role' => '預設使用者角色',
    'user_default_role_desc' => '註冊後預設使用者角色',
    'user_default_avatar' => '預設使用者頭像',
    'user_default_avatar_desc' => '使用者未設定頭像時的預設頭像圖',
    'user_default_anonymous_avatar' => '匿名使用者頭像',
    'user_default_anonymous_avatar_desc' => '內容髮表匿名者的頭像圖',
    'user_default_deactivate_avatar' => '已停用使用者頭像',
    'user_default_deactivate_avatar_desc' => '使用者註銷或停用後的頭像圖',
    'user_identifier' => '使用者標識類型',
    'user_identifier_desc' => '使用者互動中以哪個標識為主',
    'user_uid_digit' => '使用者 UID 起始位數',
    'user_uid_digit_desc' => '註冊時隨機生成的數字位數',
    'user_profile_desc' => '訪問使用者主頁時，預設內容列表',
    'user_ban_names' => '使用者禁用名',
    'user_ban_names_desc' => '一行一個。 禁止使用者名稱和暱稱使用。',
    'user_edit_username_length' => '使用者名長度',
    'user_edit_username_length_min' => '最小長度',
    'user_edit_username_length_max' => '最大長度',
    'user_edit_username_length_desc' => '使用者名最小長度和最大長度',
    'user_edit_username_periodicity' => '使用者名修改間隔天數',
    'user_edit_nickname_length' => '使用者暱稱長度',
    'user_edit_nickname_periodicity' => '使用者暱稱修改間隔天數',
    'user_edit_nickname_unique' => '使用者暱稱唯一值',
    'user_edit_bio_length' => '使用者簡介長度',
    'user_edit_bio_support' => '使用者簡介支援',
    'user_bio_support_mention' => '艾特使用者',
    'user_bio_support_link' => '超鏈接',
    'user_bio_support_hashtag' => '話題',
    'user_extcredits_config' => '擴充分值配置',
    'user_extcredits_name' => '分值名稱',
    'user_extcredits_unit' => '分值單位',
    'user_extcredits_state_not_enabled' => '不啟用',
    'user_extcredits_state_private' => '私有',
    'user_extcredits_state_public' => '公開',
    'user_conversation_status' => '私信會話功能',
    'user_conversation_status_desc' => '關閉對全員有效，開啟後以使用者角色權限為準',
    'user_conversation_files' => '會話附件功能',
    'user_conversation_files_desc' => '如果全部不勾選則代表只支援純文字的對話',
    // Operating-User-Profile
    'profile_posts' => '他發表的貼文',
    'profile_comments' => '他發表的留言',
    'profile_likers' => '讚了他的使用者',
    'profile_dislikers' => '不喜歡他的使用者',
    'profile_followers' => '跟隨了他的使用者',
    'profile_blockers' => '封鎖了他的使用者',
    'profile_followers_you_follow' => '你認識的跟隨者',
    'profile_likes_users' => '他讚的使用者',
    'profile_likes_groups' => '他讚的社團',
    'profile_likes_hashtags' => '他讚的話題',
    'profile_likes_geotags' => '他讚的地理',
    'profile_likes_posts' => '他讚的貼文',
    'profile_likes_comments' => '他讚的留言',
    'profile_dislikes_users' => '他不喜歡的使用者',
    'profile_dislikes_groups' => '他不喜歡的社團',
    'profile_dislikes_hashtags' => '他不喜歡的話題',
    'profile_dislikes_geotags' => '他不喜歡的地理',
    'profile_dislikes_posts' => '他不喜歡的貼文',
    'profile_dislikes_comments' => '他不喜歡的留言',
    'profile_following_users' => '他跟隨的使用者',
    'profile_following_groups' => '他跟隨的社團',
    'profile_following_hashtags' => '他跟隨的話題',
    'profile_following_geotags' => '他跟隨的地理',
    'profile_following_posts' => '他跟隨的貼文',
    'profile_following_comments' => '他跟隨的留言',
    'profile_blocking_users' => '他封鎖的使用者',
    'profile_blocking_groups' => '他封鎖的社團',
    'profile_blocking_hashtags' => '他封鎖的話題',
    'profile_blocking_geotags' => '他封鎖的地理',
    'profile_blocking_posts' => '他封鎖的貼文',
    'profile_blocking_comments' => '他封鎖的留言',
    // Operating-Content
    'content_group_name' => '社團自定義名稱',
    'content_group_name_desc' => '例如“版區”、“圈子”、“分類”等命名',
    'content_hashtag_name' => '話題自定義名稱',
    'content_hashtag_name_desc' => '例如“超話”、“標籤”、“話題”等命名',
    'content_post_name' => '貼文內容名稱',
    'content_post_name_desc' => '例如“貼文”、“動態”、“說說”等命名',
    'content_comment_name' => '留言內容名稱',
    'content_comment_name_desc' => '例如“留言”、“回复”、“互動”等命名',
    'content_publish_post_name' => '發表貼文行為名稱',
    'content_publish_post_name_desc' => '例如“發表”、“投稿”、“反饋”等命名',
    'content_publish_comment_name' => '發表留言行為名稱',
    'content_publish_comment_name_desc' => '例如“回复”、“回帖”、“跟帖”等命名',
    'content_mention_status' => '艾特功能',
    'content_mention_number' => '艾特個數',
    'content_mention_number_desc' => '每篇內容支援艾特使用者的數量，0 表示不限制',
    'content_hashtag_status' => '話題狀態',
    'content_hashtag_format' => '話題格式',
    'content_hashtag_format_1' => '單 # 號',
    'content_hashtag_format_2' => '雙 # 號',
    'content_hashtag_format_desc' => '<a href="#">#話題</a> 和 <a href="#">#話題#</a> 的區別',
    'content_hashtag_length' => '話題長度',
    'content_hashtag_number' => '話題個數',
    'content_hashtag_number_desc' => '每篇內容支援話題的數量，0 表示不限制',
    'content_hashtag_regexp' => '話題正則表達式',
    'content_nearby_length' => '附近搜尋預設範圍',
    'content_nearby_length_desc' => '查看附近內容時的搜尋範圍',
    'content_post_brief_length' => '貼文摘要字數',
    'content_post_brief_length_desc' => '貼文超過該設定值將採用摘要，超長內容摘要字數',
    'content_comment_brief_length' => '留言摘要字數',
    'content_comment_brief_length_desc' => '留言超過該設定值將採用摘要，超長內容摘要字數',
    'content_comment_visibility_rule' => '留言可見度規則',
    'content_comment_visibility_rule_desc' => '貼文發表時間大於天數，留言將隱藏，0 代表不啟用',
    'content_preview_post_like_users' => '貼文按讚使用者預覽',
    'content_preview_post_like_users_desc' => '預覽按讚了貼文的使用者，數字代表預覽數量。',
    'content_preview_post_comments' => '貼文留言預覽',
    'content_preview_post_comments_desc' => '貼文列表頁預覽留言，數字代表預覽數量。',
    'content_preview_post_comment_require' => '貼文留言預覽條件',
    'content_preview_post_comment_require_desc' => 'Count 數量達到多少才輸出預覽',
    'content_preview_comment_like_users' => '留言按讚使用者預覽',
    'content_preview_comment_replies' => '留言回覆預覽數量',
    'content_post_edit_config' => '貼文編輯權限',
    'content_post_delete_config' => '貼文刪除權限',
    'content_comment_edit_config' => '留言編輯權限',
    'content_comment_delete_config' => '留言刪除權限',
    'content_edit_desc' => '發表後是否可以編輯',
    'content_delete_desc' => '發表後是否可以刪除',
    // Operating-Interaction
    'interaction_function_status' => '功能狀態',
    'interaction_operation_name' => '行為名稱',
    'interaction_user_title' => '使用者頭銜',
    'interaction_public_record' => '公開記錄',
    'interaction_public_count' => '公開總數',
    'interaction_column_name' => '欄位名稱',
    // Operating-Sticker
    'sticker_group' => '表情組',
    'sticker_table_group_name' => '表情組名稱',
    'sticker_table_group_image' => '表情組圖標',
    'sticker_table_group_code' => '表情組標識',
    'sticker_table_quantity' => '表情數量',
    'sticker_manage' => '表情管理',
    'sticker_table_image' => '表情圖',
    'sticker_table_code' => '表情符號',
    // Operating-Editor
    'editor_group' => '社團',
    'editor_title' => '標題',
    'editor_sticker' => '表情',
    'editor_image' => '圖片',
    'editor_video' => '視頻',
    'editor_audio' => '音頻',
    'editor_document' => '文檔',
    'editor_mention' => '艾特',
    'editor_hashtag' => '話題',
    'editor_extend' => '擴充功能',
    'editor_location' => '定位',
    'editor_anonymous' => '匿名',
    'editor_upload_image_type' => '圖片上傳方式',
    'editor_upload_video_type' => '視頻上傳方式',
    'editor_upload_audio_type' => '音頻上傳方式',
    'editor_upload_document_type' => '文檔上傳方式',
    'editor_upload_image_number' => '上傳圖片上限個數',
    'editor_upload_video_number' => '上傳視頻上限個數',
    'editor_upload_audio_number' => '上傳音頻上限個數',
    'editor_upload_document_number' => '上傳文檔上限個數',
    // Operating-Publish
    'publish_editor_config' => '編輯器選擇',
    'publish_editor_function_status' => '編輯器功能開啟',
    'publish_editor_function_options' => '編輯器功能配置',
    'publish_post_verify_config' => '發表貼文要求',
    'publish_comment_verify_config' => '發表留言要求',
    'publish_post_rules_config' => '發表貼文特殊規則',
    'publish_comment_rules_config' => '發表留言特殊規則',
    'publish_editor_desc' => '發表內容的編輯器',
    'publish_verify_desc' => '帳號必須完善所選資料才可以發表',
    'publish_rules_desc' => '全員有效，優先級大於角色規則要求',
    'publish_rule_type' => '規則類型',
    'publish_rule_datetime' => '日期範圍',
    'publish_rule_time' => '時間範圍',
    'publish_rule_timezone' => '時區標準',
    'publish_rule_rule' => '規則要求',
    'publish_rule_tip' => '規則提示',
    'publish_edit_time_limit' => '多長時間可編輯',
    'publish_edit_sticky_limit' => '置頂後',
    'publish_edit_digest_limit' => '加精後',
    'publish_editor_group_required' => '社團是否必選',
    'publish_editor_group_required_desc' => '發表貼文的時候，社團是否必須選擇',
    'publish_editor_title_input_box' => '標題輸入框顯示',
    'publish_editor_title_input_box_desc' => '弱顯示需使用者手動選擇後才會顯示標題輸入框',
    'publish_editor_title_required' => '標題是否必填',
    'publish_editor_title_required_desc' => '發表貼文的時候，標題是否必填',
    'publish_editor_title_length' => '標題字數限制',
    'publish_editor_title_length_desc' => '標題字數不得超過設定數，最大上限 255 個字符',
    'publish_editor_post_content_length' => '貼文字數限制',
    'publish_editor_post_content_length_desc' => '貼文字數不得超過設定數，最小上限 140 個字符',
    'publish_editor_comment_content_length' => '留言字數限制',
    'publish_editor_comment_content_length_desc' => '留言字數不得超過設定數，最小上限 140 個字符',
    // Operating-Permission
    'permission_option_email' => '已綁定郵箱',
    'permission_option_phone' => '已綁定手機號',
    'permission_option_kyc' => '已實名認證',
    'permission_option_rule_datetime' => '指定日期範圍內生效',
    'permission_option_rule_time' => '指定時間段範圍內每天循環生效',
    'permission_option_review_publish' => '可以發表，但是需要審核',
    'permission_option_close_publish' => '禁止發表',
    'permission_option_can_be_edited' => '可以編輯',
    'permission_option_cannot_be_edited' => '不可編輯',
    'permission_option_can_be_deleted' => '可以刪除',
    'permission_option_cannot_be_deleted' => '不可刪除',
    'permission_option_direct_release' => '直接透過',
    'permission_option_required_review' => '需要審核',
    'permission_option_title_optional_display' => '弱顯示',
    'permission_option_title_direct_display' => '強顯示',
    // Operating-Roles
    'role_table_display' => '顯示標識',
    'role_table_nickname_color' => '暱稱顏色',
    'role_option_display_icon' => '顯示圖標',
    'role_option_display_text' => '顯示文字',
    'role_option_close_nickname_color' => '不使用顏色',
    'role_current' => '當前角色',
    'role_target' => '目標角色',
    'role_target_desc' => '角色刪除後，該角色下使用者合併到所選目標角色名下',
    'role_perm_basic_config' => '基礎設定',
    'role_perm_post_config' => '發表貼文設定',
    'role_perm_comment_config' => '發表留言設定',
    'role_perm_upload_config' => '上傳設定',
    'role_perm_interaction_config' => '交互設定',
    'role_perm_customize_config' => '自定義設定',
    'role_perm_content_view' => '瀏覽權限',
    'role_perm_conversation' => '會話權限',
    'role_perm_content_link_handle' => '發表內容的鏈接處理',
    'role_perm_content_link_handle_1' => '不解析並掩碼域名',
    'role_perm_content_link_handle_2' => '不解析但以文本方式顯示',
    'role_perm_content_link_handle_3' => '正常解析',
    'role_perm_post_publish' => '發表貼文權限',
    'role_perm_post_verify' => '發表貼文要求',
    'role_perm_post_review' => '發表貼文規則',
    'role_perm_post_rules' => '發表貼文特殊規則',
    'role_perm_post_time_interval' => '發表貼文時間間隔',
    'role_perm_post_daily_count' => '發表帖子每日上限',
    'role_perm_post_draft_count' => '貼文草稿數量限制',
    'role_perm_comment_publish' => '發表留言權限',
    'role_perm_comment_verify' => '發表留言要求',
    'role_perm_comment_review' => '發表留言規則',
    'role_perm_comment_rules' => '發表留言特殊規則',
    'role_perm_comment_time_interval' => '發表留言時間間隔',
    'role_perm_comment_daily_count' => '發表留言每日上限',
    'role_perm_comment_draft_count' => '留言草稿數量限制',
    'role_perm_upload_image' => '上傳圖片',
    'role_perm_upload_video' => '上傳視頻',
    'role_perm_upload_audio' => '上傳音頻',
    'role_perm_upload_document' => '上傳文檔',
    'role_perm_upload_file_desc' => '勾選代表有權上傳，輸入框留空則使用“存儲配置”的設定值作為預設參數。',
    'role_perm_follow_user_max_count' => '跟隨使用者上限數量',
    'role_perm_block_user_max_count' => '封鎖使用者上限數量',
    'role_perm_download_file_count' => '24 小時內下載上限',
    'role_perm_table_name' => '權限名',
    'role_perm_table_value' => '權限值',
    // Operating-Groups
    'group_table_parent_group' => '父級社團',
    'group_table_subgroup' => '子級社團',
    'group_table_privacy' => '社團模式',
    'group_table_visibility' => '能見度',
    'group_table_follow_method' => '跟隨方式',
    'group_table_recommend' => '是否推薦',
    'group_table_admins' => '社團管理員',
    'group_table_can_publish' => '發布權限',
    'group_table_post_permissions' => '貼文權限',
    'group_table_comment_permissions' => '留言權限',
    'group_table_publish_perm_role' => '有權發表的角色',
    'group_table_publish_perm_review' => '是否需要審核',
    'group_table_publish_perm_review_desc' => '社團管理員不受限制',
    'group_public_desc' => '公開（任何人都能查看社團內貼文）',
    'group_private_desc' => '非公開（只有成員才能查看社團內貼文）',
    'group_visible_desc' => '可發現（任何人都能找到這個社團）',
    'group_hidden_desc' => '不可發現（只有成員能找到這個社團）',
    'group_publish_option_all' => '所有人',
    'group_publish_option_members' => '僅跟隨了社團的使用者',
    'group_publish_option_roles' => '僅指定的角色使用者',
    'group_publish_option_admins' => '僅限社團管理員',
    'group_can_publish_desc' => '關閉發布權限，可作為社團分類使用',
    'group_current' => '當前社團',
    'group_target' => '目標社團',
    'group_target_desc' => '合併後舊社團將被刪除，舊社團名下內容將遷移到所選目標社團名下。',
    // Extends
    'extend_editor_menus' => '顯示在擴充菜單',
    'extend_editor_toolbar' => '顯示在工具欄',
    'extend_editor_number_of_uses_desc' => '以“投票”外掛舉例，數量為 2 則代表單個貼文可以附帶 2 個投票',
    'extend_content_service' => '內容服務',
    'extend_content_list' => '內容列表',
    'extend_content_detail' => '內容詳情',
    'extend_content_search' => '內容搜尋',
    'extend_content_list_desc' => '該配置的優先級大於內容類型配置，當配置後，內容類型指定的數據來源將被取代。',
    'extend_content_ip' => 'IP 服務',
    'extend_content_map' => '地圖服務',
    'extend_content_notifications_service' => '通知服務',
    'extend_content_review' => '審核服務',
    'extend_content_list_by_all' => '全部貼文或留言',
    'extend_content_list_by_timelines' => '時間軸的貼文或留言',
    'extend_content_list_by_nearby' => '附近範圍的貼文或留言',
    'extend_content_by_detail' => '貼文或留言詳情',
    'extend_content_search_users' => '搜尋使用者',
    'extend_content_search_groups' => '搜尋社團',
    'extend_content_search_hashtags' => '搜尋話題',
    'extend_content_search_geotags' => '搜尋地理',
    'extend_content_search_posts' => '搜尋貼文',
    'extend_content_search_comments' => '搜尋留言',
    // Client-Channels
    'channel_default_homepage' => '預設首頁',
    'channel_table_channel' => '頻道',
    'channel_table_page' => '頁面',
    'channel_table_page_home' => '首頁',
    'channel_table_page_list' => '清單頁',
    'channel_table_page_detail' => '詳情頁',
    'channel_table_page_interaction' => '互動頁',
    'channel_table_path' => '路徑',
    'channel_table_seo' => 'SEO 訊息',
    'channel_table_seo_title' => 'SEO 標題',
    'channel_table_seo_description' => 'SEO 描述',
    'channel_table_seo_keywords' => 'SEO 關鍵詞',
    'channel_table_query_state' => '使用者端傳參',
    'channel_table_query_state_desc' => '是否接受使用者端傳參，關閉後將僅支援預設參數值',
    'channel_table_query_config' => '預設參數',
    'channel_table_query_config_desc' => '參考本接口的 API Query 參數',
    'channel_query_state_1' => '不接受使用者端傳參',
    'channel_query_state_2' => '僅接受使用者端分頁參數',
    'channel_query_state_3' => '接受全部參數',
    // Client-Columns
    'channel_timeline' => '時間軸',
    'channel_timeline_all_posts' => '全部跟隨的貼文',
    'channel_timeline_user_posts' => '跟隨使用者的貼文',
    'channel_timeline_group_posts' => '跟隨社團的貼文',
    'channel_timeline_hashtag_posts' => '跟隨話題的貼文',
    'channel_timeline_geotag_posts' => '跟隨地理的貼文',
    'channel_timeline_all_comments' => '全部跟隨的留言',
    'channel_timeline_user_comments' => '跟隨使用者的留言',
    'channel_timeline_group_comments' => '跟隨社團的留言',
    'channel_timeline_hashtag_comments' => '跟隨話題的留言',
    'channel_timeline_geotag_comments' => '跟隨地理的留言',
    'channel_nearby' => '附近',
    'channel_nearby_posts' => '附近的貼文',
    'channel_nearby_comments' => '附近的留言',
    'channel_me' => '個人中心',
    'channel_me_extcredits' => '擴展分數',
    'channel_me_wallet' => '錢包',
    'channel_me_drafts' => '草稿箱',
    'channel_me_users' => '名下使用者',
    'channel_me_settings' => '設定',
    'channel_messages' => '訊息',
    'channel_conversations' => '對話',
    'channel_notifications' => '通知',
    'channel_notifications_all' => '通知-全部',
    'channel_notifications_systems' => '通知-系統',
    'channel_notifications_recommends' => '通知-推薦',
    'channel_notifications_likes' => '通知-喜歡',
    'channel_notifications_dislikes' => '通知-不喜歡',
    'channel_notifications_follows' => '通知-跟隨',
    'channel_notifications_blocks' => '通知-封鎖',
    'channel_notifications_mentions' => '通知-提及',
    'channel_notifications_comments' => '通知-留言',
    'channel_notifications_quotes' => '通知-引用',
    'channel_search' => '搜尋',
    // Client-Keys
    'key_table_read_only' => '只讀',
    'key_select_platform' => '選擇密鑰應用平台',
    'key_option_main_api' => '主程 API',
    'key_option_manage_api' => '管理 API',
    'key_option_plugin_api' => '外掛 API',
    'key_option_plugin_api_select' => '選擇密鑰用於哪個外掛',
    'key_option_plugin_api_select_desc' => '該密鑰僅能請求關聯外掛的 API',
    // Client-Basic
    'website_stat_code' => '網站統計代碼',
    'website_stat_code_desc' => '第三方統計代碼，不支援使用含有 document.write 的統計代碼。',
    'website_stat_position' => '統計代碼位置',
    'website_stat_position_desc' => '統計代碼載入到 HTML 的哪個位置。',
    'china_mode' => '中國模式',
    'china_mode_desc' => '站點伺服器部署在中國境內時需要填寫的信息。',
    'china_mode_config' => '中國伺服器配置（非必填項）',
    'china_icp_filing' => '互聯網內容提供商備案',
    'china_icp_license' => '互聯網內容提供商許可證',
    'china_mps_filing' => '公安局備案',
    'china_broadcasting_license' => '廣播電視節目製作經營許可證',
    // Client-Status
    'client_status_desc' => '使用者端每 10 分鐘請求一次狀態配置',
    // App-Center-Themes
    'website_engine_config' => '網站引擎配置',
    'website_engine_api_config' => 'API 配置',
    'website_engine_status' => '引擎狀態',
    'website_engine_api_type' => '引擎 API 類型',
    'website_engine_key_id' => '關聯應用密鑰',
    'website_engine_view_desktop' => '電腦端',
    'website_engine_view_mobile' => '行動端',
    // App-Center-Install
    'install_website_engine' => '安裝網站引擎',
    'install_plugin' => '安裝外掛',
    'install_application' => '安裝應用',
    'install_mode' => '安裝方式',
    'install_mode_fskey' => '輸入 key',
    'install_mode_upload' => '上傳 zip',
    'install_mode_directory' => '输入目錄路徑',
    'download_application' => '下載應用',
];
