<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CodeMessagesTableSeeder extends Seeder
{
    /**
     * Fresns seed file.
     */
    public function run(): void
    {
        DB::table('code_messages')->delete();

        DB::table('code_messages')->insert([
            [
                'app_fskey' => 'Fresns',
                'code' => 0,
                'messages' => '{"en":"Success","zh-Hans":"成功","zh-Hant":"成功"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21000,
                'messages' => '{"en":"Unconfigured plugin","zh-Hans":"未配置插件","zh-Hant":"未配置外掛"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21001,
                'messages' => '{"en":"Plugin does not exist","zh-Hans":"插件不存在","zh-Hant":"外掛不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21002,
                'messages' => '{"en":"Command word does not exist","zh-Hans":"命令字不存在","zh-Hant":"命令字不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21003,
                'messages' => '{"en":"Command word unknown error","zh-Hans":"命令字未知错误","zh-Hant":"命令字未知錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21004,
                'messages' => '{"en":"Command word not responding","zh-Hans":"命令字无响应","zh-Hant":"命令字無響應"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21005,
                'messages' => '{"en":"Command word request parameter error","zh-Hans":"命令字请求参数错误","zh-Hant":"命令字請求參數錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21006,
                'messages' => '{"en":"Command word execution request error","zh-Hans":"命令字执行请求出错","zh-Hant":"命令字執行請求出錯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21007,
                'messages' => '{"en":"Command word response result is incorrect","zh-Hans":"命令字响应结果不正确","zh-Hant":"命令字響應結果不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21008,
                'messages' => '{"en":"Data anomalies, queries not available or data duplication","zh-Hans":"数据异常，查询不到或者数据重复","zh-Hant":"資料異常，查詢不到或者資料重複"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21009,
                'messages' => '{"en":"Execution anomalies, missing files or logging errors","zh-Hans":"执行异常，文件丢失或者记录错误","zh-Hant":"執行異常，文件丟失或者記錄錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21010,
                'messages' => '{"en":"Command word function is disabled","zh-Hans":"命令字功能已关闭","zh-Hant":"命令字功能已關閉"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'CmdWord',
                'code' => 21011,
                'messages' => '{"en":"Incorrect command word configuration","zh-Hans":"命令字配置不正确","zh-Hant":"命令字配置不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30000,
                'messages' => '{"en":"Parameter error","zh-Hans":"参数格式错误","zh-Hant":"參數格式錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30001,
                'messages' => '{"en":"Parameter missing error","zh-Hans":"参数缺失错误","zh-Hant":"參數缺失錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30002,
                'messages' => '{"en":"Parameter values do not meet the requirements","zh-Hans":"参数值不符合要求","zh-Hant":"參數值不符合要求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30003,
                'messages' => '{"en":"The parameter value is not in a valid Json array format","zh-Hans":"参数值不是有效 Json 数组格式","zh-Hant":"參數值不是有效 Json 數組格式"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30004,
                'messages' => '{"en":"The parameter value is not in a valid Json object format","zh-Hans":"参数值不是有效 Json 对象格式","zh-Hant":"參數值不是有效 Json 對象格式"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30005,
                'messages' => '{"en":"The two-choice parameter value cannot be passed to both parameters","zh-Hans":"二选一参数值不可以两个都传参","zh-Hant":"二選一參數值不可以兩個都傳參"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30006,
                'messages' => '{"en":"Same old and new value, no change","zh-Hans":"新旧值一样，没有变化","zh-Hant":"新值和舊值一樣，沒有變化"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30007,
                'messages' => '{"en":"Can\'t be empty","zh-Hans":"不能留空","zh-Hant":"不能留空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 30008,
                'messages' => '{"en":"Operation failed, please try again","zh-Hans":"操作失败，请重试","zh-Hant":"操作失敗，請重試"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31000,
                'messages' => '{"en":"Header error","zh-Hans":"Header Error","zh-Hant":"Header Error"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31101,
                'messages' => '{"en":"Platform ID not exist","zh-Hans":"平台 ID 不存在","zh-Hant":"平台 ID 不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31102,
                'messages' => '{"en":"Platform ID and Key do not match","zh-Hans":"平台 ID 与密钥不匹配","zh-Hant":"平台 ID 與密鑰不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31103,
                'messages' => '{"en":"Platform ID does not match the account or user","zh-Hans":"平台 ID 与账号或用户不匹配","zh-Hant":"平台 ID 與賬號或使用者不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31201,
                'messages' => '{"en":"Version not exist","zh-Hans":"版本号不存在","zh-Hant":"版本號不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31202,
                'messages' => '{"en":"Version and key do not match","zh-Hans":"版本号与密钥不匹配","zh-Hant":"版本號與密鑰不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31301,
                'messages' => '{"en":"App ID does not exist or is disabled","zh-Hans":"App ID 不存在或已禁用","zh-Hant":"App ID 不存在或已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31302,
                'messages' => '{"en":"Signature error","zh-Hans":"签名错误","zh-Hant":"簽名錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31303,
                'messages' => '{"en":"Signature expired","zh-Hans":"签名已过期","zh-Hant":"簽名已過期"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31304,
                'messages' => '{"en":"The key does not have the right to request for the interface","zh-Hans":"该密钥无权请求本接口","zh-Hant":"該密鑰無權請求本接口"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31305,
                'messages' => '{"en":"Read-only key are not entitled to request for the interface","zh-Hans":"只读密钥无权请求本接口","zh-Hant":"只讀密鑰無權請求本接口"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31401,
                'messages' => '{"en":"Language tag incorrect","zh-Hans":"语言标签不正确","zh-Hant":"語言標籤不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31402,
                'messages' => '{"en":"Timezone incorrect","zh-Hans":"时区不正确","zh-Hant":"時區不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31501,
                'messages' => '{"en":"Account not logged in, Unable to use","zh-Hans":"账号未登录，无权操作","zh-Hant":"賬號未登入，無權操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31502,
                'messages' => '{"en":"Wrong account or record not exist","zh-Hans":"账号错误或者不存在","zh-Hant":"賬號錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31503,
                'messages' => '{"en":"Lost login token, Please login again","zh-Hans":"登录凭证丢失，请重新登录","zh-Hant":"登入憑證丟失，請重新登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31504,
                'messages' => '{"en":"Login token is no longer valid, please login again","zh-Hans":"登录凭证已失效，请重新登录","zh-Hant":"登入憑證已失效，請重新登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31505,
                'messages' => '{"en":"Account login token are incorrect or do not exist","zh-Hans":"账号登录凭证错误或者不存在","zh-Hant":"賬號登入憑證錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31506,
                'messages' => '{"en":"Login token is incorrect or does not exist, please login again.","zh-Hans":"登录令牌错误或者不存在，请重新登录","zh-Hant":"登入令牌錯誤或不存在，請重新登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31507,
                'messages' => '{"en":"Login token has expired, please login again.","zh-Hans":"登录令牌已超时失效，请重新登录","zh-Hant":"登入令牌已逾時失效，請重新登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31508,
                'messages' => '{"en":"There are multiple users for the current account, please select a user","zh-Hans":"当前账户有多个用户，请选择一个用户","zh-Hant":"目前帳戶有多個使用者，請選擇一個使用者"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31601,
                'messages' => '{"en":"User not logged in, Unable to use","zh-Hans":"用户未登录，无权操作","zh-Hant":"使用者未登入，無權操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31602,
                'messages' => '{"en":"Wrong user or record not exist","zh-Hans":"用户错误或者不存在","zh-Hant":"使用者錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31603,
                'messages' => '{"en":"User login token are incorrect or do not exist","zh-Hans":"用户登录凭证错误或者不存在","zh-Hant":"使用者登入憑證錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31604,
                'messages' => '{"en":"The current user has set a PIN, please enter the PIN to log in","zh-Hans":"当前用户设置了 PIN，请输入 PIN 登录","zh-Hant":"目前使用者設定了 PIN，請輸入 PIN 登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31701,
                'messages' => '{"en":"Device information is not available","zh-Hans":"无法获知设备信息","zh-Hant":"無法獲知設備信息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31702,
                'messages' => '{"en":"Wrong format of device information","zh-Hans":"设备信息格式错误","zh-Hant":"設備信息格式錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 31703,
                'messages' => '{"en":"Missing IP information in device information","zh-Hans":"设备信息中缺失 IP 信息","zh-Hant":"設備信息中缺失 IP 信息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32100,
                'messages' => '{"en":"No service provider configured","zh-Hans":"未配置服务商","zh-Hant":"未配置服務商"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32101,
                'messages' => '{"en":"The service provider not exist","zh-Hans":"服务商不存在","zh-Hant":"服務商不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32102,
                'messages' => '{"en":"The service provider not enabled","zh-Hans":"服务商未启用","zh-Hant":"服務商未啟用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32103,
                'messages' => '{"en":"Service provider config parameter is empty","zh-Hans":"服务商配置参数为空","zh-Hant":"服務商配置參數為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32104,
                'messages' => '{"en":"S3 uploads are not supported by the storage provider","zh-Hans":"存储服务商不支持 S3 方式上传","zh-Hant":"儲存服務商不支援 S3 方式上傳"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32105,
                'messages' => '{"en":"Storage service provider configuration exception, temporarily unable to upload file","zh-Hans":"存储服务商配置异常，暂时无法上传文件","zh-Hant":"存儲服務商配置異常，暫時無法上傳文件"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32201,
                'messages' => '{"en":"Wrong ID or record not exist","zh-Hans":"ID 错误或者记录不存在","zh-Hant":"ID 錯誤或者記錄不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32202,
                'messages' => '{"en":"Abnormal data: failed to be queried or data duplicated.","zh-Hans":"数据异常，查询不到或者数据重复","zh-Hant":"數據異常，查詢不到或者數據重複"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32203,
                'messages' => '{"en":"Record expired and invalid. Please try again.","zh-Hans":"记录已超时失效，请重新操作","zh-Hant":"記錄已超時失效，請重新操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32204,
                'messages' => '{"en":"Record used. Please try again.","zh-Hans":"记录已被使用过，请重新操作","zh-Hant":"記錄已被使用過，請重新操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32205,
                'messages' => '{"en":"Record used. Can no longer be used.","zh-Hans":"记录已被使用过，无法再使用","zh-Hant":"記錄已被使用過，無法再使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32206,
                'messages' => '{"en":"Record content is empty","zh-Hans":"记录内容为空","zh-Hant":"記錄內容為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32301,
                'messages' => '{"en":"No response from the service provider","zh-Hans":"服务商未响应","zh-Hant":"服務商未響應"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32302,
                'messages' => '{"en":"Service provider processing failed","zh-Hans":"服务商处理失败","zh-Hant":"服務商處理失敗"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32303,
                'messages' => '{"en":"Callback error: data lost or wrong record","zh-Hans":"回调异常，查询不到或者数据记录错误","zh-Hant":"回調異常，查詢不到或者數據記錄錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 32304,
                'messages' => '{"en":"Abnormal execution: file lost or wrong record","zh-Hans":"执行异常，文件丢失或者记录错误","zh-Hant":"執行異常，文件丟失或者記錄錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33100,
                'messages' => '{"en":"This interface or version has been disabled by the system and cannot be requested","zh-Hans":"该接口或该版本已被系统禁用，无法请求","zh-Hant":"該接口或該版本已被系統禁用，無法請求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33101,
                'messages' => '{"en":"Request for the interface is forbidden under private mode","zh-Hans":"私有模式禁止请求该接口","zh-Hant":"私有模式禁止請求該接口"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33102,
                'messages' => '{"en":"Site mode configuration error","zh-Hans":"站点模式配置错误","zh-Hant":"站點模式配置錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33200,
                'messages' => '{"en":"Verify code template unavailable or not exist","zh-Hans":"验证码模板关闭或者不存在","zh-Hant":"驗證碼模板關閉或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33201,
                'messages' => '{"en":"Send the verify code too often, please try again later","zh-Hans":"发送验证码太频繁，请稍后再试","zh-Hant":"發送驗證碼太頻繁，請稍後再試"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33202,
                'messages' => '{"en":"Verify code cannot be empty","zh-Hans":"验证码不能为空","zh-Hant":"驗證碼不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33203,
                'messages' => '{"en":"Verify code incorrect or expired","zh-Hans":"验证码不正确或验证码已过期","zh-Hant":"驗證碼不正確或驗證碼已過期"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33301,
                'messages' => '{"en":"Content contains system banned words, please modify before submitting","zh-Hans":"内容含有系统禁用词，请修改后再提交","zh-Hant":"內容含有系統禁用詞，請修改後再提交"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33302,
                'messages' => '{"en":"The length of the content exceeds the system limit, please reduce it and submit again","zh-Hans":"内容长度超过系统上限，请删减后再提交","zh-Hant":"內容長度超過系統上限，請刪減後再提交"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33400,
                'messages' => '{"en":"IP error, not a valid IP address","zh-Hans":"IP 错误，不是有效 IP 地址","zh-Hant":"IP 錯誤，不是有效 IP 地址"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33401,
                'messages' => '{"en":"The IP is abnormal and the details are not available","zh-Hans":"IP 异常，查询不到详情信息","zh-Hant":"IP 異常，查詢不到詳情信息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33402,
                'messages' => '{"en":"The IP cannot be queried for details","zh-Hans":"该 IP 查询不到详情信息","zh-Hant":"該 IP 查詢不到詳情信息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33403,
                'messages' => '{"en":"The IP has been disabled and the system cannot provide service","zh-Hans":"该 IP 已被禁用，系统无法提供服务","zh-Hant":"該 IP 已停用，系統無法提供服務"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 33404,
                'messages' => '{"en":"The IP is unknown.","zh-Hans":"IP 属地未知","zh-Hant":"IP 屬地未知"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34100,
                'messages' => '{"en":"Account cannot be empty","zh-Hans":"账号不能为空","zh-Hant":"賬號不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34101,
                'messages' => '{"en":"Email format incorrect","zh-Hans":"邮箱格式不正确","zh-Hant":"電子郵件地址格式不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34102,
                'messages' => '{"en":"Phone number format incorrect","zh-Hans":"手机号格式不正确","zh-Hant":"手機號碼格式不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34103,
                'messages' => '{"en":"Country calling code error","zh-Hans":"国际区号错误","zh-Hant":"國際區號錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34104,
                'messages' => '{"en":"The new password entered twice does not match","zh-Hans":"两次输入的新密码不一致","zh-Hant":"兩次輸入的新密碼不一致"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34105,
                'messages' => '{"en":"Password length incorrect","zh-Hans":"密码长度不正确","zh-Hant":"密碼長度不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34106,
                'messages' => '{"en":"Password should contain numbers","zh-Hans":"密码应包含数字","zh-Hant":"密碼應包含數字"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34107,
                'messages' => '{"en":"Password should contain lowercase letters","zh-Hans":"密码应包含小写字母","zh-Hant":"密碼應包含小寫字母"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34108,
                'messages' => '{"en":"Password should contain uppercase letters","zh-Hans":"密码应包含大写字母","zh-Hant":"密碼應包含大寫字母"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34109,
                'messages' => '{"en":"Password should contain symbols","zh-Hans":"密码应包含符号","zh-Hant":"密碼應包含符號"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34110,
                'messages' => '{"en":"Email that do not support the domain","zh-Hans":"不支持该域名的邮箱","zh-Hant":"不支持該域名的電子郵件地址"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34111,
                'messages' => '{"en":"Password cannot be empty","zh-Hans":"密码不能为空","zh-Hant":"密碼不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34112,
                'messages' => '{"en":"Password or verify code cannot be empty","zh-Hans":"密码或者验证码不能全部为空","zh-Hant":"密碼或者驗證碼不能全部為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34113,
                'messages' => '{"en":"Birthday cannot be empty","zh-Hans":"出生日期不能为空","zh-Hant":"出生日期不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34114,
                'messages' => '{"en":"We are sorry, but according to our Terms of Use, you are not of legal age to use our services. This is to ensure that we comply with applicable laws and to protect the safety of all our users.","zh-Hans":"很抱歉，根据我们的使用条款，您的年龄无法使用我们的服务。这是为了确保我们遵守相关法律和保护所有用户的安全。","zh-Hant":"很抱歉，根據我們的使用條款，您的年齡無法使用我們的服務。 這是為了確保我們遵守相關法律和保護所有使用者的安全。"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34201,
                'messages' => '{"en":"This registration channel has been closed and account registration through this function is prohibited","zh-Hans":"该注册通道已关闭，禁止通过此功能注册账号","zh-Hant":"該註冊通道已關閉，禁止透過此功能註冊賬號"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34202,
                'messages' => '{"en":"Registration with Email not supported","zh-Hans":"不支持邮箱注册","zh-Hant":"不支持電子郵件地址註冊"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34203,
                'messages' => '{"en":"Registration with Phone number not supported","zh-Hans":"不支持手机号注册","zh-Hant":"不支持手機號碼註冊"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34204,
                'messages' => '{"en":"The account has registered","zh-Hans":"该账号已注册","zh-Hant":"該賬號已註冊"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34205,
                'messages' => '{"en":"Email has been used","zh-Hans":"邮箱已被使用","zh-Hant":"電子郵件地址已被使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34206,
                'messages' => '{"en":"Phone number has been used","zh-Hans":"手机号已被使用","zh-Hant":"手機號碼已被使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34207,
                'messages' => '{"en":"Login with Email not supported","zh-Hans":"不支持邮箱登录","zh-Hant":"不支持電子郵件地址登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34208,
                'messages' => '{"en":"Login with Phone number not supported","zh-Hans":"不支持手机号登录","zh-Hant":"不支持手機號碼登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34301,
                'messages' => '{"en":"Account not exist","zh-Hans":"该账号不存在","zh-Hant":"該賬號不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34302,
                'messages' => '{"en":"Email not exist","zh-Hans":"邮箱不存在","zh-Hant":"電子郵件地址不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34303,
                'messages' => '{"en":"Phone number not exist","zh-Hans":"手机号不存在","zh-Hant":"手機號碼不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34304,
                'messages' => '{"en":"Incorrect account password","zh-Hans":"账号密码不正确","zh-Hant":"賬號密碼不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34305,
                'messages' => '{"en":"Incorrect account or wrong password","zh-Hans":"账号不正确或者密码错误","zh-Hant":"賬號不正確或者密碼錯誤"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34306,
                'messages' => '{"en":"The error has exceeded the system limit. Please log in again 1 hour later","zh-Hans":"错误已超系统限制，请 1 小时后再登录","zh-Hant":"錯誤已超系統限制，請 1 小時後再登入"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34307,
                'messages' => '{"en":"Current account disabled","zh-Hans":"该账号已被禁用","zh-Hant":"該賬號已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34308,
                'messages' => '{"en":"The account has been logged out","zh-Hans":"该账号已注销","zh-Hant":"該賬號已註銷"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34401,
                'messages' => '{"en":"Email bound","zh-Hans":"已绑定邮箱","zh-Hant":"已綁定電子郵件地址"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34402,
                'messages' => '{"en":"Phone bound","zh-Hans":"已绑定手机","zh-Hant":"已綁定手機"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34403,
                'messages' => '{"en":"Connect account error","zh-Hans":"互联账号已存在","zh-Hant":"互聯賬號已存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34404,
                'messages' => '{"en":"Connect token is disabled","zh-Hans":"互联凭证已禁用","zh-Hant":"互聯憑證已禁用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34405,
                'messages' => '{"en":"You have already connected an account and cannot connect it again.","zh-Hans":"您已经绑定过账号，无法再绑定","zh-Hant":"您已經綁定過賬號，無法再綁定"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34406,
                'messages' => '{"en":"Your account is not set up with an email and phone number, so after you are disconnected your account will be empty, and you will not be able to log in, so disconnect is disabled.","zh-Hans":"您的账号未设置邮箱和手机号，解绑后账号为空，将无法登录，所以禁止解绑。","zh-Hant":"您的賬號未設置電子郵件地址和手機號碼，解綁後賬號為空，將無法登入，所以禁止解綁。"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34501,
                'messages' => '{"en":"Account wallet not exist or disabled","zh-Hans":"账号钱包不存在或者已禁用","zh-Hant":"賬號錢包不存在或者已禁用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34502,
                'messages' => '{"en":"Account wallet password is incorrect","zh-Hans":"账号钱包密码不正确","zh-Hant":"賬號錢包密碼不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34503,
                'messages' => '{"en":"The counterparty wallet not exist or disabled","zh-Hans":"对方钱包不存在或者已禁用","zh-Hant":"對方錢包不存在或者已禁用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34504,
                'messages' => '{"en":"Wallet balance is not allowed to make payment","zh-Hans":"钱包余额不允许支付","zh-Hant":"錢包餘額不允許支付"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34505,
                'messages' => '{"en":"The counterparty wallet balance is not allowed to make payment","zh-Hans":"对方钱包余额不足","zh-Hant":"對方錢包餘額不足"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34506,
                'messages' => '{"en":"The closing balance not match with the wallet limit","zh-Hans":"期末余额和钱包额度不匹配","zh-Hant":"期末餘額和錢包額度不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 34507,
                'messages' => '{"en":"The closing balance of the counterparty does not match with the wallet limit","zh-Hans":"对方期末余额和钱包额度不匹配","zh-Hant":"對方期末餘額和錢包額度不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35100,
                'messages' => '{"en":"User UID or username cannot be empty","zh-Hans":"用户 UID 或用户名不能为空","zh-Hant":"使用者 UID 或使用者名稱不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35101,
                'messages' => '{"en":"Could only be modified once within the specified number of days","zh-Hans":"指定天数内只能修改一次","zh-Hant":"指定天數內只能修改一次"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35102,
                'messages' => '{"en":"Your username can only contain letters, numbers and single hyphens","zh-Hans":"用户名格式错误，请勿使用特殊字符","zh-Hant":"使用者名格式錯誤，請勿使用特殊字符"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35103,
                'messages' => '{"en":"Username length incorrect","zh-Hans":"用户名长度超出限制","zh-Hant":"使用者名長度超出限制"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35104,
                'messages' => '{"en":"Username does not meet the minimum length requirement","zh-Hans":"用户名未达到最小长度要求","zh-Hant":"使用者名未達到最小長度要求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35105,
                'messages' => '{"en":"That username has been taken. Please choose another.","zh-Hans":"用户名已被使用","zh-Hant":"使用者名已被使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35106,
                'messages' => '{"en":"The username contains block words","zh-Hans":"用户名存在禁用词","zh-Hant":"使用者名存在禁用詞"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35107,
                'messages' => '{"en":"Consider using a nickname without special characters so it’s accessible to even more people, including people who are blind or have low vision.","zh-Hans":"昵称格式错误，请勿使用特殊字符","zh-Hant":"暱稱格式錯誤，請勿使用特殊字符"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35108,
                'messages' => '{"en":"Nickname length incorrect","zh-Hans":"昵称长度超出限制","zh-Hant":"暱稱長度超出限制"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35109,
                'messages' => '{"en":"Nickname does not meet the minimum length requirement","zh-Hans":"昵称未达到最小长度要求","zh-Hant":"暱稱未達到最小長度要求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35110,
                'messages' => '{"en":"The nickname contains block words","zh-Hans":"昵称存在禁用词","zh-Hant":"暱稱存在禁用詞"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35111,
                'messages' => '{"en":"That nickname has been taken. Please choose another.","zh-Hans":"昵称已被使用","zh-Hant":"暱稱已被使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35201,
                'messages' => '{"en":"Current user not exist or not belong to the current account","zh-Hans":"当前用户不存在或者不属于当前账号","zh-Hant":"當前使用者不存在或者不屬於當前賬號"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35202,
                'messages' => '{"en":"Current user disabled","zh-Hans":"当前用户已被禁用","zh-Hant":"當前使用者已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35203,
                'messages' => '{"en":"The user has been logged out","zh-Hans":"当前用户已注销","zh-Hant":"當前使用者已註銷"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35204,
                'messages' => '{"en":"Incorrect User PIN","zh-Hans":"用户 PIN 不正确","zh-Hant":"使用者 PIN 不正確"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35301,
                'messages' => '{"en":"Current user has no right to request","zh-Hans":"当前用户无权请求","zh-Hant":"當前使用者無權請求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35302,
                'messages' => '{"en":"The user has expired and has no right to use the function","zh-Hans":"用户已过期，无权操作该功能","zh-Hant":"使用者已過期，無權操作該功能"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35303,
                'messages' => '{"en":"User has expired and is not entitled to view current content","zh-Hans":"用户已过期，无权查看当前内容","zh-Hant":"使用者已過期，無權查看當前內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35304,
                'messages' => '{"en":"The content belongs to the new content after the expiration date, the current user has expired and does not have the right to view","zh-Hans":"该内容属于过期后的新内容，当前用户已过期，无权浏览","zh-Hant":"該內容屬於過期後的新內容，當前使用者已過期，無權瀏覽"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35305,
                'messages' => '{"en":"You cannot specify a user to view the content","zh-Hans":"无法指定用户查看内容","zh-Hant":"無法指定使用者查看內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35306,
                'messages' => '{"en":"The system has been opened in private mode, the current user has no authorization information","zh-Hans":"系统已开启私有模式，当前用户暂无授权信息","zh-Hant":"系統已開啟私有模式，當前使用者暫無授權信息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 35400,
                'messages' => '{"en":"None of the selected users are eligible, the content is empty","zh-Hans":"所选用户都不符合条件，内容为空","zh-Hant":"所選使用者都不符合條件，內容為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36100,
                'messages' => '{"en":"Wrong role or record not exist","zh-Hans":"角色错误或者不存在","zh-Hant":"角色錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36101,
                'messages' => '{"en":"Current role not configured with permissions. Please contact the administrator to confirm.","zh-Hans":"当前角色未配置权限，请联系管理员确认","zh-Hant":"當前角色未配置權限，請聯繫管理員確認"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36102,
                'messages' => '{"en":"Current role has no right to make request","zh-Hans":"当前角色无权请求","zh-Hant":"當前角色無權請求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36103,
                'messages' => '{"en":"Current role has no right to browse","zh-Hans":"当前角色无权浏览","zh-Hant":"當前角色無權瀏覽"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36104,
                'messages' => '{"en":"Current role has no right to publish content","zh-Hans":"当前角色无权发表","zh-Hant":"當前角色無權發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36105,
                'messages' => '{"en":"There is a time limit for the current role to publish content. Please try again within specific time","zh-Hans":"当前角色发表内容有时间限制，请在规定的时间内再发表","zh-Hant":"當前角色發表內容有時間限制，請在規定的時間內再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36106,
                'messages' => '{"en":"Current role has to have an email bound before publishing content","zh-Hans":"当前角色发表内容需要先绑定邮箱","zh-Hant":"當前角色發表內容需要先綁定電子郵件地址"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36107,
                'messages' => '{"en":"Current role has to have a mobile phone number bound before publishing content","zh-Hans":"当前角色发表内容需要先绑定手机号","zh-Hant":"當前角色發表內容需要先綁定手機號碼"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36108,
                'messages' => '{"en":"KYC verification is required for current role to publish content","zh-Hans":"当前角色发表内容需要先实名制认证","zh-Hant":"當前角色發表內容需要先實名制認證"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36109,
                'messages' => '{"en":"Current role has no right to upload images","zh-Hans":"当前角色无权上传图片","zh-Hant":"當前角色無權上傳圖片"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36110,
                'messages' => '{"en":"Current role has no right to upload videos","zh-Hans":"当前角色无权上传视频","zh-Hant":"當前角色無權上傳視頻"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36111,
                'messages' => '{"en":"Current role has no right to upload audios","zh-Hans":"当前角色无权上传音频","zh-Hant":"當前角色無權上傳音頻"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36112,
                'messages' => '{"en":"Current role has no right to upload files","zh-Hans":"当前角色无权上传文档","zh-Hant":"當前角色無權上傳文檔"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36113,
                'messages' => '{"en":"File size exceeds the set limit","zh-Hans":"文件尺寸超出设置的限制","zh-Hant":"文件尺寸超出設置的限制"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36114,
                'messages' => '{"en":"File time length exceeds the set limit","zh-Hans":"文件时长超出设置的限制","zh-Hant":"文件時長超出設置的限制"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36115,
                'messages' => '{"en":"The number of files exceeds the set limit","zh-Hans":"文件数量超出设置的限制","zh-Hant":"文件數量超出設置的限制"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36116,
                'messages' => '{"en":"Current role has no conversation message permission","zh-Hans":"当前角色无私信权限","zh-Hant":"當前角色無私信權限"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36117,
                'messages' => '{"en":"The current role has reached the upper limit of today download, please download again tomorrow.","zh-Hans":"当前角色已经达到今天下载次数上限，请明天再下载","zh-Hant":"當前角色已經達到今天下載次數上限，請明天再下載"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36118,
                'messages' => '{"en":"The current number of characters has reached the maximum number and cannot be added","zh-Hans":"当前角色已经达到上限数量，无法再添加","zh-Hant":"當前角色已經達到上限數量，無法再添加"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36119,
                'messages' => '{"en":"Publish too fast, please post again at intervals. Please check the current role settings for details","zh-Hans":"发表太快，请间隔一段时间再发。详情请查看当前角色的设置","zh-Hant":"發表太快，請間隔一段時間再發。詳情請查看當前角色的設置"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36120,
                'messages' => '{"en":"The daily publish limit has been reached, please publish again tomorrow","zh-Hans":"发表已达每日上限，请明天再发表","zh-Hant":"發表已達每日上限，請明天再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36200,
                'messages' => '{"en":"This feature is not open and cannot be operated","zh-Hans":"该功能未开启，无法操作","zh-Hant":"該功能未開啟，無法操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36201,
                'messages' => '{"en":"The content is not open and cannot be viewed","zh-Hans":"该内容未开放，无法浏览","zh-Hant":"該內容未開放，無法瀏覽"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36202,
                'messages' => '{"en":"Cannot operate on yourself or your published content","zh-Hans":"不能对自己或自己发表的内容操作","zh-Hant":"不能對自己或自己發表的內容操作"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36300,
                'messages' => '{"en":"Only the specified method of publication is supported, and this interface prohibits requests","zh-Hans":"仅支持指定方式发表，本接口禁止请求","zh-Hant":"僅支持指定方式發表，本接口禁止請求"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36301,
                'messages' => '{"en":"Please have your email bound before publishing content","zh-Hans":"发表内容需要先绑定邮箱","zh-Hant":"發表內容需要先綁定電子郵件地址"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36302,
                'messages' => '{"en":"Please have your mobile phone number bound before publishing content","zh-Hans":"发表内容需要先绑定手机号","zh-Hant":"發表內容需要先綁定手機號碼"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36303,
                'messages' => '{"en":"Please go through the KYC verification process before publishing content","zh-Hans":"发表内容需要先实名制认证","zh-Hant":"發表內容需要先實名制認證"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36304,
                'messages' => '{"en":"The system has time limit for content publishing. Please try again within specified time","zh-Hans":"系统已经开启发表时间限制，请在规定的时间内再发表","zh-Hant":"系統已經開啟發表時間限制，請在規定的時間內再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36305,
                'messages' => '{"en":"Post cannot be edited after publication","zh-Hans":"帖子发表后不可再编辑","zh-Hant":"貼文發表後不可再編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36306,
                'messages' => '{"en":"Comment can not be edited after posting","zh-Hans":"评论发表后不可再编辑","zh-Hant":"留言發表後不可再編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36307,
                'messages' => '{"en":"Editing not allowed for sticky contents","zh-Hans":"置顶后不允许编辑","zh-Hant":"置頂後不允許編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36308,
                'messages' => '{"en":"Editing not allowed for digest contents","zh-Hans":"加精后不允许编辑","zh-Hant":"加精後不允許編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36309,
                'messages' => '{"en":"Editable time expired","zh-Hans":"超出可编辑时间","zh-Hant":"超出可編輯時間"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36310,
                'messages' => '{"en":"This extension of file can not be uploaded","zh-Hans":"该文件类型不在允许上传的范围内","zh-Hant":"該文件類型不在允許上傳的範圍內"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36311,
                'messages' => '{"en":"Current user does not have the post permission of the group","zh-Hans":"当前用户无权在该小组发帖","zh-Hant":"當前使用者無權在該社團發帖"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36312,
                'messages' => '{"en":"Current user does not have the comment permission of the group","zh-Hans":"当前用户无权在该小组评论","zh-Hant":"當前使用者無權在該社團留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36313,
                'messages' => '{"en":"The current group is closed for publication","zh-Hans":"当前小组已关闭发表内容","zh-Hant":"目前小組已關閉發表內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36314,
                'messages' => '{"en":"This comment type does not allow editing","zh-Hans":"该评论类型不允许编辑","zh-Hant":"該留言類型不允許編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36400,
                'messages' => '{"en":"Failed to delete. Content error or not exist","zh-Hans":"删除失败，内容错误或者不存在","zh-Hant":"刪除失敗，內容錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36401,
                'messages' => '{"en":"The content can not be deleted","zh-Hans":"该内容不允许删除","zh-Hant":"該內容不允許刪除"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36402,
                'messages' => '{"en":"The resource is being used and deletion is not allowed","zh-Hans":"该资源正在被使用，不允许删除","zh-Hant":"該資源正在被使用，不允許刪除"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36403,
                'messages' => '{"en":"You can only delete your own content","zh-Hans":"只能删除自己的内容","zh-Hant":"只能刪除自己的內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36404,
                'messages' => '{"en":"Not allowed to delete in the review, please withdraw the review and then delete","zh-Hans":"正在审核中不允许删除，请撤销审核再删除","zh-Hant":"正在審核中不允許刪除，請撤銷審核再刪除"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36405,
                'messages' => '{"en":"Content has been published, the draft can no longer operate, if you need to delete please delete the published content","zh-Hans":"内容已发表，草稿不可再操作，如需删除请删除发表内容","zh-Hant":"內容已發表，草稿不可再操作，如需刪除請刪除發表內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36500,
                'messages' => '{"en":"Operation failed. Please confirm that you are the author","zh-Hans":"操作失败，内容不属于当前用户","zh-Hant":"操作失敗，內容不屬於當前使用者"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36501,
                'messages' => '{"en":"There is no need to withdraw the content, for it is not being reviewed","zh-Hans":"当前内容并非审核状态，无需撤回","zh-Hant":"當前內容並非審核狀態，無需撤回"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36600,
                'messages' => '{"en":"Conversation function is not enabled and cannot be used","zh-Hans":"对话功能未启用，无法使用","zh-Hant":"對話功能未啟用，無法使用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36601,
                'messages' => '{"en":"Conversation exception or non-existent","zh-Hans":"对话异常或者不存在","zh-Hant":"對話異常或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36602,
                'messages' => '{"en":"The conversation does not belong to the current user","zh-Hans":"该对话不属于当前用户","zh-Hant":"該對話不屬於當前使用者"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36603,
                'messages' => '{"en":"You can not send messages to yourself","zh-Hans":"自己不能给自己发送消息","zh-Hant":"自己不能給自己發送消息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36604,
                'messages' => '{"en":"Each message should be either [file] or [text]","zh-Hans":"单个消息只能「文件」或「文本」二选一","zh-Hant":"單個消息只能「文件」或「文本」二選一"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36605,
                'messages' => '{"en":"The message could not be sent for the block words it contains","zh-Hans":"消息文本中含有禁用词，不能发送","zh-Hant":"消息文本中含有禁用詞，不能發送"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36606,
                'messages' => '{"en":"The user they set that only the users he follows can send messages","zh-Hans":"用户已设置仅他关注的人可以发送消息","zh-Hant":"使用者已設置僅他跟隨的人可以發送消息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36607,
                'messages' => '{"en":"The user they set that only the users he follows and the verified users can send messages","zh-Hans":"用户已设置仅他关注的人和认证用户可以发送消息","zh-Hant":"使用者已設置僅他跟隨的人和認證使用者可以發送消息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36608,
                'messages' => '{"en":"The other party they set the conversation off function","zh-Hans":"用户已关闭对话功能","zh-Hant":"使用者已關閉對話功能"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36609,
                'messages' => '{"en":"Only your own conversation messages could be deleted.","zh-Hans":"只能删除自己的对话消息","zh-Hant":"只能刪除自己的對話消息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36700,
                'messages' => '{"en":"Notification exception or non-existent","zh-Hans":"通知异常或者不存在","zh-Hant":"通知異常或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36701,
                'messages' => '{"en":"The notification does not belong to the current user","zh-Hans":"该通知不属于当前用户","zh-Hant":"該通知不屬於當前使用者"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 36702,
                'messages' => '{"en":"Only your own notification messages could be deleted.","zh-Hans":"只能删除自己的通知消息","zh-Hant":"只能刪除自己的通知消息"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37100,
                'messages' => '{"en":"Wrong group or record not exist","zh-Hans":"小组错误或者不存在","zh-Hant":"社團錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37101,
                'messages' => '{"en":"Group disabled","zh-Hans":"小组已被禁用","zh-Hant":"社團已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37102,
                'messages' => '{"en":"None of the selected groups are eligible, the content is empty","zh-Hans":"所选小组都不符合条件，内容为空","zh-Hant":"所選社團都不符合條件，內容為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37103,
                'messages' => '{"en":"Only members can view this group.","zh-Hans":"只有小组成员才能查看小组","zh-Hant":"只有社團成員才能查看社團"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37104,
                'messages' => '{"en":"Only members can see who\'s in the group and what they post.","zh-Hans":"只有小组成员才能查看小组内帖子","zh-Hant":"只有社團成員才能查看社團內貼文"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37105,
                'messages' => '{"en":"The current user disabled from viewing the content of this group","zh-Hans":"当前用户已被禁止查看本小组内容","zh-Hant":"當前使用者已被禁止查看本社團內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37106,
                'messages' => '{"en":"Service has expired, cannot browse and interact within this group","zh-Hans":"服务已到期，不能在本小组内浏览和互动","zh-Hant":"服務已到期，不能在本社團內瀏覽和互動"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37107,
                'messages' => '{"en":"Service has expired, can\'t view new content","zh-Hans":"服务已到期，无法浏览新内容","zh-Hant":"服務已到期，無法瀏覽新內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37200,
                'messages' => '{"en":"Wrong hashtag or record not exist","zh-Hans":"话题错误或者不存在","zh-Hant":"話題錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37201,
                'messages' => '{"en":"Hashtag disabled","zh-Hans":"话题已被禁用","zh-Hant":"話題已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37202,
                'messages' => '{"en":"None of the selected hashtags are eligible, the content is empty","zh-Hans":"所选话题都不符合条件，内容为空","zh-Hant":"所選話題都不符合條件，內容為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37300,
                'messages' => '{"en":"Wrong geotag or record not exist","zh-Hans":"地理标签错误或者不存在","zh-Hant":"地理標籤錯誤或不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37301,
                'messages' => '{"en":"Geotag disabled","zh-Hans":"地理标签已被禁用","zh-Hant":"地理標籤已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37302,
                'messages' => '{"en":"None of the selected geotags are eligible, the content is empty","zh-Hans":"所选地理标签都不符合条件，内容为空","zh-Hant":"所選地理標籤都不符合條件，內容為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37400,
                'messages' => '{"en":"Wrong post or record not exist","zh-Hans":"帖子错误或者不存在","zh-Hant":"貼文錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37401,
                'messages' => '{"en":"Post disabled","zh-Hans":"帖子已被禁用","zh-Hant":"貼文已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37402,
                'messages' => '{"en":"Wrong post log or record not exist","zh-Hans":"帖子日志错误或者不存在","zh-Hant":"貼文日誌錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37403,
                'messages' => '{"en":"Post log suspended","zh-Hans":"帖子日志已被禁用","zh-Hant":"貼文日誌已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37404,
                'messages' => '{"en":"The content could not be accessed without authorization","zh-Hans":"该内容需要授权后才能浏览","zh-Hant":"該內容需要授權後才能瀏覽"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37500,
                'messages' => '{"en":"Wrong comment or record not exist","zh-Hans":"评论错误或者不存在","zh-Hant":"留言錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37501,
                'messages' => '{"en":"Comment disabled","zh-Hans":"评论已被禁用","zh-Hant":"留言已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37502,
                'messages' => '{"en":"Wrong comment log or record not exist","zh-Hans":"评论日志错误或者不存在","zh-Hant":"留言日誌錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37503,
                'messages' => '{"en":"Comment log suspended","zh-Hans":"评论日志已被禁用","zh-Hant":"留言日誌已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37504,
                'messages' => '{"en":"Comments are only visible to the author of the post","zh-Hans":"评论仅限帖子作者可见","zh-Hant":"留言僅限貼文作者可見"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37505,
                'messages' => '{"en":"The post has timed out and no longer shows comments","zh-Hans":"帖子已超时，不再显示评论","zh-Hant":"貼文已超時，不再顯示留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37600,
                'messages' => '{"en":"Wrong file or record not exist","zh-Hans":"文件错误或者不存在","zh-Hant":"文件錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37601,
                'messages' => '{"en":"File disabled","zh-Hans":"文件已被禁用","zh-Hant":"文件已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37602,
                'messages' => '{"en":"You are not authorized to edit this file.","zh-Hans":"你无权编辑该文件","zh-Hant":"你無權編輯該文件"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37700,
                'messages' => '{"en":"Wrong extend content or record not exist","zh-Hans":"扩展错误或者不存在","zh-Hant":"擴充錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37701,
                'messages' => '{"en":"Extend disabled","zh-Hans":"扩展已被禁用","zh-Hant":"擴充已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37702,
                'messages' => '{"en":"Extend key does not exist","zh-Hans":"扩展键名不存在","zh-Hant":"擴充鍵名不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37800,
                'messages' => '{"en":"Wrong archive content or record not exist","zh-Hans":"扩展参数错误或者不存在","zh-Hant":"擴充參數錯誤或不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37801,
                'messages' => '{"en":"Archive configuration disabled","zh-Hans":"扩展参数配置已被禁用","zh-Hant":"擴充參數配置已停用"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 37802,
                'messages' => '{"en":"Archive configuration mismatch","zh-Hans":"扩展参数配置不匹配","zh-Hant":"擴充參數配置不匹配"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38100,
                'messages' => '{"en":"Draft ID is incorrect or does not exist","zh-Hans":"草稿 ID 错误或者不存在","zh-Hant":"草稿 ID 錯誤或者不存在"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38101,
                'messages' => '{"en":"You can only edit your own content","zh-Hans":"只能编辑自己的内容","zh-Hant":"只能編輯自己的內容"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38102,
                'messages' => '{"en":"The content is being reviewed and can not be edited","zh-Hans":"内容审核中不可编辑","zh-Hant":"內容審核中不可編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38103,
                'messages' => '{"en":"The content has been published and can not be edited","zh-Hans":"内容已正式发表不可编辑","zh-Hant":"內容已正式發表不可編輯"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38104,
                'messages' => '{"en":"Content being reviewed can not be submitted again","zh-Hans":"处于审核状态的内容不可再提交","zh-Hant":"處於審核狀態的內容不可再提交"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38105,
                'messages' => '{"en":"Content being published can not be submitted again","zh-Hans":"处于发布状态的内容不可再提交","zh-Hant":"處於發布狀態的內容不可再提交"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38106,
                'messages' => '{"en":"Failed to create draft comment. Only first-level comment can create draft","zh-Hans":"评论草稿创建失败，只有一级评论才能创建草稿","zh-Hant":"留言草稿創建失敗，只有一級留言才能創建草稿"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38107,
                'messages' => '{"en":"Draft creation failed, draft box is full, please organize and create again","zh-Hans":"草稿创建失败，草稿箱已满，请整理后再创建","zh-Hant":"草稿創建失敗，草稿箱已滿，請整理後再創建"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38108,
                'messages' => '{"en":"Comment failed, belongs to the post or has been deleted","zh-Hans":"评论失败，所属帖子或已删除","zh-Hant":"留言失敗，所屬帖子或已刪除"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38109,
                'messages' => '{"en":"Comment failed, the post belongs to the comment function has been closed","zh-Hans":"评论失败，所属帖子已关闭评论功能","zh-Hant":"留言失敗，所屬貼文已關閉留言功能"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38110,
                'messages' => '{"en":"The author of the post has made the comment private, do not support separate reconfiguration of comments","zh-Hans":"帖子作者已经设置评论私有，不支持单独再配置评论","zh-Hant":"貼文作者已經設定留言私有，不支援單獨再配置留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38200,
                'messages' => '{"en":"Content has been submitted, pending review and approval before official publication","zh-Hans":"内容已提交，待审核通过后才能正式发表","zh-Hant":"內容已提交，待審核透過後才能正式發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38201,
                'messages' => '{"en":"The existence of content to be audited, the system does not allow the simultaneous submission of two pieces of content for review, to be submitted after the end of the audit","zh-Hans":"存在待审核内容，系统不允许同时提交审核两篇内容，待审核结束后再提交","zh-Hant":"存在待審核內容，系統不允許同時提交審核兩篇內容，待審核結束後再提交"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38202,
                'messages' => '{"en":"Title cannot be empty","zh-Hans":"标题不能为空","zh-Hant":"標題不能為空"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38203,
                'messages' => '{"en":"The title is too long and has exceeded the length limit","zh-Hans":"标题过长，已超出限制长度","zh-Hant":"標題過長，已超出限制長度"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38204,
                'messages' => '{"en":"The content cannot be empty, please write the content and then publish","zh-Hans":"成功内容不能为空，请撰写内容后再发表","zh-Hant":"內容不能為空，請撰寫內容後再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38205,
                'messages' => '{"en":"The content is too long and has exceeded the length limit","zh-Hans":"内容过长，已超出限制长度","zh-Hant":"內容過長，已超出限制長度"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38206,
                'messages' => '{"en":"There are banned words in the title, please modify it before publishing","zh-Hans":"标题存在禁用词，请修改后再发表","zh-Hant":"標題存在禁用詞，請修改後再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38207,
                'messages' => '{"en":"There are banned words in the content, please revise before publishing","zh-Hans":"内容存在禁用词，请修改后再发表","zh-Hant":"內容存在禁用詞，請修改後再發表"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38208,
                'messages' => '{"en":"Group cannot be empty, please select group","zh-Hans":"小组不能为空，请选择小组","zh-Hant":"社團不能為空，請選擇社團"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38209,
                'messages' => '{"en":"The author has set only the users he follows to comment","zh-Hans":"作者已设置仅他关注的人可以评论","zh-Hant":"作者已設置僅他關注的人可以留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38210,
                'messages' => '{"en":"The author has set only the users he follows and the verified users can comment","zh-Hans":"作者已设置仅他关注的人和认证用户可以评论","zh-Hant":"作者已設置僅他關注的人和認證使用者可以留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38211,
                'messages' => '{"en":"The author has turned off the comment function","zh-Hans":"作者已关闭评论功能","zh-Hant":"作者已關閉留言功能"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'app_fskey' => 'Fresns',
                'code' => 38212,
                'messages' => '{"en":"Only users mentioned by the author can comment","zh-Hans":"仅限作者提及到的用户才可以评论","zh-Hant":"僅限作者提及到的使用者才可以留言"}',
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
        ]);
    }
}
