/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.cruise.plugins.task.say;

import com.thoughtworks.cruise.config.AbstractTask;
import com.thoughtworks.cruise.config.ConfigSubtag;
import com.thoughtworks.cruise.config.ConfigTag;
import com.thoughtworks.cruise.config.ValidationContext;
import com.thoughtworks.cruise.domain.Builder;
import com.thoughtworks.cruise.domain.Pipeline;
import com.thoughtworks.cruise.domain.Task;
import com.thoughtworks.cruise.plugins.task.say.SayBuilder;
import com.thoughtworks.cruise.plugins.task.say.SayMessage;
import com.thoughtworks.cruise.server.service.UpstreamPipelineResolver;
import com.thoughtworks.cruise.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ConfigTag(value="say", namespacePrefix="say", namespaceURI="com.thoughtworks.cruise.task.plugin.say")
public class SayTask
extends AbstractTask {
    @ConfigSubtag(label="message")
    private SayMessage message;
    public static final String MESSAGE = "message";

    public SayTask() {
        this("");
    }

    public SayTask(String message) {
        this.message = new SayMessage(message);
    }

    public Builder getBuilder(Pipeline pipeline, UpstreamPipelineResolver resolver) {
        return new SayBuilder(this.getConditions(), this.cancelTask().getBuilder(pipeline, resolver), String.format("Saying '%s'", this.getMessage()), this.getMessage(), pipeline.defaultWorkingFolder());
    }

    public String getTypeForDisplay() {
        return "Echo Message";
    }

    public List<Task.TaskProperty> getPropertiesForDisplay() {
        ArrayList<Task.TaskProperty> taskProperties = new ArrayList<Task.TaskProperty>();
        if (!StringUtil.isBlank((String)this.message.getMessage())) {
            taskProperties.add(new Task.TaskProperty(this.capitalize(MESSAGE), this.message.getMessage()));
        }
        return taskProperties;
    }

    private String capitalize(String message) {
        return Character.toUpperCase(message.charAt(0)) + message.substring(1);
    }

    protected void setTaskConfigAttributes(Map attributes) {
        if (attributes.containsKey(MESSAGE)) {
            this.message = new SayMessage((String)attributes.get(MESSAGE));
        }
    }

    protected void validateTask(ValidationContext validationContext) {
        if (this.getMessage() == null || this.getMessage().isEmpty()) {
            this.addError(MESSAGE, "Message cannot be empty");
        }
    }

    public String getMessage() {
        return this.message.getMessage();
    }

    public String getTaskSimpleName() {
        return "say";
    }
}

