/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.cruise.plugins.task.view;

import com.thoughtworks.cruise.plugins.presentation.PluggableViewModel;
import com.thoughtworks.cruise.plugins.presentation.PluggableViewModelFactory;
import com.thoughtworks.cruise.plugins.task.say.SayTask;
import java.util.Collections;
import java.util.Map;
import org.osgi.framework.Bundle;

public final class SayTaskPluggableViewModelFactory
implements PluggableViewModelFactory<SayTask> {
    private final Bundle bundle;

    public SayTaskPluggableViewModelFactory(Bundle bundle) {
        this.bundle = bundle;
    }

    public PluggableViewModel viewModelFor(final SayTask sayTask, String actionName) {
        final String templatePath = this.getTemplatePath(sayTask, actionName);
        return new PluggableViewModel<SayTask>(){

            public String getRenderingFramework() {
                return "freemarker";
            }

            public String getTemplatePath() {
                return templatePath;
            }

            public Map<String, Object> getParameters() {
                return Collections.singletonMap("task", sayTask);
            }

            public SayTask getModel() {
                return sayTask;
            }
        };
    }

    private String getTemplatePath(SayTask sayTask, String actionName) {
        if ("list-entry".equals(actionName)) {
            return this.bundle.getResource("templates/list-entry.ftl").toString();
        }
        if ("new".equals(actionName) || "edit".equals(actionName)) {
            return this.bundle.getResource("templates/form.ftl").toString();
        }
        throw new IllegalArgumentException(String.format("No view model is available for object '%s' and action '%s'", new Object[]{sayTask, actionName}));
    }
}

