/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class Breakpoint
extends RubyObject {
    private static final long serialVersionUID = 1L;

    protected Breakpoint(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    DebugBreakpoint debuggerBreakpoint() {
        return (DebugBreakpoint)this.dataGetStruct();
    }

    @JRubyMethod(name={"enabled="}, required=1)
    public IRubyObject setEnabled(IRubyObject iRubyObject, Block block) {
        this.debuggerBreakpoint().setEnabled(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod(name={"enabled?"})
    public IRubyObject isEnabled(Block block) {
        return this.getRuntime().newBoolean(this.debuggerBreakpoint().isEnabled());
    }

    @JRubyMethod(name={"id"})
    public RubyFixnum id(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getId());
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source(Block block) {
        return this.debuggerBreakpoint().getSource();
    }

    @JRubyMethod(name={"source="}, required=1)
    public IRubyObject source_set(IRubyObject iRubyObject, Block block) {
        this.debuggerBreakpoint().setSource((IRubyObject)iRubyObject.convertToString());
        return iRubyObject;
    }

    @JRubyMethod(name={"pos"})
    public IRubyObject pos(Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (debugBreakpoint.getType() == DebugBreakpoint.Type.METHOD) {
            return this.getRuntime().newString(this.debuggerBreakpoint().getPos().getMethodName());
        }
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getPos().getLine());
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject pos_set(IRubyObject iRubyObject, Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (debugBreakpoint.getType() == DebugBreakpoint.Type.METHOD) {
            debugBreakpoint.getPos().setMethodName(iRubyObject.convertToString().toString());
        } else {
            debugBreakpoint.getPos().setLine(RubyNumeric.fix2int((IRubyObject)iRubyObject));
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"expr"})
    public IRubyObject expr(Block block) {
        return this.debuggerBreakpoint().getExpr();
    }

    @JRubyMethod(name={"expr="}, required=1)
    public IRubyObject expr_set(IRubyObject iRubyObject, Block block) {
        this.debuggerBreakpoint().setExpr((IRubyObject)(iRubyObject.isNil() ? iRubyObject : iRubyObject.convertToString()));
        return iRubyObject;
    }

    @JRubyMethod(name={"hit_count"})
    public IRubyObject hit_count(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getHitCount());
    }

    @JRubyMethod(name={"hit_value"})
    public IRubyObject hit_value(Block block) {
        return this.getRuntime().newFixnum(this.debuggerBreakpoint().getHitValue());
    }

    @JRubyMethod(name={"hit_value="}, required=1)
    public IRubyObject hit_value_set(IRubyObject iRubyObject, Block block) {
        this.debuggerBreakpoint().setHitValue(RubyNumeric.fix2int((IRubyObject)iRubyObject));
        return iRubyObject;
    }

    @JRubyMethod(name={"hit_condition"})
    public IRubyObject hit_condition(Block block) {
        DebugBreakpoint.HitCondition hitCondition = this.debuggerBreakpoint().getHitCondition();
        if (hitCondition == null) {
            return this.getRuntime().getNil();
        }
        switch (hitCondition) {
            case GE: {
                return this.getRuntime().newSymbol("greater_or_equal");
            }
            case EQ: {
                return this.getRuntime().newSymbol("equal");
            }
            case MOD: {
                return this.getRuntime().newSymbol("modulo");
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"hit_condition="}, required=1)
    public IRubyObject hit_condition_set(IRubyObject iRubyObject, Block block) {
        DebugBreakpoint debugBreakpoint = this.debuggerBreakpoint();
        if (!this.getRuntime().getSymbol().isInstance(iRubyObject)) {
            throw this.getRuntime().newArgumentError("Invalid condition parameter");
        }
        String string = ((RubySymbol)iRubyObject).asJavaString();
        if (string.equals("greater_or_equal") || string.equals("ge")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.GE);
        } else if (string.equals("equal") || string.equals("eq")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.EQ);
        } else if (string.equals("modulo") || string.equals("mod")) {
            debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.MOD);
        } else {
            throw this.getRuntime().newArgumentError("Invalid condition parameter");
        }
        return iRubyObject;
    }
}

