/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugFrame;
import org.jruby.debug.Debugger;
import org.jruby.debug.Util;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class Context
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private final Debugger debugger;

    Context(Ruby ruby, RubyClass rubyClass, Debugger debugger) {
        super(ruby, rubyClass);
        this.debugger = debugger;
    }

    DebugContext debugContext() {
        return (DebugContext)this.dataGetStruct();
    }

    @JRubyMethod(name={"stop_next=", "step"}, required=1, optional=1)
    public IRubyObject stop_next_set(IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = this.getRuntime();
        this.checkStarted();
        IRubyObject iRubyObject = Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)1, (int)2) == 2 ? iRubyObjectArray[1] : ruby.getNil();
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        if (RubyFixnum.fix2int((IRubyObject)iRubyObject2) < 0) {
            ruby.newRuntimeError("Steps argument can't be negative.");
        }
        DebugContext debugContext = this.debugContext();
        debugContext.setStopNext(RubyFixnum.fix2int((IRubyObject)iRubyObject2));
        debugContext.setForceMove(!iRubyObject.isNil() && iRubyObject.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"step_over"}, required=1, optional=2)
    public IRubyObject step_over(IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = this.getRuntime();
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (debugContext.getStackSize() == 0) {
            ruby.newRuntimeError("No frames collected.");
        }
        IRubyObject[] iRubyObjectArray2 = Arity.scanArgs((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)1, (int)2);
        IRubyObject iRubyObject = iRubyObjectArray2[0];
        IRubyObject iRubyObject2 = iRubyObjectArray2[1];
        IRubyObject iRubyObject3 = iRubyObjectArray2[2];
        debugContext.setStopLine(RubyFixnum.fix2int((IRubyObject)iRubyObject));
        debugContext.setStepped(false);
        if (iRubyObject2.isNil()) {
            debugContext.setDestFrame(debugContext.getStackSize());
        } else {
            int n = this.checkFrameNumber(iRubyObject2);
            debugContext.setDestFrame(debugContext.getStackSize() - n);
        }
        debugContext.setForceMove(iRubyObject3.isTrue());
        return ruby.getNil();
    }

    @JRubyMethod(name={"stop_frame="}, required=1)
    public IRubyObject stop_frame_set(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        int n = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        if (n < 0 || n >= debugContext.getStackSize()) {
            this.getRuntime().newRuntimeError("Stop frame is out of range.");
        }
        debugContext.setStopFrame(debugContext.getStackSize() - n);
        return iRubyObject;
    }

    @JRubyMethod(name={"thread"})
    public IRubyObject thread(Block block) {
        this.checkStarted();
        return this.debugContext().getThread();
    }

    @JRubyMethod(name={"pause"})
    public IRubyObject pause(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (debugContext.isDead()) {
            return this.getRuntime().getFalse();
        }
        if (this.debugContext().getThread() == this.getRuntime().getCurrentContext().getThread()) {
            return this.getRuntime().getFalse();
        }
        this.debugContext().setThreadPaused(true);
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"thnum"})
    public IRubyObject thnum(Block block) {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.debugContext().getThnum());
    }

    @JRubyMethod(name={"stop_reason"})
    public IRubyObject stop_reason(Block block) {
        String string;
        Ruby ruby = this.getRuntime();
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        switch (debugContext.getStopReason()) {
            case STEP: {
                string = "step";
                break;
            }
            case BREAKPOINT: {
                string = "breakpoint";
                break;
            }
            case CATCHPOINT: {
                string = "catchpoint";
                break;
            }
            default: {
                string = "none";
            }
        }
        if (debugContext.isDead()) {
            string = "post-mortem";
        }
        return ruby.newSymbol(string);
    }

    @JRubyMethod(name={"suspend"})
    public IRubyObject suspend(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (debugContext.isSuspended()) {
            throw this.getRuntime().newRuntimeError("Already suspended.");
        }
        this.suspend0();
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend0() {
        DebugContext debugContext = this.debugContext();
        String string = debugContext.getThread().status().toString();
        if (string.equals("run") || string.equals("sleep")) {
            Context context = this;
            synchronized (context) {
                debugContext.setWasRunning(true);
                debugContext.setSuspended(true);
            }
        }
    }

    @JRubyMethod(name={"suspended?"})
    public IRubyObject suspended_p(Block block) {
        this.checkStarted();
        return this.getRuntime().newBoolean(this.debugContext().isSuspended());
    }

    @JRubyMethod(name={"resume"})
    public IRubyObject resume(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (!debugContext.isSuspended()) {
            throw this.getRuntime().newRuntimeError("Thread is not suspended.");
        }
        this.resume0();
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume0() {
        DebugContext debugContext = this.debugContext();
        Context context = this;
        synchronized (context) {
            debugContext.setSuspended(false);
        }
        if (debugContext.isWasRunning()) {
            debugContext.getThread().wakeup();
        }
    }

    @JRubyMethod(name={"tracing"})
    public IRubyObject tracing(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        return this.getRuntime().newBoolean(debugContext.isTracing());
    }

    @JRubyMethod(name={"tracing="}, required=1)
    public IRubyObject tracing_set(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        debugContext.setTracing(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod(name={"ignored?"})
    public IRubyObject ignored_p(Block block) {
        this.checkStarted();
        return this.getRuntime().newBoolean(this.debugContext().isIgnored());
    }

    @JRubyMethod(name={"frame_args"}, required=1)
    public IRubyObject frame_args(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        DebugFrame debugFrame = this.getFrame(iRubyObject);
        if (debugFrame.isDead()) {
            return debugFrame.getInfo().getCopyArgs();
        }
        return this.contextCopyArgs(debugFrame);
    }

    @JRubyMethod(name={"frame_binding"}, required=1)
    public IRubyObject frame_binding(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        return this.getFrame(iRubyObject).getBinding();
    }

    @JRubyMethod(name={"frame_id", "frame_method"}, required=1)
    public IRubyObject frame_method(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        String string = this.getFrame(iRubyObject).getMethodName();
        return string == null ? this.getRuntime().getNil() : this.getRuntime().newSymbol(string);
    }

    @JRubyMethod(name={"frame_args_info"}, optional=1)
    public IRubyObject frame_args_info(IRubyObject[] iRubyObjectArray, Block block) {
        this.checkStarted();
        return this.getFrame(iRubyObjectArray).getArgValues();
    }

    @JRubyMethod(name={"frame_line"}, optional=1)
    public IRubyObject frame_line(IRubyObject[] iRubyObjectArray, Block block) {
        this.checkStarted();
        return this.getRuntime().newFixnum(this.getFrame(iRubyObjectArray).getLine());
    }

    @JRubyMethod(name={"frame_file"}, optional=1)
    public IRubyObject frame_file(IRubyObject[] iRubyObjectArray, Block block) {
        return this.getRuntime().newString(this.getFrame(iRubyObjectArray).getFile());
    }

    @JRubyMethod(name={"frame_locals"}, required=1)
    public IRubyObject frame_locals(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        DebugFrame debugFrame = this.getFrame(iRubyObject);
        if (debugFrame.isDead()) {
            return debugFrame.getInfo().getCopyLocals();
        }
        return this.contextCopyLocals(debugFrame);
    }

    @JRubyMethod(name={"frame_self"}, required=1)
    public IRubyObject frame_self(IRubyObject iRubyObject, Block block) {
        this.checkStarted();
        return this.getFrame(iRubyObject).getSelf();
    }

    @JRubyMethod(name={"frame_class"}, optional=1)
    public IRubyObject frame_class(IRubyObject[] iRubyObjectArray, Block block) {
        this.checkStarted();
        DebugFrame debugFrame = this.getFrame(iRubyObjectArray);
        if (debugFrame.isDead()) {
            return this.getRuntime().getNil();
        }
        return debugFrame.getInfo().getFrame().getKlazz();
    }

    @JRubyMethod(name={"stack_size"})
    public IRubyObject stack_size(Block block) {
        this.checkStarted();
        return this.getRuntime().newFixnum(this.debugContext().getStackSize());
    }

    @JRubyMethod(name={"dead?"})
    public IRubyObject dead_p(Block block) {
        this.checkStarted();
        return Util.toRBoolean((IRubyObject)this, this.debugContext().isDead());
    }

    @JRubyMethod(name={"breakpoint"})
    public IRubyObject breakpoint(Block block) {
        this.checkStarted();
        return this.debugContext().getBreakpoint();
    }

    @JRubyMethod(name={"set_breakpoint"}, required=2, optional=1)
    public IRubyObject set_breakpoint(IRubyObject[] iRubyObjectArray, Block block) {
        this.checkStarted();
        IRubyObject iRubyObject = this.debugger.createBreakpointFromArgs((IRubyObject)this, iRubyObjectArray, 0);
        this.debugContext().setBreakpoint(iRubyObject);
        return iRubyObject;
    }

    private IRubyObject getFrameNumber(IRubyObject[] iRubyObjectArray) {
        return iRubyObjectArray.length == 1 ? iRubyObjectArray[0] : this.getRuntime().newFixnum(0);
    }

    private DebugFrame getFrame(IRubyObject[] iRubyObjectArray) {
        return this.getFrame(this.getFrameNumber(iRubyObjectArray));
    }

    private DebugFrame getFrame(IRubyObject iRubyObject) {
        DebugContext debugContext = this.debugContext();
        int n = this.checkFrameNumber(iRubyObject);
        return debugContext.getFrame(n);
    }

    private int checkFrameNumber(IRubyObject iRubyObject) {
        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject);
        if (n < 0 || n >= this.debugContext().getStackSize()) {
            throw iRubyObject.getRuntime().newArgumentError(String.format("Invalid frame number %d, stack (0...%d)", n, this.debugContext().getStackSize()));
        }
        return n;
    }

    private void checkStarted() {
        this.debugger.checkStarted(this.getRuntime());
    }

    private IRubyObject contextCopyArgs(DebugFrame debugFrame) {
        RubyArray rubyArray = this.getRuntime().newArray();
        StaticScope staticScope = debugFrame.getInfo().getScope();
        int n = staticScope.getRequiredArgs() + staticScope.getOptionalArgs();
        if (staticScope.getRestArg() >= 0) {
            ++n;
        }
        String[] stringArray = staticScope.getVariables();
        for (int i = 0; i < n; ++i) {
            rubyArray.append((IRubyObject)this.getRuntime().newString(stringArray[i]));
        }
        return rubyArray;
    }

    private IRubyObject contextCopyLocals(DebugFrame debugFrame) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)this.getRuntime());
        DynamicScope dynamicScope = debugFrame.getInfo().getDynaVars();
        if (dynamicScope != null) {
            String[] stringArray;
            DynamicScope dynamicScope2 = null;
            try {
                stringArray = dynamicScope.getClass();
                Method method = stringArray.getDeclaredMethod("getEvalScope", new Class[0]);
                Class<?>[] classArray = method.getParameterTypes();
                dynamicScope2 = (DynamicScope)(classArray.length > 0 ? method.invoke((Object)dynamicScope, this.getRuntime()) : method.invoke((Object)dynamicScope, new Object[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            if (dynamicScope2 != null) {
                dynamicScope = dynamicScope2;
            }
            while (dynamicScope != null) {
                stringArray = dynamicScope.getStaticScope().getVariables();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        rubyHash.op_aset(this.getRuntime().getCurrentContext(), (IRubyObject)RubyString.newString((Ruby)this.getRuntime(), (String)stringArray[i]), dynamicScope.getValues()[i]);
                    }
                }
                dynamicScope = dynamicScope.getNextCapturedScope();
            }
        }
        return rubyHash;
    }
}

