/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.util.LinkedList;
import java.util.List;
import org.jruby.RubyThread;
import org.jruby.debug.DebugFrame;
import org.jruby.runtime.builtin.IRubyObject;

final class DebugContext {
    static final String AT_BREAKPOINT = "at_breakpoint";
    static final String AT_CATCHPOINT = "at_catchpoint";
    static final String AT_LINE = "at_line";
    static final String AT_TRACING = "at_tracing";
    static final String LIST = "list";
    private static int thnumMax = 0;
    private final RubyThread thread;
    private IRubyObject breakpoint;
    private final List<DebugFrame> frames;
    private int lastLine = 0;
    private String lastFile = null;
    private int destFrame = -1;
    private int stopFrame = -1;
    private int stopNext = -1;
    private int stopLine = -1;
    private int stackLen;
    private StopReason stopReason;
    private int thnum = ++thnumMax;
    private boolean dead;
    private boolean threadPaused = false;
    private boolean suspended;
    private boolean wasRunning;
    private boolean ignored;
    private boolean skipped;
    private boolean enableBreakpoint;
    private boolean stepped;
    private boolean tracing;
    private boolean forceMove;

    DebugContext(RubyThread rubyThread) {
        this.stopReason = StopReason.NONE;
        this.frames = new LinkedList<DebugFrame>();
        this.breakpoint = rubyThread.getRuntime().getNil();
        this.thread = rubyThread;
    }

    void addFrame(DebugFrame debugFrame) {
        this.frames.add(debugFrame);
    }

    RubyThread getThread() {
        return this.thread;
    }

    DebugFrame getTopFrame() {
        return this.frames.get(this.getStackSize() - 1);
    }

    DebugFrame getFrame(int n) {
        return this.frames.get(this.getStackSize() - n - 1);
    }

    DebugFrame popFrame() {
        return this.frames.remove(this.getStackSize() - 1);
    }

    void clearFrames() {
        this.frames.clear();
    }

    IRubyObject getBreakpoint() {
        return this.breakpoint;
    }

    void setBreakpoint(IRubyObject iRubyObject) {
        this.breakpoint = iRubyObject;
    }

    int getDestFrame() {
        return this.destFrame;
    }

    void setDestFrame(int n) {
        this.destFrame = n;
    }

    boolean isEnableBreakpoint() {
        return this.enableBreakpoint;
    }

    void setEnableBreakpoint(boolean bl) {
        this.enableBreakpoint = bl;
    }

    boolean isForceMove() {
        return this.forceMove;
    }

    void setForceMove(boolean bl) {
        this.forceMove = bl;
    }

    boolean isIgnored() {
        return this.ignored;
    }

    void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    String getLastFile() {
        return this.lastFile;
    }

    void setLastFile(String string) {
        this.lastFile = string;
    }

    int getLastLine() {
        return this.lastLine;
    }

    void setLastLine(int n) {
        this.lastLine = n;
    }

    boolean isSkipped() {
        return this.skipped;
    }

    void setSkipped(boolean bl) {
        this.skipped = bl;
    }

    int getStackLen() {
        return this.stackLen;
    }

    void setStackLen(int n) {
        this.stackLen = n;
    }

    int getStackSize() {
        return this.frames.size();
    }

    boolean isStepped() {
        return this.stepped;
    }

    void setStepped(boolean bl) {
        this.stepped = bl;
    }

    int getStopFrame() {
        return this.stopFrame;
    }

    void setStopFrame(int n) {
        this.stopFrame = n;
    }

    int getStopLine() {
        return this.stopLine;
    }

    void setStopLine(int n) {
        this.stopLine = n;
    }

    int getStopNext() {
        return this.stopNext;
    }

    void setStopNext(int n) {
        this.stopNext = n;
    }

    StopReason getStopReason() {
        return this.stopReason;
    }

    void setStopReason(StopReason stopReason) {
        this.stopReason = stopReason;
    }

    boolean isSuspended() {
        return this.suspended;
    }

    void setSuspended(boolean bl) {
        this.suspended = bl;
    }

    int getThnum() {
        return this.thnum;
    }

    void setThnum(int n) {
        this.thnum = n;
    }

    boolean isTracing() {
        return this.tracing;
    }

    void setTracing(boolean bl) {
        this.tracing = bl;
    }

    boolean isWasRunning() {
        return this.wasRunning;
    }

    void setWasRunning(boolean bl) {
        this.wasRunning = bl;
    }

    boolean isDead() {
        return this.dead;
    }

    void setDead(boolean bl) {
        this.dead = bl;
    }

    boolean isThreadPaused() {
        return this.threadPaused;
    }

    void setThreadPaused(boolean bl) {
        this.threadPaused = bl;
    }

    void resetSteppingStopPoints() {
        this.destFrame = -1;
        this.stopLine = -1;
        this.stopNext = -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StopReason {
        NONE,
        STEP,
        BREAKPOINT,
        CATCHPOINT;

    }
}

